/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import net.sf.memoranda.CurrentNote;
import net.sf.memoranda.History;
import net.sf.memoranda.Note;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.ui.AllFilesFilter;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.DailyItemsPanel;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.FileExportDialog;
import net.sf.memoranda.ui.htmleditor.HTMLEditor;
import net.sf.memoranda.ui.htmleditor.util.Local;
import net.sf.memoranda.util.Configuration;
import net.sf.memoranda.util.Context;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.HTMLFileExport;
import net.sf.memoranda.util.HTMLFileImport;
import net.sf.memoranda.util.Util;

public class EditorPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    public HTMLEditor editor = null;
    JButton importB = new JButton();
    JButton exportB = new JButton();
    JButton redoB = new JButton();
    JButton copyB = new JButton();
    JButton historyBackB = new JButton();
    JToolBar editorToolBar = new JToolBar();
    JButton pasteB = new JButton();
    JButton historyForwardB = new JButton();
    JButton insDateB = new JButton();
    JButton insTimeB = new JButton();
    JButton undoB = new JButton();
    JButton cutB = new JButton();
    BorderLayout borderLayout2 = new BorderLayout();
    JToolBar titleBar = new JToolBar();
    JLabel titleLabel = new JLabel();
    public JTextField titleField = new JTextField();
    JButton newB = new JButton();
    JButton previewB = new JButton();
    DailyItemsPanel parentPanel = null;
    public Action insertTimeAction = new AbstractAction(net.sf.memoranda.util.Local.getString("Insert current time"), new ImageIcon(AppFrame.class.getResource("resources/icons/time.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPanel.this.insTimeB_actionPerformed(actionEvent);
        }
    };
    public Action insertDateAction = new AbstractAction(net.sf.memoranda.util.Local.getString("Insert current date"), new ImageIcon(AppFrame.class.getResource("resources/icons/date.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPanel.this.insDateB_actionPerformed(actionEvent);
        }
    };
    public Action newAction = new AbstractAction(net.sf.memoranda.util.Local.getString("New note"), new ImageIcon(AppFrame.class.getResource("resources/icons/filenew.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPanel.this.newB_actionPerformed(actionEvent);
        }
    };
    public Action exportAction = new AbstractAction(net.sf.memoranda.util.Local.getString("Export note to file"), new ImageIcon(AppFrame.class.getResource("resources/icons/export.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPanel.this.exportB_actionPerformed(actionEvent);
        }
    };
    public Action importAction = new AbstractAction(net.sf.memoranda.util.Local.getString("Insert file"), new ImageIcon(AppFrame.class.getResource("resources/icons/import.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPanel.this.importB_actionPerformed(actionEvent);
        }
    };
    public Action previewAction = new AbstractAction(net.sf.memoranda.util.Local.getString("Preview note in browser"), new ImageIcon(AppFrame.class.getResource("resources/icons/preview.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPanel.this.previewB_actionPerformed(actionEvent);
        }
    };
    String initialTitle = "";

    public EditorPanel(DailyItemsPanel dailyItemsPanel) {
        try {
            this.parentPanel = dailyItemsPanel;
            this.jbInit();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    void jbInit() throws Exception {
        if (!Configuration.get("DISABLE_L10N").equals("yes")) {
            Local.setMessages(net.sf.memoranda.util.Local.getMessages());
        }
        this.editor = new HTMLEditor();
        this.setLayout(this.borderLayout1);
        this.newB.setAction(this.newAction);
        this.newB.setMaximumSize(new Dimension(24, 24));
        this.newB.setMinimumSize(new Dimension(24, 24));
        this.newB.setPreferredSize(new Dimension(24, 24));
        this.newB.setRequestFocusEnabled(false);
        this.newB.setToolTipText(net.sf.memoranda.util.Local.getString("New note"));
        this.newB.setBorderPainted(false);
        this.newB.setFocusable(false);
        this.newB.setText("");
        this.importB.setAction(this.importAction);
        this.importB.setBorderPainted(false);
        this.importB.setFocusable(false);
        this.importB.setPreferredSize(new Dimension(24, 24));
        this.importB.setRequestFocusEnabled(false);
        this.importB.setToolTipText(net.sf.memoranda.util.Local.getString("Insert file"));
        this.importB.setMinimumSize(new Dimension(24, 24));
        this.importB.setMaximumSize(new Dimension(24, 24));
        this.importB.setText("");
        this.exportB.setAction(this.exportAction);
        this.exportB.setMaximumSize(new Dimension(24, 24));
        this.exportB.setMinimumSize(new Dimension(24, 24));
        this.exportB.setPreferredSize(new Dimension(24, 24));
        this.exportB.setRequestFocusEnabled(false);
        this.exportB.setToolTipText(net.sf.memoranda.util.Local.getString("Export note to file"));
        this.exportB.setBorderPainted(false);
        this.exportB.setFocusable(false);
        this.exportB.setText("");
        this.redoB.setAction(this.editor.redoAction);
        this.redoB.setMaximumSize(new Dimension(24, 24));
        this.redoB.setMinimumSize(new Dimension(24, 24));
        this.redoB.setPreferredSize(new Dimension(24, 24));
        this.redoB.setRequestFocusEnabled(false);
        this.redoB.setToolTipText(net.sf.memoranda.util.Local.getString("Redo"));
        this.redoB.setBorderPainted(false);
        this.redoB.setFocusable(false);
        this.redoB.setText("");
        this.copyB.setAction(this.editor.copyAction);
        this.copyB.setMaximumSize(new Dimension(24, 24));
        this.copyB.setMinimumSize(new Dimension(24, 24));
        this.copyB.setPreferredSize(new Dimension(24, 24));
        this.copyB.setRequestFocusEnabled(false);
        this.copyB.setToolTipText(net.sf.memoranda.util.Local.getString("Copy"));
        this.copyB.setBorderPainted(false);
        this.copyB.setFocusable(false);
        this.copyB.setText("");
        this.historyBackB.setAction(History.historyBackAction);
        this.historyBackB.setMaximumSize(new Dimension(24, 24));
        this.historyBackB.setMinimumSize(new Dimension(24, 24));
        this.historyBackB.setPreferredSize(new Dimension(24, 24));
        this.historyBackB.setRequestFocusEnabled(false);
        this.historyBackB.setToolTipText(net.sf.memoranda.util.Local.getString("History back"));
        this.historyBackB.setBorderPainted(false);
        this.historyBackB.setFocusable(false);
        this.historyBackB.setText("");
        this.historyForwardB.setAction(History.historyForwardAction);
        this.historyForwardB.setBorderPainted(false);
        this.historyForwardB.setFocusable(false);
        this.historyForwardB.setPreferredSize(new Dimension(24, 24));
        this.historyForwardB.setRequestFocusEnabled(false);
        this.historyForwardB.setToolTipText(net.sf.memoranda.util.Local.getString("History forward"));
        this.historyForwardB.setMinimumSize(new Dimension(24, 24));
        this.historyForwardB.setMaximumSize(new Dimension(24, 24));
        this.historyForwardB.setText("");
        this.pasteB.setAction(this.editor.pasteAction);
        this.pasteB.setMaximumSize(new Dimension(24, 24));
        this.pasteB.setMinimumSize(new Dimension(24, 24));
        this.pasteB.setPreferredSize(new Dimension(24, 24));
        this.pasteB.setRequestFocusEnabled(false);
        this.pasteB.setToolTipText(net.sf.memoranda.util.Local.getString("paste"));
        this.pasteB.setBorderPainted(false);
        this.pasteB.setFocusable(false);
        this.pasteB.setText("");
        this.insDateB.setAction(this.insertDateAction);
        this.insDateB.setBorderPainted(false);
        this.insDateB.setFocusable(false);
        this.insDateB.setPreferredSize(new Dimension(24, 24));
        this.insDateB.setRequestFocusEnabled(false);
        this.insDateB.setToolTipText(net.sf.memoranda.util.Local.getString("Insert current date"));
        this.insDateB.setMinimumSize(new Dimension(24, 24));
        this.insDateB.setMaximumSize(new Dimension(24, 24));
        this.insDateB.setText("");
        this.insTimeB.setAction(this.insertTimeAction);
        this.insTimeB.setMaximumSize(new Dimension(24, 24));
        this.insTimeB.setMinimumSize(new Dimension(24, 24));
        this.insTimeB.setPreferredSize(new Dimension(24, 24));
        this.insTimeB.setRequestFocusEnabled(false);
        this.insTimeB.setToolTipText(net.sf.memoranda.util.Local.getString("Insert current time"));
        this.insTimeB.setBorderPainted(false);
        this.insTimeB.setFocusable(false);
        this.insTimeB.setText("");
        this.undoB.setAction(this.editor.undoAction);
        this.undoB.setBorderPainted(false);
        this.undoB.setFocusable(false);
        this.undoB.setPreferredSize(new Dimension(24, 24));
        this.undoB.setRequestFocusEnabled(false);
        this.undoB.setToolTipText(net.sf.memoranda.util.Local.getString("Undo"));
        this.undoB.setMinimumSize(new Dimension(24, 24));
        this.undoB.setMaximumSize(new Dimension(24, 24));
        this.undoB.setText("");
        this.cutB.setAction(this.editor.cutAction);
        this.cutB.setBorderPainted(false);
        this.cutB.setFocusable(false);
        this.cutB.setPreferredSize(new Dimension(24, 24));
        this.cutB.setRequestFocusEnabled(false);
        this.cutB.setToolTipText(net.sf.memoranda.util.Local.getString("Cut"));
        this.cutB.setMinimumSize(new Dimension(24, 24));
        this.cutB.setMaximumSize(new Dimension(24, 24));
        this.cutB.setText("");
        this.previewB.setAction(this.previewAction);
        this.previewB.setBorderPainted(false);
        this.previewB.setFocusable(false);
        this.previewB.setPreferredSize(new Dimension(24, 24));
        this.previewB.setRequestFocusEnabled(false);
        this.previewB.setToolTipText(this.previewAction.getValue("Name").toString());
        this.previewB.setMinimumSize(new Dimension(24, 24));
        this.previewB.setMaximumSize(new Dimension(24, 24));
        this.previewB.setText("");
        this.jPanel1.setLayout(this.borderLayout2);
        this.titleLabel.setFont(new Font("Dialog", 1, 10));
        this.titleLabel.setText(net.sf.memoranda.util.Local.getString("Title") + "  ");
        this.titleField.setText("");
        this.editorToolBar.setFloatable(false);
        this.editor.editToolbar.setFloatable(false);
        this.titleBar.setFloatable(false);
        this.add((Component)this.jPanel1, "Center");
        this.editorToolBar.add((Component)this.newB, null);
        this.editorToolBar.addSeparator(new Dimension(8, 24));
        this.editorToolBar.add((Component)this.historyBackB, null);
        this.editorToolBar.add((Component)this.historyForwardB, null);
        this.editorToolBar.addSeparator(new Dimension(8, 24));
        this.editorToolBar.add((Component)this.undoB, null);
        this.editorToolBar.add((Component)this.redoB, null);
        this.editorToolBar.addSeparator(new Dimension(8, 24));
        this.editorToolBar.add((Component)this.cutB, null);
        this.editorToolBar.add((Component)this.copyB, null);
        this.editorToolBar.add((Component)this.pasteB, null);
        this.editorToolBar.addSeparator(new Dimension(8, 24));
        this.editorToolBar.add((Component)this.insDateB, null);
        this.editorToolBar.add((Component)this.insTimeB, null);
        this.editorToolBar.addSeparator(new Dimension(8, 24));
        this.editorToolBar.add((Component)this.importB, null);
        this.editorToolBar.add((Component)this.exportB, null);
        this.editorToolBar.addSeparator(new Dimension(8, 24));
        this.editorToolBar.add((Component)this.previewB, null);
        this.jPanel1.add((Component)this.editorToolBar, "North");
        this.jPanel1.add((Component)this.editor, "Center");
        this.add((Component)this.titleBar, "North");
        this.titleBar.add((Component)this.titleLabel, null);
        this.titleBar.add((Component)this.titleField, null);
        this.initCSS();
        this.editor.editor.setAntiAlias(Configuration.get("ANTIALIAS_TEXT").toString().equalsIgnoreCase("yes"));
        this.titleField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    EditorPanel.this.editor.editor.requestFocus();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    public void initCSS() {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(EditorPanel.class.getResourceAsStream("resources/css/default.css")));
        String string2 = "";
        try {
            string = bufferedReader.readLine();
            while (string != null) {
                string2 = string2 + string + "\n";
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        string = Configuration.get("NORMAL_FONT").toString();
        String string3 = Configuration.get("HEADER_FONT").toString();
        String string4 = Configuration.get("MONO_FONT").toString();
        String string5 = Configuration.get("BASE_FONT_SIZE").toString();
        string2 = string2.replaceAll("%NORMAL_FONT%", string.length() > 0 ? "\"" + string + "\"" : "serif");
        string2 = string2.replaceAll("%HEADER_FONT%", string3.length() > 0 ? "\"" + string3 + "\"" : "sans-serif");
        string2 = string2.replaceAll("%MONO_FONT%", string4.length() > 0 ? "\"" + string4 + "\"" : "monospaced");
        string2 = string2.replaceAll("%BASE_FONT_SIZE%", string5.length() > 0 ? string5 : "16");
        this.editor.setStyleSheet(new StringReader(string2));
        String string6 = (String)Configuration.get("USER_CSS");
        if (string6.length() > 0) {
            try {
                System.out.println("***[DEBUG] User css used: " + string6);
                this.editor.setStyleSheet(new InputStreamReader(new FileInputStream(string6)));
            }
            catch (Exception exception) {
                System.out.println("***[DEBUG] Failed to open: " + string6);
                exception.printStackTrace();
            }
        }
    }

    void insDateB_actionPerformed(ActionEvent actionEvent) {
        this.editor.editor.replaceSelection(CurrentDate.get().getFullDateString());
    }

    void insTimeB_actionPerformed(ActionEvent actionEvent) {
        Date date = new Date();
        this.editor.editor.replaceSelection(DateFormat.getTimeInstance(3, net.sf.memoranda.util.Local.getCurrentLocale()).format(date));
    }

    void exportB_actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2;
        String string3;
        UIManager.put("FileChooser.lookInLabelText", net.sf.memoranda.util.Local.getString("Save in:"));
        UIManager.put("FileChooser.upFolderToolTipText", net.sf.memoranda.util.Local.getString("Up One Level"));
        UIManager.put("FileChooser.newFolderToolTipText", net.sf.memoranda.util.Local.getString("Create New Folder"));
        UIManager.put("FileChooser.listViewButtonToolTipText", net.sf.memoranda.util.Local.getString("List"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", net.sf.memoranda.util.Local.getString("Details"));
        UIManager.put("FileChooser.fileNameLabelText", net.sf.memoranda.util.Local.getString("File Name:"));
        UIManager.put("FileChooser.filesOfTypeLabelText", net.sf.memoranda.util.Local.getString("Files of Type:"));
        UIManager.put("FileChooser.saveButtonText", net.sf.memoranda.util.Local.getString("Save"));
        UIManager.put("FileChooser.saveButtonToolTipText", net.sf.memoranda.util.Local.getString("Save selected file"));
        UIManager.put("FileChooser.cancelButtonText", net.sf.memoranda.util.Local.getString("Cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", net.sf.memoranda.util.Local.getString("Cancel"));
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setDialogTitle(net.sf.memoranda.util.Local.getString("Export note"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new AllFilesFilter("XHTML"));
        jFileChooser.addChoosableFileFilter(new AllFilesFilter("HTML"));
        String string4 = (String)Context.get("LAST_SELECTED_EXPORT_FILE");
        if (string4 != null) {
            jFileChooser.setCurrentDirectory(new File(string4));
        }
        FileExportDialog fileExportDialog = new FileExportDialog((Frame)App.getFrame(), net.sf.memoranda.util.Local.getString("Export note"), jFileChooser);
        String string5 = (String)Context.get("EXPORT_FILE_ENCODING");
        if (string5 != null) {
            fileExportDialog.encCB.setSelectedItem(string5);
        }
        if ((string3 = (String)Context.get("EXPORT_TEMPLATE")) != null) {
            fileExportDialog.templF.setText(string3);
        }
        if ((string2 = (String)Context.get("EXPORT_XHTML")) != null && string2.equalsIgnoreCase("YES")) {
            fileExportDialog.xhtmlChB.setSelected(true);
        }
        if ((string = (String)Context.get("EXPORT_NUMENT")) != null && string.equalsIgnoreCase("YES")) {
            fileExportDialog.numentChB.setSelected(true);
        }
        Dimension dimension = new Dimension(550, 475);
        fileExportDialog.setSize(dimension);
        Dimension dimension2 = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        fileExportDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        fileExportDialog.setVisible(true);
        if (fileExportDialog.CANCELLED) {
            return;
        }
        Context.put("LAST_SELECTED_EXPORT_FILE", jFileChooser.getSelectedFile().getPath());
        Context.put("EXPORT_FILE_ENCODING", fileExportDialog.encCB.getSelectedItem());
        Context.put("EXPORT_NUMENT", fileExportDialog.numentChB.isSelected() ? "YES" : "NO");
        Context.put("EXPORT_XHTML", fileExportDialog.xhtmlChB.isSelected() ? "YES" : "NO");
        String string6 = null;
        if (fileExportDialog.usetemplChB.isSelected() && fileExportDialog.templF.getText().length() > 0) {
            string6 = fileExportDialog.templF.getText();
            Context.put("EXPORT_TEMPLATE", string6);
        }
        int n = fileExportDialog.encCB.getSelectedIndex();
        string5 = null;
        if (n == 1) {
            string5 = "UTF-8";
        }
        File file = jFileChooser.getSelectedFile();
        new HTMLFileExport(file, this.editor.document, CurrentNote.get(), string5, fileExportDialog.numentChB.isSelected(), string6, fileExportDialog.xhtmlChB.isSelected());
    }

    public void setDocument(Note note) {
        this.editor.document = (HTMLDocument)CurrentStorage.get().openNote(note);
        this.editor.initEditor();
        if (note != null) {
            this.titleField.setText(note.getTitle());
        } else {
            this.titleField.setText("");
        }
        this.initialTitle = this.titleField.getText();
    }

    public Document getDocument() {
        return this.editor.document;
    }

    public boolean isDocumentChanged() {
        return this.editor.isDocumentChanged() || !this.titleField.getText().equals(this.initialTitle);
    }

    void importB_actionPerformed(ActionEvent actionEvent) {
        UIManager.put("FileChooser.lookInLabelText", net.sf.memoranda.util.Local.getString("Look in:"));
        UIManager.put("FileChooser.upFolderToolTipText", net.sf.memoranda.util.Local.getString("Up One Level"));
        UIManager.put("FileChooser.newFolderToolTipText", net.sf.memoranda.util.Local.getString("Create New Folder"));
        UIManager.put("FileChooser.listViewButtonToolTipText", net.sf.memoranda.util.Local.getString("List"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", net.sf.memoranda.util.Local.getString("Details"));
        UIManager.put("FileChooser.fileNameLabelText", net.sf.memoranda.util.Local.getString("File Name:"));
        UIManager.put("FileChooser.filesOfTypeLabelText", net.sf.memoranda.util.Local.getString("Files of Type:"));
        UIManager.put("FileChooser.openButtonText", net.sf.memoranda.util.Local.getString("Open"));
        UIManager.put("FileChooser.openButtonToolTipText", net.sf.memoranda.util.Local.getString("Open selected file"));
        UIManager.put("FileChooser.cancelButtonText", net.sf.memoranda.util.Local.getString("Cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", net.sf.memoranda.util.Local.getString("Cancel"));
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setDialogTitle(net.sf.memoranda.util.Local.getString("Insert file"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new AllFilesFilter("HTML"));
        jFileChooser.setPreferredSize(new Dimension(550, 375));
        String string = (String)Context.get("LAST_SELECTED_IMPORT_FILE");
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        if (jFileChooser.showOpenDialog(this) != 0) {
            return;
        }
        Context.put("LAST_SELECTED_IMPORT_FILE", jFileChooser.getSelectedFile().getPath());
        File file = jFileChooser.getSelectedFile();
        new HTMLFileImport(file, this.editor);
    }

    void newB_actionPerformed(ActionEvent actionEvent) {
        CurrentNote.set(null, true);
        this.setDocument(null);
        this.titleField.requestFocus();
    }

    void previewB_actionPerformed(ActionEvent actionEvent) {
        try {
            File file = Util.getTempFile();
            new HTMLFileExport(file, this.editor.document, CurrentNote.get(), "UTF-8", false, null, false);
            Util.runBrowser("file:" + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            new ExceptionDialog(iOException, "Cannot create temporary file", null);
        }
    }
}

