/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.CalendarFrame;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.util.Local;

public class EventDialog
extends JDialog
implements WindowListener {
    public boolean CANCELLED = false;
    boolean ignoreStartChanged = false;
    boolean ignoreEndChanged = false;
    JPanel topPanel = new JPanel(new BorderLayout());
    JPanel bottomPanel = new JPanel(new BorderLayout());
    JPanel headerPanel = new JPanel(new FlowLayout(0));
    public JLabel header = new JLabel();
    JPanel eventPanel = new JPanel(new GridBagLayout());
    GridBagConstraints gbc;
    JLabel lblTime = new JLabel();
    public JSpinner timeSpin = new JSpinner(new SpinnerDateModel(new Date(), null, null, 12));
    JLabel lblText = new JLabel();
    public JTextField textField = new JTextField();
    TitledBorder repeatBorder;
    JPanel repeatPanel = new JPanel(new GridBagLayout());
    public JRadioButton noRepeatRB = new JRadioButton();
    public JRadioButton dailyRepeatRB = new JRadioButton();
    public JSpinner daySpin = new JSpinner(new SpinnerNumberModel(1, 1, 365, 1));
    JLabel lblDays = new JLabel();
    JLabel lblSince = new JLabel();
    public JSpinner startDate = new JSpinner(new SpinnerDateModel());
    JButton setStartDateB = new JButton();
    public JRadioButton weeklyRepeatRB = new JRadioButton();
    public JComboBox weekdaysCB = new JComboBox<String>(Local.getWeekdayNames());
    public JCheckBox enableEndDateCB = new JCheckBox();
    public JCheckBox workingDaysOnlyCB = new JCheckBox();
    public JSpinner endDate = new JSpinner(new SpinnerDateModel());
    JButton setEndDateB = new JButton();
    public JRadioButton monthlyRepeatRB = new JRadioButton();
    public JSpinner dayOfMonthSpin = new JSpinner(new SpinnerNumberModel(1, 1, 31, 1));
    JLabel lblDoM = new JLabel();
    public JRadioButton yearlyRepeatRB = new JRadioButton();
    ButtonGroup repeatRBGroup = new ButtonGroup();
    JPanel buttonsPanel = new JPanel(new FlowLayout(2, 10, 10));
    JButton okB = new JButton();
    JButton cancelB = new JButton();
    CalendarFrame endCalFrame = new CalendarFrame();
    CalendarFrame startCalFrame = new CalendarFrame();
    private Date eventDate;

    public EventDialog(Frame frame, String string) {
        super(frame, string, true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
        super.addWindowListener(this);
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        this.headerPanel.setBackground(Color.WHITE);
        this.headerPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.header.setFont(new Font("Dialog", 0, 20));
        this.header.setForeground(new Color(0, 0, 124));
        this.header.setText(Local.getString("Event"));
        this.header.setIcon(new ImageIcon(EventDialog.class.getResource("resources/icons/event48.png")));
        this.headerPanel.add(this.header);
        this.lblTime.setText(Local.getString("Time"));
        this.lblTime.setMinimumSize(new Dimension(60, 24));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(10, 10, 5, 10);
        this.gbc.anchor = 17;
        this.eventPanel.add((Component)this.lblTime, this.gbc);
        this.timeSpin.setPreferredSize(new Dimension(60, 24));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(10, 0, 5, 0);
        this.gbc.anchor = 17;
        this.eventPanel.add((Component)this.timeSpin, this.gbc);
        this.lblText.setText(Local.getString("Text"));
        this.lblText.setMinimumSize(new Dimension(120, 24));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 3;
        this.gbc.insets = new Insets(5, 10, 5, 10);
        this.gbc.anchor = 17;
        this.eventPanel.add((Component)this.lblText, this.gbc);
        this.textField.setMinimumSize(new Dimension(375, 24));
        this.textField.setPreferredSize(new Dimension(375, 24));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 6;
        this.gbc.insets = new Insets(5, 10, 10, 10);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.eventPanel.add((Component)this.textField, this.gbc);
        this.repeatBorder = new TitledBorder(BorderFactory.createLineBorder(Color.gray, 1), Local.getString("Repeat"));
        this.repeatPanel.setBorder(this.repeatBorder);
        this.noRepeatRB.setMaximumSize(new Dimension(80, 35));
        this.noRepeatRB.setSelected(true);
        this.noRepeatRB.setText(Local.getString("No repeat"));
        this.noRepeatRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventDialog.this.noRepeatRB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 4;
        this.gbc.insets = new Insets(5, 5, 5, 0);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.repeatPanel.add((Component)this.noRepeatRB, this.gbc);
        this.dailyRepeatRB.setActionCommand("daily");
        this.dailyRepeatRB.setText(Local.getString("Every"));
        this.dailyRepeatRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventDialog.this.dailyRepeatRB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 5, 5, 0);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.dailyRepeatRB, this.gbc);
        this.daySpin.setPreferredSize(new Dimension(50, 24));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 5, 5, 0);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.daySpin, this.gbc);
        this.lblDays.setText(Local.getString("day(s)"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(5, 5, 5, 40);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.lblDays, this.gbc);
        this.lblSince.setText(Local.getString("Since"));
        this.lblSince.setMinimumSize(new Dimension(70, 16));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 4;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 0, 5, 5);
        this.gbc.anchor = 13;
        this.repeatPanel.add((Component)this.lblSince, this.gbc);
        this.startDate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Date date;
                if (EventDialog.this.ignoreStartChanged) {
                    return;
                }
                EventDialog.this.ignoreStartChanged = true;
                Date date2 = (Date)EventDialog.this.startDate.getModel().getValue();
                if (date2.after(date = (Date)EventDialog.this.endDate.getModel().getValue())) {
                    EventDialog.this.endDate.getModel().setValue(date2);
                    date = date2;
                }
                EventDialog.this.startCalFrame.cal.set(new CalendarDate(date2));
                EventDialog.this.ignoreStartChanged = false;
            }
        });
        this.startDate.setPreferredSize(new Dimension(80, 24));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3);
        this.startDate.setEditor(new JSpinner.DateEditor(this.startDate, simpleDateFormat.toPattern()));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 5;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 0, 5, 5);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.startDate, this.gbc);
        this.setStartDateB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventDialog.this.setStartDateB_actionPerformed(actionEvent);
            }
        });
        this.setStartDateB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/calendar.png")));
        this.setStartDateB.setText("");
        this.setStartDateB.setPreferredSize(new Dimension(24, 24));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 6;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 0, 5, 5);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.setStartDateB, this.gbc);
        this.weeklyRepeatRB.setActionCommand("weekly");
        this.weeklyRepeatRB.setText(Local.getString("Every"));
        this.weeklyRepeatRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventDialog.this.weeklyRepeatRB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.weeklyRepeatRB, this.gbc);
        this.weekdaysCB.setPreferredSize(new Dimension(100, 25));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(5, 0, 5, 40);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.weekdaysCB, this.gbc);
        this.enableEndDateCB.setHorizontalAlignment(4);
        this.enableEndDateCB.setText(Local.getString("Till"));
        this.enableEndDateCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventDialog.this.enableEndDateCB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 4;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 0, 5, 5);
        this.gbc.anchor = 13;
        this.repeatPanel.add((Component)this.enableEndDateCB, this.gbc);
        this.endDate.setPreferredSize(new Dimension(80, 24));
        this.endDate.setEditor(new JSpinner.DateEditor(this.endDate, simpleDateFormat.toPattern()));
        this.endDate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Date date;
                if (EventDialog.this.ignoreEndChanged) {
                    return;
                }
                EventDialog.this.ignoreEndChanged = true;
                Date date2 = (Date)EventDialog.this.startDate.getModel().getValue();
                if (date2.after(date = (Date)EventDialog.this.endDate.getModel().getValue())) {
                    EventDialog.this.endDate.getModel().setValue(date2);
                    date = date2;
                }
                EventDialog.this.endCalFrame.cal.set(new CalendarDate(date));
                EventDialog.this.ignoreEndChanged = false;
            }
        });
        this.workingDaysOnlyCB.setText(Local.getString("Working days only"));
        this.workingDaysOnlyCB.setHorizontalAlignment(4);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 4;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(5, 0, 5, 5);
        this.gbc.anchor = 13;
        this.repeatPanel.add((Component)this.workingDaysOnlyCB, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 5;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 0, 5, 5);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.endDate, this.gbc);
        this.setEndDateB.setMinimumSize(new Dimension(24, 24));
        this.setEndDateB.setPreferredSize(new Dimension(24, 24));
        this.setEndDateB.setText("");
        this.setEndDateB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/calendar.png")));
        this.setEndDateB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventDialog.this.setEndDateB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 6;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 0, 5, 5);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.setEndDateB, this.gbc);
        this.monthlyRepeatRB.setActionCommand("daily");
        this.monthlyRepeatRB.setText(Local.getString("Every"));
        this.monthlyRepeatRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventDialog.this.monthlyRepeatRB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.monthlyRepeatRB, this.gbc);
        this.dayOfMonthSpin.setPreferredSize(new Dimension(50, 24));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.dayOfMonthSpin, this.gbc);
        this.lblDoM.setText(Local.getString("day of month"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 3;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.lblDoM, this.gbc);
        this.yearlyRepeatRB.setActionCommand("yearly");
        this.yearlyRepeatRB.setText(Local.getString("Yearly"));
        this.yearlyRepeatRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventDialog.this.yearlyRepeatRB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.gridwidth = 5;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        this.gbc.anchor = 17;
        this.repeatPanel.add((Component)this.yearlyRepeatRB, this.gbc);
        this.repeatRBGroup.add(this.noRepeatRB);
        this.repeatRBGroup.add(this.dailyRepeatRB);
        this.repeatRBGroup.add(this.weeklyRepeatRB);
        this.repeatRBGroup.add(this.monthlyRepeatRB);
        this.repeatRBGroup.add(this.yearlyRepeatRB);
        this.okB.setMaximumSize(new Dimension(100, 26));
        this.okB.setMinimumSize(new Dimension(100, 26));
        this.okB.setPreferredSize(new Dimension(100, 26));
        this.okB.setText(Local.getString("Ok"));
        this.okB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventDialog.this.okB_actionPerformed(actionEvent);
            }
        });
        this.getRootPane().setDefaultButton(this.okB);
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventDialog.this.cancelB_actionPerformed(actionEvent);
            }
        });
        this.cancelB.setText(Local.getString("Cancel"));
        this.cancelB.setPreferredSize(new Dimension(100, 26));
        this.cancelB.setMinimumSize(new Dimension(100, 26));
        this.cancelB.setMaximumSize(new Dimension(100, 26));
        this.buttonsPanel.add(this.okB);
        this.buttonsPanel.add(this.cancelB);
        this.topPanel.add((Component)this.headerPanel, "North");
        this.topPanel.add((Component)this.eventPanel, "South");
        this.bottomPanel.add((Component)this.repeatPanel, "North");
        this.bottomPanel.add((Component)this.buttonsPanel, "South");
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.startCalFrame.cal.addSelectionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EventDialog.this.ignoreStartChanged) {
                    return;
                }
                EventDialog.this.startDate.getModel().setValue(EventDialog.this.startCalFrame.cal.get().getCalendar().getTime());
            }
        });
        this.endCalFrame.cal.addSelectionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EventDialog.this.ignoreEndChanged) {
                    return;
                }
                EventDialog.this.endDate.getModel().setValue(EventDialog.this.endCalFrame.cal.get().getCalendar().getTime());
            }
        });
        this.disableElements();
        ((JSpinner.DateEditor)this.timeSpin.getEditor()).getFormat().applyPattern("HH:mm");
        this.enableEndDateCB_actionPerformed(null);
    }

    void disableElements() {
        this.dayOfMonthSpin.setEnabled(false);
        this.daySpin.setEnabled(false);
        this.weekdaysCB.setEnabled(false);
        this.startDate.setEnabled(false);
        this.setStartDateB.setEnabled(false);
        this.lblSince.setEnabled(false);
        this.endDate.setEnabled(false);
        this.setEndDateB.setEnabled(false);
        this.enableEndDateCB.setEnabled(false);
        this.enableEndDateCB.setSelected(false);
        this.workingDaysOnlyCB.setEnabled(false);
        this.workingDaysOnlyCB.setSelected(false);
    }

    public void yearlyRepeatRB_actionPerformed(ActionEvent actionEvent) {
        this.disableElements();
        this.startDate.setEnabled(true);
        this.setStartDateB.setEnabled(true);
        this.lblSince.setEnabled(true);
        this.enableEndDateCB.setEnabled(true);
        this.workingDaysOnlyCB.setEnabled(true);
        this.startDate.getModel().setValue(this.startCalFrame.cal.get().getCalendar().getTime());
    }

    public void monthlyRepeatRB_actionPerformed(ActionEvent actionEvent) {
        this.disableElements();
        this.dayOfMonthSpin.setEnabled(true);
        this.startDate.setEnabled(true);
        this.setStartDateB.setEnabled(true);
        this.lblSince.setEnabled(true);
        this.enableEndDateCB.setEnabled(true);
        this.workingDaysOnlyCB.setEnabled(true);
        this.startDate.getModel().setValue(this.startCalFrame.cal.get().getCalendar().getTime());
    }

    public void dailyRepeatRB_actionPerformed(ActionEvent actionEvent) {
        this.disableElements();
        this.daySpin.setEnabled(true);
        this.startDate.setEnabled(true);
        this.setStartDateB.setEnabled(true);
        this.lblSince.setEnabled(true);
        this.enableEndDateCB.setEnabled(true);
        this.workingDaysOnlyCB.setEnabled(true);
        this.startDate.getModel().setValue(this.startCalFrame.cal.get().getCalendar().getTime());
    }

    public void weeklyRepeatRB_actionPerformed(ActionEvent actionEvent) {
        this.disableElements();
        this.weekdaysCB.setEnabled(true);
        this.startDate.setEnabled(true);
        this.setStartDateB.setEnabled(true);
        this.lblSince.setEnabled(true);
        this.enableEndDateCB.setEnabled(true);
        this.startDate.getModel().setValue(this.startCalFrame.cal.get().getCalendar().getTime());
    }

    public void noRepeatRB_actionPerformed(ActionEvent actionEvent) {
        this.disableElements();
    }

    void okB_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void cancelB_actionPerformed(ActionEvent actionEvent) {
        this.CANCELLED = true;
        this.dispose();
    }

    void setStartDateB_actionPerformed(ActionEvent actionEvent) {
        this.startCalFrame.setSize(200, 190);
        this.startCalFrame.setTitle(Local.getString("Start date"));
        this.getLayeredPane().add(this.startCalFrame);
        this.startCalFrame.show();
    }

    void setEndDateB_actionPerformed(ActionEvent actionEvent) {
        this.endCalFrame.setSize(200, 190);
        this.endCalFrame.setTitle(Local.getString("End date"));
        this.getLayeredPane().add(this.endCalFrame);
        this.endCalFrame.show();
    }

    public void enableEndDateCB_actionPerformed(ActionEvent actionEvent) {
        this.endDate.setEnabled(this.enableEndDateCB.isSelected());
        this.setEndDateB.setEnabled(this.enableEndDateCB.isSelected());
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.CANCELLED = true;
        this.dispose();
    }

    public void setEventDate(Date date) {
        this.eventDate = date;
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

