/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JLabel;
import net.sf.memoranda.Task;
import net.sf.memoranda.ui.TaskTable;
import net.sf.memoranda.ui.TaskTreeTableCellRenderer;

class TaskProgressLabel
extends JLabel {
    TaskTable table;
    int column;
    Task task;

    public TaskProgressLabel(TaskTable taskTable) {
        this.table = taskTable;
        this.setHorizontalAlignment(0);
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public void paintComponent(Graphics graphics) {
        int n = this.task.getProgress();
        int n2 = this.table.getColumnModel().getColumn(this.column).getWidth();
        int n3 = this.table.getRowHeight();
        int n4 = n2 * n / 100;
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, n2, n3);
        graphics.setColor(TaskTreeTableCellRenderer.getColorForTaskStatus(this.task, true));
        graphics.fillRect(1, 1, n4, n3 - 2);
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.drawRect(1, 1, n2, n3 - 2);
        this.setText(n + "%");
        this.setBounds(0, 0, n2, n3);
        super.paintComponent(graphics);
    }
}

