/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui.htmleditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.sf.memoranda.ui.htmleditor.CharTablePanel;
import net.sf.memoranda.ui.htmleditor.Context;
import net.sf.memoranda.ui.htmleditor.ElementDialog;
import net.sf.memoranda.ui.htmleditor.FindDialog;
import net.sf.memoranda.ui.htmleditor.Finder;
import net.sf.memoranda.ui.htmleditor.FontDialog;
import net.sf.memoranda.ui.htmleditor.HTMLEditorPane;
import net.sf.memoranda.ui.htmleditor.ImageDialog;
import net.sf.memoranda.ui.htmleditor.LinkDialog;
import net.sf.memoranda.ui.htmleditor.TableDialog;
import net.sf.memoranda.ui.htmleditor.TdDialog;
import net.sf.memoranda.ui.htmleditor.Util;
import net.sf.memoranda.ui.htmleditor.util.Local;

public class HTMLEditor
extends JPanel {
    public HTMLEditorPane editor = new HTMLEditorPane("");
    JScrollPane jScrollPane1 = new JScrollPane();
    public HTMLEditorKit editorKit = new HTMLEditorKit();
    public HTMLDocument document = null;
    boolean bold = false;
    boolean italic = false;
    boolean under = false;
    boolean list = false;
    String currentTagName = "BODY";
    Element currentParaElement = null;
    Border border1;
    Border border2;
    Class cl = HTMLEditor.class;
    String imagesDir = null;
    String imagesPath = null;
    public Action boldAction = new HTMLEditorAction(Local.getString("Bold"), new ImageIcon(this.cl.getResource("resources/icons/bold.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.boldActionB_actionPerformed(actionEvent);
        }
    };
    public Action italicAction = new HTMLEditorAction(Local.getString("Italic"), new ImageIcon(this.cl.getResource("resources/icons/italic.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.italicActionB_actionPerformed(actionEvent);
        }
    };
    public Action underAction = new HTMLEditorAction(Local.getString("Underline"), new ImageIcon(this.cl.getResource("resources/icons/underline.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.underActionB_actionPerformed(actionEvent);
        }
    };
    public Action ulAction = new HTMLEditorAction(Local.getString("Unordered list"), new ImageIcon(this.cl.getResource("resources/icons/listunordered.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.ulActionB_actionPerformed(actionEvent);
        }
    };
    public Action olAction = new HTMLEditorAction(Local.getString("Ordered list"), new ImageIcon(this.cl.getResource("resources/icons/listordered.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.olActionB_actionPerformed(actionEvent);
        }
    };
    public Action lAlignAction = new HTMLEditorAction(Local.getString("Align left"), new ImageIcon(this.cl.getResource("resources/icons/alignleft.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.lAlignActionB_actionPerformed(actionEvent);
        }
    };
    public Action cAlignAction = new HTMLEditorAction(Local.getString("Align center"), new ImageIcon(this.cl.getResource("resources/icons/aligncenter.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.cAlignActionB_actionPerformed(actionEvent);
        }
    };
    public Action rAlignAction = new HTMLEditorAction(Local.getString("Align right"), new ImageIcon(this.cl.getResource("resources/icons/alignright.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.rAlignActionB_actionPerformed(actionEvent);
        }
    };
    public Action imageAction = new HTMLEditorAction(Local.getString("Insert image"), new ImageIcon(this.cl.getResource("resources/icons/image.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.imageActionB_actionPerformed(actionEvent);
        }
    };
    public Action tableAction = new HTMLEditorAction(Local.getString("Insert table"), new ImageIcon(this.cl.getResource("resources/icons/table.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.tableActionB_actionPerformed(actionEvent);
        }
    };
    public Action linkAction = new HTMLEditorAction(Local.getString("Insert hyperlink"), new ImageIcon(this.cl.getResource("resources/icons/link.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.linkActionB_actionPerformed(actionEvent);
        }
    };
    public Action propsAction = new HTMLEditorAction(Local.getString("Object properties"), new ImageIcon(this.cl.getResource("resources/icons/properties.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.propsActionB_actionPerformed(actionEvent);
        }
    };
    public Action selectAllAction = new HTMLEditorAction(Local.getString("Select all")){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.editor.selectAll();
        }
    };
    public Action insertHRAction = new HTMLEditorAction(Local.getString("Insert horizontal rule"), new ImageIcon(this.cl.getResource("resources/icons/hr.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                HTMLEditor.this.editorKit.insertHTML(HTMLEditor.this.document, HTMLEditor.this.editor.getCaretPosition(), "<hr>", 0, 0, HTML.Tag.HR);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };
    CharTablePanel charTablePanel = new CharTablePanel(this.editor);
    boolean charTableShow = false;
    public JTabbedPane toolsPanel = new JTabbedPane();
    public boolean toolsPanelShow = false;
    public Action insCharAction = new HTMLEditorAction(Local.getString("Insert character"), new ImageIcon(this.cl.getResource("resources/icons/char.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            if (!HTMLEditor.this.charTableShow) {
                HTMLEditor.this.addCharTablePanel();
                HTMLEditor.this.charTableShow = true;
                HTMLEditor.this.insCharActionB.setBorder(HTMLEditor.this.border2);
            } else {
                HTMLEditor.this.removeCharTablePanel();
                HTMLEditor.this.charTableShow = false;
                HTMLEditor.this.insCharActionB.setBorder(HTMLEditor.this.border1);
            }
            HTMLEditor.this.insCharActionB.setBorderPainted(HTMLEditor.this.charTableShow);
        }
    };
    public Action findAction = new HTMLEditorAction(Local.getString("Find & Replace"), new ImageIcon(this.cl.getResource("resources/icons/find.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.doFind();
        }
    };
    public InsertTableCellAction insertTableCellAction = new InsertTableCellAction();
    public InsertTableRowAction insertTableRowAction = new InsertTableRowAction();
    public BreakAction breakAction = new BreakAction();
    public Action cutAction = new DefaultEditorKit.CutAction();
    public Action styleCopyAction;
    public Action copyAction = this.styleCopyAction = new DefaultEditorKit.CopyAction();
    public Action stylePasteAction = new DefaultEditorKit.PasteAction();
    public Action pasteAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.doPaste();
        }
    };
    public Action zoomInAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.doZoom(true);
        }
    };
    public Action zoomOutAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.doZoom(false);
        }
    };
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public UndoAction undoAction = new UndoAction();
    public RedoAction redoAction = new RedoAction();
    JButton jAlignActionB = new JButton();
    public JToolBar editToolbar = new JToolBar();
    JButton lAlignActionB = new JButton();
    JButton olActionB = new JButton();
    JButton linkActionB = new JButton();
    JButton italicActionB = new JButton();
    JButton propsActionB = new JButton();
    JButton imageActionB = new JButton();
    public final int T_P = 0;
    public final int T_H1 = 1;
    public final int T_H2 = 2;
    public final int T_H3 = 3;
    public final int T_H4 = 4;
    public final int T_H5 = 5;
    public final int T_H6 = 6;
    public final int T_PRE = 7;
    public final int T_BLOCKQ = 8;
    String[] elementTypes = new String[]{Local.getString("Paragraph"), Local.getString("Header") + " 1", Local.getString("Header") + " 2", Local.getString("Header") + " 3", Local.getString("Header") + " 4", Local.getString("Header") + " 5", Local.getString("Header") + " 6", Local.getString("Preformatted"), Local.getString("Blockquote")};
    public JComboBox blockCB = new JComboBox<String>(this.elementTypes);
    boolean blockCBEventsLock = false;
    public final int I_NORMAL = 0;
    public final int I_EM = 1;
    public final int I_STRONG = 2;
    public final int I_CODE = 3;
    public final int I_CITE = 4;
    public final int I_SUPERSCRIPT = 5;
    public final int I_SUBSCRIPT = 6;
    public final int I_CUSTOM = 7;
    String[] inlineTypes = new String[]{Local.getString("Normal"), Local.getString("Emphasis"), Local.getString("Strong"), Local.getString("Code"), Local.getString("Cite"), Local.getString("Superscript"), Local.getString("Subscript"), Local.getString("Custom style") + "..."};
    public JComboBox inlineCB = new JComboBox<String>(this.inlineTypes);
    boolean inlineCBEventsLock = false;
    JButton boldActionB = new JButton();
    JButton ulActionB = new JButton();
    JButton rAlignActionB = new JButton();
    JButton tableActionB = new JButton();
    JButton cAlignActionB = new JButton();
    JButton underActionB = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JPopupMenu defaultPopupMenu = new JPopupMenu();
    JMenuItem jMenuItemUndo = new JMenuItem(this.undoAction);
    JMenuItem jMenuItemRedo = new JMenuItem(this.redoAction);
    JMenuItem jMenuItemCut = new JMenuItem(this.cutAction);
    JMenuItem jMenuItemCopy = new JMenuItem(this.copyAction);
    JMenuItem jMenuItemPaste = new JMenuItem(this.pasteAction);
    JMenuItem jMenuItemProp = new JMenuItem(this.propsAction);
    JMenuItem jMenuItemInsCell = new JMenuItem(this.insertTableCellAction);
    JMenuItem jMenuItemInsRow = new JMenuItem(this.insertTableRowAction);
    int currentCaret = 0;
    int currentFontSize = 4;
    JButton brActionB = new JButton();
    JButton hrActionB = new JButton();
    JButton insCharActionB = new JButton();

    public void setImagesDir(String string) {
        this.imagesDir = string;
    }

    public String getImagesDir() {
        return this.imagesDir;
    }

    public void showToolsPanel() {
        if (this.toolsPanelShow) {
            return;
        }
        this.add((Component)this.toolsPanel, "South");
        this.toolsPanelShow = true;
    }

    public void hideToolsPanel() {
        if (!this.toolsPanelShow) {
            return;
        }
        this.remove(this.charTablePanel);
        this.toolsPanelShow = false;
    }

    void addCharTablePanel() {
        this.showToolsPanel();
        this.toolsPanel.addTab(Local.getString("Characters"), this.charTablePanel);
    }

    void removeCharTablePanel() {
        this.toolsPanel.remove(this.charTablePanel);
        if (this.toolsPanel.getTabCount() == 0) {
            this.hideToolsPanel();
        }
    }

    private void doCopy() {
        Element element = this.document.getParagraphElement(this.editor.getSelectionStart());
        if (element.getName().toUpperCase().equals("P-IMPLIED")) {
            element = element.getParentElement();
        }
        String string = element.getName();
        StringWriter stringWriter = new StringWriter();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            this.editorKit.write(stringWriter, (Document)this.document, this.editor.getSelectionStart(), this.editor.getSelectionEnd() - this.editor.getSelectionStart());
            String string2 = stringWriter.toString();
            string2 = string2.split("<" + string + "(.*?)>")[1];
            string2 = string2.split("</" + string + ">")[0];
            clipboard.setContents(new StringSelection(string2.trim()), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doPaste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable transferable = clipboard.getContents(this);
            if (transferable == null) {
                return;
            }
            String string = transferable.getTransferData(new DataFlavor(String.class, "String")).toString();
            this.document.replace(this.editor.getSelectionStart(), this.editor.getSelectionEnd() - this.editor.getSelectionStart(), string, this.editorKit.getInputAttributes());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public HTMLEditor() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.cutAction.putValue("SmallIcon", new ImageIcon(this.cl.getResource("resources/icons/cut.png")));
        this.cutAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        this.cutAction.putValue("Name", Local.getString("Cut"));
        this.cutAction.putValue("ShortDescription", Local.getString("Cut"));
        this.copyAction.putValue("SmallIcon", new ImageIcon(this.cl.getResource("resources/icons/copy.png")));
        this.copyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        this.copyAction.putValue("Name", Local.getString("Copy"));
        this.copyAction.putValue("ShortDescription", Local.getString("Copy"));
        this.pasteAction.putValue("SmallIcon", new ImageIcon(this.cl.getResource("resources/icons/paste.png")));
        this.pasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        this.pasteAction.putValue("Name", Local.getString("Paste"));
        this.pasteAction.putValue("ShortDescription", Local.getString("Paste"));
        this.stylePasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 3));
        this.stylePasteAction.putValue("Name", Local.getString("Paste special"));
        this.stylePasteAction.putValue("ShortDescription", Local.getString("Paste special"));
        this.selectAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        this.boldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
        this.italicAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 2));
        this.underAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, 2));
        this.breakAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 1));
        this.breakAction.putValue("Name", Local.getString("Insert Break"));
        this.breakAction.putValue("ShortDescription", Local.getString("Insert Break"));
        this.findAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
        this.document = (HTMLDocument)this.editorKit.createDefaultDocument();
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this.border2 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(142, 142, 142), new Color(99, 99, 99));
        this.setLayout(this.borderLayout1);
        this.editor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                HTMLEditor.this.editor_caretUpdate(caretEvent);
            }
        });
        this.editor.setEditorKit(this.editorKit);
        this.editorKit.setDefaultCursor(new Cursor(2));
        this.editor.setDocument(this.document);
        this.document.addUndoableEditListener(this.undoHandler);
        this.setPreferredSize(new Dimension(520, 57));
        this.editToolbar.setRequestFocusEnabled(false);
        this.editToolbar.setToolTipText("");
        this.boldActionB.setAction(this.boldAction);
        this.boldActionB.setBorder(this.border1);
        this.boldActionB.setMaximumSize(new Dimension(22, 22));
        this.boldActionB.setMinimumSize(new Dimension(22, 22));
        this.boldActionB.setPreferredSize(new Dimension(22, 22));
        this.boldActionB.setBorderPainted(false);
        this.boldActionB.setFocusable(false);
        this.boldActionB.setText("");
        this.italicActionB.setAction(this.italicAction);
        this.italicActionB.setBorder(this.border1);
        this.italicActionB.setMaximumSize(new Dimension(22, 22));
        this.italicActionB.setMinimumSize(new Dimension(22, 22));
        this.italicActionB.setPreferredSize(new Dimension(22, 22));
        this.italicActionB.setBorderPainted(false);
        this.italicActionB.setFocusable(false);
        this.italicActionB.setText("");
        this.underActionB.setAction(this.underAction);
        this.underActionB.setBorder(this.border1);
        this.underActionB.setMaximumSize(new Dimension(22, 22));
        this.underActionB.setMinimumSize(new Dimension(22, 22));
        this.underActionB.setPreferredSize(new Dimension(22, 22));
        this.underActionB.setBorderPainted(false);
        this.underActionB.setFocusable(false);
        this.underActionB.setText("");
        this.lAlignActionB.setAction(this.lAlignAction);
        this.lAlignActionB.setMaximumSize(new Dimension(22, 22));
        this.lAlignActionB.setMinimumSize(new Dimension(22, 22));
        this.lAlignActionB.setPreferredSize(new Dimension(22, 22));
        this.lAlignActionB.setBorderPainted(false);
        this.lAlignActionB.setFocusable(false);
        this.lAlignActionB.setText("");
        this.rAlignActionB.setAction(this.rAlignAction);
        this.rAlignActionB.setFocusable(false);
        this.rAlignActionB.setPreferredSize(new Dimension(22, 22));
        this.rAlignActionB.setBorderPainted(false);
        this.rAlignActionB.setMinimumSize(new Dimension(22, 22));
        this.rAlignActionB.setMaximumSize(new Dimension(22, 22));
        this.rAlignActionB.setText("");
        this.cAlignActionB.setAction(this.cAlignAction);
        this.cAlignActionB.setMaximumSize(new Dimension(22, 22));
        this.cAlignActionB.setMinimumSize(new Dimension(22, 22));
        this.cAlignActionB.setPreferredSize(new Dimension(22, 22));
        this.cAlignActionB.setBorderPainted(false);
        this.cAlignActionB.setFocusable(false);
        this.cAlignActionB.setText("");
        this.ulActionB.setAction(this.ulAction);
        this.ulActionB.setMaximumSize(new Dimension(22, 22));
        this.ulActionB.setMinimumSize(new Dimension(22, 22));
        this.ulActionB.setPreferredSize(new Dimension(22, 22));
        this.ulActionB.setBorderPainted(false);
        this.ulActionB.setFocusable(false);
        this.ulActionB.setText("");
        this.olActionB.setAction(this.olAction);
        this.olActionB.setMaximumSize(new Dimension(22, 22));
        this.olActionB.setMinimumSize(new Dimension(22, 22));
        this.olActionB.setPreferredSize(new Dimension(22, 22));
        this.olActionB.setBorderPainted(false);
        this.olActionB.setFocusable(false);
        this.olActionB.setText("");
        this.linkActionB.setAction(this.linkAction);
        this.linkActionB.setMaximumSize(new Dimension(22, 22));
        this.linkActionB.setMinimumSize(new Dimension(22, 22));
        this.linkActionB.setPreferredSize(new Dimension(22, 22));
        this.linkActionB.setBorderPainted(false);
        this.linkActionB.setFocusable(false);
        this.linkActionB.setText("");
        this.propsActionB.setAction(this.propsAction);
        this.propsActionB.setFocusable(false);
        this.propsActionB.setPreferredSize(new Dimension(22, 22));
        this.propsActionB.setBorderPainted(false);
        this.propsActionB.setMinimumSize(new Dimension(22, 22));
        this.propsActionB.setMaximumSize(new Dimension(22, 22));
        this.propsActionB.setText("");
        this.imageActionB.setAction(this.imageAction);
        this.imageActionB.setMaximumSize(new Dimension(22, 22));
        this.imageActionB.setMinimumSize(new Dimension(22, 22));
        this.imageActionB.setPreferredSize(new Dimension(22, 22));
        this.imageActionB.setBorderPainted(false);
        this.imageActionB.setFocusable(false);
        this.imageActionB.setText("");
        this.tableActionB.setAction(this.tableAction);
        this.tableActionB.setFocusable(false);
        this.tableActionB.setPreferredSize(new Dimension(22, 22));
        this.tableActionB.setBorderPainted(false);
        this.tableActionB.setMinimumSize(new Dimension(22, 22));
        this.tableActionB.setMaximumSize(new Dimension(22, 22));
        this.tableActionB.setText("");
        this.brActionB.setAction(this.breakAction);
        this.brActionB.setFocusable(false);
        this.brActionB.setBorderPainted(false);
        this.brActionB.setPreferredSize(new Dimension(22, 22));
        this.brActionB.setMinimumSize(new Dimension(22, 22));
        this.brActionB.setMaximumSize(new Dimension(22, 22));
        this.brActionB.setText("");
        this.hrActionB.setAction(this.insertHRAction);
        this.hrActionB.setMaximumSize(new Dimension(22, 22));
        this.hrActionB.setMinimumSize(new Dimension(22, 22));
        this.hrActionB.setPreferredSize(new Dimension(22, 22));
        this.hrActionB.setBorderPainted(false);
        this.hrActionB.setFocusable(false);
        this.hrActionB.setText("");
        this.insCharActionB.setAction(this.insCharAction);
        this.insCharActionB.setBorder(this.border1);
        this.insCharActionB.setMaximumSize(new Dimension(22, 22));
        this.insCharActionB.setMinimumSize(new Dimension(22, 22));
        this.insCharActionB.setPreferredSize(new Dimension(22, 22));
        this.insCharActionB.setBorderPainted(false);
        this.insCharActionB.setFocusable(false);
        this.insCharActionB.setText("");
        this.blockCB.setBackground(new Color(230, 230, 230));
        this.blockCB.setMaximumRowCount(12);
        this.blockCB.setFont(new Font("Dialog", 1, 10));
        this.blockCB.setMaximumSize(new Dimension(120, 22));
        this.blockCB.setMinimumSize(new Dimension(60, 22));
        this.blockCB.setPreferredSize(new Dimension(79, 22));
        this.blockCB.setFocusable(false);
        this.blockCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLEditor.this.blockCB_actionPerformed(actionEvent);
            }
        });
        this.inlineCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLEditor.this.inlineCB_actionPerformed(actionEvent);
            }
        });
        this.inlineCB.setFocusable(false);
        this.inlineCB.setPreferredSize(new Dimension(79, 22));
        this.inlineCB.setMinimumSize(new Dimension(60, 22));
        this.inlineCB.setMaximumSize(new Dimension(120, 22));
        this.inlineCB.setFont(new Font("Dialog", 1, 10));
        this.inlineCB.setMaximumRowCount(12);
        this.inlineCB.setBackground(new Color(230, 230, 230));
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.editToolbar, "North");
        this.editToolbar.add((Component)this.propsActionB, null);
        this.editToolbar.addSeparator();
        this.editToolbar.add((Component)this.blockCB, null);
        this.editToolbar.addSeparator();
        this.editToolbar.add((Component)this.inlineCB, null);
        this.editToolbar.addSeparator();
        this.editToolbar.add((Component)this.boldActionB, null);
        this.editToolbar.add((Component)this.italicActionB, null);
        this.editToolbar.add((Component)this.underActionB, null);
        this.editToolbar.addSeparator();
        this.editToolbar.add((Component)this.ulActionB, null);
        this.editToolbar.add((Component)this.olActionB, null);
        this.editToolbar.addSeparator();
        this.editToolbar.add((Component)this.lAlignActionB, null);
        this.editToolbar.add((Component)this.cAlignActionB, null);
        this.editToolbar.add((Component)this.rAlignActionB, null);
        this.editToolbar.addSeparator();
        this.editToolbar.add((Component)this.imageActionB, null);
        this.editToolbar.add((Component)this.tableActionB, null);
        this.editToolbar.add((Component)this.linkActionB, null);
        this.editToolbar.addSeparator();
        this.editToolbar.add((Component)this.hrActionB, null);
        this.editToolbar.add((Component)this.brActionB, null);
        this.editToolbar.add((Component)this.insCharActionB, null);
        this.jScrollPane1.getViewport().add((Component)this.editor, null);
        this.toolsPanel.setTabPlacement(3);
        this.toolsPanel.setFont(new Font("Dialog", 1, 10));
        this.editor.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
        this.editor.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), new ParaBreakAction());
        this.editor.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(67, 2));
        this.editor.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(86, 2));
        this.editor.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(88, 2));
        this.editor.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(67, 2), this.copyAction);
        this.editor.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(86, 2), this.pasteAction);
        this.editor.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(86, 3), this.stylePasteAction);
        this.editor.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(88, 2), this.cutAction);
        this.editor.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(70, 2), this.findAction);
        this.editor.addMouseListener(new PopupListener());
        this.document.getStyleSheet().setBaseFontSize(this.currentFontSize);
        this.requestFocusInWindow();
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    public String getContent() {
        try {
            return this.editor.getText();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public void boldActionB_actionPerformed(ActionEvent actionEvent) {
        if (!this.bold) {
            this.boldActionB.setBorder(this.border2);
        } else {
            this.boldActionB.setBorder(this.border1);
        }
        this.bold = !this.bold;
        this.boldActionB.setBorderPainted(this.bold);
        new StyledEditorKit.BoldAction().actionPerformed(actionEvent);
    }

    public void italicActionB_actionPerformed(ActionEvent actionEvent) {
        if (!this.italic) {
            this.italicActionB.setBorder(this.border2);
        } else {
            this.italicActionB.setBorder(this.border1);
        }
        this.italic = !this.italic;
        this.italicActionB.setBorderPainted(this.italic);
        new StyledEditorKit.ItalicAction().actionPerformed(actionEvent);
    }

    public void underActionB_actionPerformed(ActionEvent actionEvent) {
        if (!this.under) {
            this.underActionB.setBorder(this.border2);
        } else {
            this.underActionB.setBorder(this.border1);
        }
        this.under = !this.under;
        this.underActionB.setBorderPainted(this.under);
        new StyledEditorKit.UnderlineAction().actionPerformed(actionEvent);
    }

    void editor_caretUpdate(CaretEvent caretEvent) {
        this.currentCaret = caretEvent.getDot();
        AttributeSet attributeSet = null;
        if (this.editor.getCaretPosition() > 0) {
            try {
                attributeSet = this.document.getCharacterElement(this.editor.getCaretPosition() - 1).getAttributes();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            attributeSet = this.document.getCharacterElement(this.editor.getCaretPosition()).getAttributes();
        }
        if (attributeSet.containsAttribute(StyleConstants.Bold, new Boolean(true))) {
            this.boldActionB.setBorder(this.border2);
            this.bold = true;
        } else if (this.bold) {
            this.boldActionB.setBorder(this.border1);
            this.bold = false;
        }
        this.boldActionB.setBorderPainted(this.bold);
        if (attributeSet.containsAttribute(StyleConstants.Italic, new Boolean(true))) {
            this.italicActionB.setBorder(this.border2);
            this.italic = true;
        } else if (this.italic) {
            this.italicActionB.setBorder(this.border1);
            this.italic = false;
        }
        this.italicActionB.setBorderPainted(this.italic);
        if (attributeSet.containsAttribute(StyleConstants.Underline, new Boolean(true))) {
            this.underActionB.setBorder(this.border2);
            this.under = true;
        } else if (this.under) {
            this.underActionB.setBorder(this.border1);
            this.under = false;
        }
        this.underActionB.setBorderPainted(this.under);
        this.inlineCBEventsLock = true;
        this.inlineCB.setEnabled(!attributeSet.isDefined(HTML.Tag.A));
        if (attributeSet.isDefined(HTML.Tag.EM)) {
            this.inlineCB.setSelectedIndex(1);
        } else if (attributeSet.isDefined(HTML.Tag.STRONG)) {
            this.inlineCB.setSelectedIndex(2);
        } else if (attributeSet.isDefined(HTML.Tag.CODE) || attributeSet.isDefined(HTML.Tag.SAMP)) {
            this.inlineCB.setSelectedIndex(3);
        } else if (attributeSet.isDefined(HTML.Tag.SUP)) {
            this.inlineCB.setSelectedIndex(5);
        } else if (attributeSet.isDefined(HTML.Tag.SUB)) {
            this.inlineCB.setSelectedIndex(6);
        } else if (attributeSet.isDefined(HTML.Tag.CITE)) {
            this.inlineCB.setSelectedIndex(4);
        } else if (attributeSet.isDefined(HTML.Tag.FONT)) {
            this.inlineCB.setSelectedIndex(7);
        } else {
            this.inlineCB.setSelectedIndex(0);
        }
        this.inlineCBEventsLock = false;
        Element element = this.document.getParagraphElement(this.editor.getCaretPosition());
        String string = element.getName().toUpperCase();
        this.blockCBEventsLock = true;
        if (string.equals("P-IMPLIED")) {
            string = element.getParentElement().getName().toUpperCase();
        }
        if (string.equals("P")) {
            this.blockCB.setSelectedIndex(0);
        } else if (string.equals("H1")) {
            this.blockCB.setSelectedIndex(1);
        } else if (string.equals("H2")) {
            this.blockCB.setSelectedIndex(2);
        } else if (string.equals("H3")) {
            this.blockCB.setSelectedIndex(3);
        } else if (string.equals("H4")) {
            this.blockCB.setSelectedIndex(4);
        } else if (string.equals("H5")) {
            this.blockCB.setSelectedIndex(5);
        } else if (string.equals("H6")) {
            this.blockCB.setSelectedIndex(6);
        } else if (string.equals("PRE")) {
            this.blockCB.setSelectedIndex(7);
        } else if (string.equals("BLOCKQUOTE")) {
            this.blockCB.setSelectedIndex(8);
        }
        this.blockCBEventsLock = false;
        this.insertTableCellAction.update();
        this.insertTableRowAction.update();
    }

    public void ulActionB_actionPerformed(ActionEvent actionEvent) {
        String string = this.document.getParagraphElement(this.editor.getCaretPosition()).getParentElement().getName();
        HTML.Tag tag = HTML.getTag(string);
        HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insertUL", "<ul><li></li></ul>", tag, HTML.Tag.UL);
        insertHTMLTextAction.actionPerformed(actionEvent);
        this.list = true;
    }

    public void olActionB_actionPerformed(ActionEvent actionEvent) {
        String string = this.document.getParagraphElement(this.editor.getCaretPosition()).getParentElement().getName();
        HTML.Tag tag = HTML.getTag(string);
        HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insertOL", "<ol><li></li></ol>", tag, HTML.Tag.OL);
        insertHTMLTextAction.actionPerformed(actionEvent);
        this.list = true;
    }

    void removeIfEmpty(Element element) {
        if (element.getEndOffset() - element.getStartOffset() < 2) {
            try {
                this.document.remove(element.getStartOffset(), element.getEndOffset());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void lAlignActionB_actionPerformed(ActionEvent actionEvent) {
        StyledEditorKit.AlignmentAction alignmentAction = new StyledEditorKit.AlignmentAction("leftAlign", 0);
        alignmentAction.actionPerformed(actionEvent);
    }

    public void cAlignActionB_actionPerformed(ActionEvent actionEvent) {
        StyledEditorKit.AlignmentAction alignmentAction = new StyledEditorKit.AlignmentAction("centerAlign", 1);
        alignmentAction.actionPerformed(actionEvent);
    }

    public void rAlignActionB_actionPerformed(ActionEvent actionEvent) {
        StyledEditorKit.AlignmentAction alignmentAction = new StyledEditorKit.AlignmentAction("rightAlign", 2);
        alignmentAction.actionPerformed(actionEvent);
    }

    public void jAlignActionB_actionPerformed(ActionEvent actionEvent) {
        StyledEditorKit.AlignmentAction alignmentAction = new StyledEditorKit.AlignmentAction("justifyAlign", 3);
        alignmentAction.actionPerformed(actionEvent);
    }

    public void insertHTML(String string, int n) {
        try {
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.editor.getEditorKit();
            Document document = this.editor.getDocument();
            StringReader stringReader = new StringReader(string);
            hTMLEditorKit.read(stringReader, document, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void imageActionB_actionPerformed(ActionEvent actionEvent) {
        ImageDialog imageDialog = new ImageDialog(null);
        Dimension dimension = imageDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocationOnScreen();
        imageDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        imageDialog.setModal(true);
        imageDialog.setVisible(true);
        if (!imageDialog.CANCELLED) {
            Object object;
            String string;
            String string2 = this.document.getParagraphElement(this.editor.getCaretPosition()).getParentElement().getName();
            String string3 = string = imageDialog.fileField.getText();
            if (this.imagesDir != null) {
                try {
                    object = new URL(string);
                    if (!((URL)object).getProtocol().startsWith("http")) {
                        string3 = this.imagesDir + "/" + ((URL)object).getFile();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            try {
                object = "<img src=\"" + string3 + "\" alt=\"" + imageDialog.altField.getText() + "\" ";
                String string4 = imageDialog.widthField.getText();
                try {
                    Integer.parseInt(string4, 10);
                    object = (String)object + " width=\"" + string4 + "\" ";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string5 = imageDialog.heightField.getText();
                try {
                    Integer.parseInt(string5, 10);
                    object = (String)object + " height=\"" + string5 + "\" ";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string6 = imageDialog.hspaceField.getText();
                try {
                    Integer.parseInt(string6, 10);
                    object = (String)object + " hspace=\"" + string6 + "\" ";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string7 = imageDialog.vspaceField.getText();
                try {
                    Integer.parseInt(string7, 10);
                    object = (String)object + " vspace=\"" + string7 + "\" ";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string8 = imageDialog.borderField.getText();
                try {
                    Integer.parseInt(string8, 10);
                    object = (String)object + " border=\"" + string8 + "\" ";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (imageDialog.alignCB.getSelectedIndex() > 0) {
                    object = (String)object + " align=\"" + imageDialog.alignCB.getSelectedItem() + "\" ";
                }
                object = (String)object + ">";
                if (imageDialog.urlField.getText().length() > 0) {
                    object = "<a href=\"" + imageDialog.urlField.getText() + "\">" + (String)object + "</a>";
                    if (this.editor.getCaretPosition() == this.document.getLength()) {
                        object = (String)object + "&nbsp;";
                    }
                    this.editorKit.insertHTML(this.document, this.editor.getCaretPosition(), (String)object, 0, 0, HTML.Tag.A);
                } else {
                    this.editorKit.insertHTML(this.document, this.editor.getCaretPosition(), (String)object, 0, 0, HTML.Tag.IMG);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void tableActionB_actionPerformed(ActionEvent actionEvent) {
        String string;
        TableDialog tableDialog = new TableDialog(null);
        Dimension dimension = tableDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocationOnScreen();
        tableDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        tableDialog.setModal(true);
        tableDialog.setVisible(true);
        if (tableDialog.CANCELLED) {
            return;
        }
        String string2 = "<table ";
        String string3 = tableDialog.widthField.getText().trim();
        if (string3.length() > 0) {
            string2 = string2 + " width=\"" + string3 + "\" ";
        }
        if ((string = tableDialog.heightField.getText().trim()).length() > 0) {
            string2 = string2 + " height=\"" + string + "\" ";
        }
        String string4 = tableDialog.cellpadding.getValue().toString();
        try {
            Integer.parseInt(string4, 10);
            string2 = string2 + " cellpadding=\"" + string4 + "\" ";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string5 = tableDialog.cellspacing.getValue().toString();
        try {
            Integer.parseInt(string5, 10);
            string2 = string2 + " cellspacing=\"" + string5 + "\" ";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string6 = tableDialog.border.getValue().toString();
        try {
            Integer.parseInt(string6, 10);
            string2 = string2 + " border=\"" + string6 + "\" ";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tableDialog.alignCB.getSelectedIndex() > 0) {
            string2 = string2 + " align=\"" + tableDialog.alignCB.getSelectedItem() + "\" ";
        }
        if (tableDialog.vAlignCB.getSelectedIndex() > 0) {
            string2 = string2 + " valign=\"" + tableDialog.vAlignCB.getSelectedItem() + "\" ";
        }
        if (tableDialog.bgcolorField.getText().length() > 0) {
            string2 = string2 + " bgcolor=\"" + tableDialog.bgcolorField.getText() + "\" ";
        }
        string2 = string2 + ">";
        int n = 1;
        int n2 = 1;
        try {
            n = (Integer)tableDialog.columns.getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            n2 = (Integer)tableDialog.rows.getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < n2; ++i) {
            string2 = string2 + "<tr>";
            for (int j = 0; j < n; ++j) {
                string2 = string2 + "<td><p></p></td>";
            }
            string2 = string2 + "</tr>";
        }
        string2 = string2 + "</table>";
        String string7 = this.document.getParagraphElement(this.editor.getCaretPosition()).getParentElement().getName();
        HTML.Tag tag = HTML.getTag(string7);
        System.out.println(tag + ":\n" + string2);
        try {
            this.editorKit.insertHTML(this.document, this.editor.getCaretPosition(), string2, 1, 0, HTML.Tag.TABLE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void linkActionB_actionPerformed(ActionEvent actionEvent) {
        LinkDialog linkDialog = new LinkDialog(null);
        Dimension dimension = linkDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocationOnScreen();
        linkDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        linkDialog.setModal(true);
        if (this.editor.getSelectedText() != null) {
            linkDialog.txtDesc.setText(this.editor.getSelectedText());
        }
        linkDialog.setVisible(true);
        if (linkDialog.CANCELLED) {
            return;
        }
        String string = "<a";
        if (linkDialog.txtURL.getText().length() > 0) {
            string = string + " href=\"" + linkDialog.txtURL.getText() + "\"";
        }
        if (linkDialog.txtName.getText().length() > 0) {
            string = string + " name=\"" + linkDialog.txtName.getText() + "\"";
        }
        if (linkDialog.txtTitle.getText().length() > 0) {
            string = string + " title=\"" + linkDialog.txtTitle.getText() + "\"";
        }
        if (linkDialog.chkNewWin.isSelected()) {
            string = string + " target=\"_blank\"";
        }
        string = string + ">" + linkDialog.txtDesc.getText() + "</a>";
        if (this.editor.getCaretPosition() == this.document.getLength()) {
            string = string + "&nbsp;";
        }
        this.editor.replaceSelection("");
        try {
            this.editorKit.insertHTML(this.document, this.editor.getCaretPosition(), string, 0, 0, HTML.Tag.A);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setLinkProperties(Element element, String string, String string2, String string3, String string4) {
        LinkDialog linkDialog = new LinkDialog(null);
        linkDialog.setLocation(this.linkActionB.getLocationOnScreen());
        linkDialog.setModal(true);
        linkDialog.txtURL.setText(string);
        linkDialog.txtName.setText(string4);
        linkDialog.txtTitle.setText(string3);
        try {
            linkDialog.txtDesc.setText(this.document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        linkDialog.chkNewWin.setSelected(string2.toUpperCase().equals("_BLANK"));
        linkDialog.header.setText(Local.getString("Hyperlink properties"));
        linkDialog.setTitle(Local.getString("Hyperlink properties"));
        linkDialog.setVisible(true);
        if (linkDialog.CANCELLED) {
            return;
        }
        String string5 = "<a";
        if (linkDialog.txtURL.getText().length() > 0) {
            string5 = string5 + " href=\"" + linkDialog.txtURL.getText() + "\"";
        }
        if (linkDialog.txtName.getText().length() > 0) {
            string5 = string5 + " name=\"" + linkDialog.txtName.getText() + "\"";
        }
        if (linkDialog.txtTitle.getText().length() > 0) {
            string5 = string5 + " title=\"" + linkDialog.txtTitle.getText() + "\"";
        }
        if (linkDialog.chkNewWin.isSelected()) {
            string5 = string5 + " target=\"_blank\"";
        }
        string5 = string5 + ">" + linkDialog.txtDesc.getText() + "</a>";
        try {
            this.document.setOuterHTML(element, string5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setImageProperties(Element element, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        ImageDialog imageDialog = new ImageDialog(null);
        imageDialog.setLocation(this.imageActionB.getLocationOnScreen());
        imageDialog.setModal(true);
        imageDialog.setTitle(Local.getString("Image properties"));
        imageDialog.fileField.setText(string);
        imageDialog.altField.setText(string2);
        imageDialog.widthField.setText(string3);
        imageDialog.heightField.setText(string4);
        imageDialog.hspaceField.setText(string5);
        imageDialog.vspaceField.setText(string6);
        imageDialog.borderField.setText(string7);
        imageDialog.alignCB.setSelectedItem(string8);
        imageDialog.updatePreview();
        imageDialog.setVisible(true);
        if (imageDialog.CANCELLED) {
            return;
        }
        String string9 = "<img src=\"" + imageDialog.fileField.getText() + "\" alt=\"" + imageDialog.altField.getText() + "\" ";
        String string10 = imageDialog.widthField.getText();
        try {
            Integer.parseInt(string10, 10);
            string9 = string9 + " width=\"" + string10 + "\" ";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string11 = imageDialog.heightField.getText();
        try {
            Integer.parseInt(string11, 10);
            string9 = string9 + " height=\"" + string11 + "\" ";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string12 = imageDialog.hspaceField.getText();
        try {
            Integer.parseInt(string12, 10);
            string9 = string9 + " hspace=\"" + string12 + "\" ";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string13 = imageDialog.vspaceField.getText();
        try {
            Integer.parseInt(string13, 10);
            string9 = string9 + " vspace=\"" + string13 + "\" ";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string14 = imageDialog.borderField.getText();
        try {
            Integer.parseInt(string14, 10);
            string9 = string9 + " border=\"" + string14 + "\" ";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (imageDialog.alignCB.getSelectedIndex() > 0) {
            string9 = string9 + " align=\"" + imageDialog.alignCB.getSelectedItem() + "\" ";
        }
        string9 = string9 + ">";
        if (imageDialog.urlField.getText().length() > 0) {
            string9 = "<a href=\"" + imageDialog.urlField.getText() + "\">" + string9 + "</a>";
            if (this.editor.getCaretPosition() == this.document.getLength()) {
                string9 = string9 + "&nbsp;";
            }
        }
        try {
            this.document.setOuterHTML(element, string9);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setElementProperties(Element element, String string, String string2, String string3) {
        ElementDialog elementDialog = new ElementDialog(null);
        Dimension dimension = elementDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocationOnScreen();
        elementDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        elementDialog.setModal(true);
        elementDialog.setTitle(Local.getString("Object properties"));
        elementDialog.idField.setText(string);
        elementDialog.classField.setText(string2);
        elementDialog.styleField.setText(string3);
        elementDialog.setVisible(true);
        if (elementDialog.CANCELLED) {
            return;
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(element.getAttributes());
        if (elementDialog.idField.getText().length() > 0) {
            simpleAttributeSet.addAttribute(HTML.Attribute.ID, elementDialog.idField.getText());
        }
        if (elementDialog.classField.getText().length() > 0) {
            simpleAttributeSet.addAttribute(HTML.Attribute.CLASS, elementDialog.classField.getText());
        }
        if (elementDialog.styleField.getText().length() > 0) {
            simpleAttributeSet.addAttribute(HTML.Attribute.STYLE, elementDialog.styleField.getText());
        }
        this.document.setParagraphAttributes(element.getStartOffset(), 0, simpleAttributeSet, true);
    }

    void setTableProperties(Element element) {
        Object object;
        AttributeSet attributeSet;
        Object object2;
        Element element2 = element.getParentElement();
        Element element3 = element2.getParentElement();
        TdDialog tdDialog = new TdDialog(null);
        tdDialog.setLocation(this.editor.getLocationOnScreen());
        tdDialog.setModal(true);
        tdDialog.setTitle(Local.getString("Table properties"));
        AttributeSet attributeSet2 = element.getAttributes();
        if (attributeSet2.isDefined(HTML.Attribute.BGCOLOR)) {
            tdDialog.tdBgcolorField.setText(attributeSet2.getAttribute(HTML.Attribute.BGCOLOR).toString());
            Util.setBgcolorField(tdDialog.tdBgcolorField);
        }
        if (attributeSet2.isDefined(HTML.Attribute.WIDTH)) {
            tdDialog.tdWidthField.setText(attributeSet2.getAttribute(HTML.Attribute.WIDTH).toString());
        }
        if (attributeSet2.isDefined(HTML.Attribute.HEIGHT)) {
            tdDialog.tdHeightField.setText(attributeSet2.getAttribute(HTML.Attribute.HEIGHT).toString());
        }
        if (attributeSet2.isDefined(HTML.Attribute.COLSPAN)) {
            try {
                object2 = new Integer(attributeSet2.getAttribute(HTML.Attribute.COLSPAN).toString());
                tdDialog.tdColspan.setValue(object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (attributeSet2.isDefined(HTML.Attribute.ROWSPAN)) {
            try {
                object2 = new Integer(attributeSet2.getAttribute(HTML.Attribute.ROWSPAN).toString());
                tdDialog.tdRowspan.setValue(object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (attributeSet2.isDefined(HTML.Attribute.ALIGN)) {
            tdDialog.tdAlignCB.setSelectedItem(attributeSet2.getAttribute(HTML.Attribute.ALIGN).toString().toLowerCase());
        }
        if (attributeSet2.isDefined(HTML.Attribute.VALIGN)) {
            tdDialog.tdValignCB.setSelectedItem(attributeSet2.getAttribute(HTML.Attribute.VALIGN).toString().toLowerCase());
        }
        tdDialog.tdNowrapChB.setSelected(attributeSet2.isDefined(HTML.Attribute.NOWRAP));
        object2 = element2.getAttributes();
        if (object2.isDefined(HTML.Attribute.BGCOLOR)) {
            tdDialog.trBgcolorField.setText(object2.getAttribute(HTML.Attribute.BGCOLOR).toString());
            Util.setBgcolorField(tdDialog.trBgcolorField);
        }
        if (object2.isDefined(HTML.Attribute.ALIGN)) {
            tdDialog.trAlignCB.setSelectedItem(object2.getAttribute(HTML.Attribute.ALIGN).toString().toLowerCase());
        }
        if (object2.isDefined(HTML.Attribute.VALIGN)) {
            tdDialog.trValignCB.setSelectedItem(object2.getAttribute(HTML.Attribute.VALIGN).toString().toLowerCase());
        }
        if ((attributeSet = element3.getAttributes()).isDefined(HTML.Attribute.BGCOLOR)) {
            tdDialog.bgcolorField.setText(attributeSet.getAttribute(HTML.Attribute.BGCOLOR).toString());
            Util.setBgcolorField(tdDialog.bgcolorField);
        }
        if (attributeSet.isDefined(HTML.Attribute.WIDTH)) {
            tdDialog.widthField.setText(attributeSet.getAttribute(HTML.Attribute.WIDTH).toString());
        }
        if (attributeSet.isDefined(HTML.Attribute.HEIGHT)) {
            tdDialog.heightField.setText(attributeSet.getAttribute(HTML.Attribute.HEIGHT).toString());
        }
        if (attributeSet.isDefined(HTML.Attribute.ALIGN)) {
            tdDialog.alignCB.setSelectedItem(attributeSet.getAttribute(HTML.Attribute.ALIGN).toString().toLowerCase());
        }
        if (attributeSet.isDefined(HTML.Attribute.VALIGN)) {
            tdDialog.vAlignCB.setSelectedItem(attributeSet.getAttribute(HTML.Attribute.VALIGN).toString().toLowerCase());
        }
        if (attributeSet.isDefined(HTML.Attribute.CELLPADDING)) {
            try {
                object = new Integer(attributeSet.getAttribute(HTML.Attribute.CELLPADDING).toString());
                tdDialog.cellpadding.setValue(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (attributeSet.isDefined(HTML.Attribute.CELLSPACING)) {
            try {
                object = new Integer(attributeSet.getAttribute(HTML.Attribute.CELLSPACING).toString());
                tdDialog.cellspacing.setValue(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (attributeSet.isDefined(HTML.Attribute.BORDER)) {
            try {
                object = new Integer(attributeSet.getAttribute(HTML.Attribute.BORDER).toString());
                tdDialog.border.setValue(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        tdDialog.setVisible(true);
        if (tdDialog.CANCELLED) {
            return;
        }
        object = "<td";
        if (tdDialog.tdBgcolorField.getText().length() > 0) {
            object = (String)object + " bgcolor=\"" + tdDialog.tdBgcolorField.getText() + "\"";
        }
        if (tdDialog.tdWidthField.getText().length() > 0) {
            object = (String)object + " width=\"" + tdDialog.tdWidthField.getText() + "\"";
        }
        if (tdDialog.tdHeightField.getText().length() > 0) {
            object = (String)object + " height=\"" + tdDialog.tdHeightField.getText() + "\"";
        }
        if (!tdDialog.tdColspan.getValue().toString().equals("0")) {
            object = (String)object + " colspan=\"" + tdDialog.tdColspan.getValue().toString() + "\"";
        }
        if (!tdDialog.tdRowspan.getValue().toString().equals("0")) {
            object = (String)object + " rowspan=\"" + tdDialog.tdRowspan.getValue().toString() + "\"";
        }
        if (tdDialog.tdAlignCB.getSelectedItem().toString().length() > 0) {
            object = (String)object + " align=\"" + tdDialog.tdAlignCB.getSelectedItem().toString() + "\"";
        }
        if (tdDialog.tdValignCB.getSelectedItem().toString().length() > 0) {
            object = (String)object + " valign=\"" + tdDialog.tdValignCB.getSelectedItem().toString() + "\"";
        }
        if (tdDialog.tdNowrapChB.isSelected()) {
            object = (String)object + " nowrap";
        }
        object = (String)object + ">";
        String string = "<tr";
        if (tdDialog.trBgcolorField.getText().length() > 0) {
            string = string + " bgcolor=\"" + tdDialog.trBgcolorField.getText() + "\"";
        }
        if (tdDialog.trAlignCB.getSelectedItem().toString().length() > 0) {
            string = string + " align=\"" + tdDialog.trAlignCB.getSelectedItem().toString() + "\"";
        }
        if (tdDialog.trValignCB.getSelectedItem().toString().length() > 0) {
            string = string + " valign=\"" + tdDialog.trValignCB.getSelectedItem().toString() + "\"";
        }
        string = string + ">";
        String string2 = "<table";
        if (tdDialog.bgcolorField.getText().length() > 0) {
            string2 = string2 + " bgcolor=\"" + tdDialog.bgcolorField.getText() + "\"";
        }
        if (tdDialog.widthField.getText().length() > 0) {
            string2 = string2 + " width=\"" + tdDialog.widthField.getText() + "\"";
        }
        if (tdDialog.heightField.getText().length() > 0) {
            string2 = string2 + " height=\"" + tdDialog.heightField.getText() + "\"";
        }
        string2 = string2 + " cellpadding=\"" + tdDialog.cellpadding.getValue().toString() + "\"";
        string2 = string2 + " cellspacing=\"" + tdDialog.cellspacing.getValue().toString() + "\"";
        string2 = string2 + " border=\"" + tdDialog.border.getValue().toString() + "\"";
        if (tdDialog.alignCB.getSelectedItem().toString().length() > 0) {
            string2 = string2 + " align=\"" + tdDialog.alignCB.getSelectedItem().toString() + "\"";
        }
        if (tdDialog.vAlignCB.getSelectedItem().toString().length() > 0) {
            string2 = string2 + " valign=\"" + tdDialog.vAlignCB.getSelectedItem().toString() + "\"";
        }
        string2 = string2 + ">";
        try {
            StringWriter stringWriter = new StringWriter();
            this.editorKit.write(stringWriter, (Document)this.document, element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
            String string3 = stringWriter.toString();
            string3 = string3.split("<td(.*?)>")[1];
            string3 = string3.split("</td>")[0];
            this.document.setOuterHTML(element, (String)object + string3 + "</td>");
            stringWriter = new StringWriter();
            this.editorKit.write(stringWriter, (Document)this.document, element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
            string3 = stringWriter.toString();
            string3 = string3.split("<tr(.*?)>")[1];
            string3 = string3.split("</tr>")[0];
            this.document.setOuterHTML(element2, string + string3 + "</tr>");
            stringWriter = new StringWriter();
            this.editorKit.write(stringWriter, (Document)this.document, element3.getStartOffset(), element3.getEndOffset() - element3.getStartOffset());
            string3 = stringWriter.toString();
            string3 = string3.split("<table(.*?)>")[1];
            string3 = string3.split("</table>")[0];
            this.document.setOuterHTML(element3, string2 + string3 + "</table>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void blockCB_actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (this.blockCBEventsLock) {
            return;
        }
        int n = this.blockCB.getSelectedIndex();
        HTML.Tag tag = null;
        switch (n) {
            case 0: {
                tag = HTML.Tag.P;
                break;
            }
            case 1: {
                tag = HTML.Tag.H1;
                break;
            }
            case 2: {
                tag = HTML.Tag.H2;
                break;
            }
            case 3: {
                tag = HTML.Tag.H3;
                break;
            }
            case 4: {
                tag = HTML.Tag.H4;
                break;
            }
            case 5: {
                tag = HTML.Tag.H5;
                break;
            }
            case 6: {
                tag = HTML.Tag.H6;
                break;
            }
            case 7: {
                tag = HTML.Tag.PRE;
                break;
            }
            case 8: {
                tag = HTML.Tag.BLOCKQUOTE;
            }
        }
        Element element = this.document.getParagraphElement(this.editor.getCaretPosition());
        if (element.getName().toUpperCase().equals("P-IMPLIED")) {
            object = element.getParentElement();
            String string = object.getName();
            String string2 = tag.toString();
            StringWriter stringWriter = new StringWriter();
            try {
                this.editorKit.write(stringWriter, (Document)this.document, element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                String string3 = stringWriter.toString();
                string3 = string3.split("<" + string + "(.*?)>")[1];
                string3 = string3.split("</" + string + ">")[0];
                this.document.setOuterHTML((Element)object, "<" + string2 + ">" + string3 + "</" + string2 + ">");
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = new SimpleAttributeSet(element.getAttributes());
        ((SimpleAttributeSet)object).addAttribute(StyleConstants.NameAttribute, tag);
        if (this.editor.getSelectionEnd() - this.editor.getSelectionStart() > 0) {
            this.document.setParagraphAttributes(this.editor.getSelectionStart(), this.editor.getSelectionEnd() - this.editor.getSelectionStart(), (AttributeSet)object, true);
        } else {
            this.document.setParagraphAttributes(this.editor.getCaretPosition(), 0, (AttributeSet)object, true);
        }
    }

    public void propsActionB_actionPerformed(ActionEvent actionEvent) {
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.document.getParagraphElement(this.editor.getCaretPosition());
        System.out.println("--------------");
        System.out.println(branchElement.getName() + "<-" + branchElement.getParentElement().getName());
        Element element = branchElement.positionToElement(this.editor.getCaretPosition());
        System.out.println(":" + element.getAttributes().getAttribute(StyleConstants.NameAttribute));
        AttributeSet attributeSet = element.getAttributes();
        String string = attributeSet.getAttribute(StyleConstants.NameAttribute).toString().toUpperCase();
        if (string.equals("IMG")) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            if (attributeSet.isDefined(HTML.Attribute.SRC)) {
                string2 = attributeSet.getAttribute(HTML.Attribute.SRC).toString();
            }
            if (attributeSet.isDefined(HTML.Attribute.ALT)) {
                string3 = attributeSet.getAttribute(HTML.Attribute.ALT).toString();
            }
            if (attributeSet.isDefined(HTML.Attribute.WIDTH)) {
                string4 = attributeSet.getAttribute(HTML.Attribute.WIDTH).toString();
            }
            if (attributeSet.isDefined(HTML.Attribute.HEIGHT)) {
                string5 = attributeSet.getAttribute(HTML.Attribute.HEIGHT).toString();
            }
            if (attributeSet.isDefined(HTML.Attribute.HSPACE)) {
                string6 = attributeSet.getAttribute(HTML.Attribute.HSPACE).toString();
            }
            if (attributeSet.isDefined(HTML.Attribute.VSPACE)) {
                string7 = attributeSet.getAttribute(HTML.Attribute.VSPACE).toString();
            }
            if (attributeSet.isDefined(HTML.Attribute.BORDER)) {
                string8 = attributeSet.getAttribute(HTML.Attribute.BORDER).toString();
            }
            if (attributeSet.isDefined(HTML.Attribute.ALIGN)) {
                string9 = attributeSet.getAttribute(HTML.Attribute.ALIGN).toString();
            }
            this.setImageProperties(element, string2, string3, string4, string5, string6, string7, string8, string9);
            return;
        }
        Object object = null;
        Object object2 = attributeSet.getAttributeNames();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (object.toString().equals("a")) {
                String[] stringArray = attributeSet.getAttribute(object).toString().split(" ");
                String string10 = "";
                String string11 = "";
                String string12 = "";
                String string13 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].startsWith("href=")) {
                        string10 = stringArray[i].split("=")[1];
                        continue;
                    }
                    if (stringArray[i].startsWith("title=")) {
                        string12 = stringArray[i].split("=")[1];
                        continue;
                    }
                    if (stringArray[i].startsWith("target=")) {
                        string11 = stringArray[i].split("=")[1];
                        continue;
                    }
                    if (!stringArray[i].startsWith("name=")) continue;
                    string13 = stringArray[i].split("=")[1];
                }
                this.setLinkProperties(element, string10, string11, string12, string13);
                return;
            }
            System.out.println(object + " = '" + attributeSet.getAttribute(object) + "'");
        }
        if (branchElement.getParentElement().getName().toUpperCase().equals("TD")) {
            this.setTableProperties(branchElement.getParentElement());
            return;
        }
        object2 = "";
        String string14 = "";
        String string15 = "";
        AttributeSet attributeSet2 = branchElement.getAttributes();
        if (attributeSet2.getAttribute(HTML.Attribute.ID) != null) {
            object2 = attributeSet2.getAttribute(HTML.Attribute.ID).toString();
        }
        if (attributeSet2.getAttribute(HTML.Attribute.CLASS) != null) {
            string14 = attributeSet2.getAttribute(HTML.Attribute.CLASS).toString();
        }
        if (attributeSet2.getAttribute(HTML.Attribute.STYLE) != null) {
            string15 = attributeSet2.getAttribute(HTML.Attribute.STYLE).toString();
        }
        this.setElementProperties(branchElement, (String)object2, string14, string15);
    }

    String setFontProperties(Element element, String string) {
        String string2;
        FontDialog fontDialog = new FontDialog(null);
        Dimension dimension = fontDialog.getSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocationOnScreen();
        fontDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        fontDialog.setModal(true);
        AttributeSet attributeSet = element.getAttributes();
        if (attributeSet.isDefined(StyleConstants.FontFamily)) {
            fontDialog.fontFamilyCB.setSelectedItem(attributeSet.getAttribute(StyleConstants.FontFamily).toString());
        }
        if (attributeSet.isDefined(HTML.Tag.FONT)) {
            string2 = attributeSet.getAttribute(HTML.Tag.FONT).toString();
            String string3 = string2.substring(string2.indexOf("size=") + 5, string2.indexOf("size=") + 6);
            fontDialog.fontSizeCB.setSelectedItem(string3);
        }
        if (attributeSet.isDefined(StyleConstants.Foreground)) {
            fontDialog.colorField.setText(Util.encodeColor((Color)attributeSet.getAttribute(StyleConstants.Foreground)));
            Util.setColorField(fontDialog.colorField);
            fontDialog.sample.setForeground((Color)attributeSet.getAttribute(StyleConstants.Foreground));
        }
        if (string != null) {
            fontDialog.sample.setText(string);
        }
        fontDialog.setVisible(true);
        if (fontDialog.CANCELLED) {
            return null;
        }
        string2 = "";
        if (fontDialog.fontSizeCB.getSelectedIndex() > 0) {
            string2 = string2 + "size=\"" + fontDialog.fontSizeCB.getSelectedItem() + "\"";
        }
        if (fontDialog.fontFamilyCB.getSelectedIndex() > 0) {
            string2 = string2 + "face=\"" + fontDialog.fontFamilyCB.getSelectedItem() + "\"";
        }
        if (fontDialog.colorField.getText().length() > 0) {
            string2 = string2 + "color=\"" + fontDialog.colorField.getText() + "\"";
        }
        if (string2.length() > 0) {
            return " " + string2;
        }
        return null;
    }

    void inlineCB_actionPerformed(ActionEvent actionEvent) {
        if (this.inlineCBEventsLock) {
            return;
        }
        int n = this.inlineCB.getSelectedIndex();
        if (n == 0) {
            Element element = this.document.getCharacterElement(this.editor.getCaretPosition());
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            if (this.editor.getSelectionEnd() > this.editor.getSelectionStart()) {
                this.document.setCharacterAttributes(this.editor.getSelectionStart(), this.editor.getSelectionEnd() - this.editor.getSelectionStart(), simpleAttributeSet, true);
            } else {
                this.document.setCharacterAttributes(element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), simpleAttributeSet, true);
            }
            return;
        }
        String string = "&nbsp;";
        if (this.editor.getSelectedText() != null) {
            string = this.editor.getSelectedText();
        }
        String string2 = "";
        String string3 = "";
        switch (n) {
            case 1: {
                string2 = "em";
                break;
            }
            case 2: {
                string2 = "strong";
                break;
            }
            case 3: {
                string2 = "code";
                break;
            }
            case 5: {
                string2 = "sup";
                break;
            }
            case 6: {
                string2 = "sub";
                break;
            }
            case 4: {
                string2 = "cite";
                break;
            }
            case 7: {
                string2 = "font";
                string3 = this.setFontProperties(this.document.getCharacterElement(this.editor.getCaretPosition()), this.editor.getSelectedText());
                if (string3 != null) break;
                return;
            }
        }
        String string4 = "<" + string2 + string3 + ">" + string + "</" + string2 + ">";
        if (this.editor.getCaretPosition() == this.document.getLength()) {
            string4 = string4 + "&nbsp;";
        }
        this.editor.replaceSelection("");
        try {
            this.editorKit.insertHTML(this.document, this.editor.getCaretPosition(), string4, 0, 0, HTML.getTag(string2));
            if (this.editor.getCaretPosition() == this.document.getLength()) {
                this.editor.setCaretPosition(this.editor.getCaretPosition() - 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void doZoom(boolean bl) {
    }

    public void setDocument(Document document) {
        this.document = (HTMLDocument)document;
        this.initEditor();
    }

    public void initEditor() {
        this.editor.setDocument(this.document);
        this.resetUndoManager();
        this.document.addUndoableEditListener(this.undoHandler);
        this.editor.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        this.editor.setCaretPosition(0);
    }

    public boolean isDocumentChanged() {
        return this.undo.canUndo();
    }

    public void setStyleSheet(Reader reader) {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.loadRules(reader, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.editorKit.setStyleSheet(styleSheet);
    }

    public void reload() {
    }

    void doFind() {
        FindDialog findDialog = new FindDialog();
        Dimension dimension = findDialog.getSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocationOnScreen();
        findDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        findDialog.setModal(true);
        if (this.editor.getSelectedText() != null) {
            findDialog.txtSearch.setText(this.editor.getSelectedText());
        } else if (Context.get("LAST_SEARCHED_WORD") != null) {
            findDialog.txtSearch.setText(Context.get("LAST_SEARCHED_WORD").toString());
        }
        findDialog.setVisible(true);
        if (findDialog.CANCELLED) {
            return;
        }
        Context.put("LAST_SEARCHED_WORD", findDialog.txtSearch.getText());
        String string = null;
        if (findDialog.chkReplace.isSelected()) {
            string = findDialog.txtReplace.getText();
        }
        Finder finder = new Finder(this, findDialog.txtSearch.getText(), findDialog.chkWholeWord.isSelected(), findDialog.chkCaseSens.isSelected(), findDialog.chkRegExp.isSelected(), string);
        finder.start();
    }

    class InsertTableCellAction
    extends AbstractAction {
        InsertTableCellAction() {
            super(Local.getString("Insert table cell"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 3));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "<td><p></p></td>";
            Element element = HTMLEditor.this.document.getParagraphElement(HTMLEditor.this.editor.getCaretPosition()).getParentElement();
            try {
                HTMLEditor.this.document.insertAfterEnd(element, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public boolean isEnabled() {
            if (HTMLEditor.this.document == null) {
                return false;
            }
            return HTMLEditor.this.document.getParagraphElement(HTMLEditor.this.editor.getCaretPosition()).getParentElement().getName().toUpperCase().equals("TD");
        }

        public void update() {
            this.setEnabled(this.isEnabled());
        }
    }

    class InsertTableRowAction
    extends AbstractAction {
        InsertTableRowAction() {
            super(Local.getString("Insert table row"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "<tr>";
            Element element = HTMLEditor.this.document.getParagraphElement(HTMLEditor.this.editor.getCaretPosition()).getParentElement().getParentElement();
            for (int i = 0; i < element.getElementCount(); ++i) {
                if (!element.getElement(i).getName().toUpperCase().equals("TD")) continue;
                string = string + "<td><p></p></td>";
            }
            string = string + "</tr>";
            try {
                HTMLEditor.this.document.insertAfterEnd(element, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public boolean isEnabled() {
            if (HTMLEditor.this.document == null) {
                return false;
            }
            return HTMLEditor.this.document.getParagraphElement(HTMLEditor.this.editor.getCaretPosition()).getParentElement().getName().toUpperCase().equals("TD");
        }

        public void update() {
            this.setEnabled(this.isEnabled());
        }
    }

    class BreakAction
    extends AbstractAction {
        BreakAction() {
            super(Local.getString("Insert break"), new ImageIcon(HTMLEditor.this.cl.getResource("resources/icons/break.png")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HTMLEditor.this.document.getParagraphElement(HTMLEditor.this.editor.getCaretPosition()).getName();
            HTML.Tag tag = HTML.getTag(string);
            if (string.toUpperCase().equals("P-IMPLIED")) {
                tag = HTML.Tag.IMPLIED;
            }
            HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insertBR", "<br>", tag, HTML.Tag.BR);
            insertHTMLTextAction.actionPerformed(actionEvent);
        }
    }

    class ParaBreakAction
    extends AbstractAction {
        ParaBreakAction() {
            super("ParaBreakAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Element element = HTMLEditor.this.document.getParagraphElement(HTMLEditor.this.editor.getCaretPosition());
            String string = element.getName().toUpperCase();
            String string2 = element.getParentElement().getName();
            HTML.Tag tag = HTML.getTag(string2);
            if (string2.toUpperCase().equals("P-IMPLIED")) {
                tag = HTML.Tag.IMPLIED;
            }
            if (string2.toLowerCase().equals("li")) {
                if (element.getEndOffset() - element.getStartOffset() > 1) {
                    try {
                        HTMLEditor.this.document.insertAfterEnd(element.getParentElement(), "<li></li>");
                        HTMLEditor.this.editor.setCaretPosition(element.getParentElement().getEndOffset());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    try {
                        HTMLEditor.this.document.remove(HTMLEditor.this.editor.getCaretPosition(), 1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Element element2 = element.getParentElement().getParentElement().getParentElement();
                    HTML.Tag tag2 = HTML.getTag(element2.getName());
                    String string3 = tag2.toString();
                    if (string3.toLowerCase().equals("li")) {
                        Element element3 = element2.getParentElement();
                        try {
                            HTMLEditor.this.editorKit.insertHTML(HTMLEditor.this.document, element3.getEndOffset(), "<li><p></p></li>", 3, 0, HTML.Tag.LI);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insertP", "<p></p>", tag2, HTML.Tag.P);
                        insertHTMLTextAction.actionPerformed(actionEvent);
                    }
                }
            } else if (string.equals("PRE") || string.equals("ADDRESS") || string.equals("BLOCKQUOTE")) {
                if (HTMLEditor.this.editor.getCaretPosition() > 0) {
                    HTMLEditor.this.removeIfEmpty(HTMLEditor.this.document.getParagraphElement(HTMLEditor.this.editor.getCaretPosition() - 1));
                }
                HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insertP", "<p></p>", tag, HTML.Tag.P);
                System.out.println("PRE");
                insertHTMLTextAction.actionPerformed(actionEvent);
            } else if (string.equals("P-IMPLIED")) {
                try {
                    System.out.println("IMPLIED");
                    HTMLEditor.this.document.insertAfterEnd(element.getParentElement(), "<p></p>");
                    HTMLEditor.this.editor.setCaretPosition(element.getParentElement().getEndOffset());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                HTMLEditor.this.editor.replaceSelection("\n");
                HTMLEditor.this.editorKit.getInputAttributes().removeAttribute(HTML.Attribute.ID);
                HTMLEditor.this.editorKit.getInputAttributes().removeAttribute(HTML.Attribute.CLASS);
            }
        }
    }

    public class InlineAction
    extends AbstractAction {
        int _type;

        public InlineAction(int n, String string) {
            super(string);
            this._type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.inlineCB.setSelectedIndex(this._type);
        }
    }

    public class BlockAction
    extends AbstractAction {
        int _type;

        public BlockAction(int n, String string) {
            super(string);
            this._type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditor.this.blockCB.setSelectedIndex(this._type);
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(Local.getString("Redo"));
            this.setEnabled(false);
            this.putValue("SmallIcon", new ImageIcon(HTMLEditor.this.cl.getResource("resources/icons/redo16.png")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 3));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                HTMLEditor.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.out.println("Unable to redo: " + cannotRedoException);
                cannotRedoException.printStackTrace();
            }
            this.update();
            HTMLEditor.this.undoAction.update();
        }

        protected void update() {
            if (HTMLEditor.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("ShortDescription", HTMLEditor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("ShortDescription", Local.getString("Redo"));
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(Local.getString("Undo"));
            this.setEnabled(false);
            this.putValue("SmallIcon", new ImageIcon(HTMLEditor.this.cl.getResource("resources/icons/undo16.png")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                HTMLEditor.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.out.println("Unable to undo: " + cannotUndoException);
                cannotUndoException.printStackTrace();
            }
            this.update();
            HTMLEditor.this.redoAction.update();
        }

        protected void update() {
            if (HTMLEditor.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("ShortDescription", HTMLEditor.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("ShortDescription", Local.getString("Undo"));
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            HTMLEditor.this.undo.addEdit(undoableEditEvent.getEdit());
            HTMLEditor.this.undoAction.update();
            HTMLEditor.this.redoAction.update();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.setFocusable(false);
                jPopupMenu.add(HTMLEditor.this.jMenuItemUndo);
                jPopupMenu.add(HTMLEditor.this.jMenuItemRedo);
                jPopupMenu.addSeparator();
                jPopupMenu.add(HTMLEditor.this.jMenuItemCut);
                jPopupMenu.add(HTMLEditor.this.jMenuItemCopy);
                jPopupMenu.add(HTMLEditor.this.jMenuItemPaste);
                jPopupMenu.addSeparator();
                if (HTMLEditor.this.jMenuItemInsCell.getAction().isEnabled()) {
                    jPopupMenu.add(HTMLEditor.this.jMenuItemInsCell);
                    HTMLEditor.this.jMenuItemInsCell.setEnabled(true);
                    jPopupMenu.add(HTMLEditor.this.jMenuItemInsRow);
                    HTMLEditor.this.jMenuItemInsRow.setEnabled(true);
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add(HTMLEditor.this.jMenuItemProp);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    abstract class HTMLEditorAction
    extends AbstractAction {
        HTMLEditorAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
            super.putValue("ShortDescription", string);
        }

        HTMLEditorAction(String string) {
            super(string);
            super.putValue("ShortDescription", string);
        }
    }
}

