/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui.htmleditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import net.sf.memoranda.ui.htmleditor.Context;
import net.sf.memoranda.ui.htmleditor.filechooser.ImageFilter;
import net.sf.memoranda.ui.htmleditor.filechooser.ImagePreview;
import net.sf.memoranda.ui.htmleditor.util.Local;

public class ImageDialog
extends JDialog
implements WindowListener {
    JPanel headerPanel = new JPanel(new FlowLayout(0));
    JLabel header = new JLabel();
    JPanel areaPanel = new JPanel(new GridBagLayout());
    GridBagConstraints gbc;
    JLabel jLabel1 = new JLabel();
    public JTextField fileField = new JTextField();
    JButton browseB = new JButton();
    JLabel jLabel2 = new JLabel();
    public JTextField altField = new JTextField();
    JLabel jLabel3 = new JLabel();
    public JTextField widthField = new JTextField();
    JLabel jLabel4 = new JLabel();
    public JTextField heightField = new JTextField();
    JLabel jLabel5 = new JLabel();
    public JTextField hspaceField = new JTextField();
    JLabel jLabel6 = new JLabel();
    public JTextField vspaceField = new JTextField();
    JLabel jLabel7 = new JLabel();
    public JTextField borderField = new JTextField();
    JLabel jLabel8 = new JLabel();
    String[] aligns = new String[]{"left", "right", "top", "middle", "bottom", "absmiddle", "texttop", "baseline"};
    public JComboBox alignCB = new JComboBox<String>(this.aligns);
    JLabel jLabel9 = new JLabel();
    public JTextField urlField = new JTextField();
    JPanel buttonsPanel = new JPanel(new FlowLayout(2, 10, 10));
    JButton okB = new JButton();
    JButton cancelB = new JButton();
    public boolean CANCELLED = false;

    public ImageDialog(Frame frame) {
        super(frame, Local.getString("Image"), true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.addWindowListener(this);
    }

    public ImageDialog() {
        this((Frame)null);
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        this.headerPanel.setBorder(new EmptyBorder(new Insets(0, 5, 0, 5)));
        this.headerPanel.setBackground(Color.WHITE);
        this.header.setFont(new Font("Dialog", 0, 20));
        this.header.setForeground(new Color(0, 0, 124));
        this.header.setText(Local.getString("Image"));
        this.header.setIcon(new ImageIcon(ImageDialog.class.getResource("resources/icons/imgbig.png")));
        this.headerPanel.add(this.header);
        this.getContentPane().add((Component)this.headerPanel, "North");
        this.areaPanel.setBorder(new EtchedBorder(Color.white, new Color(142, 142, 142)));
        this.jLabel1.setText(Local.getString("Image file"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(10, 10, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.jLabel1, this.gbc);
        this.fileField.setMinimumSize(new Dimension(200, 25));
        this.fileField.setPreferredSize(new Dimension(285, 25));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 5;
        this.gbc.insets = new Insets(10, 5, 5, 5);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.areaPanel.add((Component)this.fileField, this.gbc);
        this.browseB.setMinimumSize(new Dimension(25, 25));
        this.browseB.setPreferredSize(new Dimension(25, 25));
        this.browseB.setIcon(new ImageIcon(ImageDialog.class.getResource("resources/icons/fileopen16.png")));
        this.browseB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageDialog.this.browseB_actionPerformed(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 6;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(10, 5, 5, 10);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.browseB, this.gbc);
        this.jLabel2.setText(Local.getString("ALT text"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.jLabel2, this.gbc);
        this.altField.setPreferredSize(new Dimension(315, 25));
        this.altField.setMinimumSize(new Dimension(200, 25));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 6;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.areaPanel.add((Component)this.altField, this.gbc);
        this.jLabel3.setText(Local.getString("Width"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.jLabel3, this.gbc);
        this.widthField.setPreferredSize(new Dimension(30, 25));
        this.widthField.setMinimumSize(new Dimension(30, 25));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.widthField, this.gbc);
        this.jLabel4.setText(Local.getString("Height"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 50, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.jLabel4, this.gbc);
        this.heightField.setMinimumSize(new Dimension(30, 25));
        this.heightField.setPreferredSize(new Dimension(30, 25));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 3;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.heightField, this.gbc);
        this.jLabel5.setText(Local.getString("H. space"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.jLabel5, this.gbc);
        this.hspaceField.setMinimumSize(new Dimension(30, 25));
        this.hspaceField.setPreferredSize(new Dimension(30, 25));
        this.hspaceField.setText("0");
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.hspaceField, this.gbc);
        this.jLabel6.setText(Local.getString("V. space"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 3;
        this.gbc.insets = new Insets(5, 50, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.jLabel6, this.gbc);
        this.vspaceField.setMinimumSize(new Dimension(30, 25));
        this.vspaceField.setPreferredSize(new Dimension(30, 25));
        this.vspaceField.setText("0");
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 3;
        this.gbc.gridy = 3;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.vspaceField, this.gbc);
        this.jLabel7.setText(Local.getString("Border"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.jLabel7, this.gbc);
        this.borderField.setMinimumSize(new Dimension(30, 25));
        this.borderField.setPreferredSize(new Dimension(30, 25));
        this.borderField.setText("0");
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 4;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.borderField, this.gbc);
        this.jLabel8.setText(Local.getString("Align"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 4;
        this.gbc.insets = new Insets(5, 50, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.jLabel8, this.gbc);
        this.alignCB.setBackground(new Color(230, 230, 230));
        this.alignCB.setFont(new Font("Dialog", 1, 10));
        this.alignCB.setPreferredSize(new Dimension(100, 25));
        this.alignCB.setSelectedIndex(0);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 3;
        this.gbc.gridy = 4;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.alignCB, this.gbc);
        this.jLabel9.setText(Local.getString("Hyperlink"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 5;
        this.gbc.insets = new Insets(5, 10, 10, 5);
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.jLabel9, this.gbc);
        this.urlField.setPreferredSize(new Dimension(315, 25));
        this.urlField.setMinimumSize(new Dimension(200, 25));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 5;
        this.gbc.gridwidth = 6;
        this.gbc.insets = new Insets(5, 5, 10, 10);
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.areaPanel.add((Component)this.urlField, this.gbc);
        this.getContentPane().add((Component)this.areaPanel, "Center");
        this.okB.setMaximumSize(new Dimension(100, 26));
        this.okB.setMinimumSize(new Dimension(100, 26));
        this.okB.setPreferredSize(new Dimension(100, 26));
        this.okB.setText(Local.getString("Ok"));
        this.okB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageDialog.this.okB_actionPerformed(actionEvent);
            }
        });
        this.getRootPane().setDefaultButton(this.okB);
        this.cancelB.setMaximumSize(new Dimension(100, 26));
        this.cancelB.setMinimumSize(new Dimension(100, 26));
        this.cancelB.setPreferredSize(new Dimension(100, 26));
        this.cancelB.setText(Local.getString("Cancel"));
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageDialog.this.cancelB_actionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add((Component)this.okB, null);
        this.buttonsPanel.add((Component)this.cancelB, null);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
    }

    void okB_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void cancelB_actionPerformed(ActionEvent actionEvent) {
        this.CANCELLED = true;
        this.dispose();
    }

    private ImageIcon getPreviewIcon(File file) {
        ImageIcon imageIcon = new ImageIcon(file.getPath());
        ImageIcon imageIcon2 = null;
        imageIcon2 = imageIcon.getIconHeight() > 48 ? new ImageIcon(imageIcon.getImage().getScaledInstance(-1, 48, 1)) : imageIcon;
        if (imageIcon2.getIconWidth() > 350) {
            return new ImageIcon(imageIcon2.getImage().getScaledInstance(350, -1, 1));
        }
        return imageIcon2;
    }

    public void updatePreview() {
        try {
            if (new URL(this.fileField.getText()).getPath() != "") {
                this.header.setIcon(this.getPreviewIcon(new File(new URL(this.fileField.getText()).getPath())));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.CANCELLED = true;
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    void browseB_actionPerformed(ActionEvent actionEvent) {
        UIManager.put("FileChooser.lookInLabelText", Local.getString("Look in:"));
        UIManager.put("FileChooser.upFolderToolTipText", Local.getString("Up One Level"));
        UIManager.put("FileChooser.newFolderToolTipText", Local.getString("Create New Folder"));
        UIManager.put("FileChooser.listViewButtonToolTipText", Local.getString("List"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", Local.getString("Details"));
        UIManager.put("FileChooser.fileNameLabelText", Local.getString("File Name:"));
        UIManager.put("FileChooser.filesOfTypeLabelText", Local.getString("Files of Type:"));
        UIManager.put("FileChooser.openButtonText", Local.getString("Open"));
        UIManager.put("FileChooser.openButtonToolTipText", Local.getString("Open selected file"));
        UIManager.put("FileChooser.cancelButtonText", Local.getString("Cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", Local.getString("Cancel"));
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setDialogTitle(Local.getString("Choose an image file"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new ImageFilter());
        jFileChooser.setAccessory(new ImagePreview(jFileChooser));
        jFileChooser.setPreferredSize(new Dimension(550, 375));
        File file = (File)Context.get("LAST_SELECTED_IMG_FILE");
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                this.fileField.setText(jFileChooser.getSelectedFile().toURL().toString());
                this.header.setIcon(this.getPreviewIcon(jFileChooser.getSelectedFile()));
                Context.put("LAST_SELECTED_IMG_FILE", jFileChooser.getSelectedFile());
            }
            catch (Exception exception) {
                this.fileField.setText(jFileChooser.getSelectedFile().getPath());
            }
            try {
                ImageIcon imageIcon = new ImageIcon(jFileChooser.getSelectedFile().getPath());
                this.widthField.setText(new Integer(imageIcon.getIconWidth()).toString());
                this.heightField.setText(new Integer(imageIcon.getIconHeight()).toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

