/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.util.LoadableProperties;
import net.sf.memoranda.util.Util;

public class Configuration {
    static LoadableProperties config = new LoadableProperties();
    static String configPath = Configuration.getConfigPath();

    static String getConfigPath() {
        String string = Util.getEnvDir() + "memoranda.properties";
        if (new File(string).exists()) {
            return string;
        }
        String string2 = Util.getEnvDir() + "jnotes2.properties";
        if (new File(string2).exists()) {
            System.out.println(string + " not found.\n" + string2 + " used instead.");
            return string2;
        }
        return string;
    }

    public static void saveConfig() {
        try {
            config.save(new FileOutputStream(configPath));
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to save a configuration file:<br>" + configPath, "");
        }
    }

    public static Object get(String string) {
        if (config.get(string) == null) {
            return "";
        }
        return config.get(string);
    }

    public static void put(String string, Object object) {
        config.put(string, object);
    }

    static {
        try {
            config.load(new FileInputStream(configPath));
        }
        catch (Exception exception) {
            File file = new File(configPath);
            new File(file.getParent()).mkdirs();
            System.out.println("New configuration created: " + configPath);
            try {
                config.load(Configuration.class.getResourceAsStream("resources/memoranda.default.properties"));
                Configuration.saveConfig();
            }
            catch (Exception exception2) {
                new ExceptionDialog(exception2, "Failed to load default configuration from resources.", "");
                config = null;
            }
        }
    }
}

