/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.swing.JFileChooser;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.util.AppList;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.MimeTypesList;

public class Util {
    static long seed = 0L;
    static Set tempFiles = new HashSet();

    public static String generateId() {
        long l = System.currentTimeMillis();
        while (l == seed) {
            l = System.currentTimeMillis();
        }
        seed = l;
        Random random = new Random(seed);
        return Integer.toString(random.nextInt(), 16) + "-" + Integer.toString(random.nextInt(65535), 16) + "-" + Integer.toString(random.nextInt(65535), 16) + "-" + Integer.toString(random.nextInt(65535), 16);
    }

    public static String getDateStamp(Calendar calendar) {
        return calendar.get(5) + "/" + calendar.get(2) + "/" + new Integer(calendar.get(1)).toString();
    }

    public static String getDateStamp(CalendarDate calendarDate) {
        return Util.getDateStamp(calendarDate.getCalendar());
    }

    public static int[] parseDateStamp(String string) {
        string = string.trim();
        int n = string.indexOf("/");
        int n2 = string.indexOf("/", n + 1);
        int[] nArray = new int[]{new Integer(string.substring(0, n)), new Integer(string.substring(n + 1, n2)), new Integer(string.substring(n2 + 1))};
        return nArray;
    }

    public static String getEnvDir() {
        String string = System.getProperty("user.home") + File.separator + ".jnotes2" + File.separator;
        if (new File(string).isDirectory()) {
            return string;
        }
        return System.getProperty("user.home") + File.separator + ".memoranda" + File.separator;
    }

    public static String getCDATA(String string) {
        return "<![CDATA[" + string + "]]>";
    }

    public static void runBrowser(String string) {
        if (!Util.checkBrowser()) {
            return;
        }
        String string2 = MimeTypesList.getAppList().getBrowserExec() + " " + string;
        System.out.println("Run: " + string2);
        try {
            Runtime.getRuntime().exec(string2);
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to run an external web-browser application with commandline<br><code>" + string2 + "</code>", "Check the application path and command line parameters (File-&gt;Preferences-&gt;Resource types).");
        }
    }

    public static boolean checkBrowser() {
        AppList appList = MimeTypesList.getAppList();
        String string = appList.getBrowserExec();
        if (string != null && new File(string).isFile()) {
            return true;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setDialogTitle(Local.getString("Select the web-browser executable"));
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(App.getFrame()) != 0) {
            return false;
        }
        appList.setBrowserExec(jFileChooser.getSelectedFile().getPath());
        CurrentStorage.get().storeMimeTypesList();
        return true;
    }

    public static String getHoursFromMillis(long l) {
        double d = (double)l / 1000.0;
        return String.valueOf(d / 3600.0);
    }

    public static long getMillisFromHours(String string) {
        try {
            double d = Double.parseDouble(string);
            double d2 = d * 3600.0 * 1000.0;
            return (long)d2;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static File getTempFile() throws IOException {
        File file = File.createTempFile("tmp", ".html", null);
        tempFiles.add(file);
        return file;
    }

    public static void debug(String string) {
        System.out.println("[DEBUG] " + string);
    }

    public static void error(Exception exception) {
        System.out.println("[ERROR] Exception: " + exception.getClass().getName());
        System.out.println("[ERROR] Exception Message: " + exception.getMessage());
        String string = "";
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string = stackTraceElementArray[i].toString() + "\n";
        }
        System.out.println("[ERROR] Stack Trace: " + string);
    }

    static {
        AppFrame.addExitListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Iterator iterator = tempFiles.iterator();
                while (iterator.hasNext()) {
                    ((File)iterator.next()).delete();
                }
            }
        });
    }
}

