/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.xsd.ConcreteType;
import com.sun.msv.datatype.xsd.DataTypeWithFacet;
import com.sun.msv.datatype.xsd.WhiteSpaceProcessor;
import com.sun.msv.datatype.xsd.XSDatatype;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public abstract class XSDatatypeImpl
implements XSDatatype {
    private final String namespaceUri;
    private final String typeName;
    public final WhiteSpaceProcessor whiteSpace;
    protected static final ValidationContext serializedValueChecker = new ValidationContext(){};

    public String getName() {
        return this.typeName;
    }

    protected XSDatatypeImpl(String uri, String typeName, WhiteSpaceProcessor whiteSpace) {
        this.namespaceUri = uri;
        this.typeName = typeName;
        this.whiteSpace = whiteSpace;
    }

    public final Object createValue(String lexicalValue, ValidationContext context) {
        return this._createValue(this.whiteSpace.process(lexicalValue), context);
    }

    protected abstract Object _createValue(String var1, ValidationContext var2);

    public final void checkValid(String content, ValidationContext context) throws DatatypeException {
        this._checkValid(this.whiteSpace.process(content), context);
    }

    protected abstract void _checkValid(String var1, ValidationContext var2) throws DatatypeException;

    public final Object createJavaObject(String literal, ValidationContext context) {
        return this._createJavaObject(this.whiteSpace.process(literal), context);
    }

    protected abstract Object _createJavaObject(String var1, ValidationContext var2);

    public final boolean isValid(String literal, ValidationContext context) {
        literal = this.whiteSpace.process(literal);
        if (this.needValueCheck()) {
            return this._createValue(literal, context) != null;
        }
        return this.checkFormat(literal, context);
    }

    protected abstract boolean checkFormat(String var1, ValidationContext var2);

    protected boolean needValueCheck() {
        return false;
    }

    public DataTypeWithFacet getFacetObject(String facetName) {
        XSDatatype dt = this.getBaseType();
        if (dt != null) {
            return dt.getFacetObject(facetName);
        }
        return null;
    }

    public abstract ConcreteType getConcreteType();

    public final boolean sameValue(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public int getIdType() {
        return 0;
    }

    public static String localize(String prop, Object[] args) {
        return MessageFormat.format(ResourceBundle.getBundle("com.sun.msv.datatype.xsd.Messages").getString(prop), args);
    }

    public static String localize(String prop, Object arg1) {
        return XSDatatypeImpl.localize(prop, new Object[]{arg1});
    }

    public static String localize(String prop, Object arg1, Object arg2) {
        return XSDatatypeImpl.localize(prop, new Object[]{arg1, arg2});
    }
}

