/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;

public class MppTaskTest
extends MPXJTestCase {
    public void testMpp9Task() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp9task.mpp");
        this.testBasicTask(mpp);
    }

    public void testMpp12Task() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp12task.mpp");
        this.testBasicTask(mpp);
    }

    public void testMpd9Task() throws Exception {
        ProjectFile mpp = new MPDDatabaseReader().read(String.valueOf(this.m_basedir) + "/mpp9task.mpd");
        this.testBasicTask(mpp);
    }

    public void testMpp9Baseline() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp9baseline.mpp");
        this.testBaselineTasks(mpp);
    }

    public void testMpp12Baseline() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp12baseline.mpp");
        this.testBaselineTasks(mpp);
    }

    public void testMpd9Baseline() throws Exception {
        ProjectFile mpp = new MPDDatabaseReader().read(String.valueOf(this.m_basedir) + "/mpp9baseline.mpd");
        this.testBaselineTasks(mpp);
    }

    public void testMpp9Splits() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp9splittask.mpp");
        this.testSplitTasks(mpp);
    }

    public void testMpp12Splits() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp12splittask.mpp");
        this.testSplitTasks(mpp);
    }

    public void testMpd9Splits() throws Exception {
    }

    public void testMpp9Relations() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp9relations.mpp");
        this.testRelations(mpp);
    }

    public void testMpd9Relations() throws Exception {
        ProjectFile mpp = new MPDDatabaseReader().read(String.valueOf(this.m_basedir) + "/mpp9relations.mpd");
        this.testRelations(mpp);
    }

    public void testMpp12Relations() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp12relations.mpp");
        this.testRelations(mpp);
    }

    public void testBasicTask(ProjectFile mpp) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        ProjectHeader projectHeader = mpp.getProjectHeader();
        MppTaskTest.assertNotNull((Object)projectHeader);
        List listAllTasks = mpp.getAllTasks();
        List listAllResources = mpp.getAllResources();
        MppTaskTest.assertTrue((listAllTasks != null ? 1 : 0) != 0);
        MppTaskTest.assertTrue((listAllResources != null ? 1 : 0) != 0);
        MppTaskTest.assertEquals((int)2, (int)listAllTasks.size());
        Task task = (Task)listAllTasks.get(0);
        MppTaskTest.assertTrue((task != null ? 1 : 0) != 0);
        MppTaskTest.assertEquals((int)0, (int)task.getID());
        MppTaskTest.assertEquals((String)"MPP12 Test", (String)task.getName());
        task = (Task)listAllTasks.get(1);
        MppTaskTest.assertTrue((task != null ? 1 : 0) != 0);
        MppTaskTest.assertEquals((int)1, (int)task.getID());
        MppTaskTest.assertEquals((String)"Task #1", (String)task.getName());
        String string = "23/08/2006";
        String string2 = "29/08/2006";
        MppTaskTest.assertEquals((String)"23/08/2006", (String)df.format(task.getStart()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getFinish()));
        MppTaskTest.assertTrue((task.getPredecessors() == null ? 1 : 0) != 0);
        Duration expectedDuration = Duration.getInstance(1, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration());
        expectedDuration = Duration.getInstance(40, TimeUnit.HOURS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getWork());
        Double expectedPctComp = new Double(45.0);
        MppTaskTest.assertEquals((Object)expectedPctComp, (Object)task.getPercentageComplete());
        expectedPctComp = new Double(45.0);
        MppTaskTest.assertEquals((Object)expectedPctComp, (Object)task.getPercentageWorkComplete());
        Double expectedCost = new Double(5000.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost());
        expectedCost = new Double(2800.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getActualCost());
        expectedCost = new Double(1000.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getFixedCost());
        expectedCost = new Double(2200.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getRemainingCost());
        expectedDuration = Duration.getInstance(18, TimeUnit.HOURS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)expectedDuration);
        String expectedContact = "wade";
        MppTaskTest.assertEquals((String)expectedContact, (String)task.getContact());
        MppTaskTest.assertEquals((String)"23/08/2006", (String)df.format(task.getConstraintDate()));
        MppTaskTest.assertEquals((Object)ConstraintType.MUST_START_ON, (Object)task.getConstraintType());
        expectedCost = new Double(1.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost1());
        expectedCost = new Double(2.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost2());
        expectedCost = new Double(3.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost3());
        expectedCost = new Double(4.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost4());
        expectedCost = new Double(5.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost5());
        expectedCost = new Double(6.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost6());
        expectedCost = new Double(7.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost7());
        expectedCost = new Double(8.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost8());
        expectedCost = new Double(9.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost9());
        expectedCost = new Double(10.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost10());
        expectedCost = new Double(5000.0);
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCostVariance());
        MppTaskTest.assertEquals((String)"23/08/2006", (String)df.format(task.getCreateDate()));
        MppTaskTest.assertEquals((String)"25/08/2006", (String)df.format(task.getDate1()));
        MppTaskTest.assertEquals((String)"26/08/2006", (String)df.format(task.getDate2()));
        MppTaskTest.assertEquals((String)"27/08/2006", (String)df.format(task.getDate3()));
        MppTaskTest.assertEquals((String)"28/08/2006", (String)df.format(task.getDate4()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getDate5()));
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(task.getDate6()));
        MppTaskTest.assertEquals((String)"31/08/2006", (String)df.format(task.getDate7()));
        MppTaskTest.assertEquals((String)"01/09/2006", (String)df.format(task.getDate8()));
        MppTaskTest.assertEquals((String)"02/09/2006", (String)df.format(task.getDate9()));
        MppTaskTest.assertEquals((String)"03/09/2006", (String)df.format(task.getDate10()));
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(task.getDeadline()));
        expectedDuration = Duration.getInstance(1, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration1());
        expectedDuration = Duration.getInstance(2, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration2());
        expectedDuration = Duration.getInstance(3, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration3());
        expectedDuration = Duration.getInstance(4, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration4());
        expectedDuration = Duration.getInstance(5, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration5());
        expectedDuration = Duration.getInstance(6, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration6());
        expectedDuration = Duration.getInstance(7, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration7());
        expectedDuration = Duration.getInstance(8, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration8());
        expectedDuration = Duration.getInstance(9, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration9());
        expectedDuration = Duration.getInstance(10, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration10());
        expectedDuration = Duration.getInstance(1, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDurationVariance());
        MppTaskTest.assertEquals((String)"23/08/2006", (String)df.format(task.getEarlyStart()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getEarlyFinish()));
        MppTaskTest.assertTrue((String)"Effort Driven does not match", (boolean)task.getEffortDriven());
        MppTaskTest.assertEquals((String)"25/08/2006", (String)df.format(task.getStart1()));
        MppTaskTest.assertEquals((String)"26/08/2006", (String)df.format(task.getStart2()));
        MppTaskTest.assertEquals((String)"27/08/2006", (String)df.format(task.getStart3()));
        MppTaskTest.assertEquals((String)"28/08/2006", (String)df.format(task.getStart4()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getStart5()));
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(task.getStart6()));
        MppTaskTest.assertEquals((String)"31/08/2006", (String)df.format(task.getStart7()));
        MppTaskTest.assertEquals((String)"01/09/2006", (String)df.format(task.getStart8()));
        MppTaskTest.assertEquals((String)"02/09/2006", (String)df.format(task.getStart9()));
        MppTaskTest.assertEquals((String)"03/09/2006", (String)df.format(task.getStart10()));
        MppTaskTest.assertEquals((String)"25/08/2006", (String)df.format(task.getFinish1()));
        MppTaskTest.assertEquals((String)"26/08/2006", (String)df.format(task.getFinish2()));
        MppTaskTest.assertEquals((String)"27/08/2006", (String)df.format(task.getFinish3()));
        MppTaskTest.assertEquals((String)"28/08/2006", (String)df.format(task.getFinish4()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getFinish5()));
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(task.getFinish6()));
        MppTaskTest.assertEquals((String)"31/08/2006", (String)df.format(task.getFinish7()));
        MppTaskTest.assertEquals((String)"01/09/2006", (String)df.format(task.getFinish8()));
        MppTaskTest.assertEquals((String)"02/09/2006", (String)df.format(task.getFinish9()));
        MppTaskTest.assertEquals((String)"03/09/2006", (String)df.format(task.getFinish10()));
        expectedDuration = Duration.getInstance(0, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getFinishSlack());
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getStartSlack());
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getFreeSlack());
        expectedDuration = Duration.getInstance(0, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getFinishVariance());
        MppTaskTest.assertEquals((Object)AccrueType.START, (Object)task.getFixedCostAccrual());
        boolean expectedValue = true;
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag1());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag2());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag3());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag4());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag5());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag6());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag7());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag8());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag9());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag10());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag11());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag12());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag13());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag14());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag15());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag16());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag17());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag18());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag19());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag20());
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getHideBar());
        String string3 = "http://www.steelray.com";
        MppTaskTest.assertEquals((String)"http://www.steelray.com", (String)task.getHyperlink());
        MppTaskTest.assertEquals((String)"http://www.steelray.com", (String)task.getHyperlinkAddress());
        MppTaskTest.assertEquals((boolean)false, (boolean)task.getIgnoreResourceCalendar());
        MppTaskTest.assertEquals((String)"23/08/2006", (String)df.format(task.getLateStart()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getLateFinish()));
        MppTaskTest.assertEquals((boolean)false, (boolean)task.getLevelAssignments());
        MppTaskTest.assertEquals((boolean)false, (boolean)task.getLevelingCanSplit());
        expectedDuration = Duration.getInstance(0, TimeUnit.ELAPSED_DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getLevelingDelay());
        MppTaskTest.assertTrue((boolean)task.getMarked());
        MppTaskTest.assertTrue((boolean)task.getMilestone());
        MppTaskTest.assertEquals((String)"Notes Example\n", (String)task.getNotes());
        MppTaskTest.assertEquals((Object)new Double(1.0), (Object)task.getNumber1());
        MppTaskTest.assertEquals((Object)new Double(2.0), (Object)task.getNumber2());
        MppTaskTest.assertEquals((Object)new Double(3.0), (Object)task.getNumber3());
        MppTaskTest.assertEquals((Object)new Double(4.0), (Object)task.getNumber4());
        MppTaskTest.assertEquals((Object)new Double(5.0), (Object)task.getNumber5());
        MppTaskTest.assertEquals((Object)new Double(6.0), (Object)task.getNumber6());
        MppTaskTest.assertEquals((Object)new Double(7.0), (Object)task.getNumber7());
        MppTaskTest.assertEquals((Object)new Double(8.0), (Object)task.getNumber8());
        MppTaskTest.assertEquals((Object)new Double(9.0), (Object)task.getNumber9());
        MppTaskTest.assertEquals((Object)new Double(10.0), (Object)task.getNumber10());
        MppTaskTest.assertEquals((Object)new Double(11.0), (Object)task.getNumber11());
        MppTaskTest.assertEquals((Object)new Double(12.0), (Object)task.getNumber12());
        MppTaskTest.assertEquals((Object)new Double(13.0), (Object)task.getNumber13());
        MppTaskTest.assertEquals((Object)new Double(14.0), (Object)task.getNumber14());
        MppTaskTest.assertEquals((Object)new Double(15.0), (Object)task.getNumber15());
        MppTaskTest.assertEquals((Object)new Double(16.0), (Object)task.getNumber16());
        MppTaskTest.assertEquals((Object)new Double(17.0), (Object)task.getNumber17());
        MppTaskTest.assertEquals((Object)new Double(18.0), (Object)task.getNumber18());
        MppTaskTest.assertEquals((Object)new Double(19.0), (Object)task.getNumber19());
        MppTaskTest.assertEquals((Object)new Double(20.0), (Object)task.getNumber20());
        MppTaskTest.assertEquals((Object)new Integer(1), (Object)task.getOutlineLevel());
        MppTaskTest.assertEquals((String)"1", (String)task.getOutlineNumber());
        MppTaskTest.assertEquals((String)"1", (String)task.getOutlineCode1());
        MppTaskTest.assertEquals((String)"A", (String)task.getOutlineCode2());
        MppTaskTest.assertEquals((String)"a", (String)task.getOutlineCode3());
        MppTaskTest.assertEquals((String)"Aa", (String)task.getOutlineCode4());
        MppTaskTest.assertEquals((String)"5", (String)task.getOutlineCode5());
        MppTaskTest.assertEquals((String)"6", (String)task.getOutlineCode6());
        MppTaskTest.assertEquals((String)"7", (String)task.getOutlineCode7());
        MppTaskTest.assertEquals((String)"8", (String)task.getOutlineCode8());
        MppTaskTest.assertEquals((String)"9", (String)task.getOutlineCode9());
        MppTaskTest.assertEquals((String)"10", (String)task.getOutlineCode10());
        MppTaskTest.assertEquals((Object)Priority.getInstance(600), (Object)task.getPriority());
        expectedDuration = Duration.getInstance(22, TimeUnit.HOURS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getRemainingWork());
        expectedDuration = Duration.getInstance(0.55, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getRemainingDuration());
        MppTaskTest.assertEquals((String)"25/08/2006", (String)df.format(task.getResume()));
        MppTaskTest.assertTrue((boolean)task.getRollup());
        expectedDuration = Duration.getInstance(0, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getStartSlack());
        expectedDuration = Duration.getInstance(0, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getStartVariance());
        MppTaskTest.assertEquals((String)"25/08/2006", (String)df.format(task.getStop()));
        expectedDuration = Duration.getInstance(0, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getTotalSlack());
        MppTaskTest.assertEquals((String)"1", (String)task.getText1());
        MppTaskTest.assertEquals((String)"2", (String)task.getText2());
        MppTaskTest.assertEquals((String)"3", (String)task.getText3());
        MppTaskTest.assertEquals((String)"4", (String)task.getText4());
        MppTaskTest.assertEquals((String)"5", (String)task.getText5());
        MppTaskTest.assertEquals((String)"6", (String)task.getText6());
        MppTaskTest.assertEquals((String)"7", (String)task.getText7());
        MppTaskTest.assertEquals((String)"8", (String)task.getText8());
        MppTaskTest.assertEquals((String)"9", (String)task.getText9());
        MppTaskTest.assertEquals((String)"10", (String)task.getText10());
        MppTaskTest.assertEquals((String)"11", (String)task.getText11());
        MppTaskTest.assertEquals((String)"12", (String)task.getText12());
        MppTaskTest.assertEquals((String)"13", (String)task.getText13());
        MppTaskTest.assertEquals((String)"14", (String)task.getText14());
        MppTaskTest.assertEquals((String)"15", (String)task.getText15());
        MppTaskTest.assertEquals((String)"16", (String)task.getText16());
        MppTaskTest.assertEquals((String)"17", (String)task.getText17());
        MppTaskTest.assertEquals((String)"18", (String)task.getText18());
        MppTaskTest.assertEquals((String)"19", (String)task.getText19());
        MppTaskTest.assertEquals((String)"20", (String)task.getText20());
        MppTaskTest.assertEquals((String)"21", (String)task.getText21());
        MppTaskTest.assertEquals((String)"22", (String)task.getText22());
        MppTaskTest.assertEquals((String)"23", (String)task.getText23());
        MppTaskTest.assertEquals((String)"24", (String)task.getText24());
        MppTaskTest.assertEquals((String)"25", (String)task.getText25());
        MppTaskTest.assertEquals((String)"26", (String)task.getText26());
        MppTaskTest.assertEquals((String)"27", (String)task.getText27());
        MppTaskTest.assertEquals((String)"28", (String)task.getText28());
        MppTaskTest.assertEquals((String)"29", (String)task.getText29());
        MppTaskTest.assertEquals((String)"30", (String)task.getText30());
        MppTaskTest.assertEquals((Object)new Integer(1), (Object)task.getUniqueID());
        MppTaskTest.assertEquals((String)"1", (String)task.getWBS());
        expectedDuration = Duration.getInstance(40, TimeUnit.HOURS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getWorkVariance());
    }

    private void testBaselineTasks(ProjectFile mpp) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        List listAllTasks = mpp.getAllTasks();
        List listAllResources = mpp.getAllResources();
        MppTaskTest.assertTrue((listAllTasks != null ? 1 : 0) != 0);
        MppTaskTest.assertTrue((listAllResources != null ? 1 : 0) != 0);
        MppTaskTest.assertTrue((listAllTasks.size() > 0 ? 1 : 0) != 0);
        MppTaskTest.assertTrue((listAllResources.size() > 0 ? 1 : 0) != 0);
        Task baseTask = (Task)listAllTasks.get(1);
        MppTaskTest.assertEquals((String)"Base Task", (String)baseTask.getName());
        Task subtask1 = (Task)listAllTasks.get(2);
        MppTaskTest.assertEquals((String)"Subtask 1", (String)subtask1.getName());
        Task subtask2 = (Task)listAllTasks.get(3);
        MppTaskTest.assertEquals((String)"Subtask 2", (String)subtask2.getName());
        Task subtask3 = (Task)listAllTasks.get(4);
        MppTaskTest.assertEquals((String)"Subtask 3", (String)subtask3.getName());
        Task subtask4 = (Task)listAllTasks.get(5);
        MppTaskTest.assertEquals((String)"Subtask 4", (String)subtask4.getName());
        Task subtask5 = (Task)listAllTasks.get(6);
        MppTaskTest.assertEquals((String)"Subtask 5", (String)subtask5.getName());
        Task completeTask = (Task)listAllTasks.get(7);
        MppTaskTest.assertEquals((String)"Complete", (String)completeTask.getName());
        Task complexOutlineNumberTask = (Task)listAllTasks.get(8);
        MppTaskTest.assertEquals((String)"Complex Outline Number", (String)complexOutlineNumberTask.getName());
        Task subtaskA = (Task)listAllTasks.get(9);
        MppTaskTest.assertEquals((String)"Subtask A", (String)subtaskA.getName());
        Task subtaskA1 = (Task)listAllTasks.get(10);
        MppTaskTest.assertEquals((String)"Subtask A1", (String)subtaskA1.getName());
        Task subtaskA2 = (Task)listAllTasks.get(11);
        MppTaskTest.assertEquals((String)"Subtask A2", (String)subtaskA2.getName());
        Task subtaskB = (Task)listAllTasks.get(12);
        MppTaskTest.assertEquals((String)"Subtask B", (String)subtaskB.getName());
        Task subtaskB1 = (Task)listAllTasks.get(13);
        MppTaskTest.assertEquals((String)"Subtask B1", (String)subtaskB1.getName());
        Task subtaskB1a = (Task)listAllTasks.get(14);
        MppTaskTest.assertEquals((String)"Subtask B1a", (String)subtaskB1a.getName());
        MppTaskTest.assertEquals((String)"24/08/2006", (String)df.format(baseTask.getBaselineStart()));
        MppTaskTest.assertEquals((String)"13/09/2006", (String)df.format(baseTask.getBaselineFinish()));
        MppTaskTest.assertEquals((String)"24/08/2006", (String)df.format(baseTask.getActualStart()));
        MppTaskTest.assertEquals(null, (Object)baseTask.getActualFinish());
        MppTaskTest.assertEquals((Object)new Double(57.0), (Object)baseTask.getPercentageComplete());
        MppTaskTest.assertEquals((Object)TaskType.FIXED_DURATION, (Object)baseTask.getType());
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(subtask2.getStart()));
        MppTaskTest.assertEquals((String)"05/09/2006", (String)df.format(subtask2.getFinish()));
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(subtask2.getActualStart()));
        MppTaskTest.assertEquals((String)"05/09/2006", (String)df.format(subtask2.getActualFinish()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(subtask2.getBaselineStart()));
        MppTaskTest.assertEquals((String)"01/09/2006", (String)df.format(subtask2.getBaselineFinish()));
        List predecessors = subtask2.getPredecessors();
        MppTaskTest.assertEquals((int)1, (int)predecessors.size());
        Relation relation = (Relation)predecessors.get(0);
        MppTaskTest.assertEquals((Object)subtask1.getID(), (Object)relation.getTaskID());
        MppTaskTest.assertEquals((Object)subtask1.getUniqueID(), (Object)relation.getTaskUniqueID());
        Task predTask = relation.getTask();
        MppTaskTest.assertEquals((Object)predTask.getID(), (Object)subtask1.getID());
        MppTaskTest.assertEquals((Object)predTask.getUniqueID(), (Object)subtask1.getUniqueID());
        MppTaskTest.assertEquals((Object)TaskType.FIXED_UNITS, (Object)subtask2.getType());
        predecessors = subtask5.getPredecessors();
        MppTaskTest.assertEquals((int)2, (int)predecessors.size());
        relation = (Relation)predecessors.get(0);
        Relation relation2 = (Relation)predecessors.get(1);
        MppTaskTest.assertEquals((Object)subtask3.getID(), (Object)relation.getTaskID());
        MppTaskTest.assertEquals((Object)subtask4.getID(), (Object)relation2.getTaskID());
        MppTaskTest.assertEquals((Object)TaskType.FIXED_WORK, (Object)subtask5.getType());
        MppTaskTest.assertTrue((boolean)subtaskA.getSummary());
        MppTaskTest.assertTrue((boolean)subtaskA1.getEstimated());
        String outlineNumber = "2.1.1";
        MppTaskTest.assertEquals((String)outlineNumber, (String)subtaskA1.getOutlineNumber());
        MppTaskTest.assertEquals((String)outlineNumber, (String)subtaskA1.getWBS());
        outlineNumber = "2.2.1.1";
        MppTaskTest.assertEquals((String)outlineNumber, (String)subtaskB1a.getOutlineNumber());
        MppTaskTest.assertEquals((String)outlineNumber, (String)subtaskB1a.getWBS());
    }

    private void testSplitTasks(ProjectFile mpp) {
        Task task1 = mpp.getTaskByID(new Integer(1));
        Task task2 = mpp.getTaskByID(new Integer(2));
        List listSplits1 = task1.getSplits();
        List listSplits2 = task2.getSplits();
        MppTaskTest.assertEquals((int)3, (int)listSplits1.size());
        MppTaskTest.assertEquals((int)5, (int)listSplits2.size());
        Duration duration = (Duration)listSplits1.get(0);
        MppTaskTest.assertEquals((int)32, (int)((int)duration.getDuration()));
        MppTaskTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
        duration = (Duration)listSplits1.get(1);
        MppTaskTest.assertEquals((int)56, (int)((int)duration.getDuration()));
        MppTaskTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
        duration = (Duration)listSplits1.get(2);
        MppTaskTest.assertEquals((int)104, (int)((int)duration.getDuration()));
        MppTaskTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
        duration = (Duration)listSplits2.get(0);
        MppTaskTest.assertEquals((int)24, (int)((int)duration.getDuration()));
        MppTaskTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
        duration = (Duration)listSplits2.get(1);
        MppTaskTest.assertEquals((int)40, (int)((int)duration.getDuration()));
        MppTaskTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
        duration = (Duration)listSplits2.get(2);
        MppTaskTest.assertEquals((int)80, (int)((int)duration.getDuration()));
        MppTaskTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
        duration = (Duration)listSplits2.get(3);
        MppTaskTest.assertEquals((int)104, (int)((int)duration.getDuration()));
        MppTaskTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
        duration = (Duration)listSplits2.get(4);
        MppTaskTest.assertEquals((int)160, (int)((int)duration.getDuration()));
        MppTaskTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
    }

    private void testRelations(ProjectFile mpp) {
        List listAllTasks = mpp.getAllTasks();
        MppTaskTest.assertTrue((listAllTasks != null ? 1 : 0) != 0);
        Task task1 = mpp.getTaskByID(new Integer(1));
        Task task2 = mpp.getTaskByID(new Integer(2));
        Task task3 = mpp.getTaskByID(new Integer(3));
        Task task4 = mpp.getTaskByID(new Integer(4));
        Task task5 = mpp.getTaskByID(new Integer(5));
        List listPreds = task2.getPredecessors();
        Relation relation = (Relation)listPreds.get(0);
        MppTaskTest.assertEquals((int)1, (int)relation.getTaskID());
        MppTaskTest.assertEquals((int)1, (int)relation.getTaskUniqueID());
        MppTaskTest.assertEquals((Object)RelationType.FINISH_START, (Object)relation.getType());
        MppTaskTest.assertEquals((Object)task1, (Object)relation.getTask());
        listPreds = task3.getPredecessors();
        relation = (Relation)listPreds.get(0);
        MppTaskTest.assertEquals((int)2, (int)relation.getTaskID());
        MppTaskTest.assertEquals((int)2, (int)relation.getTaskUniqueID());
        MppTaskTest.assertEquals((Object)RelationType.START_START, (Object)relation.getType());
        Duration duration = relation.getDuration();
        MppTaskTest.assertEquals((int)1, (int)((int)duration.getDuration()));
        MppTaskTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        listPreds = task4.getPredecessors();
        relation = (Relation)listPreds.get(0);
        MppTaskTest.assertEquals((int)3, (int)relation.getTaskID());
        MppTaskTest.assertEquals((int)3, (int)relation.getTaskUniqueID());
        MppTaskTest.assertEquals((Object)RelationType.FINISH_FINISH, (Object)relation.getType());
        listPreds = task5.getPredecessors();
        relation = (Relation)listPreds.get(0);
        MppTaskTest.assertEquals((int)4, (int)relation.getTaskID());
        MppTaskTest.assertEquals((int)4, (int)relation.getTaskUniqueID());
        MppTaskTest.assertEquals((Object)RelationType.START_FINISH, (Object)relation.getType());
    }
}

