/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.poi.poifs.filesystem.DocumentOutputStream;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.DocumentBlock;
import org.apache.poi.poifs.storage.ListManagedBlock;
import org.apache.poi.poifs.storage.RawDataBlock;
import org.apache.poi.poifs.storage.SmallDocumentBlock;

public class POIFSDocument
implements BlockWritable {
    private DocumentProperty _property;
    private int _size;
    private SmallBlockStore _small_store;
    private BigBlockStore _big_store;

    public POIFSDocument(String name, ListManagedBlock[] blocks, int length) throws IOException {
        this._size = length;
        this._property = new DocumentProperty(name, this._size);
        this._property.setDocument(this);
        if (Property.isSmall(this._size)) {
            this._big_store = new BigBlockStore(new RawDataBlock[0]);
            this._small_store = new SmallBlockStore(blocks);
        } else {
            this._big_store = new BigBlockStore(blocks);
            this._small_store = new SmallBlockStore(new BlockWritable[0]);
        }
    }

    void read(byte[] buffer, int offset) {
        if (this._property.shouldUseSmallBlocks()) {
            SmallDocumentBlock.read(this._small_store.getBlocks(), buffer, offset);
        } else {
            DocumentBlock.read(this._big_store.getBlocks(), buffer, offset);
        }
    }

    DocumentProperty getDocumentProperty() {
        return this._property;
    }

    private class BigBlockStore {
        private DocumentBlock[] bigBlocks;
        private POIFSDocumentPath path;
        private String name;
        private int size;
        private POIFSWriterListener writer;

        BigBlockStore(Object[] blocks) throws IOException {
            this.bigBlocks = new DocumentBlock[blocks.length];
            for (int j = 0; j < blocks.length; ++j) {
                this.bigBlocks[j] = blocks[j] instanceof DocumentBlock ? (DocumentBlock)blocks[j] : new DocumentBlock((RawDataBlock)blocks[j]);
            }
            this.path = null;
            this.name = null;
            this.size = -1;
            this.writer = null;
        }

        boolean isValid() {
            return this.bigBlocks.length > 0 || this.writer != null;
        }

        DocumentBlock[] getBlocks() {
            if (this.isValid() && this.writer != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(this.size);
                DocumentOutputStream dstream = new DocumentOutputStream(stream, this.size);
                this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this.path, this.name, this.size));
                this.bigBlocks = DocumentBlock.convert(stream.toByteArray(), this.size);
            }
            return this.bigBlocks;
        }
    }

    private class SmallBlockStore {
        private SmallDocumentBlock[] smallBlocks;
        private POIFSDocumentPath path;
        private String name;
        private int size;
        private POIFSWriterListener writer;

        SmallBlockStore(Object[] blocks) {
            this.smallBlocks = new SmallDocumentBlock[blocks.length];
            for (int j = 0; j < blocks.length; ++j) {
                this.smallBlocks[j] = (SmallDocumentBlock)blocks[j];
            }
            this.path = null;
            this.name = null;
            this.size = -1;
            this.writer = null;
        }

        boolean isValid() {
            return this.smallBlocks.length > 0 || this.writer != null;
        }

        BlockWritable[] getBlocks() {
            if (this.isValid() && this.writer != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(this.size);
                DocumentOutputStream dstream = new DocumentOutputStream(stream, this.size);
                this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this.path, this.name, this.size));
                this.smallBlocks = SmallDocumentBlock.convert(stream.toByteArray(), this.size);
            }
            return this.smallBlocks;
        }
    }
}

