/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.codehaus.groovy.control.ParserPluginFactory;
import org.codehaus.groovy.control.io.NullWriter;

public class CompilerConfiguration {
    public static final CompilerConfiguration DEFAULT = new CompilerConfiguration();
    private static boolean jsrGroovy;
    private int warningLevel;
    private String sourceEncoding;
    private PrintWriter output;
    private File targetDirectory;
    private LinkedList classpath;
    private boolean verbose;
    private boolean debug;
    private int tolerance;
    private String scriptBaseClass;
    private boolean useNewGroovy = CompilerConfiguration.getDefaultJsrFlag();
    private ParserPluginFactory pluginFactory;
    private String defaultScriptExtension = ".groovy";
    private boolean recompileGroovySource;
    private int minimumRecompilationInterval;

    public CompilerConfiguration() {
        this.setWarningLevel(1);
        this.setSourceEncoding("US-ASCII");
        this.setOutput(null);
        this.setTargetDirectory((File)null);
        this.setClasspath("");
        this.setVerbose(false);
        this.setDebug(false);
        this.setTolerance(10);
        this.setScriptBaseClass(null);
        this.setRecompileGroovySource(false);
        this.setMinimumRecompilationInterval(100);
        try {
            this.setSourceEncoding(System.getProperty("file.encoding", "US-ASCII"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setOutput(new PrintWriter(System.err));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String target = System.getProperty("groovy.target.directory");
            if (target != null) {
                this.setTargetDirectory(target);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWarningLevel(int level) {
        this.warningLevel = level < 0 || level > 3 ? 1 : level;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String encoding) {
        this.sourceEncoding = encoding;
    }

    public void setOutput(PrintWriter output) {
        this.output = this.output == null ? new PrintWriter(NullWriter.DEFAULT) : output;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String directory) {
        this.targetDirectory = directory != null && directory.length() > 0 ? new File(directory) : null;
    }

    public void setTargetDirectory(File directory) {
        this.targetDirectory = directory;
    }

    public List getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = new LinkedList();
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            this.classpath.add(tokenizer.nextToken());
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    public String getScriptBaseClass() {
        return this.scriptBaseClass;
    }

    public void setScriptBaseClass(String scriptBaseClass) {
        this.scriptBaseClass = scriptBaseClass;
    }

    public boolean isUseNewGroovy() {
        return this.useNewGroovy;
    }

    public ParserPluginFactory getPluginFactory() {
        if (this.pluginFactory == null) {
            this.pluginFactory = ParserPluginFactory.newInstance(this.isUseNewGroovy());
        }
        return this.pluginFactory;
    }

    public static void setJsrGroovy(boolean value) {
        jsrGroovy = value;
    }

    protected static boolean getDefaultJsrFlag() {
        String property = null;
        try {
            property = System.getProperty("groovy.jsr");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (property != null) {
            return "true".equalsIgnoreCase(property);
        }
        return true;
    }

    public String getDefaultScriptExtension() {
        return this.defaultScriptExtension;
    }

    public void setRecompileGroovySource(boolean recompile) {
        this.recompileGroovySource = recompile;
    }

    public boolean getRecompileGroovySource() {
        return this.recompileGroovySource;
    }

    public void setMinimumRecompilationInterval(int time) {
        this.minimumRecompilationInterval = Math.max(0, time);
    }

    public int getMinimumRecompilationInterval() {
        return this.minimumRecompilationInterval;
    }
}

