/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.pool.BaseKeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public class StackKeyedObjectPool
extends BaseKeyedObjectPool
implements KeyedObjectPool {
    protected HashMap a = null;
    protected KeyedPoolableObjectFactory b = null;
    protected int c = 8;
    protected int d = 4;
    protected int e = 0;
    protected int f = 0;
    protected HashMap g = null;

    public StackKeyedObjectPool() {
        this(null, 8, 4);
    }

    public StackKeyedObjectPool(int n2) {
        this(null, n2, 4);
    }

    public StackKeyedObjectPool(int n2, int n3) {
        this(null, n2, n3);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory) {
        this(keyedPoolableObjectFactory, 8);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n2) {
        this(keyedPoolableObjectFactory, n2, 4);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n2, int n3) {
        this.b = keyedPoolableObjectFactory;
        this.c = n2 < 0 ? 8 : n2;
        this.d = n3 < 1 ? 4 : n3;
        this.a = new HashMap();
        this.g = new HashMap();
    }

    public synchronized Object borrowObject(Object object) throws Exception {
        Object object2 = null;
        Stack stack = (Stack)this.a.get(object);
        if (null == stack) {
            stack = new Stack();
            stack.ensureCapacity(this.d > this.c ? this.c : this.d);
            this.a.put(object, stack);
        }
        try {
            object2 = stack.pop();
            --this.f;
        }
        catch (Exception exception) {
            if (null == this.b) {
                throw new NoSuchElementException();
            }
            object2 = this.b.makeObject(object);
        }
        if (null != object2 && null != this.b) {
            this.b.activateObject(object, object2);
        }
        this.b(object);
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void returnObject(Object object, Object object2) throws Exception {
        this.c(object);
        if (null != this.b && !this.b.validateObject(object, object2)) {
            if (null == this.b) return;
            this.b.destroyObject(object, object2);
            return;
        }
        Stack<Object> stack = (Stack<Object>)this.a.get(object);
        if (null == stack) {
            stack = new Stack<Object>();
            stack.ensureCapacity(this.d > this.c ? this.c : this.d);
            this.a.put(object, stack);
        }
        if (null != this.b) {
            try {
                this.b.passivateObject(object, object2);
            }
            catch (Exception exception) {
                this.b.destroyObject(object, object2);
                return;
            }
        }
        if (stack.size() < this.c) {
            stack.push(object2);
            ++this.f;
            return;
        }
        if (null == this.b) return;
        this.b.destroyObject(object, object2);
    }

    public synchronized void invalidateObject(Object object, Object object2) throws Exception {
        this.c(object);
        if (null != this.b) {
            this.b.destroyObject(object, object2);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject(Object object) throws Exception {
        Object object2 = this.b.makeObject(object);
        StackKeyedObjectPool stackKeyedObjectPool = this;
        synchronized (stackKeyedObjectPool) {
            this.b(object);
            this.returnObject(object, object2);
            return;
        }
    }

    public int getNumIdle() {
        return this.f;
    }

    public int getNumActive() {
        return this.e;
    }

    public int getNumActive(Object object) {
        return this.a(object);
    }

    public synchronized int getNumIdle(Object object) {
        try {
            return ((Stack)this.a.get(object)).size();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public synchronized void clear() {
        Iterator iterator = this.a.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            Stack stack = (Stack)this.a.get(k2);
            this.a(k2, stack);
        }
        this.f = 0;
        this.a.clear();
        this.g.clear();
    }

    public synchronized void clear(Object object) {
        Stack stack = (Stack)this.a.remove(object);
        this.a(object, stack);
    }

    private synchronized void a(Object object, Stack stack) {
        if (null == stack) {
            return;
        }
        if (null != this.b) {
            Enumeration enumeration = stack.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    this.b.destroyObject(object, enumeration.nextElement());
                }
                catch (Exception exception) {}
            }
        }
        this.f -= stack.size();
        this.g.remove(object);
        stack.clear();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" contains ").append(this.a.size()).append(" distinct pools: ");
        Iterator iterator = this.a.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            stringBuffer.append(" |").append(k2).append("|=");
            Stack stack = (Stack)this.a.get(k2);
            stringBuffer.append(stack.size());
        }
        return stringBuffer.toString();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this.a = null;
        this.b = null;
        this.g = null;
    }

    public synchronized void setFactory(KeyedPoolableObjectFactory keyedPoolableObjectFactory) throws IllegalStateException {
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this.b = keyedPoolableObjectFactory;
    }

    private int a(Object object) {
        try {
            return (Integer)this.g.get(object);
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    private void b(Object object) {
        ++this.e;
        Integer n2 = (Integer)this.g.get(object);
        if (null == n2) {
            this.g.put(object, new Integer(1));
            return;
        }
        this.g.put(object, new Integer(n2 + 1));
    }

    private void c(Object object) {
        --this.e;
        Integer n2 = (Integer)this.g.get(object);
        if (null == n2) {
            return;
        }
        if (n2 <= 1) {
            this.g.remove(object);
            return;
        }
        this.g.put(object, new Integer(n2 - 1));
    }
}

