/*
 * Decompiled with CFR 0.152.
 */
package com.projity.datatype;

import com.projity.datatype.Duration;
import com.projity.datatype.Work;
import com.projity.options.EditOption;
import com.projity.options.ScheduleOption;
import com.projity.strings.Messages;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationFormat
extends Format {
    private boolean showPlusSign = false;
    private boolean isWork = false;
    private boolean canBeNonTemporal = false;
    private static Format instance = null;
    private static Format signedInstance = null;
    private static Format workInstance = null;
    private static Format nonTemporalWorkInstance = null;
    private static String[] types = new String[]{"minute", "hour", "day", "week", "month", "year", "percent", "eminute", "ehour", "eday", "eweek", "emonth", "eyear", "epercent"};
    private static final int SINGULAR = 0;
    private static final int PLURAL = 1;
    private static final String[] multiple = new String[]{".singular", ".plural"};
    private static int TYPE_COUNT = types.length;
    private static int NAME_COUNT = 4;
    private static String[][][] typesArray = new String[NAME_COUNT][multiple.length][TYPE_COUNT];
    private static Pattern[] pattern = new Pattern[TYPE_COUNT];
    private static String estimatedSymbol = Messages.getString("Units.estimatedSymbol");
    private static NumberFormat DECIMAL_FORMAT = NumberFormat.getNumberInstance();

    public static Format getInstance() {
        if (instance == null) {
            instance = new DurationFormat(false);
        }
        return instance;
    }

    public static Format getSignedInstance() {
        if (signedInstance == null) {
            signedInstance = new DurationFormat(true);
        }
        return signedInstance;
    }

    public static Format getWorkInstance() {
        if (workInstance == null) {
            workInstance = new DurationFormat(false);
            ((DurationFormat)DurationFormat.workInstance).isWork = true;
        }
        return workInstance;
    }

    public static Format getNonTemporalWorkInstance() {
        if (nonTemporalWorkInstance == null) {
            nonTemporalWorkInstance = new DurationFormat(false);
            ((DurationFormat)DurationFormat.nonTemporalWorkInstance).isWork = true;
            ((DurationFormat)DurationFormat.nonTemporalWorkInstance).canBeNonTemporal = true;
        }
        return nonTemporalWorkInstance;
    }

    private DurationFormat(boolean bl) {
        this.showPlusSign = bl;
        String string = Messages.getString("Units.estimatedSymbolRegex");
        for (int i = 0; i < TYPE_COUNT; ++i) {
            String string2 = null;
            String string3 = null;
            for (int j = 0; j < multiple.length; ++j) {
                String string4 = new String(Messages.getString("Units." + types[i] + multiple[j]));
                if (j == 0) {
                    string2 = string4;
                }
                if (j == 1) {
                    string3 = string4;
                }
                String[] stringArray = string4.split("\\|");
                for (int k = 0; k < NAME_COUNT; ++k) {
                    DurationFormat.typesArray[k][j][i] = stringArray[k];
                }
            }
            DurationFormat.pattern[i] = Pattern.compile("((?:" + string2 + ")" + "|(?:" + string3 + "))?" + "(\\s*" + string + "?)");
        }
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        Number number;
        Duration duration = null;
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(parsePosition.getIndex()) == '+') {
            parsePosition.setIndex(parsePosition.getIndex() + 1);
        }
        if ((number = DECIMAL_FORMAT.parse(string, parsePosition)) == null) {
            return null;
        }
        String string2 = string.substring(parsePosition.getIndex());
        string2 = string2.trim();
        for (int i = 0; i < TYPE_COUNT; ++i) {
            long l2;
            Matcher matcher = pattern[i].matcher(string2);
            if (!matcher.matches()) continue;
            int n2 = matcher.group(1) != null ? i : -1;
            double d2 = number.doubleValue();
            if (n2 == 6 || n2 == 13) {
                d2 /= 100.0;
            }
            if (n2 == -1 && this.isWork) {
                n2 = this.canBeNonTemporal ? -2 : ScheduleOption.getInstance().getWorkUnit();
            }
            if (Duration.millis(l2 = Duration.getInstance(d2, n2)) > 105120000000L) {
                return null;
            }
            if (matcher.group(2).length() != 0) {
                l2 = Duration.setAsEstimated(l2, true);
            }
            duration = new Duration(l2);
            return duration;
        }
        return null;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        long l2 = ((Duration)object).getEncodedMillis();
        if (((Duration)object).isWork() && Duration.getType(l2) != -2) {
            l2 = Duration.setAsTimeUnit(l2, ScheduleOption.getInstance().getWorkUnit());
        }
        double d2 = Duration.getValue(l2);
        int n2 = Duration.getEffectiveType(l2);
        if (d2 > 0.0 && this.showPlusSign) {
            stringBuffer.append("+");
        }
        if (bl = Duration.isPercent(l2)) {
            d2 *= 100.0;
        }
        DECIMAL_FORMAT.format(d2, stringBuffer, fieldPosition);
        String string = DurationFormat.formatTypeUnit(n2, Math.abs(d2) == 1.0, EditOption.getInstance().isAddSpaceBeforeLabel(), Duration.isPercent(l2), Duration.isEstimated(l2), EditOption.getInstance().getViewAs(n2));
        stringBuffer.append(string);
        return stringBuffer;
    }

    public String formatCompact(Object object) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = ((Duration)object).getEncodedMillis();
        if (((Duration)object).isWork() && Duration.getType(l2) != -2) {
            l2 = Duration.setAsTimeUnit(l2, ScheduleOption.getInstance().getWorkUnit());
        }
        double d2 = Duration.getValue(l2);
        int n2 = Duration.getEffectiveType(l2);
        if (d2 > 0.0 && this.showPlusSign) {
            stringBuffer.append("+");
        }
        if (bl = Duration.isPercent(l2)) {
            d2 *= 100.0;
        }
        stringBuffer.append(DECIMAL_FORMAT.format(d2));
        String string = DurationFormat.formatTypeUnit(n2, Math.abs(d2) == 1.0, false, Duration.isPercent(l2), Duration.isEstimated(l2), 3);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String formatTypeUnit(int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == -2) {
            return "";
        }
        if (bl2 && !bl3) {
            stringBuffer.append(" ");
        }
        String string = typesArray[n3][bl ? 0 : 1][n2];
        stringBuffer.append(string);
        if (bl4) {
            stringBuffer.append(estimatedSymbol);
        }
        return stringBuffer.toString();
    }

    public static String formatTypeUnit(int n2) {
        DurationFormat.getInstance();
        return DurationFormat.formatTypeUnit(n2, true, false, false, false, EditOption.getInstance().getViewAs(n2));
    }

    public static String format(long l2) {
        return DurationFormat.getInstance().format(new Duration(l2)).toString();
    }

    public static String formatCompact(long l2) {
        return ((DurationFormat)DurationFormat.getInstance()).formatCompact(new Duration(l2)).toString();
    }

    public static String formatWork(long l2) {
        return DurationFormat.getWorkInstance().format(new Work(l2)).toString();
    }

    public static String formatWork(Object object) {
        if (object != null && object instanceof Long) {
            return DurationFormat.formatWork((Long)object);
        }
        return DurationFormat.getWorkInstance().format(object);
    }
}

