/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.summaries;

import com.projity.datatype.DurationFormat;
import com.projity.grouping.core.summaries.Average;
import com.projity.grouping.core.summaries.ConcatTextSummaryVisitor;
import com.projity.grouping.core.summaries.Count;
import com.projity.grouping.core.summaries.DeepChildWalker;
import com.projity.grouping.core.summaries.LeafWalker;
import com.projity.grouping.core.summaries.Maximum;
import com.projity.grouping.core.summaries.Minimum;
import com.projity.grouping.core.summaries.Same;
import com.projity.grouping.core.summaries.ShallowChildWalker;
import com.projity.grouping.core.summaries.Sum;
import com.projity.grouping.core.summaries.SummaryNames;
import com.projity.grouping.core.summaries.SummaryVisitor;
import com.projity.strings.Messages;
import java.util.Date;
import java.util.Hashtable;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;

public class SummaryVisitorFactory
implements SummaryNames {
    private static BidiMap COST_SUMMARY_MAP = new DualHashBidiMap();
    private static BidiMap DATE_SUMMARY_MAP;
    private static BidiMap DURATION_SUMMARY_MAP;
    private static BidiMap FLAG_SUMMARY_MAP;
    private static BidiMap NUMBER_SUMMARY_MAP;
    private static BidiMap TEXT_SUMMARY_MAP;
    private static Hashtable ALL_SUMMARY_MAP;

    public static SummaryVisitor getInstance(int n2, Class clazz, boolean bl) {
        if (n2 == 8) {
            return new ShallowChildWalker(new Same());
        }
        if (clazz == Boolean.class) {
            switch (n2) {
                case 0: {
                    return new LeafWalker(new Maximum());
                }
                case 1: {
                    return new LeafWalker(new Minimum());
                }
            }
        } else {
            switch (n2) {
                case 0: {
                    return new LeafWalker(new Maximum());
                }
                case 1: {
                    return new LeafWalker(new Minimum());
                }
                case 2: {
                    return new DeepChildWalker(new Count(), true);
                }
                case 3: {
                    if (bl) {
                        return new DeepChildWalker(new Sum(), true);
                    }
                    return new LeafWalker(new Sum());
                }
                case 4: {
                    return new LeafWalker(new Average());
                }
                case 5: {
                    return new ShallowChildWalker(new Average());
                }
                case 6: {
                    return new ShallowChildWalker(new Count());
                }
                case -2: {
                    return new LeafWalker(new ConcatTextSummaryVisitor());
                }
            }
        }
        return null;
    }

    public static int getSummaryId(String string) {
        Integer n2 = (Integer)ALL_SUMMARY_MAP.get(string);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public static BidiMap getMap(Class clazz, boolean bl) {
        if (clazz == Double.class) {
            return bl ? COST_SUMMARY_MAP : NUMBER_SUMMARY_MAP;
        }
        if (clazz == Date.class) {
            return DATE_SUMMARY_MAP;
        }
        if (clazz == DurationFormat.class) {
            return DURATION_SUMMARY_MAP;
        }
        if (clazz == String.class) {
            return TEXT_SUMMARY_MAP;
        }
        if (clazz == Boolean.class) {
            return FLAG_SUMMARY_MAP;
        }
        return null;
    }

    static {
        COST_SUMMARY_MAP.put(Messages.getString("Summary.None"), new Integer(-1));
        COST_SUMMARY_MAP.put(Messages.getString("Summary.Average"), new Integer(4));
        COST_SUMMARY_MAP.put(Messages.getString("Summary.AverageFirstSublevel"), new Integer(5));
        COST_SUMMARY_MAP.put(Messages.getString("Summary.Maximum"), new Integer(0));
        COST_SUMMARY_MAP.put(Messages.getString("Summary.Minimum"), new Integer(1));
        COST_SUMMARY_MAP.put(Messages.getString("Summary.Sum"), new Integer(3));
        DATE_SUMMARY_MAP = new DualHashBidiMap();
        DATE_SUMMARY_MAP.put(Messages.getString("Summary.None"), new Integer(-1));
        DATE_SUMMARY_MAP.put(Messages.getString("Summary.Maximum"), new Integer(0));
        DATE_SUMMARY_MAP.put(Messages.getString("Summary.Minimum"), new Integer(1));
        DURATION_SUMMARY_MAP = COST_SUMMARY_MAP;
        FLAG_SUMMARY_MAP = new DualHashBidiMap();
        FLAG_SUMMARY_MAP.put(Messages.getString("Summary.None"), new Integer(-1));
        FLAG_SUMMARY_MAP.put(Messages.getString("Summary.OR"), new Integer(0));
        FLAG_SUMMARY_MAP.put(Messages.getString("Summary.AND"), new Integer(1));
        NUMBER_SUMMARY_MAP = new DualHashBidiMap();
        NUMBER_SUMMARY_MAP.put(Messages.getString("Summary.None"), new Integer(-1));
        NUMBER_SUMMARY_MAP.put(Messages.getString("Summary.Average"), new Integer(4));
        NUMBER_SUMMARY_MAP.put(Messages.getString("Summary.AverageFirstSublevel"), new Integer(5));
        NUMBER_SUMMARY_MAP.put(Messages.getString("Summary.CountAll"), new Integer(2));
        NUMBER_SUMMARY_MAP.put(Messages.getString("Summary.CountFirstSublevel"), new Integer(6));
        NUMBER_SUMMARY_MAP.put(Messages.getString("Summary.CountNonsummaries"), new Integer(7));
        NUMBER_SUMMARY_MAP.put(Messages.getString("Summary.Maximum"), new Integer(0));
        NUMBER_SUMMARY_MAP.put(Messages.getString("Summary.Minimum"), new Integer(1));
        NUMBER_SUMMARY_MAP.put(Messages.getString("Summary.Sum"), new Integer(3));
        TEXT_SUMMARY_MAP = new DualHashBidiMap();
        TEXT_SUMMARY_MAP.put(Messages.getString("Summary.None"), new Integer(-1));
        TEXT_SUMMARY_MAP.put(Messages.getString("Summary.List"), new Integer(-2));
        ALL_SUMMARY_MAP = new Hashtable();
        ALL_SUMMARY_MAP.put("None", new Integer(-1));
        ALL_SUMMARY_MAP.put("This", new Integer(-4));
        ALL_SUMMARY_MAP.put("List", new Integer(-2));
        ALL_SUMMARY_MAP.put("Average", new Integer(4));
        ALL_SUMMARY_MAP.put("AverageFirstSublevel", new Integer(5));
        ALL_SUMMARY_MAP.put("CountAll", new Integer(2));
        ALL_SUMMARY_MAP.put("CountFirstSublevel", new Integer(6));
        ALL_SUMMARY_MAP.put("CountNonsummaries", new Integer(7));
        ALL_SUMMARY_MAP.put("Maximum", new Integer(0));
        ALL_SUMMARY_MAP.put("Minimum", new Integer(1));
        ALL_SUMMARY_MAP.put("Sum", new Integer(3));
        ALL_SUMMARY_MAP.put("OR", new Integer(0));
        ALL_SUMMARY_MAP.put("AND", new Integer(1));
        ALL_SUMMARY_MAP.put("Same", new Integer(8));
    }
}

