/*
 * Decompiled with CFR 0.152.
 */
package com.projity.print;

import com.projity.pm.task.Project;
import com.projity.print.ExtendedPageFormat;
import com.projity.print.FitToSettings;
import com.projity.print.GanttSettings;
import com.projity.print.PDFPrintService;
import com.projity.print.PrintPreviewFrame;
import com.projity.print.PrintSettings;
import com.projity.print.PrintSettingsManager;
import com.projity.print.ScaleToSettings;
import com.projity.print.ScalingSettings;
import com.projity.print.ViewSettings;
import java.awt.geom.AffineTransform;
import java.awt.print.Pageable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;

public abstract class PrintDocument
implements Pageable {
    public static final double DEFAULT_ZOOM = 0.77;
    protected ExtendedPageFormat pageFormat;
    protected PrintService[] printServices;
    protected PrintService[] realPrintServices;
    protected PrintService printService;
    protected PDFPrintService pdfPrintService;
    protected PrintPreviewFrame printPreview;
    protected PrintSettings printSettings;
    boolean scaleToSelected = true;
    ScaleToSettings scaleToSettings = null;
    FitToSettings fitToSettings = null;
    boolean showSpreadsheet = true;
    boolean showGantt = true;
    protected double svgZoomX;
    protected double svgZoomY;
    protected double zoomX = 1.0;
    protected double zoomY = 1.0;

    public PrintDocument(Project project, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<ScalingSettings> arrayList;
        int n2;
        Object object;
        this.printSettings = PrintSettingsManager.getSettings(bl3 ? null : project);
        this.pdfPrintService = new PDFPrintService();
        if (bl) {
            this.realPrintServices = new PrintService[0];
            this.printServices = new PrintService[]{this.pdfPrintService};
            this.setPrintService(this.pdfPrintService, true);
        } else {
            this.realPrintServices = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            object = PrintServiceLookup.lookupDefaultPrintService();
            if (this.realPrintServices.length == 0 && object != null) {
                this.realPrintServices = new PrintService[]{object};
            }
            this.printServices = new PrintService[this.realPrintServices.length + 1];
            this.printServices[0] = this.pdfPrintService;
            for (int i2 = 0; i2 < this.realPrintServices.length; ++i2) {
                this.printServices[i2 + 1] = this.realPrintServices[i2];
            }
            if (bl2) {
                object = this.pdfPrintService;
            }
            if (this.printSettings.isPdfService()) {
                object = this.pdfPrintService;
            } else if (this.printSettings.getPrintServiceName() != null) {
                PrintService printService = null;
                for (n2 = 0; n2 < this.printServices.length; ++n2) {
                    if (!this.printSettings.getPrintServiceName().equals(this.printServices[n2].getName())) continue;
                    printService = this.printServices[n2];
                    break;
                }
                if (printService != null) {
                    object = printService;
                }
            }
            this.setPrintService((PrintService)(object == null ? this.pdfPrintService : object), true);
        }
        object = this.printSettings.getViewSettings();
        if (object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ViewSettings viewSettings = (ViewSettings)iterator.next();
                if (!(viewSettings instanceof GanttSettings)) continue;
                GanttSettings ganttSettings = (GanttSettings)viewSettings;
                this.showGantt = ganttSettings.isGanttVisible();
                this.showSpreadsheet = ganttSettings.isSpreadSheetVisible();
            }
        }
        if ((arrayList = this.printSettings.getScalingSettings()) != null) {
            n2 = 0;
            for (ScalingSettings scalingSettings : arrayList) {
                if (scalingSettings instanceof ScaleToSettings) {
                    this.scaleToSettings = (ScaleToSettings)scalingSettings;
                    if (this.printSettings.scalingIndex == n2) {
                        this.scaleToSelected = true;
                    }
                } else if (scalingSettings instanceof FitToSettings) {
                    this.fitToSettings = (FitToSettings)scalingSettings;
                    if (this.printSettings.scalingIndex == n2) {
                        this.scaleToSelected = false;
                    }
                }
                ++n2;
            }
        }
        if (this.scaleToSettings == null) {
            this.scaleToSettings = new ScaleToSettings();
        }
        if (this.fitToSettings == null) {
            this.fitToSettings = new FitToSettings();
        }
    }

    public PrintService[] getPrintServices() {
        return this.printServices;
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    public void setPrintService(PrintService printService, boolean bl) {
        Cloneable cloneable;
        this.printService = printService;
        if (bl && this.printSettings != null && this.pageFormat != null && (cloneable = this.printSettings.getPageFormat()) != null) {
            ((ExtendedPageFormat)cloneable).copy(this.pageFormat);
        }
        if (this.pageFormat == null) {
            try {
                if (this.printSettings.isEmpty() || this.printSettings.getPageFormat() == null) {
                    cloneable = this.getDefaultMediaSizeName();
                    MediaPrintableArea mediaPrintableArea = this.getDefaultMediaPrintableArea((MediaSizeName)cloneable);
                    this.pageFormat = new ExtendedPageFormat((MediaSizeName)cloneable, mediaPrintableArea);
                } else {
                    this.pageFormat = (ExtendedPageFormat)this.printSettings.getPageFormat().clone();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.pageFormat == null) {
            this.pageFormat = new ExtendedPageFormat();
        }
        if (this.printSettings.isEmpty()) {
            this.printSettings.setPdfService(printService instanceof PDFPrintService);
            this.printSettings.setPrintServiceName(printService.getName());
            this.printSettings.setPageFormat(this.pageFormat);
            this.printSettings.setEmpty(false);
        }
    }

    public MediaSizeName getDefaultMediaSizeName() {
        return ExtendedPageFormat.getDefaultMediaSizeName(this.printService);
    }

    public MediaPrintableArea getDefaultMediaPrintableArea(MediaSizeName mediaSizeName) {
        return ExtendedPageFormat.getDefaultMediaPrintableArea(this.printService, mediaSizeName);
    }

    public ExtendedPageFormat getPageFormat() {
        return this.pageFormat;
    }

    public abstract void print();

    public int getColumnCount() {
        return 1;
    }

    public void update() {
    }

    public double getZoomX() {
        return this.zoomX;
    }

    public void setZoomX(double d2) {
        this.zoomX = d2;
    }

    public double getZoomY() {
        return this.zoomY;
    }

    public void setZoomY(double d2) {
        this.zoomY = d2;
    }

    public double getTotalZoomX() {
        return this.zoomX * 0.77;
    }

    public void setTotalZoomX(double d2) {
        this.zoomX = d2 / 0.77;
    }

    public double getTotalZoomY() {
        return this.zoomY * 0.77;
    }

    public void setTotalZoomY(double d2) {
        this.zoomY = d2 / 0.77;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.zoomX * 0.77, 0.0, 0.0, this.zoomY * 0.77, this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
    }

    public PrintSettings getPrintSettings() {
        return this.printSettings;
    }

    public FitToSettings getFitToSettings() {
        return this.fitToSettings;
    }

    public void setFitToSettings(FitToSettings fitToSettings) {
        this.fitToSettings = fitToSettings;
    }

    public boolean isScaleToSelected() {
        return this.scaleToSelected;
    }

    public void setScaleToSelected(boolean bl) {
        this.scaleToSelected = bl;
    }

    public ScaleToSettings getScaleToSettings() {
        return this.scaleToSettings;
    }

    public void setScaleToSettings(ScaleToSettings scaleToSettings) {
        this.scaleToSettings = scaleToSettings;
    }

    public boolean isShowGantt() {
        return this.showGantt;
    }

    public void setShowGantt(boolean bl) {
        this.showGantt = bl;
    }

    public boolean isShowSpreadsheet() {
        return this.showSpreadsheet;
    }

    public void setShowSpreadsheet(boolean bl) {
        this.showSpreadsheet = bl;
    }

    public double getSvgZoomX() {
        return this.svgZoomX;
    }

    public double getSvgZoomY() {
        return this.svgZoomY;
    }

    public void saveZoom() {
        this.svgZoomX = this.zoomX;
        this.svgZoomY = this.zoomY;
    }

    public void restoreZoom() {
        this.zoomX = this.svgZoomX;
        this.zoomY = this.svgZoomY;
    }

    public PDFPrintService getPdfPrintService() {
        return this.pdfPrintService;
    }
}

