/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class RegularTasksScanner {
    Document document;
    private static String dtd = "<?xml version='1.0' encoding='" + (String)Settings.getDefault().getSetting("systemEncoding") + "'?>&&<!--- Plan of regular tasks. -->&<!ELEMENT regular_tasks (task)*>&&<!--- Regular task of the plan.&(duration - total time how long user worked on task so far,&state - information about progress on task)&-->&<!ELEMENT task (repetition|notification|notes|keyword|description|priority)*>&<!ATTLIST task&    duration CDATA #IMPLIED&    state CDATA #IMPLIED&  >&&<!--- Priority of a task. -->&<!ELEMENT priority (#PCDATA)>&&<!--- Short description of a task. -->&<!ELEMENT description (#PCDATA)>&&<!--- Category of a task. -->&<!ELEMENT keyword (#PCDATA)>&&<!--- Long description of a task. -->&<!ELEMENT notes (#PCDATA)>&&<!--- Notification about a task at specified time.&(switch - whether task should start automatically,&time - when user should start working on a task)&-->&<!ELEMENT notification EMPTY>&<!ATTLIST notification&    switch CDATA #IMPLIED&    time CDATA #IMPLIED&  >&&<!--- Identification of regular task.&(frequency - type of repetition)&-->&<!ELEMENT repetition EMPTY>&<!ATTLIST repetition&    frequency CDATA #IMPLIED&  >&";

    public RegularTasksScanner(Document document) {
        this.document = document;
    }

    public void loadDocument() {
        Element planElement = this.document.getDocumentElement();
        this.loadPlan(planElement);
    }

    private void loadPlan(Element element) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element regularTaskElement = (Element)node;
            this.loadRegularTask(regularTaskElement);
        }
    }

    private void loadRegularTask(Element regularTaskElement) {
        long duration = Tools.getTime(regularTaskElement.getAttributeNode("duration").getValue());
        int state = Integer.parseInt(regularTaskElement.getAttributeNode("state").getValue());
        RegularTask regularTask = null;
        int priority = 0;
        String description = "";
        String keyword = "";
        String notes = "";
        long notification = -1L;
        boolean automaticStart = false;
        boolean privateTask = false;
        int repetition = -1;
        NodeList nodes = regularTaskElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element nodeElement = (Element)node;
            if (nodeElement.getTagName().equals("priority")) {
                priority = this.loadPriority(nodeElement);
            }
            if (nodeElement.getTagName().equals("description")) {
                description = this.loadDescription(nodeElement);
            }
            if (nodeElement.getTagName().equals("keyword")) {
                keyword = this.loadKeyword(nodeElement);
            }
            if (nodeElement.getTagName().equals("notes")) {
                notes = this.loadNotes(nodeElement);
            }
            if (nodeElement.getTagName().equals("notification")) {
                notification = this.loadNotification(nodeElement);
                automaticStart = this.loadAutomaticStart(nodeElement);
            }
            if (nodeElement.getTagName().equals("private")) {
                privateTask = true;
            }
            if (!nodeElement.getTagName().equals("repetition")) continue;
            repetition = this.loadRepetition(nodeElement);
        }
        Date notificationTime = notification == -1L ? null : new Date(notification);
        regularTask = new RegularTask(description, keyword, notes, priority, state, duration, notificationTime, automaticStart, privateTask, repetition);
        Plan.getDefault().addRegularTask(regularTask);
    }

    private int loadPriority(Element priorityElement) {
        NodeList nodes = priorityElement.getChildNodes();
        Node node = nodes.item(0);
        return Integer.parseInt(((Text)node).getData());
    }

    private String loadDescription(Element descriptionElement) {
        NodeList nodes = descriptionElement.getChildNodes();
        Node node = nodes.item(0);
        return ((Text)node).getData();
    }

    private String loadKeyword(Element keywordElement) {
        NodeList nodes = keywordElement.getChildNodes();
        Node node = nodes.item(0);
        return ((Text)node).getData();
    }

    private String loadNotes(Element notesElement) {
        NodeList nodes = notesElement.getChildNodes();
        Node node = nodes.item(0);
        return ((Text)node).getData();
    }

    private long loadNotification(Element notificationElement) {
        long notificationTime = Tools.getTime(notificationElement.getAttributeNode("time").getValue());
        return notificationTime;
    }

    private boolean loadAutomaticStart(Element notificationElement) {
        boolean automaticStart = Boolean.parseBoolean(notificationElement.getAttributeNode("switch").getValue());
        return automaticStart;
    }

    private int loadRepetition(Element repetitionElement) {
        int repetition = Integer.parseInt(repetitionElement.getAttributeNode("frequency").getValue());
        return repetition;
    }

    public static void createDTD() {
        String userDir = (String)Settings.getDefault().getSetting("userDir");
        String dtdFileName = userDir + File.separator + "regular_tasks.dtd";
        File dtdFile = new File(dtdFileName);
        try {
            if (dtdFile.exists()) {
                return;
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(dtdFile));
            StringTokenizer data = new StringTokenizer(dtd, "&", true);
            while (data.hasMoreTokens()) {
                String token = data.nextToken();
                if (token.equals("&")) {
                    writer.newLine();
                    continue;
                }
                writer.write(token);
            }
            writer.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.WRITE_ERROR", new String[]{dtdFileName}), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
        }
    }
}

