/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JPanel;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class PieChart
extends JPanel
implements PropertyChangeListener {
    private Vector names = new Vector();
    private Vector shares = new Vector();

    @Override
    public void paint(Graphics graphics) {
        graphics.setFont(Tools.getFont());
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.clearRect(0, 0, width, height);
        int count = this.names.size();
        if (count == 0) {
            return;
        }
        int min = Math.min(width - 15, height - this.names.size() * 15 - 5);
        int dia = (min - min / 4) / 2;
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillOval(width / 2 - dia, 20 + count * 15, dia * 2, dia * 2);
        Color color = Color.CYAN;
        float previousAngle = 0.0f;
        for (int i = 0; i < count; ++i) {
            String name = (String)this.names.get(i);
            Float share = (Float)this.shares.get(i);
            graphics.setColor(color);
            graphics.fillArc(this.getWidth() / 2 - dia, 20 + count * 15, dia * 2, dia * 2, 90 - (int)(3.6 * (double)previousAngle), (int)(-3.6 * (double)share.floatValue()));
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawOval(width / 2 - dia, 20 + count * 15, dia * 2, dia * 2);
            int y = 5 + i * 15;
            graphics.setColor(color);
            graphics.fillRect(5, y, 10, 10);
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawRect(5, y, 10, 10);
            graphics.drawString(name + " " + share + "%", 20, y + 10);
            color = this.changeColor(color);
            previousAngle = share.floatValue() + previousAngle;
        }
        int x = 5;
        int y = 5 + count * 15;
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(x, y, 10, 10);
        graphics.setColor(Color.DARK_GRAY);
        graphics.drawRect(x, y, 10, 10);
        graphics.drawString(Translator.getTranslation("HISTORYVIEW.PROJECTS_OTHERS"), x + 15, y + 10);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    public void setShares(Vector names, Vector shares) {
        this.names = names;
        this.shares = shares;
        this.repaint();
    }

    private Color changeColor(Color color) {
        int blue;
        int green;
        int red = color.getRed() + 50;
        if (red > 255) {
            red -= 255;
        }
        if ((green = color.getGreen() - 50) < 0) {
            green += 255;
        }
        if ((blue = color.getBlue() + 100) > 255) {
            blue -= 255;
        }
        return new Color(red, green, blue);
    }
}

