/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Translator;

public class RegularTasksTableModel
extends AbstractTableModel {
    public static final int TASK_PRIORITY = 0;
    public static final int TASK_DESCRIPTION = 1;
    public static final int TASK_REGULAR = 2;
    private Vector regularTasks;
    private int sortedColumn = 2;
    private boolean sortingOrder = true;
    private static final boolean ASCENDING = true;
    private static final boolean DESCENDING = false;

    public Vector sortTable(int column) {
        this.sortingOrder = !this.sortingOrder;
        this.sortedColumn = column;
        Settings.getDefault().setSetting("regularTasks.sorting.column", new Integer(column).toString());
        Settings.getDefault().setSetting("regularTasks.sorting.order", new Boolean(this.sortingOrder));
        Vector<RegularTask> sortedRegularTasks = new Vector<RegularTask>();
        int count = this.regularTasks.size();
        for (int i = 0; i < count; ++i) {
            Iterator iterator = this.regularTasks.iterator();
            RegularTask selectedTask = (RegularTask)iterator.next();
            block5: while (iterator.hasNext()) {
                RegularTask task = (RegularTask)iterator.next();
                switch (column) {
                    case 0: {
                        if (this.sortingOrder) {
                            if (task.getPriority() <= selectedTask.getPriority()) continue block5;
                            selectedTask = task;
                            continue block5;
                        }
                        if (task.getPriority() >= selectedTask.getPriority()) continue block5;
                        selectedTask = task;
                        continue block5;
                    }
                    case 1: {
                        if (this.sortingOrder) {
                            if (task.getDescription().compareTo(selectedTask.getDescription()) >= 0) continue block5;
                            selectedTask = task;
                            continue block5;
                        }
                        if (task.getDescription().compareTo(selectedTask.getDescription()) <= 0) continue block5;
                        selectedTask = task;
                        continue block5;
                    }
                }
                if (this.sortingOrder) {
                    if (task.getFrequency() >= selectedTask.getFrequency()) continue;
                    selectedTask = task;
                    continue;
                }
                if (task.getFrequency() <= selectedTask.getFrequency()) continue;
                selectedTask = task;
            }
            sortedRegularTasks.add(selectedTask);
            this.regularTasks.remove(selectedTask);
        }
        this.regularTasks = sortedRegularTasks;
        return this.regularTasks;
    }

    public RegularTasksTableModel(Vector regularTasks) {
        this.regularTasks = regularTasks;
        Settings settings = Settings.getDefault();
        try {
            this.sortedColumn = Integer.parseInt((String)settings.getSetting("regularTasks.sorting.column"));
            this.sortingOrder = (Boolean)settings.getSetting("regularTasks.sorting.order");
        }
        catch (NumberFormatException e) {
            System.out.println("Error: Can't load sorting of regular tasks. Using default values.");
            this.sortedColumn = 2;
            this.sortingOrder = true;
            settings.setSetting("regularTasks.sorting.column", new Integer(this.sortedColumn).toString());
            settings.setSetting("regularTasks.sorting.order", new Boolean(this.sortingOrder));
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.regularTasks.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        RegularTask task = (RegularTask)this.regularTasks.get(row);
        switch (column) {
            case 0: {
                return RegularTask.getPriority(task.getPriority());
            }
            case 1: {
                return task.getDescription();
            }
            case 2: {
                return RegularTask.getFrequency(task.getFrequency());
            }
        }
        return "N/A";
    }

    @Override
    public String getColumnName(int column) {
        String name;
        switch (column) {
            case 0: {
                name = Translator.getTranslation("TASK_PRIORITY");
                break;
            }
            case 1: {
                name = Translator.getTranslation("TASK_DESCRIPTION");
                break;
            }
            default: {
                name = Translator.getTranslation("TASK_REGULAR");
            }
        }
        if (column == this.sortedColumn) {
            name = name + (this.sortingOrder ? " [+]" : " [-]");
        }
        return name;
    }
}

