/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.report;

import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.bo.TaskType;
import net.ponec.jworksheet.bo.WorkDay;
import net.ponec.jworksheet.bo.item.YearMonthDay;
import org.ujoframework.UjoProperty;
import org.ujoframework.implementation.map.MapUjo;

public class TaskGroup
extends MapUjo {
    public static final UjoProperty<TaskGroup, Project> P_PROJ = TaskGroup.newProperty(Event.P_PROJ, -3);
    public static final UjoProperty<TaskGroup, TaskType> P_TASK = TaskGroup.newProperty(Event.P_TASK, -2);
    public static final UjoProperty<TaskGroup, YearMonthDay> P_DAY = TaskGroup.newProperty(WorkDay.P_DATE, -1);
    public static final UjoProperty<TaskGroup, Integer> P_MONTH = TaskGroup.newProperty("Month", Integer.class);
    public static final UjoProperty<TaskGroup, Integer> P_YEAR = TaskGroup.newProperty("Year", Integer.class);
    private int totalTime = 0;

    public TaskGroup(Event event) {
        if (event != null) {
            this.init(event);
        }
    }

    void init(Event event) {
        this.writeValue(P_PROJ, event.readValue(Event.P_PROJ));
        this.writeValue(P_TASK, event.readValue(Event.P_TASK));
    }

    public void addTime(short s) {
        this.totalTime += s;
    }

    public int getTime() {
        return this.totalTime;
    }

    public int getBusinessTime() {
        Project project = P_PROJ.of(this);
        return project != null && Project.P_PRIVATE.of(project) != false ? 0 : this.totalTime;
    }

    public Object readValue(UjoProperty ujoProperty) {
        if (P_MONTH == ujoProperty || P_YEAR == ujoProperty) {
            YearMonthDay yearMonthDay = P_DAY.of(this);
            int n = P_MONTH == ujoProperty ? 1 : 2;
            return yearMonthDay != null ? Integer.valueOf(yearMonthDay.get(n)) : null;
        }
        return super.readValue(ujoProperty);
    }
}

