/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.gui.CoordinateSystem;
import boplanets.planetSystem.Planet;

public class EclipticSystem
extends CoordinateSystem {
    private int _iAbsciss;
    private int _iOrdinate;
    private Planet[] _arrPlanets;
    private double[] _minMaxAbsciss = new double[2];
    private double[] _minMaxOrdinate = new double[2];

    public EclipticSystem(Planet[] planetArray, int n, int n2) {
        this._viewType = 0;
        this._iAbsciss = n;
        this._iOrdinate = n2;
        this.setMinMaxCoordinates(planetArray);
    }

    @Override
    public void setOrbParamsOfObserver(Planet planet) {
    }

    @Override
    public void setMinMaxCoordinates(Planet[] planetArray) {
        double[] dArray = EclipticSystem.getMinMaxCoordinates(planetArray, this._iAbsciss, this._iOrdinate);
        this._minMaxAbsciss[0] = dArray[0];
        this._minMaxAbsciss[1] = dArray[1];
        this._minMaxOrdinate[0] = dArray[2];
        this._minMaxOrdinate[1] = dArray[3];
    }

    @Override
    public double[] getNextCoordinates(Planet planet, double[] dArray) {
        double[] dArray2 = new double[]{dArray[this._iAbsciss], dArray[this._iOrdinate]};
        return dArray2;
    }

    @Override
    protected double[] getSpecMapParams(int n, int n2) {
        double[] dArray = EclipticSystem.getMapParams(n, n2, this._minMaxAbsciss, this._minMaxOrdinate);
        double d = dArray[2];
        double d2 = dArray[3];
        double d3 = dArray[4];
        double d4 = dArray[5];
        if (d < d2) {
            d2 = d;
            d4 = d3;
        } else {
            d = d2;
            d3 = d4;
        }
        dArray[2] = d;
        dArray[3] = d2;
        dArray[4] = d3;
        dArray[5] = d4;
        return dArray;
    }

    protected static double[] getMinMaxCoordinates(Planet[] planetArray, int n, int n2) {
        int n3 = planetArray.length - 1;
        Planet planet = planetArray[n3 - 1];
        double[][] dArray = planet.minMaxEclXyz;
        double d = dArray[n][0];
        double d2 = dArray[n][1];
        double d3 = dArray[n2][0];
        double d4 = dArray[n2][1];
        for (int i = n3 - 2; i >= 0; --i) {
            double d5;
            double d6;
            double d7;
            planet = planetArray[i];
            dArray = planet.minMaxEclXyz;
            double d8 = dArray[n][0];
            if (d > d8) {
                d = d8;
            }
            if (d2 < (d7 = dArray[n][1])) {
                d2 = d7;
            }
            if (d3 > (d6 = dArray[n2][0])) {
                d3 = d6;
            }
            if (!(d4 < (d5 = dArray[n2][1]))) continue;
            d4 = d5;
        }
        planet = planetArray[n3];
        dArray = planet.minMaxEclXyz;
        double d9 = dArray[n][0];
        double d10 = dArray[n][1];
        double d11 = dArray[n2][0];
        double d12 = dArray[n2][1];
        double[] dArray2 = new double[]{d -= d10, d2 -= d9, d3 -= d12, d4 -= d11};
        return dArray2;
    }
}

