/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.gui.CoordinateSystem;
import boplanets.gui.EclipticSystem;
import boplanets.planetSystem.Planet;

public class LogEclipticSystem
extends CoordinateSystem {
    private int _iAbsciss;
    private int _iOrdinate;
    private double[] _minMaxAbsciss = new double[2];
    private double[] _minMaxOrdinate = new double[2];

    public LogEclipticSystem(Planet[] planetArray, int n, int n2) {
        this._viewType = 1;
        this._iAbsciss = n;
        this._iOrdinate = n2;
        this.setMinMaxCoordinates(planetArray);
    }

    @Override
    public void setOrbParamsOfObserver(Planet planet) {
    }

    @Override
    public void setMinMaxCoordinates(Planet[] planetArray) {
        double[] dArray = EclipticSystem.getMinMaxCoordinates(planetArray, this._iAbsciss, this._iOrdinate);
        this._minMaxAbsciss[0] = Math.log10(Math.abs(dArray[0]) + 1.0) * Math.signum(dArray[0]);
        this._minMaxAbsciss[1] = Math.log10(Math.abs(dArray[1]) + 1.0) * Math.signum(dArray[1]);
        this._minMaxOrdinate[0] = Math.log10(Math.abs(dArray[2]) + 1.0) * Math.signum(dArray[2]);
        this._minMaxOrdinate[1] = Math.log10(Math.abs(dArray[3]) + 1.0) * Math.signum(dArray[3]);
    }

    @Override
    public double[] getNextCoordinates(Planet planet, double[] dArray) {
        double d = dArray[this._iAbsciss];
        double d2 = dArray[this._iOrdinate];
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = Math.log10(d3 + 1.0);
        double[] dArray2 = new double[]{d4 * d / d3, d4 * d2 / d3};
        return dArray2;
    }

    @Override
    protected double[] getSpecMapParams(int n, int n2) {
        double[] dArray = LogEclipticSystem.getMapParams(n, n2, this._minMaxAbsciss, this._minMaxOrdinate);
        double d = dArray[2];
        double d2 = dArray[3];
        double d3 = dArray[4];
        double d4 = dArray[5];
        if (d < d2) {
            d2 = d;
            d4 = d3;
        } else {
            d = d2;
            d3 = d4;
        }
        dArray[2] = d;
        dArray[3] = d2;
        dArray[4] = d3;
        dArray[5] = d4;
        return dArray;
    }
}

