/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.util.NumberConverter;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class MyTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private int _clickCountToStart = 2;
    private JTextField _editorComponent;
    private Object _oldValue;
    private int _selRow;
    private int _selCol;
    private static final int IND_EXCENTRICITY = 0;
    private static final int IND_INCLINATION = 1;
    private static final int IND_PERIHEL = 2;
    private static final int IND_LONG = 3;

    public MyTableCellEditor(JTextField jTextField) {
        this._editorComponent = jTextField;
        this._editorComponent.setHorizontalAlignment(4);
        this._clickCountToStart = 1;
        this._editorComponent.addActionListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this._selRow = n;
        this._selCol = n2;
        this._oldValue = object;
        double d = (Double)object;
        String string = NumberConverter.format(d);
        this._editorComponent.setText(string);
        return this._editorComponent;
    }

    @Override
    public Object getCellEditorValue() {
        String string = this._editorComponent.getText();
        try {
            double d;
            double d2;
            double d3 = NumberConverter.parse(string);
            double d4 = (Double)this._oldValue;
            if (d3 == d4) {
                this.fireEditingCanceled();
                return null;
            }
            switch (this._selRow) {
                case 0: {
                    d2 = 0.0;
                    d = 0.9;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    d2 = -180.0;
                    d = 180.0;
                    break;
                }
                default: {
                    return d3;
                }
            }
            if (d3 >= d2 && d3 <= d) {
                return d3;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Toolkit.getDefaultToolkit().beep();
        this.fireEditingCanceled();
        return null;
    }

    public Component getComponent() {
        return this._editorComponent;
    }

    public void setClickCountToStart(int n) {
        this._clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this._clickCountToStart;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this._clickCountToStart;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        this._editorComponent.setSelectionStart(0);
        this._editorComponent.setSelectionEnd(50);
        return true;
    }

    public boolean startCellEditing(EventObject eventObject) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireEditingStopped();
    }
}

