/*
 * Decompiled with CFR 0.152.
 */
package boplanets.planetSystem;

import boplanets.planetSystem.Planet;
import boplanets.util.AstroMath;

public class MinMaxDeclin
implements AstroMath.Newton {
    private static final int MAX_SCAN_STEPS = 25;
    private static final double GRAD_PREC = 0.02;
    private static final int GS_MAX_STEPS = 20;
    private static final double GS_START_FACTOR = 1.2;
    private static final double GS_MAX_STEP_SIZE = 1.2;
    private static final double GS_PRECISION = 0.001953125;
    private static final double CRITICAL_RATIO = 0.35;
    private static final double CRITICAL_EXC = 0.4;
    private Planet planet;
    private Planet observer;
    private double[] normalEquObs;
    private double radObs;
    private double radPlanet;

    public MinMaxDeclin(Planet planet, Planet planet2) {
        this.observer = planet2;
        this.planet = planet;
        this.normalEquObs = this.observer.normalEquPlanet;
        this.radObs = this.observer.xHalfAxis;
        this.radPlanet = this.planet.xHalfAxis;
    }

    @Override
    public double[] equation1Dim(double d) {
        double[] dArray = new double[]{-1.0, -1.0};
        return dArray;
    }

    @Override
    public double[] equation2Dim(double d, double d2) {
        double[] dArray = this.gradientSinDec(d, d2);
        double[] dArray2 = this.planet.getTangent(d);
        double d3 = AstroMath.scalarProduct(dArray, dArray2);
        double[] dArray3 = this.observer.getTangent(d2);
        double d4 = -AstroMath.scalarProduct(dArray, dArray3);
        double[] dArray4 = this.dGradientdX(d3, dArray2, d, d2);
        double[] dArray5 = this.planet.getDerivOfTangent(d);
        double d5 = AstroMath.scalarProduct(dArray4, dArray2);
        d5 += AstroMath.scalarProduct(dArray, dArray5);
        double d6 = -AstroMath.scalarProduct(dArray4, dArray3);
        dArray4 = this.dGradientdY(d4, dArray3, d, d2);
        double d7 = AstroMath.scalarProduct(dArray4, dArray2);
        dArray5 = this.observer.getDerivOfTangent(d2);
        double d8 = -AstroMath.scalarProduct(dArray4, dArray3);
        double d9 = d5 * (d8 -= AstroMath.scalarProduct(dArray, dArray5)) - d7 * d6;
        double[] dArray6 = new double[]{d3, d4, d5, d7, d6, d8, d9};
        return dArray6;
    }

    private double[] gradientSinDec(double d, double d2) {
        double[] dArray = this.observer.getRadiusVector(d2);
        double[] dArray2 = this.planet.getRadiusVector(d);
        double[] dArray3 = AstroMath.vectorDiff(dArray2, dArray);
        double d3 = AstroMath.scalarProduct(dArray3, dArray3);
        double d4 = Math.sqrt(d3);
        dArray3 = AstroMath.vectorMultiply(1.0 / d4, dArray3);
        double d5 = AstroMath.scalarProduct(this.normalEquObs, dArray3);
        double[] dArray4 = AstroMath.vectorMultiply(d5, dArray3);
        dArray2 = AstroMath.vectorDiff(this.normalEquObs, dArray4);
        return AstroMath.vectorMultiply(d3, dArray2);
    }

    private double[] dGradientdX(double d, double[] dArray, double d2, double d3) {
        double[] dArray2 = this.observer.getRadiusVector(d3);
        double[] dArray3 = this.planet.getRadiusVector(d2);
        double[] dArray4 = AstroMath.vectorDiff(dArray3, dArray2);
        double d4 = AstroMath.scalarProduct(dArray4, dArray4);
        double d5 = Math.sqrt(d4);
        dArray4 = AstroMath.vectorMultiply(1.0 / d5, dArray4);
        double d6 = AstroMath.scalarProduct(this.normalEquObs, dArray4);
        double d7 = AstroMath.scalarProduct(dArray4, dArray);
        double[] dArray5 = AstroMath.vectorMultiply(d7, dArray4);
        double[] dArray6 = AstroMath.vectorDiff(dArray, dArray5);
        dArray5 = AstroMath.vectorMultiply(-d6 * d5, dArray6);
        dArray6 = AstroMath.vectorMultiply(-d / d5, dArray4);
        dArray3 = AstroMath.vectorAdd(dArray5, dArray6);
        dArray5 = this.gradientSinDec(d2, d3);
        dArray6 = AstroMath.vectorMultiply(2.0 * d7 / d5, dArray5);
        return AstroMath.vectorAdd(dArray3, dArray6);
    }

    private double[] dGradientdY(double d, double[] dArray, double d2, double d3) {
        double[] dArray2 = this.observer.getRadiusVector(d3);
        double[] dArray3 = this.planet.getRadiusVector(d2);
        double[] dArray4 = AstroMath.vectorDiff(dArray3, dArray2);
        double d4 = AstroMath.scalarProduct(dArray4, dArray4);
        double d5 = Math.sqrt(d4);
        dArray4 = AstroMath.vectorMultiply(1.0 / d5, dArray4);
        double d6 = AstroMath.scalarProduct(this.normalEquObs, dArray4);
        double d7 = AstroMath.scalarProduct(dArray4, dArray);
        double[] dArray5 = AstroMath.vectorMultiply(d7, dArray4);
        double[] dArray6 = AstroMath.vectorDiff(dArray, dArray5);
        dArray5 = AstroMath.vectorMultiply(d6 * d5, dArray6);
        dArray6 = AstroMath.vectorMultiply(-d / d5, dArray4);
        dArray3 = AstroMath.vectorAdd(dArray5, dArray6);
        dArray5 = this.gradientSinDec(d2, d3);
        dArray6 = AstroMath.vectorMultiply(-2.0 * d7 / d5, dArray5);
        return AstroMath.vectorAdd(dArray3, dArray6);
    }

    protected double getDeclination(double d, double d2) {
        return Math.toDegrees(Math.asin(this.getSinusOfDecl(d, d2)));
    }

    private double getSinusOfDecl(double d, double d2) {
        double[] dArray = this.observer.getRadiusVector(d2);
        double[] dArray2 = this.planet.getRadiusVector(d);
        double[] dArray3 = AstroMath.vectorDiff(dArray2, dArray);
        double d3 = Math.sqrt(AstroMath.scalarProduct(dArray3, dArray3));
        double d4 = AstroMath.scalarProduct(this.normalEquObs, dArray3) / d3;
        if (Math.abs(d4) > 1.0) {
            d4 = Math.signum(d4);
        }
        return d4;
    }

    protected double[] findMinMaxDeclination(int n, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double[] dArray = this.minMaxByGradient(n, d, d2);
        double d7 = AstroMath.to0_2PiIntervall(dArray[0]);
        double d8 = AstroMath.to0_2PiIntervall(dArray[1]);
        double d9 = this.getDeclination(d7, d8);
        double d10 = dArray[2];
        if (d10 < 0.0) {
            if (this.radPlanet < this.radObs) {
                d6 = AstroMath.getExcAnoOfOpposite(d7, this.planet.numExc);
                d5 = d8;
            } else {
                d5 = AstroMath.getExcAnoOfOpposite(d8, this.observer.numExc);
                d6 = d7;
            }
            dArray = this.minMaxByGradient(n, d6, d5);
            d6 = AstroMath.to0_2PiIntervall(dArray[0]);
            d5 = AstroMath.to0_2PiIntervall(dArray[1]);
            d4 = this.getDeclination(d6, d5);
            d10 = dArray[2];
            if (d10 > 0.0) {
                d9 = d4;
                d7 = d6;
                d8 = d5;
            } else if ((double)n * (d4 - d9) > 0.0) {
                d9 = d4;
                d7 = d6;
                d8 = d5;
            }
        }
        double d11 = this.radPlanet > this.radObs ? this.radObs / this.radPlanet : this.radPlanet / this.radObs;
        double d12 = d3 = this.radPlanet > this.radObs ? this.planet.numExc : this.observer.numExc;
        if (d11 >= 0.35 || d3 >= 0.4) {
            dArray = this.findMinMaxByNewton(d7, d8);
            d4 = dArray[0];
            d6 = dArray[1];
            d5 = dArray[2];
            d10 = dArray[3];
            if (d10 < 0.0) {
                if (this.radPlanet < this.radObs) {
                    d7 = AstroMath.getExcAnoOfOpposite(d6, this.planet.numExc);
                    d8 = d5;
                } else {
                    d8 = AstroMath.getExcAnoOfOpposite(d5, this.observer.numExc);
                    d7 = d6;
                }
                dArray = this.minMaxByGradient(n, d7, d8);
                d7 = AstroMath.to0_2PiIntervall(dArray[0]);
                d8 = AstroMath.to0_2PiIntervall(dArray[1]);
                d9 = this.getDeclination(d7, d8);
                double d13 = d4;
                double d14 = d6;
                double d15 = d5;
                dArray = this.findMinMaxByNewton(d7, d8);
                d4 = dArray[0];
                d6 = dArray[1];
                d5 = dArray[2];
                d10 = dArray[3];
                if (d10 < 0.0) {
                    if ((double)n * (d4 - d13) < 0.0) {
                        d4 = d13;
                        d6 = d14;
                        d5 = d15;
                    } else if ((double)n * (d4 - d9) < 0.0) {
                        d4 = d9;
                        d6 = d7;
                        d5 = d8;
                    }
                }
            }
        } else {
            d4 = d9;
            d6 = d7;
            d5 = d8;
        }
        double[] dArray2 = new double[]{d4, d6, d5};
        return dArray2;
    }

    private double[] findMinMaxByNewton(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double[] dArray = AstroMath.findRoot2Dim(this, d, d2);
        double d7 = dArray[3];
        if (d7 < 0.0) {
            d6 = dArray[0];
            d5 = dArray[1];
            d4 = this.getDeclination(d6, d5);
            d6 = d;
            d5 = d2;
            d3 = 0.0;
            d4 = this.getDeclination(d, d2);
        } else {
            d6 = AstroMath.to0_2PiIntervall(dArray[0]);
            d5 = AstroMath.to0_2PiIntervall(dArray[1]);
            d3 = dArray[2];
            d4 = this.getDeclination(d6, d5);
        }
        double[] dArray2 = new double[]{d4, d6, d5, d3};
        return dArray2;
    }

    private double[] minMaxByGradient(int n, double d, double d2) {
        double d3 = 1.0;
        int n2 = (double)n < 0.0 ? -1 : 1;
        double d4 = d;
        double d5 = d2;
        for (int i = 0; i < 25; ++i) {
            double[] dArray = this.equation2Dim(d4, d5);
            double d6 = dArray[0];
            double d7 = dArray[1];
            d3 = dArray[6];
            double[] dArray2 = this.planet.getRadiusVector(d4);
            double[] dArray3 = this.observer.getRadiusVector(d5);
            double[] dArray4 = AstroMath.vectorDiff(dArray2, dArray3);
            double d8 = AstroMath.scalarProduct(dArray4, dArray4);
            double d9 = Math.sqrt(d8) * d8;
            double d10 = d6 / d9;
            double d11 = d7 / d9;
            if (Math.abs(d9 = Math.sqrt(d10 * d10 + d11 * d11)) > 1.0E-10) {
                double[] dArray5 = this.getBestGradientStep(d4, d5, d10 /= d9, d11 /= d9, n2);
                d10 = dArray5[0] * (double)n2;
                d11 = dArray5[1] * (double)n2;
            }
            d4 += d10;
            d5 += d11;
            if (Math.abs(d10) < 0.02 && Math.abs(d11) < 0.02) break;
        }
        d4 = AstroMath.to0_2PiIntervall(d4);
        d5 = AstroMath.to0_2PiIntervall(d5);
        double[] dArray = new double[]{d4, d5, d3};
        return dArray;
    }

    private double[] getBestGradientStep(double d, double d2, double d3, double d4, int n) {
        double d5;
        double d6 = 1.2;
        double d7 = d + (double)n * d6 * d3;
        double d8 = d2 + (double)n * d6 * d4;
        double d9 = this.getSinusOfDecl(d7, d8);
        double d10 = d + (double)n * d6 * d3 * 2.0;
        double d11 = d2 + (double)n * d6 * d4 * 2.0;
        double d12 = this.getSinusOfDecl(d10, d11);
        int n2 = 0;
        double d13 = this.getSinusOfDecl(d, d2);
        for (int i = 0; n2 == 0 && i < 20; ++i) {
            if ((d13 - d9) * (double)n >= 0.0) {
                if (d6 > 0.001953125) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                    d7 = d + (double)n * (d6 *= 0.5) * d3;
                    d8 = d2 + (double)n * d6 * d4;
                    d9 = this.getSinusOfDecl(d7, d8);
                    continue;
                }
                n2 = -1;
                break;
            }
            if ((d12 - d9) * (double)n > 0.0) {
                if (Math.abs(d6 * d3) < 1.2 && Math.abs(d6 * d4) < 1.2) {
                    d7 = d10;
                    d8 = d11;
                    d9 = d12;
                    d10 = d + (double)(2 * n) * (d6 *= 2.0) * d3;
                    d11 = d2 + (double)(2 * n) * d6 * d4;
                    d12 = this.getSinusOfDecl(d10, d11);
                    continue;
                }
                n2 = 1;
                break;
            }
            n2 = -1;
        }
        if (n2 < 0 && Math.abs(d5 = 2.0 * d9 - d13 - d12) > 5.0E-4) {
            d6 = (4.0 * d9 - 3.0 * d13 - d12) / d5 * d6 * 0.5;
        }
        double d14 = d6 * d3;
        double d15 = d6 * d4;
        d7 = d + (double)n * d14;
        d8 = d2 + (double)n * d15;
        double[] dArray = new double[]{d14, d15};
        return dArray;
    }
}

