/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ui.dialog.CheckBoxEquipmentNode;
import de.lehmannet.om.ui.dialog.CheckBoxNodeEquipmentRendererMouseListener;
import de.lehmannet.om.ui.dialog.EquipmentLeaf;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class CheckBoxNodeEquipmentRenderer
extends DefaultTreeCellRenderer {
    private Color selectionBorderColor;
    private Color selectionForeground;
    private Color selectionBackground;
    private Color textForeground;
    private Color textBackground;
    private Font selectedTreeFont = this.selectedTreeFont.deriveFont(1);
    private Font unselectedTreeFont = this.unselectedTreeFont.deriveFont(0);

    public CheckBoxNodeEquipmentRenderer() {
        this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component returnValue = null;
        if (leaf) {
            Object userObject;
            if (value != null && value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof EquipmentLeaf) {
                EquipmentLeaf sel = (EquipmentLeaf)userObject;
                if (selected) {
                    sel.setForeground(this.selectionForeground);
                    sel.setBackground(this.selectionBackground);
                } else {
                    sel.setForeground(this.textForeground);
                    sel.setBackground(this.textBackground);
                }
                if (sel.isSelected()) {
                    sel.setFont(this.selectedTreeFont);
                } else {
                    sel.setFont(this.unselectedTreeFont);
                }
                Boolean booleanValue = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon");
                sel.setFocusPainted(booleanValue != null && booleanValue != false);
                returnValue = sel;
            }
        } else {
            DefaultMutableTreeNode dmtn;
            Object userObject;
            Icon icon = null;
            CheckBoxEquipmentNode cbn = null;
            if (value != null && value instanceof DefaultMutableTreeNode && (userObject = (dmtn = (DefaultMutableTreeNode)value).getUserObject()) instanceof CheckBoxEquipmentNode) {
                cbn = (CheckBoxEquipmentNode)userObject;
                icon = expanded ? ((CheckBoxEquipmentNode)userObject).getExpandedIcon() : ((CheckBoxEquipmentNode)userObject).getCollapsedIcon();
            }
            DefaultTreeCellRenderer nonLeafRenderer = new DefaultTreeCellRenderer();
            returnValue = nonLeafRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            DefaultTreeCellRenderer dtcr = null;
            if (icon != null && returnValue instanceof DefaultTreeCellRenderer) {
                dtcr = (DefaultTreeCellRenderer)returnValue;
                if (cbn.isSelected() && cbn.size() > 0) {
                    dtcr.setFont(this.selectedTreeFont);
                } else {
                    dtcr.setFont(this.unselectedTreeFont);
                }
                dtcr.setIcon(icon);
                dtcr.setDisabledIcon(icon);
                dtcr.addMouseListener(new CheckBoxNodeEquipmentRendererMouseListener(cbn));
            }
        }
        return returnValue;
    }
}

