/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ui.dialog.AbstractDialog;
import de.lehmannet.om.ui.dialog.SimpleSchemaElementModel;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.navigation.tableModel.AbstractSchemaTableModel;
import de.lehmannet.om.ui.panel.AbstractPanel;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

class TableElementsPanel
extends AbstractPanel {
    private JTable table = new JTable();
    private AbstractSchemaTableModel model = null;
    private JScrollPane scrollTable = null;
    private ObservationManager om = null;

    public TableElementsPanel(List schemaElements, ObservationManager om) {
        super(true);
        this.om = om;
        ISchemaElement[] se = schemaElements.toArray(new ISchemaElement[0]);
        this.model = new SimpleSchemaElementModel(se);
        this.table.setModel(this.model);
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    ISchemaElement se = TableElementsPanel.this.model.getSchemaElement(selectedRow);
                    if (se != null) {
                        TableElementsPanel.this.om.update(se);
                    }
                }
            }
        });
        this.setColumnSize();
        this.scrollTable = new JScrollPane(this.table);
        this.createPanel();
    }

    public ISchemaElement createSchemaElement() {
        return null;
    }

    public ISchemaElement getSchemaElement() {
        return null;
    }

    public ISchemaElement updateSchemaElement() {
        return null;
    }

    private void setColumnSize() {
        if (this.table.getColumnModel().getColumnCount() <= 1) {
            return;
        }
        this.table.setAutoResizeMode(0);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setPreferredWidth(((AbstractSchemaTableModel)this.table.getModel()).getColumnSize(0));
        col = this.table.getColumnModel().getColumn(1);
        col.setPreferredWidth(((AbstractSchemaTableModel)this.table.getModel()).getColumnSize(1));
        this.table.setAutoResizeMode(2);
    }

    private void createPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 5, 1);
        constraints.fill = 2;
        JLabel Lelements = new JLabel(AbstractDialog.bundle.getString("dialog.tableElements.label.elements"));
        gridbag.setConstraints(Lelements, constraints);
        this.add(Lelements);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 5, 45, 10);
        constraints.fill = 1;
        gridbag.setConstraints(this.scrollTable, constraints);
        this.scrollTable.setMinimumSize(new Dimension(200, 200));
        this.add(this.scrollTable);
        ConstraintsBuilder.buildConstraints(constraints, 0, 6, 1, 1, 50, 89);
        constraints.fill = 1;
        JLabel Lfill = new JLabel("");
        gridbag.setConstraints(Lfill, constraints);
        this.add(Lfill);
    }
}

