/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation;

import de.lehmannet.om.IEquipment;
import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.navigation.SchemaElementMutableTreeNode;
import de.lehmannet.om.ui.navigation.TreeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class SchemaElementTreeCellRenderer
extends DefaultTreeCellRenderer {
    private TreeView treeView = null;
    private String imagesDir = null;
    private ObservationManager om = null;

    public SchemaElementTreeCellRenderer(TreeView treeView, ObservationManager om) {
        this.treeView = treeView;
        this.om = om;
        this.imagesDir = this.om.getInstallDir().getAbsolutePath() + File.separatorChar + "images" + File.separatorChar;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node;
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        ImageIcon icon = null;
        super.setFont(new Font("Arial", 0, 12));
        super.setForeground(Color.DARK_GRAY);
        if (this.om.isNightVisionEnabled()) {
            super.setBackgroundNonSelectionColor(new Color(255, 175, 175));
        } else {
            super.setBackgroundNonSelectionColor(Color.WHITE);
        }
        if (value instanceof SchemaElementMutableTreeNode) {
            SchemaElementMutableTreeNode schemaNode = (SchemaElementMutableTreeNode)value;
            ISchemaElement se = schemaNode.getSchemaElement();
            if (se instanceof IEyepiece) {
                if (((IEquipment)se).isAvailable()) {
                    super.setForeground(Color.DARK_GRAY);
                    super.setFont(new Font("Arial", 0, 12));
                } else {
                    super.setForeground(Color.GRAY);
                    super.setFont(new Font("Arial", 0, 12));
                }
                icon = new ImageIcon(this.imagesDir + "eyepiece_l.png");
                super.setToolTipText("");
                super.setIcon(icon);
                return this;
            }
            if (se instanceof ISession) {
                icon = new ImageIcon(this.imagesDir + "session_l.png");
                super.setToolTipText("");
                super.setIcon(icon);
                return this;
            }
            if (se instanceof ISite) {
                icon = new ImageIcon(this.imagesDir + "site_l.png");
                super.setToolTipText("");
                super.setIcon(icon);
                return this;
            }
            if (se instanceof IScope) {
                if (((IEquipment)se).isAvailable()) {
                    super.setForeground(Color.DARK_GRAY);
                    super.setFont(new Font("Arial", 0, 12));
                } else {
                    super.setForeground(Color.GRAY);
                    super.setFont(new Font("Arial", 0, 12));
                }
                icon = new ImageIcon(this.imagesDir + "scope_l.png");
                super.setToolTipText("");
                super.setIcon(icon);
                return this;
            }
            if (se instanceof ITarget) {
                icon = new ImageIcon(this.imagesDir + "target_l.png");
                super.setToolTipText("");
                super.setIcon(icon);
                return this;
            }
            if (se instanceof IObserver) {
                icon = new ImageIcon(this.imagesDir + "observer_l.png");
                super.setToolTipText("");
                super.setIcon(icon);
                return this;
            }
            if (se instanceof IObservation) {
                if (schemaNode.getParent() instanceof SchemaElementMutableTreeNode) {
                    ISchemaElement parentSE = ((SchemaElementMutableTreeNode)schemaNode.getParent()).getSchemaElement();
                    if (parentSE instanceof IObserver) {
                        if (parentSE.equals(((IObservation)se).getObserver())) {
                            super.setForeground(Color.GRAY);
                            super.setFont(new Font("Arial", 2, 12));
                        } else {
                            super.setForeground(new Color(175, 175, 175));
                            super.setFont(new Font("Arial", 2, 12));
                        }
                    } else {
                        super.setForeground(Color.GRAY);
                        super.setFont(new Font("Arial", 2, 12));
                    }
                }
                icon = new ImageIcon(this.imagesDir + "observation_l.png");
                super.setToolTipText("");
                super.setIcon(icon);
                return this;
            }
            if (se instanceof IImager) {
                if (((IEquipment)se).isAvailable()) {
                    super.setForeground(Color.DARK_GRAY);
                    super.setFont(new Font("Arial", 0, 12));
                } else {
                    super.setForeground(Color.GRAY);
                    super.setFont(new Font("Arial", 0, 12));
                }
                icon = new ImageIcon(this.imagesDir + "imager_l.png");
                super.setToolTipText("");
                super.setIcon(icon);
                return this;
            }
            if (se instanceof IFilter) {
                if (((IEquipment)se).isAvailable()) {
                    super.setForeground(Color.DARK_GRAY);
                    super.setFont(new Font("Arial", 0, 12));
                } else {
                    super.setForeground(Color.GRAY);
                    super.setFont(new Font("Arial", 0, 12));
                }
                icon = new ImageIcon(this.imagesDir + "filter_l.png");
                super.setToolTipText("");
                super.setIcon(icon);
                return this;
            }
            if (se instanceof ILens) {
                if (((IEquipment)se).isAvailable()) {
                    super.setForeground(Color.DARK_GRAY);
                    super.setFont(new Font("Arial", 0, 12));
                } else {
                    super.setForeground(Color.GRAY);
                    super.setFont(new Font("Arial", 0, 12));
                }
                icon = new ImageIcon(this.imagesDir + "lens_l.png");
                super.setToolTipText("");
                super.setIcon(icon);
                return this;
            }
        }
        if (this.treeView.eyepiece.equals(node = (DefaultMutableTreeNode)value)) {
            icon = expanded ? new ImageIcon(this.imagesDir + "eyepiece_e.png") : new ImageIcon(this.imagesDir + "eyepiece_c.png");
        } else if (this.treeView.session.equals(node)) {
            icon = expanded ? new ImageIcon(this.imagesDir + "session_e.png") : new ImageIcon(this.imagesDir + "session_c.png");
        } else if (this.treeView.site.equals(node)) {
            icon = expanded ? new ImageIcon(this.imagesDir + "site_e.png") : new ImageIcon(this.imagesDir + "site_c.png");
        } else if (this.treeView.scope.equals(node)) {
            icon = expanded ? new ImageIcon(this.imagesDir + "scope_e.png") : new ImageIcon(this.imagesDir + "scope_c.png");
        } else if (this.treeView.target.equals(node)) {
            icon = expanded ? new ImageIcon(this.imagesDir + "target_e.png") : new ImageIcon(this.imagesDir + "target_c.png");
        } else if (this.treeView.observer.equals(node)) {
            icon = expanded ? new ImageIcon(this.imagesDir + "observer_e.png") : new ImageIcon(this.imagesDir + "observer_c.png");
        } else if (this.treeView.observation.equals(node)) {
            super.setFont(new Font("Arial", 1, 12));
            icon = expanded ? new ImageIcon(this.imagesDir + "observation_e.png") : new ImageIcon(this.imagesDir + "observation_c.png");
        } else if (this.treeView.imager.equals(node)) {
            icon = expanded ? new ImageIcon(this.imagesDir + "imager_e.png") : new ImageIcon(this.imagesDir + "imager_c.png");
        } else if (this.treeView.filter.equals(node)) {
            icon = expanded ? new ImageIcon(this.imagesDir + "filter_e.png") : new ImageIcon(this.imagesDir + "filter_c.png");
        } else if (this.treeView.lens.equals(node)) {
            icon = expanded ? new ImageIcon(this.imagesDir + "lens_e.png") : new ImageIcon(this.imagesDir + "lens_c.png");
        } else if (this.treeView.root.equals(node)) {
            icon = new ImageIcon(this.imagesDir + "root.png");
        }
        if (node.children().equals(DefaultMutableTreeNode.EMPTY_ENUMERATION)) {
            icon = new ImageIcon(this.imagesDir + "empty.png");
        }
        super.setIcon(icon);
        return this;
    }
}

