/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation;

import de.lehmannet.om.Angle;
import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.navigation.PopupMenuHandler;
import de.lehmannet.om.ui.navigation.tableModel.AbstractSchemaTableModel;
import de.lehmannet.om.ui.navigation.tableModel.EyepieceTableModel;
import de.lehmannet.om.ui.navigation.tableModel.FilterTableModel;
import de.lehmannet.om.ui.navigation.tableModel.ImagerTableModel;
import de.lehmannet.om.ui.navigation.tableModel.LensTableModel;
import de.lehmannet.om.ui.navigation.tableModel.ObservationTableModel;
import de.lehmannet.om.ui.navigation.tableModel.ObserverTableModel;
import de.lehmannet.om.ui.navigation.tableModel.ScopeTableModel;
import de.lehmannet.om.ui.navigation.tableModel.SessionTableModel;
import de.lehmannet.om.ui.navigation.tableModel.SiteTableModel;
import de.lehmannet.om.ui.navigation.tableModel.TableSorter;
import de.lehmannet.om.ui.navigation.tableModel.TargetTableModel;
import de.lehmannet.om.ui.util.Configuration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableView
extends JPanel {
    private static final String CONFIG_TABLESETTINGS_PREFIX = "om.tableSetting.";
    private ObservationManager observationManager = null;
    private JTable table = null;
    private AbstractSchemaTableModel model = null;
    private JScrollPane scrollTable = null;
    private TableSorter sorter = null;
    private ISchemaElement selectedElement = null;
    private ISchemaElement parentElement = null;

    public TableView(ObservationManager om) {
        this.observationManager = om;
        this.model = new ObservationTableModel(null, this.observationManager);
        this.sorter = new TableSorter(null);
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    int selectedSortedRow = TableView.this.sorter.modelIndex(selectedRow);
                    ISchemaElement se = TableView.this.model.getSchemaElement(selectedSortedRow);
                    TableView.this.updateItemView(se);
                    if (se != null && se.equals(TableView.this.selectedElement)) {
                        return;
                    }
                    if (se instanceof IObservation) {
                        TableView.this.observationManager.getTreeView().setSelection(se, TableView.this.parentElement);
                    } else {
                        TableView.this.observationManager.getTreeView().setSelection(se, null);
                    }
                }
            }
        });
        this.table.setDoubleBuffered(true);
        super.setLayout(new BorderLayout());
        this.scrollTable = new JScrollPane(this.table);
        super.add(this.scrollTable);
        this.table.setDefaultRenderer(Angle.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
                if (value != null) {
                    String result = null;
                    Angle angle = (Angle)value;
                    DecimalFormat df = new DecimalFormat("0.00");
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                    dfs.setDecimalSeparator('.');
                    df.setDecimalFormatSymbols(dfs);
                    result = df.format(angle.getValue()) + " " + angle.getUnit();
                    cr.setText(result);
                }
                if (isSelected) {
                    cr.setBackground(Color.LIGHT_GRAY);
                }
                return cr;
            }
        });
        this.table.setDefaultRenderer(Float.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
                if (value != null) {
                    Float f = (Float)value;
                    if (Float.isNaN(f.floatValue())) {
                        cr.setText("");
                    } else {
                        String result = null;
                        DecimalFormat df = new DecimalFormat("0.00");
                        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                        dfs.setDecimalSeparator('.');
                        df.setDecimalFormatSymbols(dfs);
                        result = df.format(f.floatValue());
                        cr.setText(result);
                    }
                }
                if (isSelected) {
                    cr.setBackground(Color.LIGHT_GRAY);
                }
                return cr;
            }
        });
        this.table.setDefaultRenderer(Integer.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
                if (value != null) {
                    Integer i = (Integer)value;
                    cr.setText("" + i);
                }
                if (isSelected) {
                    cr.setBackground(Color.LIGHT_GRAY);
                }
                return cr;
            }
        });
        this.table.setDefaultRenderer(Calendar.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
                if (value != null) {
                    DateFormat df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
                    Calendar cal = (Calendar)value;
                    df.setCalendar(cal);
                    cr.setText(df.format(cal.getTime()));
                }
                if (isSelected) {
                    cr.setBackground(Color.LIGHT_GRAY);
                }
                return cr;
            }
        });
        this.table.setDefaultRenderer(SchemaElement.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
                if (value != null) {
                    ISchemaElement se = (ISchemaElement)value;
                    cr.setText(se.getDisplayName());
                }
                if (isSelected) {
                    cr.setBackground(Color.LIGHT_GRAY);
                }
                return cr;
            }
        });
        this.table.setDefaultRenderer(Object.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
                if (value != null) {
                    cr.setText(value.toString());
                }
                if (isSelected) {
                    cr.setBackground(Color.LIGHT_GRAY);
                }
                return cr;
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    ISchemaElement element;
                    int x = e.getX();
                    int y = e.getY();
                    MouseEvent c = SwingUtilities.convertMouseEvent(TableView.this.table, e, TableView.this.observationManager);
                    Point p = new Point(c.getX(), c.getY());
                    int row = TableView.this.table.getSelectedRow();
                    if (TableView.this.sorter.isSorting()) {
                        row = TableView.this.sorter.modelIndex(row);
                    }
                    if ((element = ((AbstractSchemaTableModel)TableView.this.table.getModel()).getSchemaElement(row)) != null) {
                        new PopupMenuHandler(TableView.this.observationManager, element, p.x, p.y, 126, -1, TableView.this.observationManager.getExtensionLoader().getPopupMenus());
                    }
                }
            }
        };
        this.table.addMouseListener(ml);
        this.loadSettings();
    }

    public void showObservations(IObservation selected, ISchemaElement parentElement) {
        this.saveCurrentTableModelSettings();
        IObservation[] obs = null;
        if (parentElement == null) {
            obs = this.observationManager.getXmlCache().getObservations();
            this.parentElement = null;
        } else {
            IObservation[] coObserver;
            obs = this.observationManager.getXmlCache().getObservations(parentElement);
            if (parentElement instanceof IObserver && (coObserver = this.observationManager.getXmlCache().getCoObserverObservations((IObserver)parentElement)) != null) {
                ArrayList<IObservation> obsList = new ArrayList<IObservation>(Arrays.asList(obs));
                int coObsLength = coObserver.length;
                for (int j = 0; j < coObserver.length; ++j) {
                    if (!obsList.contains(coObserver[j])) {
                        obsList.add(coObserver[j]);
                        continue;
                    }
                    --coObsLength;
                }
                obs = obsList.toArray(new IObservation[0]);
            }
            this.parentElement = parentElement;
        }
        if (obs != null && obs.length > 0) {
            this.sorter.setTableModel(new ObservationTableModel(obs, this.observationManager), true);
            this.model = this.sorter;
            this.sorter.setTableHeader(this.table.getTableHeader());
            this.updateTable((ISchemaElement)selected);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TableView.this.table.setModel(new ObservationTableModel(null, TableView.this.observationManager));
                }
            });
            this.observationManager.getItemView().clear();
        }
        this.loadCurrentTableModelSettings();
    }

    public void showObservers(IObserver selected) {
        this.saveCurrentTableModelSettings();
        IObserver[] obs = this.observationManager.getXmlCache().getObservers();
        if (obs != null && obs.length > 0) {
            this.sorter.setTableModel(new ObserverTableModel(obs), true);
            this.model = this.sorter;
            this.sorter.setTableHeader(this.table.getTableHeader());
            this.updateTable((ISchemaElement)selected);
        } else {
            this.table.setModel(new ObserverTableModel(null));
            this.observationManager.getItemView().clear();
        }
        this.loadCurrentTableModelSettings();
    }

    public void showTargets(ITarget selected) {
        this.saveCurrentTableModelSettings();
        ITarget[] targets = this.observationManager.getXmlCache().getTargets();
        if (targets != null && targets.length > 0) {
            this.sorter.setTableModel(new TargetTableModel(targets, this.observationManager), true);
            this.model = this.sorter;
            this.sorter.setTableHeader(this.table.getTableHeader());
            this.updateTable((ISchemaElement)selected);
        } else {
            this.table.setModel(new TargetTableModel(null, this.observationManager));
            this.observationManager.getItemView().clear();
        }
        this.loadCurrentTableModelSettings();
    }

    public void showSites(ISite selected) {
        this.saveCurrentTableModelSettings();
        ISite[] sites = this.observationManager.getXmlCache().getSites();
        if (sites != null && sites.length > 0) {
            this.sorter.setTableModel(new SiteTableModel(sites), true);
            this.model = this.sorter;
            this.sorter.setTableHeader(this.table.getTableHeader());
            this.updateTable((ISchemaElement)selected);
        } else {
            this.table.setModel(new SiteTableModel(null));
            this.observationManager.getItemView().clear();
        }
        this.loadCurrentTableModelSettings();
    }

    public void showScopes(IScope selected) {
        this.saveCurrentTableModelSettings();
        IScope[] scopes = this.observationManager.getXmlCache().getScopes();
        if (scopes != null && scopes.length > 0) {
            this.sorter.setTableModel(new ScopeTableModel(scopes), true);
            this.model = this.sorter;
            this.sorter.setTableHeader(this.table.getTableHeader());
            this.updateTable((ISchemaElement)selected);
        } else {
            this.table.setModel(new ScopeTableModel(null));
            this.observationManager.getItemView().clear();
        }
        this.loadCurrentTableModelSettings();
    }

    public void showSessions(ISession selected) {
        this.saveCurrentTableModelSettings();
        ISession[] session = this.observationManager.getXmlCache().getSessions();
        if (session != null && session.length > 0) {
            this.sorter.setTableModel(new SessionTableModel(session), true);
            this.model = this.sorter;
            this.sorter.setTableHeader(this.table.getTableHeader());
            this.updateTable((ISchemaElement)selected);
        } else {
            this.table.setModel(new SessionTableModel(null));
            this.observationManager.getItemView().clear();
        }
        this.loadCurrentTableModelSettings();
    }

    public void showImagers(IImager selected) {
        this.saveCurrentTableModelSettings();
        IImager[] imager = this.observationManager.getXmlCache().getImagers();
        if (imager != null && imager.length > 0) {
            this.sorter.setTableModel(new ImagerTableModel(imager), true);
            this.model = this.sorter;
            this.sorter.setTableHeader(this.table.getTableHeader());
            this.updateTable((ISchemaElement)selected);
        } else {
            this.table.setModel(new ImagerTableModel(null));
            this.observationManager.getItemView().clear();
        }
        this.loadCurrentTableModelSettings();
    }

    public void showFilters(IFilter selected) {
        this.saveCurrentTableModelSettings();
        IFilter[] filter = this.observationManager.getXmlCache().getFilters();
        if (filter != null && filter.length > 0) {
            this.sorter.setTableModel(new FilterTableModel(filter), true);
            this.model = this.sorter;
            this.sorter.setTableHeader(this.table.getTableHeader());
            this.updateTable((ISchemaElement)selected);
        } else {
            this.table.setModel(new FilterTableModel(null));
            this.observationManager.getItemView().clear();
        }
        this.loadCurrentTableModelSettings();
    }

    public void showEyepieces(IEyepiece selected) {
        this.saveCurrentTableModelSettings();
        IEyepiece[] eyepiece = this.observationManager.getXmlCache().getEyepieces();
        if (eyepiece != null && eyepiece.length > 0) {
            this.sorter.setTableModel(new EyepieceTableModel(eyepiece), true);
            this.model = this.sorter;
            this.sorter.setTableHeader(this.table.getTableHeader());
            this.updateTable((ISchemaElement)selected);
        } else {
            this.table.setModel(new EyepieceTableModel(null));
            this.observationManager.getItemView().clear();
        }
        this.loadCurrentTableModelSettings();
    }

    public void showLenses(ILens selected) {
        this.saveCurrentTableModelSettings();
        ILens[] lens = this.observationManager.getXmlCache().getLenses();
        if (lens != null && lens.length > 0) {
            this.sorter.setTableModel(new LensTableModel(lens), true);
            this.model = this.sorter;
            this.sorter.setTableHeader(this.table.getTableHeader());
            this.updateTable((ISchemaElement)selected);
        } else {
            this.table.setModel(new LensTableModel(null));
            this.observationManager.getItemView().clear();
        }
        this.loadCurrentTableModelSettings();
    }

    public ISchemaElement getSelectedElement() {
        return this.selectedElement;
    }

    public void reloadLanguage() {
        AbstractSchemaTableModel.reloadLanguage();
    }

    void saveSettings() {
        this.saveCurrentTableModelSettings();
        Configuration config = this.observationManager.getConfiguration();
        Map cache = this.observationManager.getUIDataCache();
        Iterator iterator = cache.keySet().iterator();
        String currentKey = null;
        while (iterator.hasNext()) {
            currentKey = (String)iterator.next();
            if (!currentKey.startsWith(CONFIG_TABLESETTINGS_PREFIX)) continue;
            config.setConfig(currentKey, "" + (Integer)cache.get(currentKey));
        }
    }

    void loadSettings() {
        Configuration config = this.observationManager.getConfiguration();
        Map cache = this.observationManager.getUIDataCache();
        Set set = config.getConfigKeys();
        Iterator iterator = set.iterator();
        String currentKey = null;
        while (iterator.hasNext()) {
            currentKey = (String)iterator.next();
            if (!currentKey.startsWith(CONFIG_TABLESETTINGS_PREFIX)) continue;
            cache.put(currentKey, new Integer(Integer.parseInt(config.getConfig(currentKey))));
        }
        this.loadCurrentTableModelSettings();
    }

    private void updateItemView(ISchemaElement se) {
        if (se != null) {
            if (se instanceof IObservation) {
                this.observationManager.getItemView().showObservation((IObservation)se);
            } else if (se instanceof ITarget) {
                this.observationManager.getItemView().showTarget((ITarget)se, null);
            } else if (se instanceof ISite) {
                this.observationManager.getItemView().showSite((ISite)se);
            } else if (se instanceof IScope) {
                this.observationManager.getItemView().showScope((IScope)se);
            } else if (se instanceof ISession) {
                this.observationManager.getItemView().showSession((ISession)se);
            } else if (se instanceof IObserver) {
                this.observationManager.getItemView().showObserver((IObserver)se);
            } else if (se instanceof IFilter) {
                this.observationManager.getItemView().showFilter((IFilter)se);
            } else if (se instanceof IEyepiece) {
                this.observationManager.getItemView().showEyepiece((IEyepiece)se);
            } else if (se instanceof IImager) {
                this.observationManager.getItemView().showImager((IImager)se);
            } else if (se instanceof ILens) {
                this.observationManager.getItemView().showLens((ILens)se);
            }
        }
    }

    private void updateTable(ISchemaElement selected) {
        final ISchemaElement finalSelected = selected;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TableView.this.table.setModel(TableView.this.model);
                int sel = TableView.this.model.getRow(finalSelected);
                if (TableView.this.sorter.isSorting()) {
                    sel = TableView.this.sorter.viewIndex(sel);
                }
                TableView.this.selectedElement = finalSelected;
                TableView.this.table.setRowSelectionInterval(sel, sel);
                JViewport viewport = TableView.this.scrollTable.getViewport();
                Rectangle rect = TableView.this.table.getCellRect(sel, sel, true);
                Rectangle viewRect = viewport.getViewRect();
                rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
                int centerX = (viewRect.width - rect.width) / 2;
                int centerY = (viewRect.height - rect.height) / 2;
                if (rect.x < centerX) {
                    centerX = -centerX;
                }
                if (rect.y < centerY) {
                    centerY = -centerY;
                }
                rect.translate(centerX, centerY);
                viewport.scrollRectToVisible(rect);
            }
        });
    }

    private void saveCurrentTableModelSettings() {
        String currentTableModelID = null;
        currentTableModelID = this.sorter != null && this.sorter.getTableModel() != null ? this.sorter.getTableModel().getID() : this.model.getID();
        TableColumnModel tcm = this.table.getColumnModel();
        Enumeration<TableColumn> en = tcm.getColumns();
        TableColumn current = null;
        while (en.hasMoreElements()) {
            current = en.nextElement();
            int preferedWidth = current.getPreferredWidth();
            this.observationManager.getUIDataCache().put(CONFIG_TABLESETTINGS_PREFIX + currentTableModelID + "." + current.getModelIndex(), new Integer(preferedWidth));
        }
    }

    private void loadCurrentTableModelSettings() {
        String currentTableModelID = null;
        currentTableModelID = this.sorter != null && this.sorter.getTableModel() != null ? this.sorter.getTableModel().getID() : this.model.getID();
        TableColumnModel tcm = this.table.getColumnModel();
        Enumeration<TableColumn> en = tcm.getColumns();
        TableColumn current = null;
        Object o = null;
        while (en.hasMoreElements()) {
            current = en.nextElement();
            o = this.observationManager.getUIDataCache().get(CONFIG_TABLESETTINGS_PREFIX + currentTableModelID + "." + current.getModelIndex());
            if (o == null) break;
            int preferedWidth = o;
            current.setPreferredWidth(preferedWidth);
        }
    }
}

