/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation;

import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.navigation.PopupMenuHandler;
import de.lehmannet.om.ui.navigation.SchemaElementMutableTreeNode;
import de.lehmannet.om.ui.navigation.SchemaElementTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeView
extends JPanel
implements TreeSelectionListener {
    private PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager observationManager = null;
    private JTree tree = null;
    private JScrollPane scrollTree = null;
    DefaultMutableTreeNode root = null;
    DefaultMutableTreeNode eyepiece = null;
    DefaultMutableTreeNode imager = null;
    DefaultMutableTreeNode filter = null;
    DefaultMutableTreeNode scope = null;
    DefaultMutableTreeNode site = null;
    DefaultMutableTreeNode target = null;
    DefaultMutableTreeNode observer = null;
    DefaultMutableTreeNode session = null;
    DefaultMutableTreeNode observation = null;
    DefaultMutableTreeNode lens = null;
    private HashMap nodes = new HashMap();
    SchemaElementMutableTreeNode lastSelected = null;

    public TreeView(ObservationManager om) {
        this.observationManager = om;
        this.root = new DefaultMutableTreeNode(this.bundle.getString("treeRoot"));
        this.observation = new DefaultMutableTreeNode(this.bundle.getString("tree.observations"));
        this.target = new DefaultMutableTreeNode(this.bundle.getString("targets"));
        this.scope = new DefaultMutableTreeNode(this.bundle.getString("scopes"));
        this.imager = new DefaultMutableTreeNode(this.bundle.getString("imagers"));
        this.filter = new DefaultMutableTreeNode(this.bundle.getString("filters"));
        this.eyepiece = new DefaultMutableTreeNode(this.bundle.getString("eyepieces"));
        this.lens = new DefaultMutableTreeNode(this.bundle.getString("lenses"));
        this.site = new DefaultMutableTreeNode(this.bundle.getString("sites"));
        this.session = new DefaultMutableTreeNode(this.bundle.getString("sessions"));
        this.observer = new DefaultMutableTreeNode(this.bundle.getString("observers"));
        this.root.add(this.observation);
        this.root.add(this.target);
        this.root.add(this.scope);
        this.root.add(this.imager);
        this.root.add(this.eyepiece);
        this.root.add(this.lens);
        this.root.add(this.filter);
        this.root.add(this.site);
        this.root.add(this.session);
        this.root.add(this.observer);
        this.initTree();
        this.tree = new JTree(this.root);
        this.tree.setCellRenderer(new SchemaElementTreeCellRenderer(this, this.observationManager));
        this.tree.addTreeSelectionListener(this);
        this.tree.setExpandsSelectedPaths(true);
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    int x = e.getX();
                    int y = e.getY();
                    MouseEvent c = SwingUtilities.convertMouseEvent(TreeView.this.tree, e, TreeView.this.observationManager);
                    Point p = new Point(c.getX(), c.getY());
                    int selRow = TreeView.this.tree.getRowForLocation(x, y);
                    TreePath selPath = TreeView.this.tree.getPathForLocation(e.getX(), e.getY());
                    TreeView.this.tree.setSelectionPath(selPath);
                    if (selRow != -1 && e.getClickCount() == 1) {
                        Object node = selPath.getLastPathComponent();
                        if (node instanceof SchemaElementMutableTreeNode) {
                            ISchemaElement element = ((SchemaElementMutableTreeNode)node).getSchemaElement();
                            new PopupMenuHandler(TreeView.this.observationManager, element, p.x, p.y, 126, -1, TreeView.this.observationManager.getExtensionLoader().getPopupMenus());
                        } else if (node instanceof DefaultMutableTreeNode) {
                            int type = -1;
                            Object o = selPath.getLastPathComponent();
                            if (o.equals(((TreeView)TreeView.this).observationManager.getTreeView().eyepiece)) {
                                type = 0;
                            } else if (o.equals(((TreeView)TreeView.this).observationManager.getTreeView().scope)) {
                                type = 1;
                            } else if (o.equals(((TreeView)TreeView.this).observationManager.getTreeView().observation)) {
                                type = 2;
                            } else if (o.equals(((TreeView)TreeView.this).observationManager.getTreeView().imager)) {
                                type = 3;
                            } else if (o.equals(((TreeView)TreeView.this).observationManager.getTreeView().site)) {
                                type = 4;
                            } else if (o.equals(((TreeView)TreeView.this).observationManager.getTreeView().session)) {
                                type = 5;
                            } else if (o.equals(((TreeView)TreeView.this).observationManager.getTreeView().observer)) {
                                type = 6;
                            } else if (o.equals(((TreeView)TreeView.this).observationManager.getTreeView().target)) {
                                type = 7;
                            } else if (o.equals(((TreeView)TreeView.this).observationManager.getTreeView().filter)) {
                                type = 8;
                            } else if (o.equals(((TreeView)TreeView.this).observationManager.getTreeView().lens)) {
                                type = 9;
                            }
                            new PopupMenuHandler(TreeView.this.observationManager, null, p.x, p.y, 1, type, null);
                        }
                    }
                }
            }
        };
        this.tree.addMouseListener(ml);
        super.setLayout(new BorderLayout());
        this.scrollTree = new JScrollPane(this.tree);
        super.add(this.scrollTree);
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        ISchemaElement element = null;
        if (node != null && !(node instanceof SchemaElementMutableTreeNode)) {
            TreePath tp = new TreePath(node.getPath());
            if (node.getParent() == null) {
                return;
            }
            TreePath ptp = new TreePath(node.getParent());
            if (this.tree.isExpanded(ptp)) {
                this.tree.collapsePath(tp);
            } else {
                this.tree.expandPath(tp);
                node = node.getFirstLeaf();
                this.tree.setSelectionPath(new TreePath(node.getPath()));
            }
        }
        if (node != null && node instanceof SchemaElementMutableTreeNode) {
            element = ((SchemaElementMutableTreeNode)node).getSchemaElement();
            ISchemaElement parentElement = null;
            if (node.getParent() instanceof SchemaElementMutableTreeNode) {
                parentElement = ((SchemaElementMutableTreeNode)node.getParent()).getSchemaElement();
            }
            this.observationManager.updateRight(element, parentElement);
            this.lastSelected = (SchemaElementMutableTreeNode)node;
        }
    }

    public void updateTree() {
        String rootName = this.bundle.getString("treeRoot");
        String[] fileNames = this.observationManager.getXmlCache().getAllOpenedFiles();
        if (fileNames != null && fileNames.length > 0) {
            rootName = new File(fileNames[0]).getName();
        }
        this.root.setUserObject(rootName);
        this.observation.removeAllChildren();
        this.target.removeAllChildren();
        this.scope.removeAllChildren();
        this.eyepiece.removeAllChildren();
        this.imager.removeAllChildren();
        this.filter.removeAllChildren();
        this.site.removeAllChildren();
        this.session.removeAllChildren();
        this.observer.removeAllChildren();
        this.lens.removeAllChildren();
        this.initTree();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TreeView.this.tree.updateUI();
            }
        });
    }

    public void setSelection(ISchemaElement element, ISchemaElement parentElement) {
        SchemaElementMutableTreeNode current;
        TreePath tp = null;
        if (parentElement != null) {
            if (this.nodes.containsKey(parentElement)) {
                SchemaElementMutableTreeNode current2 = (SchemaElementMutableTreeNode)this.nodes.get(parentElement);
                ISchemaElement currentSE = null;
                for (int i = 0; i < current2.getChildCount(); ++i) {
                    currentSE = ((SchemaElementMutableTreeNode)current2.getChildAt(i)).getSchemaElement();
                    if (!element.equals(currentSE)) continue;
                    TreePath newPath = new TreePath(((SchemaElementMutableTreeNode)current2.getChildAt(i)).getPath());
                    if (this.tree.getSelectionPath().equals(newPath)) continue;
                    this.tree.setSelectionPath(newPath);
                    this.scrollTree(newPath);
                    return;
                }
                tp = new TreePath(current2.getPath());
                this.tree.setSelectionPath(tp);
            }
        } else if (this.nodes.containsKey(element) && (current = (SchemaElementMutableTreeNode)this.nodes.get(element)).getSchemaElement().equals(element)) {
            tp = new TreePath(current.getPath());
            this.tree.setSelectionPath(tp);
        }
        this.scrollTree(tp);
    }

    private void scrollTree(TreePath tp) {
        JViewport viewport = this.scrollTree.getViewport();
        Rectangle rect = this.tree.getRowBounds(this.tree.getRowForPath(tp));
        if (rect == null) {
            return;
        }
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        viewport.scrollRectToVisible(rect);
    }

    private void initTree() {
        IObservation[] elements = this.observationManager.getXmlCache().getObservations();
        this.addSchemaElements((ISchemaElement[])elements, this.observation);
        if (elements.length > 0) {
            this.observation.setUserObject(this.bundle.getString("tree.observations") + " (" + elements.length + ")");
        } else {
            this.observation.setUserObject(this.bundle.getString("tree.observations"));
        }
        elements = this.observationManager.getXmlCache().getTargets();
        this.addSchemaElements((ISchemaElement[])elements, this.target);
        if (elements.length > 0) {
            this.target.setUserObject(this.bundle.getString("targets") + " (" + elements.length + ")");
        } else {
            this.target.setUserObject(this.bundle.getString("targets"));
        }
        elements = this.observationManager.getXmlCache().getScopes();
        this.addSchemaElements((ISchemaElement[])elements, this.scope);
        if (elements.length > 0) {
            this.scope.setUserObject(this.bundle.getString("scopes") + " (" + elements.length + ")");
        } else {
            this.scope.setUserObject(this.bundle.getString("scopes"));
        }
        elements = this.observationManager.getXmlCache().getImagers();
        this.addSchemaElements((ISchemaElement[])elements, this.imager);
        if (elements.length > 0) {
            this.imager.setUserObject(this.bundle.getString("imagers") + " (" + elements.length + ")");
        } else {
            this.imager.setUserObject(this.bundle.getString("imagers"));
        }
        elements = this.observationManager.getXmlCache().getEyepieces();
        this.addSchemaElements((ISchemaElement[])elements, this.eyepiece);
        if (elements.length > 0) {
            this.eyepiece.setUserObject(this.bundle.getString("eyepieces") + " (" + elements.length + ")");
        } else {
            this.eyepiece.setUserObject(this.bundle.getString("eyepieces"));
        }
        elements = this.observationManager.getXmlCache().getFilters();
        this.addSchemaElements((ISchemaElement[])elements, this.filter);
        if (elements.length > 0) {
            this.filter.setUserObject(this.bundle.getString("filters") + " (" + elements.length + ")");
        } else {
            this.filter.setUserObject(this.bundle.getString("filters"));
        }
        elements = this.observationManager.getXmlCache().getSites();
        this.addSchemaElements((ISchemaElement[])elements, this.site);
        if (elements.length > 0) {
            this.site.setUserObject(this.bundle.getString("sites") + " (" + elements.length + ")");
        } else {
            this.site.setUserObject(this.bundle.getString("sites"));
        }
        elements = this.observationManager.getXmlCache().getSessions();
        this.addSchemaElements((ISchemaElement[])elements, this.session);
        if (elements.length > 0) {
            this.session.setUserObject(this.bundle.getString("sessions") + " (" + elements.length + ")");
        } else {
            this.session.setUserObject(this.bundle.getString("sessions"));
        }
        elements = this.observationManager.getXmlCache().getObservers();
        this.addSchemaElements((ISchemaElement[])elements, this.observer);
        if (elements.length > 0) {
            this.observer.setUserObject(this.bundle.getString("observers") + " (" + elements.length + ")");
        } else {
            this.observer.setUserObject(this.bundle.getString("observers"));
        }
        elements = this.observationManager.getXmlCache().getLenses();
        this.addSchemaElements((ISchemaElement[])elements, this.lens);
        if (elements.length > 0) {
            this.lens.setUserObject(this.bundle.getString("lenses") + " (" + elements.length + ")");
        } else {
            this.lens.setUserObject(this.bundle.getString("lenses"));
        }
    }

    private void addSchemaElements(ISchemaElement[] elements, DefaultMutableTreeNode node) {
        SchemaElementMutableTreeNode current = null;
        for (int x = 0; x < elements.length; ++x) {
            IObservation[] observations;
            current = new SchemaElementMutableTreeNode(elements[x]);
            if (!(elements[x] instanceof IObservation) && (observations = this.observationManager.getXmlCache().getObservations(elements[x])) != null) {
                if (elements[x] instanceof IObserver) {
                    IObservation[] coObserver = this.observationManager.getXmlCache().getCoObserverObservations((IObserver)elements[x]);
                    if (coObserver != null) {
                        ArrayList<IObservation> obs = new ArrayList<IObservation>(Arrays.asList(observations));
                        int coObsLength = coObserver.length;
                        for (int j = 0; j < coObserver.length; ++j) {
                            if (!obs.contains(coObserver[j])) {
                                obs.add(coObserver[j]);
                                continue;
                            }
                            --coObsLength;
                        }
                        observations = obs.toArray(new IObservation[0]);
                        current.setSize(observations.length - coObsLength, coObsLength);
                    } else {
                        current.setSize(observations.length, -1);
                    }
                } else {
                    current.setSize(observations.length, -1);
                }
                for (int i = 0; i < observations.length; ++i) {
                    current.add(new SchemaElementMutableTreeNode((ISchemaElement)observations[i], -1));
                }
            }
            this.nodes.put(elements[x], current);
            node.add(current);
        }
    }
}

