/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.panel;

import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IFinding;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.Observation;
import de.lehmannet.om.SurfaceBrightness;
import de.lehmannet.om.ui.box.AbstractBox;
import de.lehmannet.om.ui.box.EyepieceBox;
import de.lehmannet.om.ui.box.FilterBox;
import de.lehmannet.om.ui.box.ImagerBox;
import de.lehmannet.om.ui.box.LensBox;
import de.lehmannet.om.ui.box.ObserverBox;
import de.lehmannet.om.ui.box.ScopeBox;
import de.lehmannet.om.ui.box.SessionBox;
import de.lehmannet.om.ui.box.SiteBox;
import de.lehmannet.om.ui.box.TargetBox;
import de.lehmannet.om.ui.container.ImageContainer;
import de.lehmannet.om.ui.container.SurfaceBrightnessContainer;
import de.lehmannet.om.ui.container.TimeContainer;
import de.lehmannet.om.ui.dialog.CatalogDialog;
import de.lehmannet.om.ui.dialog.EyepieceDialog;
import de.lehmannet.om.ui.dialog.FilterDialog;
import de.lehmannet.om.ui.dialog.IImagerDialog;
import de.lehmannet.om.ui.dialog.ITargetDialog;
import de.lehmannet.om.ui.dialog.LensDialog;
import de.lehmannet.om.ui.dialog.ObserverDialog;
import de.lehmannet.om.ui.dialog.ScopeDialog;
import de.lehmannet.om.ui.dialog.SessionDialog;
import de.lehmannet.om.ui.dialog.SiteDialog;
import de.lehmannet.om.ui.extension.SchemaUILoader;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.panel.AbstractPanel;
import de.lehmannet.om.ui.panel.IFindingPanel;
import de.lehmannet.om.ui.panel.SeeingBoxEntry;
import de.lehmannet.om.ui.util.Configuration;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.DatePicker;
import de.lehmannet.om.ui.util.ExtenableSchemaElementSelector;
import de.lehmannet.om.ui.util.OMLabel;
import de.lehmannet.om.util.FloatUtil;
import de.lehmannet.om.util.OpticsUtil;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class ObservationDialogPanel
extends AbstractPanel
implements ActionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = -6652173787359719576L;
    private static final String CACHEKEY_STARTDATE = "ObservationDialogPanel.startdate";
    private static final String CACHEKEY_OBSERVER = "ObservationDialogPanel.observer";
    private static final String CACHEKEY_SESSION = "ObservationDialogPanel.session";
    private static final String CACHEKEY_SCOPE = "ObservationDialogPanel.scope";
    private static final String CACHEKEY_SITE = "ObservationDialogPanel.site";
    private static final String CACHEKEY_ENDDATE = "ObservationDialogPanel.enddate";
    private static final String CACHEKEY_FAINTESTSTAR = "ObservationDialogPanel.fainteststar";
    private static final String CACHEKEY_SQM = "ObservationDialogPanel.sqmValue";
    private static final String CACHEKEY_SEEING = "ObservationDialogPanel.seeing";
    private static final String CACHEKEY_ACCESSORIES = "ObservationDialogPanel.accessories";
    public static final String CACHEKEY_LASTIMAGEDIR = "ObservationDialogPanel.lastImageDir";
    private ObservationManager observationManager = null;
    private IObservation observation = null;
    private Map cache = null;
    private JTabbedPane tabbedPane = null;
    private JPanel selectionPanel = null;
    private AbstractPanel findingsPanel = null;
    private ObserverBox observerBox = new ObserverBox();
    private JButton newObserver = null;
    private TargetBox targetBox = new TargetBox();
    private JButton newTarget = null;
    private JButton selectTarget = null;
    private SessionBox sessionBox = new SessionBox();
    private JButton newSession = null;
    private ScopeBox scopeBox = new ScopeBox();
    private JButton newScope = null;
    private OMLabel LeyepieceName = null;
    private EyepieceBox eyepieceBox = new EyepieceBox();
    private JSlider eyepieceFLSlider = new JSlider(0);
    private JButton newEyepiece = null;
    private LensBox lensBox = new LensBox();
    private JButton newLens = null;
    private FilterBox filterBox = new FilterBox();
    private JButton newFilter = null;
    private SiteBox siteBox = new SiteBox();
    private JButton newSite = null;
    private ImagerBox imagerBox = new ImagerBox();
    private JButton newImager = null;
    private ImageContainer imageContainer = null;
    private JButton newImage = null;
    private JTextField begin = null;
    private Calendar beginDate = null;
    private JButton beginPicker = null;
    private TimeContainer beginTime = null;
    private JButton beginNow = null;
    private JTextField end = null;
    private Calendar endDate = null;
    private JButton endPicker = null;
    private TimeContainer endTime = null;
    private JButton endNow = null;
    private JButton clearEndDateAndTime = null;
    private JTextField faintestStar = null;
    private SurfaceBrightnessContainer sqmValue = null;
    private JTextField magnification = null;
    private JComboBox seeing = null;
    private JTextField accessories = null;

    public ObservationDialogPanel(ObservationManager om, IObservation observation, ISchemaElement se) {
        super(true);
        super.setVisible(true);
        this.observationManager = om;
        this.observation = observation;
        this.cache = this.observationManager.getUIDataCache();
        this.tabbedPane = new JTabbedPane(1);
        this.fillLists(false);
        this.createPanel();
        if (this.observation != null) {
            this.loadSchemaElement();
        } else if (this.cache != null) {
            this.loadFromCache();
        }
        if (se != null) {
            if (se instanceof ISession) {
                this.sessionBox.setSelectedItem(se);
            } else if (se instanceof IObserver) {
                this.observerBox.setSelectedItem(se);
            } else if (se instanceof ITarget) {
                this.targetBox.addItem(se);
                this.setFindingPanel((ITarget)se);
            } else if (se instanceof IScope) {
                this.scopeBox.setSelectedItem(se);
            } else if (se instanceof IEyepiece) {
                this.eyepieceBox.setSelectedItem(se);
            } else if (se instanceof ILens) {
                this.lensBox.setSelectedItem(se);
            } else if (se instanceof IFilter) {
                this.filterBox.setSelectedItem(se);
            } else if (se instanceof ISite) {
                this.siteBox.setSelectedItem(se);
            } else if (se instanceof IImager) {
                this.imagerBox.setSelectedItem(se);
            } else if (se instanceof IObservation) {
                IObservation o = (IObservation)se;
                if (o.getAccessories() != null) {
                    this.accessories.setText(o.getAccessories());
                }
                if (o.getEyepiece() != null) {
                    this.eyepieceBox.setSelectedItem((ISchemaElement)o.getEyepiece());
                }
                if (!Float.isNaN(o.getFaintestStar())) {
                    this.faintestStar.setText("" + o.getFaintestStar());
                }
                if (o.getFilter() != null) {
                    this.filterBox.setSelectedItem((ISchemaElement)o.getFilter());
                }
                if (o.getImager() != null) {
                    this.imagerBox.setSelectedItem((ISchemaElement)o.getImager());
                }
                if (o.getLens() != null) {
                    this.lensBox.setSelectedItem((ISchemaElement)o.getLens());
                }
                if (o.getObserver() != null) {
                    this.observerBox.setSelectedItem((ISchemaElement)o.getObserver());
                }
                if (o.getScope() != null) {
                    this.scopeBox.setSelectedItem((ISchemaElement)o.getScope());
                }
                if (o.getSeeing() != -1) {
                    this.seeing.setSelectedIndex(o.getSeeing());
                }
                if (o.getSite() != null) {
                    this.siteBox.setSelectedItem((ISchemaElement)o.getSite());
                }
                if (o.getSession() != null) {
                    this.sessionBox.setSelectedItem((ISchemaElement)o.getSession());
                }
                if (o.getTarget() != null) {
                    this.targetBox.addItem((ISchemaElement)o.getTarget());
                    this.setFindingPanel(o.getTarget());
                }
                if (o.getSkyQuality() != null) {
                    this.sqmValue.setSurfaceBrightness(o.getSkyQuality());
                }
            }
        }
    }

    public ISchemaElement getSchemaElement() {
        return this.observation;
    }

    public ISchemaElement updateSchemaElement() {
        ISession session;
        if (this.observation == null) {
            return null;
        }
        IFinding finding = (IFinding)this.findingsPanel.updateSchemaElement();
        if (finding == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noFinding"));
            return null;
        }
        ITarget target = this.getTarget();
        if (target == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noTarget"));
            return null;
        }
        IObserver observer = this.getObserver();
        if (observer == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noObserver"));
            return null;
        }
        if (!this.beginTime.checkTime()) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.wrongStartTime"));
            return null;
        }
        if (!this.endTime.checkTime()) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.wrongEndTime"));
            return null;
        }
        if (this.beginDate == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noStartTime"));
            return null;
        }
        this.observation.setResult(finding);
        this.observation.setTarget(target);
        this.observation.setObserver(observer);
        this.cache.put(CACHEKEY_OBSERVER, observer);
        this.beginDate.set(11, this.beginTime.getHour());
        this.beginDate.set(12, this.beginTime.getMinutes());
        this.beginDate.set(13, this.beginTime.getSeconds());
        ISite site = (ISite)this.siteBox.getSelectedSchemaElement();
        if (site == null && (session = (ISession)this.sessionBox.getSelectedSchemaElement()) != null) {
            site = session.getSite();
        }
        TimeZone tz = null;
        tz = site != null ? new SimpleTimeZone(site.getTimezone() * 60 * 1000, site.getName()) : SimpleTimeZone.getDefault();
        this.beginDate.setTimeZone(tz);
        this.observation.setBegin(this.beginDate);
        this.cache.put(CACHEKEY_STARTDATE, this.beginDate);
        this.cache.put(CACHEKEY_ENDDATE, null);
        if (this.endDate != null) {
            this.endDate.set(11, this.endTime.getHour());
            this.endDate.set(12, this.endTime.getMinutes());
            this.endDate.set(13, this.endTime.getSeconds());
            if (tz != null) {
                this.endDate.setTimeZone(tz);
            }
            if (this.endDate.before(this.beginDate)) {
                this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.endBeforeStart"));
                return null;
            }
            this.cache.put(CACHEKEY_ENDDATE, this.endDate);
            this.observation.setEnd(this.endDate);
        } else {
            this.observation.setEnd(null);
        }
        this.cache.put(CACHEKEY_SESSION, null);
        try {
            ISession session2 = (ISession)this.sessionBox.getSelectedSchemaElement();
            if (session2 != null && session2.getCoObservers() != null && !session2.getCoObservers().isEmpty() && session2.getCoObservers().contains(observer)) {
                JOptionPane pane = new JOptionPane(AbstractPanel.bundle.getString("panel.observation.warning.coObserverIsObserver"), 3, 0);
                JDialog dialog = pane.createDialog(this, AbstractPanel.bundle.getString("panel.observation.warning.coObserverIsObserver.title"));
                dialog.setVisible(true);
                Object selectedValue = pane.getValue();
                if (selectedValue != null && selectedValue instanceof Integer && (Integer)selectedValue == 1) {
                    return null;
                }
            }
            this.observation.setSession((ISession)this.sessionBox.getSelectedSchemaElement());
            this.cache.put(CACHEKEY_SESSION, (ISession)this.sessionBox.getSelectedSchemaElement());
        }
        catch (IllegalArgumentException iae) {
            super.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.wrongTimeForSession"));
            return null;
        }
        this.cache.put(CACHEKEY_SCOPE, null);
        this.observation.setScope((IScope)this.scopeBox.getSelectedSchemaElement());
        this.cache.put(CACHEKEY_SCOPE, (IScope)this.scopeBox.getSelectedSchemaElement());
        this.observation.setEyepiece((IEyepiece)this.eyepieceBox.getSelectedSchemaElement());
        this.observation.setFilter((IFilter)this.filterBox.getSelectedSchemaElement());
        this.cache.put(CACHEKEY_SITE, null);
        this.observation.setSite(site);
        this.cache.put(CACHEKEY_SITE, site);
        this.observation.setImager((IImager)this.imagerBox.getSelectedSchemaElement());
        this.observation.setLens((ILens)this.lensBox.getSelectedSchemaElement());
        this.cache.put(CACHEKEY_FAINTESTSTAR, null);
        String fs = this.faintestStar.getText();
        if (fs != null && !"".equals(fs.trim())) {
            try {
                float faintest = FloatUtil.parseFloat((String)fs);
                this.observation.setFaintestStar(faintest);
                this.cache.put(CACHEKEY_FAINTESTSTAR, fs);
            }
            catch (NumberFormatException nfe) {
                this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noNumberFaintestStar"));
                return null;
            }
        } else {
            this.observation.setFaintestStar(Float.NaN);
        }
        this.cache.put(CACHEKEY_SQM, null);
        SurfaceBrightness sqm = null;
        try {
            sqm = this.sqmValue.getSurfaceBrightness();
        }
        catch (NumberFormatException nfe) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noNumberSQM"));
            return null;
        }
        if (sqm != null) {
            this.observation.setSkyQuality(sqm);
            this.cache.put(CACHEKEY_SQM, sqm);
        } else {
            this.observation.setSkyQuality(null);
        }
        String mg = this.magnification.getText();
        if (mg != null && !"".equals(mg.trim())) {
            try {
                float mag = FloatUtil.parseFloat((String)mg);
                this.observation.setMagnification(mag);
            }
            catch (NumberFormatException nfe) {
                this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noNumberMagnitude"));
                return null;
            }
        } else {
            this.observation.setMagnification(Float.NaN);
        }
        this.cache.put(CACHEKEY_SEEING, null);
        SeeingBoxEntry s = (SeeingBoxEntry)this.seeing.getSelectedItem();
        if (s.isEmptyItem()) {
            this.observation.setSeeing(-1);
        } else {
            this.observation.setSeeing(s.getValue());
            this.cache.put(CACHEKEY_SEEING, new Integer(s.getValue()));
        }
        this.observation.setAccessories(this.accessories.getText());
        this.observation.setImages(this.imageContainer.getImages(this.observationManager.getXmlCache().getXMLFileForSchemaElement((ISchemaElement)this.observation)));
        return this.observation;
    }

    public ISchemaElement createSchemaElement() {
        String mg;
        ISession session;
        IFinding finding = this.getFinding();
        if (finding == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noFinding"));
            return null;
        }
        ITarget target = this.getTarget();
        if (target == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noTarget"));
            return null;
        }
        IObserver observer = this.getObserver();
        if (observer == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noObserver"));
            return null;
        }
        if (!this.beginTime.checkTime()) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.wrongStartTime"));
            return null;
        }
        if (!this.endTime.checkTime()) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.wrongEndTime"));
            return null;
        }
        if (this.beginDate == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noStartTime"));
            return null;
        }
        this.beginDate.set(11, this.beginTime.getHour());
        this.beginDate.set(12, this.beginTime.getMinutes());
        this.beginDate.set(13, this.beginTime.getSeconds());
        ISite site = (ISite)this.siteBox.getSelectedSchemaElement();
        if (site == null && (session = (ISession)this.sessionBox.getSelectedSchemaElement()) != null) {
            site = session.getSite();
        }
        TimeZone tz = null;
        tz = site != null ? new SimpleTimeZone(site.getTimezone() * 60 * 1000, site.getName()) : SimpleTimeZone.getDefault();
        this.beginDate.setTimeZone(tz);
        this.observation = new Observation(this.beginDate, target, observer, finding);
        this.cache.put(CACHEKEY_STARTDATE, this.beginDate);
        this.cache.put(CACHEKEY_OBSERVER, observer);
        ISchemaElement se = null;
        this.cache.put(CACHEKEY_ENDDATE, null);
        if (this.endDate != null) {
            this.endDate.set(11, this.endTime.getHour());
            this.endDate.set(12, this.endTime.getMinutes());
            this.endDate.set(13, this.endTime.getSeconds());
            if (tz != null) {
                this.endDate.setTimeZone(tz);
            }
            if (this.endDate.before(this.beginDate)) {
                this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.endBeforeStart"));
                return null;
            }
            this.observation.setEnd(this.endDate);
            this.cache.put(CACHEKEY_ENDDATE, this.endDate);
        } else {
            this.observation.setEnd(null);
        }
        this.cache.put(CACHEKEY_SESSION, null);
        try {
            se = this.sessionBox.getSelectedSchemaElement();
            if (se != null) {
                ISession session2 = (ISession)this.sessionBox.getSelectedSchemaElement();
                if (session2 != null && session2.getCoObservers() != null && !session2.getCoObservers().isEmpty() && session2.getCoObservers().contains(observer)) {
                    JOptionPane pane = new JOptionPane(AbstractPanel.bundle.getString("panel.observation.warning.coObserverIsObserver"), 3, 0);
                    JDialog dialog = pane.createDialog(this, AbstractPanel.bundle.getString("panel.observation.warning.coObserverIsObserver.title"));
                    dialog.setVisible(true);
                    Object selectedValue = pane.getValue();
                    if (selectedValue != null && selectedValue instanceof Integer && (Integer)selectedValue == 1) {
                        return null;
                    }
                }
                this.observation.setSession((ISession)se);
                this.cache.put(CACHEKEY_SESSION, (ISession)se);
            }
        }
        catch (IllegalArgumentException iae) {
            super.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.wrongTimeForSession"));
            return null;
        }
        this.cache.put(CACHEKEY_SCOPE, null);
        se = this.scopeBox.getSelectedSchemaElement();
        if (se != null) {
            this.observation.setScope((IScope)se);
            this.cache.put(CACHEKEY_SCOPE, (IScope)se);
        }
        if ((se = this.eyepieceBox.getSelectedSchemaElement()) != null) {
            this.observation.setEyepiece((IEyepiece)se);
        }
        if ((se = this.lensBox.getSelectedSchemaElement()) != null) {
            this.observation.setLens((ILens)se);
        }
        if ((se = this.filterBox.getSelectedSchemaElement()) != null) {
            this.observation.setFilter((IFilter)se);
        }
        this.cache.put(CACHEKEY_SITE, null);
        se = this.siteBox.getSelectedSchemaElement();
        if (se != null) {
            this.observation.setSite((ISite)se);
            this.cache.put(CACHEKEY_SITE, (ISite)se);
        }
        if ((se = this.imagerBox.getSelectedSchemaElement()) != null) {
            this.observation.setImager((IImager)se);
        }
        String fs = this.faintestStar.getText();
        this.cache.put(CACHEKEY_FAINTESTSTAR, null);
        if (fs != null && !"".equals(fs.trim())) {
            try {
                float faintest = FloatUtil.parseFloat((String)fs);
                this.observation.setFaintestStar(faintest);
                this.cache.put(CACHEKEY_FAINTESTSTAR, fs);
            }
            catch (NumberFormatException nfe) {
                this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noNumberFaintestStar"));
                return null;
            }
        }
        SurfaceBrightness sqm = null;
        try {
            sqm = this.sqmValue.getSurfaceBrightness();
        }
        catch (NumberFormatException nfe) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noNumberSQM"));
            return null;
        }
        this.cache.put(CACHEKEY_SQM, null);
        if (sqm != null) {
            this.observation.setSkyQuality(sqm);
            this.cache.put(CACHEKEY_SQM, sqm);
        }
        if ((mg = this.magnification.getText()) != null && !"".equals(mg.trim())) {
            try {
                float mag = FloatUtil.parseFloat((String)mg);
                this.observation.setMagnification(mag);
            }
            catch (NumberFormatException nfe) {
                this.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noNumberMagnitude"));
                return null;
            }
        }
        SeeingBoxEntry s = (SeeingBoxEntry)this.seeing.getSelectedItem();
        this.cache.put(CACHEKEY_SEEING, null);
        if (s.isEmptyItem()) {
            this.observation.setSeeing(-1);
        } else {
            this.observation.setSeeing(s.getValue());
            this.cache.put(CACHEKEY_SEEING, new Integer(s.getValue()));
        }
        String ac = this.accessories.getText();
        if (ac != null && !"".equals(ac.trim())) {
            this.observation.setAccessories(ac);
            this.cache.put(CACHEKEY_ACCESSORIES, ac);
        }
        this.observation.setImages(this.imageContainer.getImages(this.observationManager.getXmlCache().getXMLFileForSchemaElement((ISchemaElement)this.observation)));
        return this.observation;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            if (source.equals(this.newEyepiece)) {
                EyepieceDialog eyepieceDialog = new EyepieceDialog(this.observationManager, null);
                this.eyepieceBox.addItem((ISchemaElement)eyepieceDialog.getEyepiece());
            } else if (source.equals(this.newObserver)) {
                ObserverDialog observerDialog = new ObserverDialog(this.observationManager, null);
                this.observerBox.addItem((ISchemaElement)observerDialog.getObserver());
            } else if (source.equals(this.newScope)) {
                ScopeDialog scopeDialog = new ScopeDialog(this.observationManager, null);
                this.scopeBox.addItem((ISchemaElement)scopeDialog.getScope());
            } else if (source.equals(this.newFilter)) {
                FilterDialog filterDialog = new FilterDialog(this.observationManager, null);
                this.filterBox.addItem((ISchemaElement)filterDialog.getFilter());
            } else if (source.equals(this.newLens)) {
                LensDialog lensDialog = new LensDialog(this.observationManager, null);
                this.lensBox.addItem((ISchemaElement)lensDialog.getLens());
            } else if (source.equals(this.newSession)) {
                SessionDialog sessionDialog = new SessionDialog(this.observationManager, null);
                this.sessionBox.addItem((ISchemaElement)sessionDialog.getSession());
                this.fillLists(true);
            } else if (source.equals(this.newSite)) {
                SiteDialog siteDialog = new SiteDialog(this.observationManager, null);
                this.siteBox.addItem((ISchemaElement)siteDialog.getSite());
            } else if (source.equals(this.selectTarget)) {
                CatalogDialog cDialog = new CatalogDialog(this.observationManager);
                ITarget target = cDialog.getTarget();
                if (target != null) {
                    this.targetBox.addItem((ISchemaElement)target);
                    this.setFindingPanel(target);
                }
            } else if (source.equals(this.newImager)) {
                IImagerDialog imagerDialog;
                IImager imager;
                ExtenableSchemaElementSelector imagerChooser = new ExtenableSchemaElementSelector(this.observationManager, this.observationManager.getExtensionLoader().getSchemaUILoader(), 3);
                if (imagerChooser.getResult() && (imager = (imagerDialog = (IImagerDialog)((Object)imagerChooser.getDialog())).getImager()) != null) {
                    this.imagerBox.addItem((ISchemaElement)imager);
                }
            } else if (source.equals(this.newTarget)) {
                ITargetDialog targetDialog;
                ITarget target;
                ExtenableSchemaElementSelector targetChooser = new ExtenableSchemaElementSelector(this.observationManager, this.observationManager.getExtensionLoader().getSchemaUILoader(), 7);
                if (targetChooser.getResult() && (target = (targetDialog = (ITargetDialog)targetChooser.getDialog()).getTarget()) != null) {
                    this.targetBox.addItem((ISchemaElement)target);
                    this.setFindingPanel(target);
                }
            } else if (source.equals(this.beginPicker)) {
                DatePicker dp = null;
                SimpleTimeZone timeZone = null;
                if (this.siteBox.getSelectedSchemaElement() != null) {
                    ISession session;
                    ISite site = (ISite)this.siteBox.getSelectedSchemaElement();
                    if (site == null && (session = (ISession)this.sessionBox.getSelectedSchemaElement()) != null) {
                        site = session.getSite();
                    }
                    if (site != null) {
                        timeZone = new SimpleTimeZone(site.getTimezone() * 60 * 1000, site.getName());
                    }
                }
                dp = this.beginDate != null ? new DatePicker(this.observationManager, AbstractPanel.bundle.getString("panel.observation.start.datePicker.title"), this.beginDate, timeZone) : new DatePicker((JFrame)this.observationManager, AbstractPanel.bundle.getString("panel.observation.start.datePicker.title"), timeZone);
                this.beginDate = dp.getDate();
                this.beginTime.setTime(this.beginDate.get(11), this.beginDate.get(12), this.beginDate.get(13));
                this.begin.setText(dp.getDateString());
            } else if (source.equals(this.endPicker)) {
                DatePicker dp = null;
                SimpleTimeZone timeZone = null;
                if (this.siteBox.getSelectedSchemaElement() != null) {
                    ISession session;
                    ISite site = (ISite)this.siteBox.getSelectedSchemaElement();
                    if (site == null && (session = (ISession)this.sessionBox.getSelectedSchemaElement()) != null) {
                        site = session.getSite();
                    }
                    if (site != null) {
                        timeZone = new SimpleTimeZone(site.getTimezone() * 60 * 1000, site.getName());
                    }
                }
                dp = this.endDate != null ? new DatePicker(this.observationManager, AbstractPanel.bundle.getString("panel.observation.end.datePicker.title"), this.endDate, timeZone) : (this.beginDate != null ? new DatePicker(this.observationManager, AbstractPanel.bundle.getString("panel.observation.end.datePicker.title"), this.beginDate, timeZone) : new DatePicker((JFrame)this.observationManager, AbstractPanel.bundle.getString("panel.observation.end.datePicker.title"), timeZone));
                this.endDate = dp.getDate();
                this.endTime.setTime(this.endDate.get(11), this.endDate.get(12), this.endDate.get(13));
                this.end.setText(dp.getDateString());
            } else if (source.equals(this.newImage)) {
                this.addNewImages();
            } else if (source.equals(this.clearEndDateAndTime)) {
                this.end.setText("");
                this.endDate = null;
                this.endTime.setTime(0, 0, 0);
            } else if (source.equals(this.endNow)) {
                Calendar now;
                this.endDate = now = Calendar.getInstance();
                this.endTime.setTime(now.get(11), now.get(12), now.get(13));
                this.end.setText(this.formatDate(this.endDate));
            } else if (source.equals(this.beginNow)) {
                Calendar now;
                this.beginDate = now = Calendar.getInstance();
                this.beginTime.setTime(now.get(11), now.get(12), now.get(13));
                this.begin.setText(this.formatDate(this.beginDate));
            }
        } else if (source instanceof AbstractBox) {
            this.calculateMagnification(-1.0f);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.eyepieceFLSlider)) {
            int currentValue = this.eyepieceFLSlider.getValue();
            this.calculateMagnification(currentValue);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.targetBox)) {
            if (e.getStateChange() == 2) {
                TargetBox tb = (TargetBox)source;
                ITarget target = (ITarget)tb.getSelectedSchemaElement();
                if (target != null) {
                    String oldType;
                    String type = target.getXSIType();
                    AbstractPanel oldPanel = this.getFindingPanel();
                    if (oldPanel == null || !(oldType = ((IFindingPanel)((Object)oldPanel)).getXSIType()).equals(type)) {
                        // empty if block
                    }
                    this.setFindingPanel(target);
                } else {
                    this.setFindingPanel(null);
                }
            }
        } else if (source.equals(this.sessionBox)) {
            SessionBox sb = (SessionBox)source;
            ISession session = (ISession)sb.getSelectedSchemaElement();
            if (e.getStateChange() == 1) {
                if (session != null) {
                    Calendar start;
                    ISession cacheSession;
                    if (this.observation != null && session.equals(this.observation.getSession())) {
                        if (session.getSite() != null) {
                            this.siteBox.addItem((ISchemaElement)session.getSite());
                            this.siteBox.setEnabled(false);
                        }
                        return;
                    }
                    if (this.cache.get(CACHEKEY_SESSION) != null && !(cacheSession = (ISession)this.cache.get(CACHEKEY_SESSION)).equals(session)) {
                        this.clearCacheData();
                    }
                    this.beginDate = start = session.getBegin();
                    this.begin.setText(this.formatDate(start));
                    this.beginTime.setTime(start.get(11), start.get(12), start.get(13));
                    if (Boolean.valueOf(this.observationManager.getConfiguration().getConfig("om.retrieve.endDateFromSession")).booleanValue()) {
                        this.endDate = (Calendar)start.clone();
                        this.endDate.add(12, 10);
                        this.end.setText(this.formatDate(this.endDate));
                        this.endTime.setTime(this.endDate.get(11), this.endDate.get(12), this.endDate.get(13));
                    }
                    if (session.getSite() != null) {
                        this.siteBox.addItem((ISchemaElement)session.getSite());
                        this.siteBox.setEnabled(false);
                    }
                } else {
                    this.siteBox.selectEmptyItem();
                    this.siteBox.setEnabled(true);
                }
            }
        } else if (source.equals(this.eyepieceBox)) {
            IEyepiece eyepiece = (IEyepiece)this.eyepieceBox.getSelectedSchemaElement();
            GridBagLayout gridbag = (GridBagLayout)this.selectionPanel.getLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.fill = 2;
            ConstraintsBuilder.buildConstraints(constraints, 2, 8, 14, 1, 6, 1);
            gridbag.setConstraints(this.eyepieceBox, constraints);
            this.eyepieceFLSlider.setVisible(false);
            ConstraintsBuilder.buildConstraints(constraints, 16, 8, 2, 1, 1, 1);
            gridbag.setConstraints(this.newEyepiece, constraints);
            this.updateUI();
            if (eyepiece == null) {
                return;
            }
            if (eyepiece.isZoomEyepiece()) {
                ConstraintsBuilder.buildConstraints(constraints, 2, 8, 9, 1, 6, 1);
                gridbag.setConstraints(this.eyepieceBox, constraints);
                ConstraintsBuilder.buildConstraints(constraints, 11, 8, 4, 1, 2, 1);
                constraints.fill = 2;
                gridbag.setConstraints(this.eyepieceFLSlider, constraints);
                this.eyepieceFLSlider.setMaximum((int)Math.ceil(eyepiece.getMaxFocalLength()));
                this.eyepieceFLSlider.setMinimum((int)Math.floor(eyepiece.getFocalLength()));
                this.eyepieceFLSlider.setVisible(true);
                ConstraintsBuilder.buildConstraints(constraints, 15, 8, 3, 1, 1, 1);
                gridbag.setConstraints(this.newEyepiece, constraints);
                this.updateUI();
            }
        }
    }

    private void addNewImages() {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        FileFilter imageFileFilter = new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".jpeg") || f.getName().toLowerCase().endsWith(".gif") || f.getName().toLowerCase().endsWith(".png") || f.getName().toLowerCase().endsWith(".fits") || f.getName().toLowerCase().endsWith(".fit") || f.getName().toLowerCase().endsWith(".fts") || f.isDirectory();
            }

            public String getDescription() {
                return AbstractPanel.bundle.getString("panel.observation.addNewImages.fileSelector.description");
            }
        };
        chooser.setFileFilter(imageFileFilter);
        chooser.setMultiSelectionEnabled(true);
        File last = (File)this.cache.get(CACHEKEY_LASTIMAGEDIR);
        if (last != null && last.exists() && last.isDirectory()) {
            chooser.setCurrentDirectory(last);
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            File[] files = chooser.getSelectedFiles();
            Cursor hourglassCursor = new Cursor(3);
            this.setCursor(hourglassCursor);
            List<File> images = Arrays.asList(files);
            this.imageContainer.addImages(images);
            this.repaint();
            if (files != null && files.length > 0) {
                this.cache.put(CACHEKEY_LASTIMAGEDIR, files[0].getParentFile());
            }
            Cursor normalCursor = new Cursor(0);
            this.setCursor(normalCursor);
        }
    }

    private String formatDate(Calendar cal) {
        DateFormat format = null;
        format = DateFormat.getDateInstance(3, Locale.getDefault());
        format.setCalendar(cal);
        return format.format(cal.getTime());
    }

    private ITarget getTarget() {
        ITarget target = (ITarget)this.targetBox.getSelectedSchemaElement();
        if (target == null) {
            super.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noTarget"));
            return null;
        }
        return target;
    }

    private IObserver getObserver() {
        IObserver observer = (IObserver)this.observerBox.getSelectedSchemaElement();
        if (observer == null) {
            super.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.noObserver"));
            return null;
        }
        return observer;
    }

    private IFinding getFinding() {
        if (this.findingsPanel == null) {
            super.createWarning(AbstractPanel.bundle.getString("panel.observation.warning.targetAndfinding"));
            return null;
        }
        IFinding finding = (IFinding)this.findingsPanel.createSchemaElement();
        return finding;
    }

    private void loadSchemaElement() {
        this.beginDate = this.observation.getBegin();
        this.begin.setText(this.formatDate(this.beginDate));
        this.beginPicker.setEnabled(super.isEditable());
        this.beginTime.setTime(this.beginDate.get(11), this.beginDate.get(12), this.beginDate.get(13));
        this.beginTime.setEditable(super.isEditable());
        this.observerBox.setSelectedItem((ISchemaElement)this.observation.getObserver());
        this.observerBox.setEditable(super.isEditable());
        this.newObserver.setEnabled(super.isEditable());
        this.targetBox.setSelectedItem((ISchemaElement)this.observation.getTarget());
        this.targetBox.setEditable(super.isEditable());
        this.newTarget.setEnabled(super.isEditable());
        this.setFindingPanel(this.observation.getTarget());
        this.endDate = this.observation.getEnd();
        if (this.endDate != null) {
            this.end.setText(this.formatDate(this.endDate));
            this.endPicker.setEnabled(super.isEditable());
            this.endTime.setTime(this.endDate.get(11), this.endDate.get(12), this.endDate.get(13));
        }
        this.endTime.setEditable(super.isEditable());
        if (this.observation.getSeeing() != -1) {
            this.seeing.setSelectedItem(new SeeingBoxEntry(this.observation.getSeeing()));
        }
        if (!Float.isNaN(this.observation.getMagnification())) {
            this.magnification.setText("" + this.observation.getMagnification());
        }
        this.magnification.setEditable(super.isEditable());
        if (!Float.isNaN(this.observation.getFaintestStar())) {
            this.faintestStar.setText("" + this.observation.getFaintestStar());
        }
        this.faintestStar.setEditable(super.isEditable());
        if (this.observation.getSkyQuality() != null) {
            this.sqmValue.setSurfaceBrightness(this.observation.getSkyQuality());
        }
        this.sqmValue.setEditable(super.isEditable());
        if (this.observation.getAccessories() != null) {
            this.accessories.setText(this.observation.getAccessories());
        }
        this.accessories.setEditable(super.isEditable());
        this.sessionBox.setEditable(super.isEditable());
        if (this.observation.getSession() != null) {
            this.sessionBox.setSelectedItem((ISchemaElement)this.observation.getSession());
        }
        this.newSession.setEnabled(super.isEditable());
        this.scopeBox.setEditable(super.isEditable());
        if (this.observation.getScope() != null) {
            this.scopeBox.setSelectedItem((ISchemaElement)this.observation.getScope());
        }
        this.newScope.setEnabled(super.isEditable());
        this.filterBox.setEditable(super.isEditable());
        if (this.observation.getFilter() != null) {
            this.filterBox.setSelectedItem((ISchemaElement)this.observation.getFilter());
        }
        this.newFilter.setEnabled(super.isEditable());
        this.lensBox.setEditable(super.isEditable());
        if (this.observation.getLens() != null) {
            this.lensBox.setSelectedItem((ISchemaElement)this.observation.getLens());
        }
        this.newLens.setEnabled(super.isEditable());
        this.eyepieceBox.setEditable(super.isEditable());
        if (this.observation.getEyepiece() != null) {
            this.eyepieceBox.setSelectedItem((ISchemaElement)this.observation.getEyepiece());
            if (this.observation.getEyepiece().isZoomEyepiece()) {
                float afl = OpticsUtil.getActualFocalLength((IScope)this.observation.getScope(), (ILens)this.observation.getLens(), (float)this.observation.getMagnification());
                this.eyepieceFLSlider.setValue(Math.round(afl));
            }
        }
        this.newEyepiece.setEnabled(super.isEditable());
        this.siteBox.setEditable(super.isEditable());
        if (this.observation.getSite() != null) {
            this.siteBox.setSelectedItem((ISchemaElement)this.observation.getSite());
        }
        this.newSite.setEnabled(super.isEditable());
        this.imagerBox.setEditable(super.isEditable());
        if (this.observation.getImager() != null) {
            this.imagerBox.setSelectedItem((ISchemaElement)this.observation.getImager());
        }
        this.newImager.setEnabled(super.isEditable());
        this.imageContainer.addImages(this.observation.getImages());
    }

    private void createPanel() {
        this.selectionPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        this.selectionPanel.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 2, 1, 2, 1);
        constraints.fill = 2;
        OMLabel LsessionName = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.session"), false);
        LsessionName.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.session"));
        gridbag.setConstraints(LsessionName, constraints);
        this.selectionPanel.add(LsessionName);
        ConstraintsBuilder.buildConstraints(constraints, 2, 0, 14, 1, 6, 1);
        this.sessionBox.addItemListener(this);
        this.sessionBox.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.session"));
        gridbag.setConstraints(this.sessionBox, constraints);
        this.selectionPanel.add(this.sessionBox);
        ConstraintsBuilder.buildConstraints(constraints, 16, 0, 2, 1, 1, 1);
        this.newSession = new JButton(AbstractPanel.bundle.getString("panel.observation.button.newSession"));
        this.newSession.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.newSession"));
        this.newSession.addActionListener(this);
        gridbag.setConstraints(this.newSession, constraints);
        this.selectionPanel.add(this.newSession);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 2, 1);
        constraints.anchor = 17;
        OMLabel Lbegin = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.begin"), true);
        Lbegin.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.begin"));
        gridbag.setConstraints(Lbegin, constraints);
        this.selectionPanel.add(Lbegin);
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 3, 1, 5, 1);
        constraints.fill = 2;
        this.begin = new JTextField(8);
        this.begin.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.begin"));
        this.begin.setEditable(false);
        gridbag.setConstraints(this.begin, constraints);
        this.selectionPanel.add(this.begin);
        if (super.isEditable()) {
            ConstraintsBuilder.buildConstraints(constraints, 4, 1, 1, 1, 1, 1);
            constraints.fill = 0;
            this.beginPicker = new JButton("...");
            this.beginPicker.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.selectBegin"));
            this.beginPicker.addActionListener(this);
            gridbag.setConstraints(this.beginPicker, constraints);
            this.selectionPanel.add(this.beginPicker);
        }
        ConstraintsBuilder.buildConstraints(constraints, 5, 1, 2, 1, 6, 1);
        constraints.fill = 2;
        this.beginTime = new TimeContainer(0, 0, 0, super.isEditable());
        this.beginTime.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.begin"));
        gridbag.setConstraints(this.beginTime, constraints);
        this.selectionPanel.add(this.beginTime);
        ConstraintsBuilder.buildConstraints(constraints, 7, 1, 2, 1, 1, 1);
        this.beginNow = new JButton(AbstractPanel.bundle.getString("panel.observation.button.beginNow"));
        this.beginNow.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.beginNow"));
        this.beginNow.addActionListener(this);
        gridbag.setConstraints(this.beginNow, constraints);
        this.selectionPanel.add(this.beginNow);
        ConstraintsBuilder.buildConstraints(constraints, 9, 1, 1, 1, 1, 1);
        constraints.anchor = 13;
        OMLabel Lend = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.end"), 4, false);
        Lend.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.end"));
        gridbag.setConstraints(Lend, constraints);
        this.selectionPanel.add(Lend);
        ConstraintsBuilder.buildConstraints(constraints, 10, 1, 2, 1, 5, 1);
        constraints.fill = 2;
        this.end = new JTextField(8);
        this.end.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.end"));
        this.end.setEditable(false);
        constraints.anchor = 17;
        gridbag.setConstraints(this.end, constraints);
        this.selectionPanel.add(this.end);
        if (super.isEditable()) {
            ConstraintsBuilder.buildConstraints(constraints, 12, 1, 1, 1, 1, 1);
            constraints.fill = 0;
            this.endPicker = new JButton("...");
            this.endPicker.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.selectEnd"));
            this.endPicker.addActionListener(this);
            gridbag.setConstraints(this.endPicker, constraints);
            this.selectionPanel.add(this.endPicker);
        }
        ConstraintsBuilder.buildConstraints(constraints, 13, 1, 2, 1, 5, 1);
        constraints.fill = 2;
        this.endTime = new TimeContainer(0, 0, 0, super.isEditable());
        this.endTime.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.end"));
        gridbag.setConstraints(this.endTime, constraints);
        this.selectionPanel.add(this.endTime);
        ConstraintsBuilder.buildConstraints(constraints, 15, 1, 2, 1, 2, 1);
        this.endNow = new JButton(AbstractPanel.bundle.getString("panel.observation.button.endNow"));
        this.endNow.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.endNow"));
        this.endNow.addActionListener(this);
        gridbag.setConstraints(this.endNow, constraints);
        this.selectionPanel.add(this.endNow);
        ConstraintsBuilder.buildConstraints(constraints, 17, 1, 1, 1, 1, 1);
        constraints.fill = 2;
        constraints.anchor = 17;
        this.clearEndDateAndTime = new JButton();
        this.clearEndDateAndTime.setText(AbstractPanel.bundle.getString("panel.observation.button.clearEndDateAndTime"));
        this.clearEndDateAndTime.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.clearEndDateAndTime"));
        this.clearEndDateAndTime.addActionListener(this);
        gridbag.setConstraints(this.clearEndDateAndTime, constraints);
        this.selectionPanel.add(this.clearEndDateAndTime);
        ConstraintsBuilder.buildConstraints(constraints, 0, 2, 2, 1, 3, 1);
        constraints.fill = 2;
        OMLabel LfaintestStar = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.faintestStar"), false);
        LfaintestStar.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.faintestStar"));
        gridbag.setConstraints(LfaintestStar, constraints);
        this.selectionPanel.add(LfaintestStar);
        ConstraintsBuilder.buildConstraints(constraints, 2, 2, 7, 1, 6, 1);
        this.faintestStar = new JTextField();
        this.faintestStar.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.faintestStar"));
        gridbag.setConstraints(this.faintestStar, constraints);
        this.selectionPanel.add(this.faintestStar);
        ConstraintsBuilder.buildConstraints(constraints, 9, 2, 1, 1, 1, 1);
        OMLabel LSeeing = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.seeing"), 4, false);
        LSeeing.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.seeing"));
        gridbag.setConstraints(LSeeing, constraints);
        constraints.fill = 2;
        this.selectionPanel.add(LSeeing);
        ConstraintsBuilder.buildConstraints(constraints, 10, 2, 8, 1, 6, 1);
        this.seeing = new JComboBox();
        this.seeing.setEditable(false);
        this.fillSeeingBox();
        this.seeing.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.seeing"));
        gridbag.setConstraints(this.seeing, constraints);
        this.selectionPanel.add(this.seeing);
        ConstraintsBuilder.buildConstraints(constraints, 0, 3, 2, 1, 3, 1);
        OMLabel LMagnification = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.magnification"), false);
        LMagnification.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.magnification"));
        constraints.fill = 2;
        gridbag.setConstraints(LMagnification, constraints);
        this.selectionPanel.add(LMagnification);
        ConstraintsBuilder.buildConstraints(constraints, 2, 3, 7, 1, 6, 1);
        this.magnification = new JTextField();
        this.magnification.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.magnification"));
        gridbag.setConstraints(this.magnification, constraints);
        this.selectionPanel.add(this.magnification);
        ConstraintsBuilder.buildConstraints(constraints, 9, 3, 1, 1, 1, 1);
        OMLabel Lsqm = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.sqm"), 4, false);
        Lsqm.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.sqm"));
        constraints.fill = 2;
        gridbag.setConstraints(Lsqm, constraints);
        this.selectionPanel.add(Lsqm);
        ConstraintsBuilder.buildConstraints(constraints, 10, 3, 8, 1, 6, 1);
        this.sqmValue = new SurfaceBrightnessContainer(null, true, new String[]{"mags-per-squarearcmin", "mags-per-squarearcsec"});
        this.sqmValue.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.sqm"));
        gridbag.setConstraints(this.sqmValue, constraints);
        this.selectionPanel.add(this.sqmValue);
        ConstraintsBuilder.buildConstraints(constraints, 0, 4, 1, 1, 3, 1);
        OMLabel LAccessories = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.accessories"), false);
        LAccessories.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.accessories"));
        gridbag.setConstraints(LAccessories, constraints);
        constraints.fill = 2;
        this.selectionPanel.add(LAccessories);
        ConstraintsBuilder.buildConstraints(constraints, 1, 4, 17, 1, 6, 1);
        this.accessories = new JTextField();
        this.accessories.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.accessories"));
        gridbag.setConstraints(this.accessories, constraints);
        this.selectionPanel.add(this.accessories);
        ConstraintsBuilder.buildConstraints(constraints, 0, 5, 2, 1, 2, 1);
        constraints.fill = 2;
        OMLabel LobserverName = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.observer"), true);
        LobserverName.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.observer"));
        gridbag.setConstraints(LobserverName, constraints);
        this.selectionPanel.add(LobserverName);
        ConstraintsBuilder.buildConstraints(constraints, 2, 5, 14, 1, 6, 1);
        this.observerBox.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.observer"));
        gridbag.setConstraints(this.observerBox, constraints);
        this.selectionPanel.add(this.observerBox);
        ConstraintsBuilder.buildConstraints(constraints, 16, 5, 2, 1, 1, 1);
        this.newObserver = new JButton(AbstractPanel.bundle.getString("panel.observation.button.newObserver"));
        this.newObserver.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.newObserver"));
        this.newObserver.addActionListener(this);
        gridbag.setConstraints(this.newObserver, constraints);
        this.selectionPanel.add(this.newObserver);
        ConstraintsBuilder.buildConstraints(constraints, 0, 6, 2, 1, 2, 1);
        constraints.fill = 2;
        OMLabel LtargetName = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.target"), true);
        LtargetName.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.target"));
        gridbag.setConstraints(LtargetName, constraints);
        this.selectionPanel.add(LtargetName);
        ConstraintsBuilder.buildConstraints(constraints, 2, 6, 9, 1, 6, 1);
        this.targetBox.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.target"));
        this.targetBox.addItemListener(this);
        gridbag.setConstraints(this.targetBox, constraints);
        this.selectionPanel.add(this.targetBox);
        ConstraintsBuilder.buildConstraints(constraints, 11, 6, 4, 1, 1, 1);
        this.selectTarget = new JButton(AbstractPanel.bundle.getString("panel.observation.button.selectTargetfromCatalog"));
        this.selectTarget.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.selectTargetfromCatalog"));
        this.selectTarget.addActionListener(this);
        if (this.observationManager.getExtensionLoader().getCatalogLoader().getCatalogNames() == null || this.observationManager.getExtensionLoader().getCatalogLoader().getCatalogNames().length == 0) {
            this.selectTarget.setEnabled(false);
        }
        gridbag.setConstraints(this.selectTarget, constraints);
        this.selectionPanel.add(this.selectTarget);
        ConstraintsBuilder.buildConstraints(constraints, 15, 6, 3, 1, 1, 1);
        this.newTarget = new JButton(AbstractPanel.bundle.getString("panel.observation.button.newTarget"));
        this.newTarget.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.newTarget"));
        this.newTarget.addActionListener(this);
        gridbag.setConstraints(this.newTarget, constraints);
        this.selectionPanel.add(this.newTarget);
        ConstraintsBuilder.buildConstraints(constraints, 0, 7, 2, 1, 2, 1);
        constraints.fill = 2;
        OMLabel LscopeName = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.scope"), false);
        LscopeName.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.scope"));
        gridbag.setConstraints(LscopeName, constraints);
        this.selectionPanel.add(LscopeName);
        ConstraintsBuilder.buildConstraints(constraints, 2, 7, 14, 1, 6, 1);
        this.scopeBox.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.scope"));
        this.scopeBox.addActionListener(this);
        gridbag.setConstraints(this.scopeBox, constraints);
        this.selectionPanel.add(this.scopeBox);
        ConstraintsBuilder.buildConstraints(constraints, 16, 7, 2, 1, 1, 1);
        this.newScope = new JButton(AbstractPanel.bundle.getString("panel.observation.button.newScope"));
        this.newScope.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.newScope"));
        this.newScope.addActionListener(this);
        gridbag.setConstraints(this.newScope, constraints);
        this.selectionPanel.add(this.newScope);
        ConstraintsBuilder.buildConstraints(constraints, 0, 8, 2, 1, 2, 1);
        constraints.fill = 2;
        this.LeyepieceName = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.eyepiece"), false);
        this.LeyepieceName.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.eyepiece"));
        gridbag.setConstraints(this.LeyepieceName, constraints);
        this.selectionPanel.add(this.LeyepieceName);
        ConstraintsBuilder.buildConstraints(constraints, 2, 8, 14, 1, 6, 1);
        this.eyepieceBox.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.eyepiece"));
        this.eyepieceBox.addActionListener(this);
        gridbag.setConstraints(this.eyepieceBox, constraints);
        this.eyepieceBox.addItemListener(this);
        this.selectionPanel.add(this.eyepieceBox);
        ConstraintsBuilder.buildConstraints(constraints, 11, 8, 4, 1, 2, 1);
        constraints.fill = 2;
        gridbag.setConstraints(this.eyepieceFLSlider, constraints);
        this.eyepieceFLSlider.setMaximum(10);
        this.eyepieceFLSlider.setMinimum(1);
        this.eyepieceFLSlider.setMajorTickSpacing(1);
        this.eyepieceFLSlider.setPaintTicks(true);
        this.eyepieceFLSlider.setPaintLabels(true);
        this.eyepieceFLSlider.setSnapToTicks(true);
        this.eyepieceFLSlider.addChangeListener(this);
        this.selectionPanel.add(this.eyepieceFLSlider);
        this.eyepieceFLSlider.setVisible(false);
        ConstraintsBuilder.buildConstraints(constraints, 16, 8, 2, 1, 1, 1);
        this.newEyepiece = new JButton(AbstractPanel.bundle.getString("panel.observation.button.newEyepiece"));
        this.newEyepiece.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.newEyepiece"));
        this.newEyepiece.addActionListener(this);
        gridbag.setConstraints(this.newEyepiece, constraints);
        this.selectionPanel.add(this.newEyepiece);
        ConstraintsBuilder.buildConstraints(constraints, 0, 9, 2, 1, 2, 1);
        constraints.fill = 2;
        OMLabel LlensName = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.lens"), false);
        LlensName.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.lens"));
        gridbag.setConstraints(LlensName, constraints);
        this.selectionPanel.add(LlensName);
        ConstraintsBuilder.buildConstraints(constraints, 2, 9, 14, 1, 6, 1);
        this.lensBox.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.lens"));
        this.lensBox.addActionListener(this);
        gridbag.setConstraints(this.lensBox, constraints);
        this.selectionPanel.add(this.lensBox);
        ConstraintsBuilder.buildConstraints(constraints, 16, 9, 2, 1, 1, 1);
        this.newLens = new JButton(AbstractPanel.bundle.getString("panel.observation.button.newLens"));
        this.newLens.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.newLens"));
        this.newLens.addActionListener(this);
        gridbag.setConstraints(this.newLens, constraints);
        this.selectionPanel.add(this.newLens);
        ConstraintsBuilder.buildConstraints(constraints, 0, 10, 2, 1, 2, 1);
        constraints.fill = 2;
        OMLabel LfilterName = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.filter"), false);
        LfilterName.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.filter"));
        gridbag.setConstraints(LfilterName, constraints);
        this.selectionPanel.add(LfilterName);
        ConstraintsBuilder.buildConstraints(constraints, 2, 10, 14, 1, 6, 1);
        this.filterBox.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.filter"));
        this.filterBox.addActionListener(this);
        gridbag.setConstraints(this.filterBox, constraints);
        this.selectionPanel.add(this.filterBox);
        ConstraintsBuilder.buildConstraints(constraints, 16, 10, 2, 1, 1, 1);
        this.newFilter = new JButton(AbstractPanel.bundle.getString("panel.observation.button.newFilter"));
        this.newFilter.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.newFilter"));
        this.newFilter.addActionListener(this);
        gridbag.setConstraints(this.newFilter, constraints);
        this.selectionPanel.add(this.newFilter);
        ConstraintsBuilder.buildConstraints(constraints, 0, 11, 2, 1, 2, 1);
        constraints.fill = 2;
        OMLabel LsiteName = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.site"), false);
        LsiteName.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.site"));
        gridbag.setConstraints(LsiteName, constraints);
        this.selectionPanel.add(LsiteName);
        ConstraintsBuilder.buildConstraints(constraints, 2, 11, 14, 1, 6, 1);
        this.siteBox.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.site"));
        gridbag.setConstraints(this.siteBox, constraints);
        this.selectionPanel.add(this.siteBox);
        ConstraintsBuilder.buildConstraints(constraints, 16, 11, 2, 1, 1, 1);
        this.newSite = new JButton(AbstractPanel.bundle.getString("panel.observation.button.newSite"));
        this.newSite.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.newSite"));
        this.newSite.addActionListener(this);
        gridbag.setConstraints(this.newSite, constraints);
        this.selectionPanel.add(this.newSite);
        ConstraintsBuilder.buildConstraints(constraints, 0, 12, 2, 1, 2, 1);
        constraints.fill = 2;
        OMLabel LimagerName = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.imager"), false);
        LimagerName.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.imager"));
        gridbag.setConstraints(LimagerName, constraints);
        this.selectionPanel.add(LimagerName);
        ConstraintsBuilder.buildConstraints(constraints, 2, 12, 14, 1, 6, 1);
        this.imagerBox.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.imager"));
        gridbag.setConstraints(this.imagerBox, constraints);
        this.selectionPanel.add(this.imagerBox);
        ConstraintsBuilder.buildConstraints(constraints, 16, 12, 2, 1, 1, 1);
        this.newImager = new JButton(AbstractPanel.bundle.getString("panel.observation.button.newImager"));
        this.newImager.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.newImager"));
        this.newImager.addActionListener(this);
        gridbag.setConstraints(this.newImager, constraints);
        this.selectionPanel.add(this.newImager);
        ConstraintsBuilder.buildConstraints(constraints, 0, 13, 2, 1, 2, 1);
        OMLabel LimageContainer = new OMLabel(AbstractPanel.bundle.getString("panel.observation.label.images"), false);
        LimageContainer.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.images"));
        gridbag.setConstraints(LimageContainer, constraints);
        this.selectionPanel.add(LimageContainer);
        ConstraintsBuilder.buildConstraints(constraints, 2, 13, 14, 4, 1, 100);
        constraints.fill = 1;
        this.imageContainer = new ImageContainer(null, this.observationManager, true);
        JScrollPane imageContainerScroll = new JScrollPane(this.imageContainer, 20, 30);
        gridbag.setConstraints(imageContainerScroll, constraints);
        imageContainerScroll.setMinimumSize(new Dimension(this.getWidth(), 130));
        this.selectionPanel.add(imageContainerScroll);
        ConstraintsBuilder.buildConstraints(constraints, 16, 13, 2, 1, 1, 1);
        constraints.fill = 2;
        this.newImage = new JButton(AbstractPanel.bundle.getString("panel.observation.button.newImages"));
        this.newImage.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.newImages"));
        this.newImage.addActionListener(this);
        gridbag.setConstraints(this.newImage, constraints);
        this.selectionPanel.add(this.newImage);
        this.tabbedPane.addTab(AbstractPanel.bundle.getString("panel.observation.mainPannel.title"), this.selectionPanel);
        super.setLayout(new BorderLayout());
        super.add(this.tabbedPane);
    }

    private void fillLists(boolean refill) {
        ISchemaElement element = null;
        if (refill) {
            element = this.observerBox.getSelectedSchemaElement();
        }
        Configuration config = this.observationManager.getConfiguration();
        String currentValue = config.getConfig("om.default.observer");
        IObserver[] observers = this.observationManager.getXmlCache().getObservers();
        IObserver defaultObserver = null;
        for (int i = 0; i < observers.length; ++i) {
            this.observerBox.addItem((ISchemaElement)observers[i]);
            if (currentValue == null || !currentValue.equals(observers[i].getDisplayName())) continue;
            defaultObserver = observers[i];
        }
        if (defaultObserver != null) {
            this.observerBox.setSelectedItem((ISchemaElement)defaultObserver);
        }
        if (refill) {
            this.observerBox.setSelectedItem(element);
        }
        if (refill) {
            element = this.targetBox.getSelectedSchemaElement();
        }
        ITarget[] targets = this.observationManager.getXmlCache().getTargets();
        for (int i = 0; i < targets.length; ++i) {
            if (targets[i].getObserver() != null) {
                this.targetBox.addItem((ISchemaElement)targets[i]);
            }
            if (this.observation == null) continue;
            this.targetBox.addItem((ISchemaElement)this.observation.getTarget());
        }
        if (refill) {
            this.targetBox.setSelectedItem(element);
        } else {
            this.targetBox.addEmptyItem();
        }
        if (refill) {
            element = this.sessionBox.getSelectedSchemaElement();
        }
        ISession[] session = this.observationManager.getXmlCache().getSessions();
        for (int i = 0; i < session.length; ++i) {
            this.sessionBox.addItem((ISchemaElement)session[i]);
        }
        if (refill) {
            this.sessionBox.setSelectedItem(element);
        } else {
            this.sessionBox.addEmptyItem();
        }
        if (refill) {
            element = this.scopeBox.getSelectedSchemaElement();
        }
        IScope[] scopes = this.observationManager.getXmlCache().getScopes();
        for (int i = 0; i < scopes.length; ++i) {
            if (this.observation == null) {
                if (!scopes[i].isAvailable()) continue;
                this.scopeBox.addItem((ISchemaElement)scopes[i]);
                continue;
            }
            this.scopeBox.addItem((ISchemaElement)scopes[i]);
        }
        if (refill) {
            this.scopeBox.setSelectedItem(element);
        } else {
            this.scopeBox.addEmptyItem();
        }
        if (refill) {
            element = this.eyepieceBox.getSelectedSchemaElement();
        }
        IEyepiece[] eyepieces = this.observationManager.getXmlCache().getEyepieces();
        for (int i = 0; i < eyepieces.length; ++i) {
            if (this.observation == null) {
                if (!eyepieces[i].isAvailable()) continue;
                this.eyepieceBox.addItem((ISchemaElement)eyepieces[i]);
                continue;
            }
            this.eyepieceBox.addItem((ISchemaElement)eyepieces[i]);
        }
        if (refill) {
            this.eyepieceBox.setSelectedItem(element);
        } else {
            this.eyepieceBox.addEmptyItem();
        }
        if (refill) {
            element = this.lensBox.getSelectedSchemaElement();
        }
        ILens[] lenses = this.observationManager.getXmlCache().getLenses();
        for (int i = 0; i < lenses.length; ++i) {
            if (this.observation == null) {
                if (!lenses[i].isAvailable()) continue;
                this.lensBox.addItem((ISchemaElement)lenses[i]);
                continue;
            }
            this.lensBox.addItem((ISchemaElement)lenses[i]);
        }
        if (refill) {
            this.lensBox.setSelectedItem(element);
        } else {
            this.lensBox.addEmptyItem();
        }
        if (refill) {
            element = this.filterBox.getSelectedSchemaElement();
        }
        IFilter[] filters = this.observationManager.getXmlCache().getFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (this.observation == null) {
                if (!filters[i].isAvailable()) continue;
                this.filterBox.addItem((ISchemaElement)filters[i]);
                continue;
            }
            this.filterBox.addItem((ISchemaElement)filters[i]);
        }
        if (refill) {
            this.filterBox.setSelectedItem(element);
        } else {
            this.filterBox.addEmptyItem();
        }
        if (refill) {
            element = this.siteBox.getSelectedSchemaElement();
        }
        ISite[] sites = this.observationManager.getXmlCache().getSites();
        for (int i = 0; i < sites.length; ++i) {
            this.siteBox.addItem((ISchemaElement)sites[i]);
        }
        if (refill) {
            this.siteBox.setSelectedItem(element);
        } else {
            this.siteBox.addEmptyItem();
        }
        if (refill) {
            element = this.imagerBox.getSelectedSchemaElement();
        }
        IImager[] imagers = this.observationManager.getXmlCache().getImagers();
        for (int i = 0; i < imagers.length; ++i) {
            if (this.observation == null) {
                if (!imagers[i].isAvailable()) continue;
                this.imagerBox.addItem((ISchemaElement)imagers[i]);
                continue;
            }
            this.imagerBox.addItem((ISchemaElement)imagers[i]);
        }
        if (refill) {
            this.imagerBox.setSelectedItem(element);
        } else {
            this.imagerBox.addEmptyItem();
        }
    }

    private void setFindingPanel(ITarget target) {
        if (this.getFindingPanel() != null) {
            this.tabbedPane.remove(this.getFindingPanel());
        }
        if (target == null) {
            return;
        }
        String xsi = target.getXSIType();
        SchemaUILoader loader = this.observationManager.getExtensionLoader().getSchemaUILoader();
        ISession session = null;
        if (this.sessionBox.getSelectedSchemaElement() != null) {
            session = (ISession)this.sessionBox.getSelectedSchemaElement();
        }
        if (this.observation != null) {
            List findings = this.observation.getResults();
            Iterator iterator = findings.iterator();
            IFinding current = null;
            while (iterator.hasNext()) {
                current = (IFinding)iterator.next();
                this.findingsPanel = loader.getFindingPanel(xsi, current, session, target, true);
                this.tabbedPane.addTab(this.findingsPanel.getName(), this.findingsPanel);
            }
        } else {
            this.findingsPanel = loader.getFindingPanel(xsi, null, session, target, true);
            this.tabbedPane.addTab(this.findingsPanel.getName(), this.findingsPanel);
        }
        super.repaint();
    }

    private AbstractPanel getFindingPanel() {
        return this.findingsPanel;
    }

    private void calculateMagnification(float focalLength) {
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        IScope scope = (IScope)this.scopeBox.getSelectedSchemaElement();
        if (scope == null) {
            this.magnification.setEditable(true);
            this.magnification.setText(null);
            return;
        }
        if (!Float.isNaN(scope.getMagnification())) {
            this.magnification.setText(df.format(scope.getMagnification()));
            this.eyepieceBox.selectEmptyItem();
            this.eyepieceBox.setEnabled(false);
            this.lensBox.selectEmptyItem();
            this.lensBox.setEnabled(false);
            this.magnification.setEditable(false);
            return;
        }
        this.magnification.setEditable(true);
        this.eyepieceBox.setEnabled(true);
        this.lensBox.setEnabled(true);
        if (focalLength == -1.0f) {
            IEyepiece eyep = (IEyepiece)this.eyepieceBox.getSelectedSchemaElement();
            if (eyep == null) {
                this.magnification.setEnabled(true);
                this.magnification.setText(null);
                return;
            }
            focalLength = eyep.getFocalLength();
        }
        ILens lens = (ILens)this.lensBox.getSelectedSchemaElement();
        float m = OpticsUtil.getMagnification((IScope)scope, (float)focalLength, (ILens)lens);
        this.magnification.setEditable(false);
        this.magnification.setText(df.format(m));
    }

    private void loadFromCache() {
        if (this.cache.get(CACHEKEY_STARTDATE) != null) {
            this.beginDate = (Calendar)this.cache.get(CACHEKEY_STARTDATE);
            this.begin.setText(this.formatDate(this.beginDate));
            this.beginPicker.setEnabled(super.isEditable());
            this.beginTime.setTime(this.beginDate.get(11), this.beginDate.get(12), this.beginDate.get(13));
        }
        if (this.cache.get(CACHEKEY_OBSERVER) != null) {
            this.observerBox.setSelectedItem((ISchemaElement)((IObserver)this.cache.get(CACHEKEY_OBSERVER)));
        }
        if (this.cache.get(CACHEKEY_SITE) != null) {
            this.siteBox.setSelectedItem((ISchemaElement)((ISite)this.cache.get(CACHEKEY_SITE)));
        }
        if (this.cache.get(CACHEKEY_SESSION) != null) {
            ISession session = (ISession)this.cache.get(CACHEKEY_SESSION);
            this.sessionBox.setSelectedItem((ISchemaElement)session);
            if (session.getSite() != null) {
                this.siteBox.setSelectedItem((ISchemaElement)session.getSite());
            }
        }
        if (this.cache.get(CACHEKEY_SCOPE) != null) {
            this.scopeBox.setSelectedItem((ISchemaElement)((IScope)this.cache.get(CACHEKEY_SCOPE)));
        }
        if (this.cache.get(CACHEKEY_ENDDATE) != null) {
            this.endDate = (Calendar)this.cache.get(CACHEKEY_ENDDATE);
            this.end.setText(this.formatDate(this.endDate));
            this.endPicker.setEnabled(super.isEditable());
            this.endTime.setTime(this.endDate.get(11), this.endDate.get(12), this.endDate.get(13));
        }
        if (this.cache.get(CACHEKEY_FAINTESTSTAR) != null) {
            this.faintestStar.setText("" + FloatUtil.parseFloat((String)((String)this.cache.get(CACHEKEY_FAINTESTSTAR))));
        }
        if (this.cache.get(CACHEKEY_SQM) != null) {
            this.sqmValue.setSurfaceBrightness((SurfaceBrightness)this.cache.get(CACHEKEY_SQM));
        }
        if (this.cache.get(CACHEKEY_SEEING) != null) {
            this.seeing.setSelectedItem(new SeeingBoxEntry((Integer)this.cache.get(CACHEKEY_SEEING)));
        }
        if (this.cache.get(CACHEKEY_ACCESSORIES) != null) {
            this.accessories.setText("" + this.cache.get(CACHEKEY_ACCESSORIES));
        }
    }

    private void clearCacheData() {
        this.beginDate = null;
        this.cache.put(CACHEKEY_STARTDATE, null);
        this.siteBox.selectEmptyItem();
        this.cache.put(CACHEKEY_SITE, null);
        this.endDate = null;
        this.cache.put(CACHEKEY_ENDDATE, null);
        this.faintestStar.setText("");
        this.cache.put(CACHEKEY_FAINTESTSTAR, null);
        this.sqmValue.setSurfaceBrightness(null);
        this.cache.put(CACHEKEY_SQM, null);
        this.seeing.setSelectedItem(new SeeingBoxEntry(0));
        this.cache.put(CACHEKEY_SEEING, null);
        this.accessories.setText("");
    }

    private void fillSeeingBox() {
        SeeingBoxEntry emptyItem = new SeeingBoxEntry(0);
        this.seeing.addItem(emptyItem);
        this.seeing.addItem(new SeeingBoxEntry(1));
        this.seeing.addItem(new SeeingBoxEntry(2));
        this.seeing.addItem(new SeeingBoxEntry(3));
        this.seeing.addItem(new SeeingBoxEntry(4));
        this.seeing.addItem(new SeeingBoxEntry(5));
        this.seeing.setSelectedItem(emptyItem);
    }
}

