/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.panel;

import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.Observer;
import de.lehmannet.om.ui.panel.AbstractPanel;
import de.lehmannet.om.ui.panel.AccountListRenderer;
import de.lehmannet.om.ui.panel.AccountTableModel;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.EditPopupHandler;
import de.lehmannet.om.ui.util.OMLabel;
import de.lehmannet.om.util.FloatUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class ObserverPanel
extends AbstractPanel
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = -7193577368053769290L;
    private IObserver observer = null;
    private JTextField name = null;
    private JTextField surname = null;
    private JTextArea contacts = null;
    private JTable accounts = null;
    private JButton addAccountRow = null;
    private JButton deleteAccountRow = null;
    private JTextField fstOffset = null;

    public ObserverPanel(IObserver observer, boolean editable) {
        super(editable);
        this.observer = observer;
        this.createPanel();
        if (observer != null) {
            this.loadSchemaElement();
        }
    }

    private void loadSchemaElement() {
        this.name.setText(this.observer.getName());
        this.name.setEditable(super.isEditable());
        this.surname.setText(this.observer.getSurname());
        this.surname.setEditable(super.isEditable());
        List contacts = this.observer.getContacts();
        ListIterator iterator = contacts.listIterator();
        StringBuffer contactString = new StringBuffer();
        while (iterator.hasNext()) {
            contactString.append(iterator.next());
            if (!iterator.hasNext()) continue;
            contactString.append("\n");
        }
        this.contacts.setText(contactString.toString());
        this.contacts.setEditable(super.isEditable());
        if (!Float.isNaN(this.observer.getFSTOffset())) {
            DecimalFormat df = new DecimalFormat("0.00");
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            df.setDecimalFormatSymbols(dfs);
            this.fstOffset.setText(df.format(this.observer.getFSTOffset()));
        }
        this.fstOffset.setEditable(super.isEditable());
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            new EditPopupHandler(e.getX(), e.getY(), this.contacts);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public ISchemaElement getSchemaElement() {
        return this.observer;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.addAccountRow)) {
            ((AccountTableModel)this.accounts.getModel()).addNewRow();
        } else if (e.getSource().equals(this.deleteAccountRow)) {
            TableCellEditor editor = this.accounts.getColumnModel().getColumn(0).getCellEditor();
            ((AccountTableModel)this.accounts.getModel()).deleteRow(this.accounts.getSelectedRow());
            this.accounts.getColumnModel().getColumn(0).setCellEditor(editor);
        }
    }

    public ISchemaElement updateSchemaElement() {
        if (this.observer == null) {
            return null;
        }
        String name = this.getObserverName();
        if (name == null) {
            return null;
        }
        this.observer.setName(name);
        String surname = this.getSurname();
        if (surname == null) {
            return null;
        }
        this.observer.setSurname(surname);
        String contacts = this.contacts.getText();
        this.observer.setContacts(new ArrayList());
        if (contacts != null && !"".equals(contacts)) {
            this.observer.addContact(contacts);
        }
        HashMap accounts = ((AccountTableModel)this.accounts.getModel()).getAllEntries();
        this.observer.setAccounts((Map)accounts);
        String fstO = this.fstOffset.getText();
        if (fstO != null && !"".equals(fstO)) {
            try {
                float fo = FloatUtil.parseFloat((String)fstO);
                this.observer.setFSTOffset(fo);
            }
            catch (NumberFormatException nfe) {
                super.createWarning(AbstractPanel.bundle.getString("panel.observer.warning.fstOffsetNumeric"));
                return null;
            }
        }
        return this.observer;
    }

    public ISchemaElement createSchemaElement() {
        String fstO;
        HashMap accounts;
        String name = this.getObserverName();
        if (name == null) {
            return null;
        }
        String surname = this.getSurname();
        if (surname == null) {
            return null;
        }
        this.observer = new Observer(name, surname);
        String contacts = this.contacts.getText();
        if (contacts != null && !"".equals(contacts)) {
            this.observer.addContact(contacts);
        }
        if (!(accounts = ((AccountTableModel)this.accounts.getModel()).getAllEntries()).isEmpty()) {
            this.observer.setAccounts((Map)accounts);
        }
        if ((fstO = this.fstOffset.getText()) != null && !"".equals(fstO)) {
            try {
                float fo = FloatUtil.parseFloat((String)fstO);
                this.observer.setFSTOffset(fo);
            }
            catch (NumberFormatException nfe) {
                super.createWarning(AbstractPanel.bundle.getString("panel.observer.warning.fstOffsetNumeric"));
                return null;
            }
        }
        return this.observer;
    }

    private String getObserverName() {
        String name = this.name.getText();
        if (name == null || "".equals(name)) {
            this.createWarning(AbstractPanel.bundle.getString("panel.observer.warning.noName"));
            return null;
        }
        return name;
    }

    private String getSurname() {
        String surname = this.surname.getText();
        if (surname == null) {
            super.createWarning(AbstractPanel.bundle.getString("panel.observer.warning.noSurename"));
            return null;
        }
        return surname;
    }

    private void createPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        this.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 5, 1);
        OMLabel Lname = new OMLabel(AbstractPanel.bundle.getString("panel.observer.label.name"), true);
        Lname.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.name"));
        gridbag.setConstraints(Lname, constraints);
        this.add(Lname);
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 45, 1);
        this.name = new JTextField();
        this.name.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.name"));
        gridbag.setConstraints(this.name, constraints);
        this.add(this.name);
        ConstraintsBuilder.buildConstraints(constraints, 2, 0, 1, 1, 5, 1);
        OMLabel Lsurname = new OMLabel(AbstractPanel.bundle.getString("panel.observer.label.surname"), 4, true);
        Lsurname.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.surname"));
        gridbag.setConstraints(Lsurname, constraints);
        this.add(Lsurname);
        ConstraintsBuilder.buildConstraints(constraints, 3, 0, 1, 1, 45, 1);
        this.surname = new JTextField();
        this.surname.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.surname"));
        gridbag.setConstraints(this.surname, constraints);
        this.add(this.surname);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 5, 1);
        OMLabel Lcontacts = new OMLabel(AbstractPanel.bundle.getString("panel.observer.label.contacts"), false);
        Lcontacts.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.contacts"));
        gridbag.setConstraints(Lcontacts, constraints);
        this.add(Lcontacts);
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 3, 1, 45, 1);
        constraints.fill = 2;
        this.contacts = new JTextArea(40, 3);
        this.contacts.addMouseListener(this);
        this.contacts.setLineWrap(true);
        this.contacts.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.contacts"));
        JScrollPane contactScroll = new JScrollPane(this.contacts);
        contactScroll.setMinimumSize(new Dimension(300, 60));
        gridbag.setConstraints(contactScroll, constraints);
        this.add(contactScroll);
        ConstraintsBuilder.buildConstraints(constraints, 0, 2, 1, 1, 5, 1);
        OMLabel LfstOffset = new OMLabel(AbstractPanel.bundle.getString("panel.observer.label.fstOffset"), false);
        LfstOffset.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.fstOffset"));
        gridbag.setConstraints(LfstOffset, constraints);
        this.add(LfstOffset);
        ConstraintsBuilder.buildConstraints(constraints, 1, 2, 1, 1, 30, 1);
        this.fstOffset = new JTextField();
        this.fstOffset.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.fstOffset"));
        gridbag.setConstraints(this.fstOffset, constraints);
        this.add(this.fstOffset);
        ConstraintsBuilder.buildConstraints(constraints, 2, 2, 1, 1, 15, 1);
        OMLabel LfstUnit = new OMLabel(AbstractPanel.bundle.getString("panel.observer.label.fstUnit"), false);
        LfstOffset.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.fstUnit"));
        gridbag.setConstraints(LfstUnit, constraints);
        this.add(LfstUnit);
        ConstraintsBuilder.buildConstraints(constraints, 0, 3, 1, 1, 50, 1);
        OMLabel Laccounts = new OMLabel(AbstractPanel.bundle.getString("panel.observer.label.accounts"), false);
        Laccounts.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.accounts"));
        gridbag.setConstraints(Laccounts, constraints);
        this.add(Laccounts);
        ConstraintsBuilder.buildConstraints(constraints, 0, 4, 4, 2, 50, 90);
        constraints.fill = 1;
        String[] accountBoxItems = null;
        JComboBox<String> accountBox = null;
        if (this.observer == null || this.observer.getAccounts() == null) {
            accountBoxItems = this.getAccountBoxItems(new HashMap());
            accountBox = new JComboBox<String>(accountBoxItems);
            this.accounts = new JTable(new AccountTableModel(new HashMap(), super.isEditable(), accountBox));
        } else {
            HashMap a = new HashMap(this.observer.getAccounts());
            accountBoxItems = this.getAccountBoxItems(a);
            accountBox = new JComboBox<String>(accountBoxItems);
            this.accounts = new JTable(new AccountTableModel(a, super.isEditable(), accountBox));
        }
        TableColumn col = this.accounts.getColumnModel().getColumn(0);
        accountBox.setRenderer(new AccountListRenderer());
        col.setCellEditor(new DefaultCellEditor(accountBox));
        this.accounts.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.accounts"));
        this.accounts.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JScrollPane scrollPane = new JScrollPane(this.accounts);
        gridbag.setConstraints(scrollPane, constraints);
        this.add(scrollPane);
        if (super.isEditable()) {
            ConstraintsBuilder.buildConstraints(constraints, 0, 6, 2, 1, 25, 1);
            this.addAccountRow = new JButton(AbstractPanel.bundle.getString("panel.observer.button.newAccount"));
            this.addAccountRow.addActionListener(this);
            this.addAccountRow.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.newAccount"));
            gridbag.setConstraints(this.addAccountRow, constraints);
            this.add(this.addAccountRow);
            ConstraintsBuilder.buildConstraints(constraints, 2, 6, 2, 1, 25, 1);
            this.deleteAccountRow = new JButton(AbstractPanel.bundle.getString("panel.observer.button.deleteAccount"));
            this.deleteAccountRow.addActionListener(this);
            this.deleteAccountRow.setToolTipText(AbstractPanel.bundle.getString("panel.observer.tooltip.deleteAccount"));
            gridbag.setConstraints(this.deleteAccountRow, constraints);
            this.add(this.deleteAccountRow);
        }
    }

    private String[] getAccountBoxItems(HashMap accounts) {
        ArrayList<String> items = new ArrayList<String>();
        items.add(AccountListRenderer.EMPTY_LIST_ENTRY);
        items.add("www.aavso.org");
        items.add("www.deepskylog.org");
        items.add("www.deepskyliste.de");
        String[] accountArray = accounts.keySet().toArray(new String[0]);
        for (int i = 0; i < accountArray.length; ++i) {
            if ("www.aavso.org".equals(accountArray[i]) || "www.deepskylog.org".equals(accountArray[i]) || "www.deepskyliste.de".equals(accountArray[i])) continue;
            items.add(accountArray[i]);
        }
        return items.toArray(new String[0]);
    }
}

