/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.preferences;

import de.lehmannet.om.IFinding;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ui.box.LanguageBox;
import de.lehmannet.om.ui.box.ObserverBox;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.preferences.PreferencesPanel;
import de.lehmannet.om.ui.util.Configuration;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.OMLabel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class BehaviourPanel
extends PreferencesPanel {
    private static final long serialVersionUID = -9046543688331125983L;
    private PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager om = null;
    private LanguageBox defaultContentLanguage = null;
    private JCheckBox imagesPathRelative = null;
    private ObserverBox defaultObserver = null;
    private JComboBox catalogBox = null;
    private JCheckBox retrieveEndDateFromSession = null;
    private JCheckBox useCoObserverInStatistics = null;
    private JCheckBox useLatinConstellationNames = null;

    public BehaviourPanel(Configuration config, ObservationManager om) {
        super(config);
        this.om = om;
        this.createPanel();
    }

    public String getTabTitle() {
        return this.bundle.getString("dialog.preferences.behaviourTab.title");
    }

    public void writeConfig() {
        boolean setAll;
        this.configuration.setConfig("om.imagesDir.relaitve", "" + this.imagesPathRelative.isSelected());
        String currentValue = this.configuration.getConfig("om.content.language.default");
        if (((currentValue == null || "".equals(currentValue.trim())) && this.defaultContentLanguage.getSelectedISOLanguage() != null || this.defaultContentLanguage.getSelectedISOLanguage() != null && !this.defaultContentLanguage.getSelectedISOLanguage().equals(currentValue)) && (setAll = this.showSetLanguageDialog())) {
            this.setLanguageForAllFindings(this.defaultContentLanguage.getSelectedISOLanguage());
            this.setLanguageForAllSessions(this.defaultContentLanguage.getSelectedISOLanguage());
        }
        this.configuration.setConfig("om.content.language.default", this.defaultContentLanguage.getSelectedISOLanguage());
        if (this.defaultObserver.getSelectedSchemaElement() != null) {
            this.configuration.setConfig("om.default.observer", "" + this.defaultObserver.getSelectedSchemaElement().getDisplayName());
        }
        if (this.catalogBox.getSelectedItem() != null) {
            this.configuration.setConfig("om.default.catalog", "" + this.catalogBox.getSelectedItem());
        }
        this.configuration.setConfig("om.retrieve.endDateFromSession", "" + this.retrieveEndDateFromSession.isSelected());
        this.configuration.setConfig("om.statistics.useCoObservers", "" + this.useCoObserverInStatistics.isSelected());
        this.configuration.setConfig("om.constellation.useI18N", "" + !this.useLatinConstellationNames.isSelected());
    }

    private void createPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        super.setLayout(gridbag);
        constraints.fill = 0;
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 10, 10);
        OMLabel imagesPathRelativeLabel = new OMLabel(this.bundle.getString("dialog.preferences.label.imagesPathRelative"), true);
        imagesPathRelativeLabel.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.imagesPathRelative"));
        gridbag.setConstraints(imagesPathRelativeLabel, constraints);
        super.add(imagesPathRelativeLabel);
        constraints.fill = 2;
        constraints.anchor = 17;
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 10, 10);
        this.imagesPathRelative = new JCheckBox();
        this.imagesPathRelative.setSelected(Boolean.valueOf(this.configuration.getConfig("om.imagesDir.relaitve", "true")));
        this.imagesPathRelative.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.imagesPathRelative"));
        gridbag.setConstraints(this.imagesPathRelative, constraints);
        super.add(this.imagesPathRelative);
        constraints.fill = 0;
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 10, 10);
        OMLabel contentDefaultLanguageLabel = new OMLabel(this.bundle.getString("dialog.preferences.label.contentDefaultLang"), true);
        contentDefaultLanguageLabel.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.contentDefaultLang"));
        gridbag.setConstraints(contentDefaultLanguageLabel, constraints);
        super.add(contentDefaultLanguageLabel);
        constraints.fill = 2;
        constraints.anchor = 17;
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 10, 10);
        this.defaultContentLanguage = new LanguageBox(true);
        this.defaultContentLanguage.setEnabled(true);
        String currentValue = this.configuration.getConfig("om.content.language.default");
        if (currentValue != null && !"".equals(currentValue.trim())) {
            this.defaultContentLanguage.setLanguage(currentValue);
        }
        this.defaultContentLanguage.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.contentDefaultLang"));
        gridbag.setConstraints(this.defaultContentLanguage, constraints);
        super.add(this.defaultContentLanguage);
        constraints.fill = 0;
        ConstraintsBuilder.buildConstraints(constraints, 0, 2, 1, 1, 10, 10);
        OMLabel defaultObserverLabel = new OMLabel(this.bundle.getString("dialog.preferences.label.defaultObserver"), true);
        defaultObserverLabel.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.defaultObserver"));
        gridbag.setConstraints(defaultObserverLabel, constraints);
        super.add(defaultObserverLabel);
        constraints.fill = 2;
        constraints.anchor = 17;
        ConstraintsBuilder.buildConstraints(constraints, 1, 2, 1, 1, 10, 10);
        this.defaultObserver = new ObserverBox();
        this.defaultObserver.setEnabled(true);
        this.fillObserverBox();
        this.defaultObserver.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.defaultObserver"));
        gridbag.setConstraints(this.defaultObserver, constraints);
        super.add(this.defaultObserver);
        constraints.fill = 0;
        ConstraintsBuilder.buildConstraints(constraints, 0, 3, 1, 1, 10, 10);
        OMLabel defaultCatalogLabel = new OMLabel(this.bundle.getString("dialog.preferences.label.defaultCatalog"), true);
        defaultCatalogLabel.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.defaultCatalog"));
        gridbag.setConstraints(defaultCatalogLabel, constraints);
        super.add(defaultCatalogLabel);
        constraints.fill = 2;
        constraints.anchor = 17;
        ConstraintsBuilder.buildConstraints(constraints, 1, 3, 1, 1, 10, 10);
        this.catalogBox = new JComboBox();
        this.catalogBox.setEnabled(true);
        this.fillCatalogBox();
        this.catalogBox.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.defaultCatalog"));
        gridbag.setConstraints(this.catalogBox, constraints);
        super.add(this.catalogBox);
        constraints.fill = 0;
        ConstraintsBuilder.buildConstraints(constraints, 0, 4, 1, 1, 10, 10);
        OMLabel LretrieveEndDateFromSession = new OMLabel(this.bundle.getString("dialog.preferences.label.retrieveEndDateFromSession"), true);
        LretrieveEndDateFromSession.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.retrieveEndDateFromSession"));
        gridbag.setConstraints(LretrieveEndDateFromSession, constraints);
        super.add(LretrieveEndDateFromSession);
        constraints.fill = 2;
        constraints.anchor = 17;
        ConstraintsBuilder.buildConstraints(constraints, 1, 4, 1, 1, 10, 10);
        this.retrieveEndDateFromSession = new JCheckBox();
        this.retrieveEndDateFromSession.setSelected(Boolean.valueOf(this.configuration.getConfig("om.retrieve.endDateFromSession")));
        this.retrieveEndDateFromSession.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.retrieveEndDateFromSession"));
        gridbag.setConstraints(this.retrieveEndDateFromSession, constraints);
        super.add(this.retrieveEndDateFromSession);
        constraints.fill = 0;
        ConstraintsBuilder.buildConstraints(constraints, 0, 5, 1, 1, 10, 10);
        OMLabel LuseCoObserverInStatistics = new OMLabel(this.bundle.getString("dialog.preferences.label.useCoObserverInStatistics"), true);
        LuseCoObserverInStatistics.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.useCoObserverInStatistics"));
        gridbag.setConstraints(LuseCoObserverInStatistics, constraints);
        super.add(LuseCoObserverInStatistics);
        constraints.fill = 2;
        constraints.anchor = 17;
        ConstraintsBuilder.buildConstraints(constraints, 1, 5, 1, 1, 10, 10);
        this.useCoObserverInStatistics = new JCheckBox();
        this.useCoObserverInStatistics.setSelected(Boolean.valueOf(this.configuration.getConfig("om.statistics.useCoObservers", "true")));
        this.useCoObserverInStatistics.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.useCoObserverInStatistics"));
        gridbag.setConstraints(this.useCoObserverInStatistics, constraints);
        super.add(this.useCoObserverInStatistics);
        constraints.fill = 0;
        ConstraintsBuilder.buildConstraints(constraints, 0, 6, 1, 1, 10, 10);
        OMLabel LuseLatinConstellationNames = new OMLabel(this.bundle.getString("dialog.preferences.label.useLatinConstellationNames"), true);
        LuseLatinConstellationNames.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.useLatinConstellationNames"));
        gridbag.setConstraints(LuseLatinConstellationNames, constraints);
        super.add(LuseLatinConstellationNames);
        constraints.fill = 2;
        constraints.anchor = 17;
        ConstraintsBuilder.buildConstraints(constraints, 1, 6, 1, 1, 10, 10);
        this.useLatinConstellationNames = new JCheckBox();
        this.useLatinConstellationNames.setSelected(Boolean.valueOf(this.configuration.getConfig("om.constellation.useI18N", "true")) == false);
        this.useLatinConstellationNames.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.useLatinConstellationNames"));
        gridbag.setConstraints(this.useLatinConstellationNames, constraints);
        super.add(this.useLatinConstellationNames);
    }

    private void fillObserverBox() {
        String currentValue = this.configuration.getConfig("om.default.observer");
        IObserver[] observers = this.om.getXmlCache().getObservers();
        IObserver defaultObserver = null;
        for (int i = 0; i < observers.length; ++i) {
            this.defaultObserver.addItem((ISchemaElement)observers[i]);
            if (currentValue == null || !currentValue.equals(observers[i].getDisplayName())) continue;
            defaultObserver = observers[i];
        }
        if (defaultObserver != null) {
            this.defaultObserver.setSelectedItem((ISchemaElement)defaultObserver);
        }
    }

    private void fillCatalogBox() {
        String[] cNames = this.om.getExtensionLoader().getCatalogLoader().getCatalogNames();
        for (int i = 0; i < cNames.length; ++i) {
            this.catalogBox.addItem(cNames[i]);
        }
        this.catalogBox.setSelectedItem(this.om.getConfiguration().getConfig("om.default.catalog"));
    }

    private void setLanguageForAllFindings(String isoLanguage) {
        IObservation[] observations = this.om.getXmlCache().getObservations();
        List findings = null;
        ListIterator iter = null;
        for (int i = 0; i < observations.length; ++i) {
            findings = observations[i].getResults();
            iter = findings.listIterator();
            while (iter.hasNext()) {
                ((IFinding)iter.next()).setLanguage(isoLanguage);
            }
        }
    }

    private void setLanguageForAllSessions(String isoLanguage) {
        ISession[] sessions = this.om.getXmlCache().getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            sessions[i].setLanguage(isoLanguage);
        }
    }

    private boolean showSetLanguageDialog() {
        JOptionPane pane = new JOptionPane(this.bundle.getString("dialog.preferences.setLanguage2All.question"), 3, 0);
        JDialog dialog = pane.createDialog(this.om, this.bundle.getString("dialog.preferences.setLanguage2All.title"));
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        return selectedValue != null && selectedValue instanceof Integer && (Integer)selectedValue == 0;
    }
}

