/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.update;

import de.lehmannet.om.ui.update.UpdateEntry;
import de.lehmannet.om.ui.util.Worker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.ListIterator;

class DownloadTask
implements Worker {
    private File targetDir = null;
    private List updateEntries = null;
    private byte returnValue = 0;

    public DownloadTask(List updateEntries, File targetDirectory) {
        this.updateEntries = updateEntries;
        this.targetDir = targetDirectory;
    }

    public String getReturnMessage() {
        return null;
    }

    public byte getReturnType() {
        return this.returnValue;
    }

    public void run() {
        ListIterator iterator = this.updateEntries.listIterator();
        UpdateEntry currentEntry = null;
        while (iterator.hasNext()) {
            currentEntry = (UpdateEntry)iterator.next();
            try {
                int len;
                HttpURLConnection conn = (HttpURLConnection)currentEntry.getDownloadURL().openConnection();
                conn.setRequestProperty("User-Agent", "Observation Manager Update Client");
                if (conn.getResponseCode() != 200) {
                    System.err.println("No download possible from: " + currentEntry.getDownloadURL() + "\nHTTP Response was: " + conn.getResponseMessage());
                    conn.disconnect();
                    this.returnValue = (byte)2;
                    continue;
                }
                String path = currentEntry.getDownloadURL().getPath();
                String filename = path.substring(path.lastIndexOf(47) + 1);
                BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
                FileOutputStream fos = new FileOutputStream(this.targetDir.getAbsolutePath() + File.separator + filename);
                byte[] buf = new byte[1024];
                while ((len = bis.read(buf)) > 0) {
                    fos.write(buf, 0, len);
                }
                bis.close();
                fos.flush();
                fos.close();
                conn.disconnect();
            }
            catch (IOException ioe) {
                System.err.println("Error while downloading file: " + currentEntry.getDownloadURL() + "\nNested exception was: " + ioe);
            }
        }
        this.returnValue = 0;
    }
}

