/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.update;

import de.lehmannet.om.ui.update.UpdateEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

class UpdateTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3059700226953902438L;
    private PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private List updateEntries = null;
    private boolean[] checkBoxes = null;
    private JButton download = null;
    private int activeCounter = 0;

    public UpdateTableModel(List updateEntries, JButton download) {
        this.updateEntries = updateEntries;
        this.checkBoxes = new boolean[this.updateEntries.size()];
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            this.checkBoxes[i] = true;
        }
        this.activeCounter = this.updateEntries.size();
        this.download = download;
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        if (this.updateEntries == null || this.updateEntries.isEmpty()) {
            return 5;
        }
        return this.updateEntries.size();
    }

    public void setValueAt(Object o, int row, int column) {
        if (column == 0 && o instanceof Boolean) {
            this.activeCounter = this.checkBoxes[row] ? --this.activeCounter : ++this.activeCounter;
            if (this.activeCounter == 0) {
                this.download.setEnabled(false);
            } else {
                this.download.setEnabled(true);
            }
            this.checkBoxes[row] = !this.checkBoxes[row];
            super.fireTableDataChanged();
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new Boolean(this.checkBoxes[rowIndex]);
            }
            case 1: {
                return "" + ((UpdateEntry)this.updateEntries.get(rowIndex)).getName();
            }
            case 2: {
                return "" + ((UpdateEntry)this.updateEntries.get(rowIndex)).getOldVersion();
            }
            case 3: {
                return "" + ((UpdateEntry)this.updateEntries.get(rowIndex)).getNewVersion();
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        Class c = null;
        switch (columnIndex) {
            case 0: {
                c = Boolean.class;
                break;
            }
            default: {
                c = String.class;
            }
        }
        return c;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public String getColumnName(int column) {
        String name = "";
        switch (column) {
            case 0: {
                name = this.bundle.getString("updateInfo.column.download");
                break;
            }
            case 1: {
                name = this.bundle.getString("updateInfo.column.name");
                break;
            }
            case 2: {
                name = this.bundle.getString("updateInfo.column.oldVersion");
                break;
            }
            case 3: {
                name = this.bundle.getString("updateInfo.column.newVersion");
            }
        }
        return name;
    }

    public List getSelected() {
        ArrayList result = new ArrayList(this.checkBoxes.length);
        boolean currentValue = false;
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            currentValue = (Boolean)this.getValueAt(i, 0);
            if (!currentValue) continue;
            result.add(this.updateEntries.get(i));
        }
        return result;
    }
}

