/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.IObserver;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.Target;
import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericTarget
extends Target {
    public static final String XML_XSI_TYPE_VALUE = "oal:observationTargetType";

    public GenericTarget(Node targetElement, IObserver[] observers) throws SchemaException {
        super(targetElement, observers);
    }

    public GenericTarget(String name, String datasource) throws IllegalArgumentException {
        super(name, datasource);
    }

    public GenericTarget(String name, IObserver observer) throws IllegalArgumentException {
        super(name, observer);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GenericTarget Name=");
        buffer.append(super.getName());
        if (super.getAliasNames() != null && super.getAliasNames().length > 0) {
            buffer.append(" Alias names=");
            String[] an = super.getAliasNames();
            for (int i = 0; i < an.length; ++i) {
                buffer.append(an[i]);
                if (i > an.length - 2) continue;
                buffer.append(", ");
            }
        }
        if (super.getPosition() != null) {
            buffer.append(" Position=");
            buffer.append(super.getPosition());
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ITarget)) {
            return false;
        }
        ITarget target = (ITarget)obj;
        String targetName = target.getName();
        if (targetName == null) {
            return false;
        }
        return super.getName().toLowerCase().equals(targetName.toLowerCase()) && this.getXSIType().equals(target.getXSIType());
    }

    public Element addToXmlElement(Element element) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        Element e_Targets = null;
        boolean created = false;
        NodeList nodeList = ownerDoc.getElementsByTagName("targets");
        if (nodeList.getLength() == 0) {
            e_Targets = ownerDoc.createElement("targets");
            created = true;
        } else {
            e_Targets = (Element)nodeList.item(0);
        }
        nodeList = e_Targets.getElementsByTagName("target");
        if (nodeList.getLength() > 0) {
            Node currentNode = null;
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                attributes = currentNode.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                if (idAttribute == null || !idAttribute.getNodeValue().trim().equals(super.getID().trim())) continue;
                return null;
            }
        }
        Element e_Target = super.createXmlTargetElement(e_Targets);
        e_Targets.appendChild(e_Target);
        e_Target.setAttribute("xsi:type", this.getXSIType());
        if (created) {
            ownerDoc.getDocumentElement().appendChild(e_Targets);
        }
        return e_Target;
    }

    public String getXSIType() {
        return XML_XSI_TYPE_VALUE;
    }
}

