/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsException;
import eap.fits.FitsHeader;
import eap.fits.NoSuchFitsCardException;

public abstract class FitsColumn {
    private int number;
    private String name;
    protected String form;
    protected char type;
    protected int count;
    private double zero;
    private double scale;
    protected Class representation;
    protected int bytes;
    String units;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;

    public FitsColumn(FitsHeader fitsHeader, int n) throws FitsException {
        this.number = this.number;
        this.name = fitsHeader.card("TTYPE" + n).stringValue();
        this.form = fitsHeader.card("TFORM" + n).stringValue();
        try {
            this.units = fitsHeader.card("TUNIT" + n).stringValue();
        }
        catch (NoSuchFitsCardException noSuchFitsCardException) {
            this.units = null;
        }
        try {
            this.scale = fitsHeader.card("TSCALE" + n).doubleValue();
        }
        catch (NoSuchFitsCardException noSuchFitsCardException) {
            this.scale = 1.0;
        }
        try {
            this.zero = fitsHeader.card("TZERO" + n).doubleValue();
        }
        catch (NoSuchFitsCardException noSuchFitsCardException) {
            this.zero = 0.0;
        }
    }

    public Class rawRepresentation() {
        return this.representation;
    }

    public Class scaledRepresentation() {
        if (!this.isScaled()) {
            return this.rawRepresentation();
        }
        if (this.representation == (class$java$lang$Double == null ? (class$java$lang$Double = FitsColumn.class$("java.lang.Double")) : class$java$lang$Double) || this.representation == (class$java$lang$Float == null ? (class$java$lang$Float = FitsColumn.class$("java.lang.Float")) : class$java$lang$Float) || (double)((int)this.scale) != this.scale || (double)((int)this.zero) != this.zero) {
            return class$java$lang$Double == null ? (class$java$lang$Double = FitsColumn.class$("java.lang.Double")) : class$java$lang$Double;
        }
        return class$java$lang$Long == null ? (class$java$lang$Long = FitsColumn.class$("java.lang.Long")) : class$java$lang$Long;
    }

    public String getUnits() {
        return this.units;
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        if (this.type == 'A') {
            return 1;
        }
        return this.count;
    }

    public int getWidth() {
        if (this.count == -1) {
            return 8;
        }
        return this.count * this.bytes;
    }

    public int getElementSize() {
        return this.bytes;
    }

    public Object represent(Number number) {
        if (number.getClass() == this.representation) {
            return number;
        }
        if (this.representation == (class$java$lang$Byte == null ? (class$java$lang$Byte = FitsColumn.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte(number.byteValue());
        }
        if (this.representation == (class$java$lang$Short == null ? (class$java$lang$Short = FitsColumn.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(number.shortValue());
        }
        if (this.representation == (class$java$lang$Integer == null ? (class$java$lang$Integer = FitsColumn.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(number.intValue());
        }
        if (this.representation == (class$java$lang$Float == null ? (class$java$lang$Float = FitsColumn.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(number.floatValue());
        }
        if (this.representation == (class$java$lang$Double == null ? (class$java$lang$Double = FitsColumn.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(number.doubleValue());
        }
        if (this.representation == (class$java$lang$String == null ? (class$java$lang$String = FitsColumn.class$("java.lang.String")) : class$java$lang$String)) {
            return number.toString();
        }
        if (this.representation == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FitsColumn.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new Boolean(number.doubleValue() != 0.0);
        }
        return null;
    }

    public Object represent(String string) {
        if (this.representation == (class$java$lang$String == null ? (class$java$lang$String = FitsColumn.class$("java.lang.String")) : class$java$lang$String)) {
            return string;
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) == '+') {
            string = string.substring(1);
        }
        if (this.representation == (class$java$lang$Byte == null ? (class$java$lang$Byte = FitsColumn.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte(string);
        }
        if (this.representation == (class$java$lang$Short == null ? (class$java$lang$Short = FitsColumn.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(string);
        }
        if (this.representation == (class$java$lang$Integer == null ? (class$java$lang$Integer = FitsColumn.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(string);
        }
        if (this.representation == (class$java$lang$Float == null ? (class$java$lang$Float = FitsColumn.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(string);
        }
        if (this.representation == (class$java$lang$Double == null ? (class$java$lang$Double = FitsColumn.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(string);
        }
        if (this.representation == (class$java$lang$String == null ? (class$java$lang$String = FitsColumn.class$("java.lang.String")) : class$java$lang$String)) {
            return string.toString();
        }
        if (this.representation == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FitsColumn.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new Boolean(string);
        }
        return null;
    }

    public Object represent(Boolean bl) {
        if (this.representation == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FitsColumn.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return bl;
        }
        if (this.representation == (class$java$lang$String == null ? (class$java$lang$String = FitsColumn.class$("java.lang.String")) : class$java$lang$String)) {
            return bl.toString();
        }
        if (bl.booleanValue()) {
            if (this.representation == (class$java$lang$Byte == null ? (class$java$lang$Byte = FitsColumn.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return new Byte(1);
            }
            if (this.representation == (class$java$lang$Short == null ? (class$java$lang$Short = FitsColumn.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Short(1);
            }
            if (this.representation == (class$java$lang$Integer == null ? (class$java$lang$Integer = FitsColumn.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer(1);
            }
            if (this.representation == (class$java$lang$Float == null ? (class$java$lang$Float = FitsColumn.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Float(1.0);
            }
            if (this.representation == (class$java$lang$Double == null ? (class$java$lang$Double = FitsColumn.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(1.0);
            }
        } else {
            if (this.representation == (class$java$lang$Byte == null ? (class$java$lang$Byte = FitsColumn.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return new Byte(0);
            }
            if (this.representation == (class$java$lang$Short == null ? (class$java$lang$Short = FitsColumn.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Short(0);
            }
            if (this.representation == (class$java$lang$Integer == null ? (class$java$lang$Integer = FitsColumn.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer(0);
            }
            if (this.representation == (class$java$lang$Float == null ? (class$java$lang$Float = FitsColumn.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Float(0.0);
            }
            if (this.representation == (class$java$lang$Double == null ? (class$java$lang$Double = FitsColumn.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(0.0);
            }
        }
        return null;
    }

    public Object represent(Object object) {
        if (object instanceof Number) {
            return this.represent((Number)object);
        }
        if (object instanceof Boolean) {
            return this.represent((Boolean)object);
        }
        return this.represent(object.toString());
    }

    public Object represent(byte by) {
        return this.represent(new Byte(by));
    }

    public Object represent(int n) {
        return this.represent(new Integer(n));
    }

    public Object represent(long l) {
        return this.represent(new Long(l));
    }

    public Object represent(float f) {
        return this.represent(new Float(f));
    }

    public Object represent(double d) {
        return this.represent(new Double(d));
    }

    public boolean isScaled() {
        if (this.scale == 1.0 && this.zero == 0.0) {
            return false;
        }
        return (class$java$lang$Number == null ? (class$java$lang$Number = FitsColumn.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.representation);
    }

    public Object scale(Object object) {
        if (this.representation == (class$java$lang$String == null ? (class$java$lang$String = FitsColumn.class$("java.lang.String")) : class$java$lang$String)) {
            int n;
            String string = (String)object;
            for (n = string.length() - 1; n >= 0 && string.charAt(n) == ' '; --n) {
            }
            return string.substring(0, n + 1);
        }
        if (!this.isScaled()) {
            return object;
        }
        if (!(object instanceof Number)) {
            return object;
        }
        Number number = (Number)object;
        if (this.scaledRepresentation() == (class$java$lang$Double == null ? (class$java$lang$Double = FitsColumn.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(number.doubleValue() * this.scale + this.zero);
        }
        return new Long((long)((double)number.longValue() * this.scale + this.zero));
    }

    public Object unscale(Object object) {
        if (!this.isScaled()) {
            return object;
        }
        if (!(object instanceof Number)) {
            return object;
        }
        Number number = (Number)object;
        return this.represent((number.doubleValue() - this.zero) / this.scale);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

