/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsTform;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FitsColumn {
    private String stringNull = null;
    private long intNull;
    private boolean intNullDefined = false;
    private int repeat = 1;
    private char dataType = '\u0000';
    private long columnOffset = 0L;
    private int recordSize = 0;
    private FitsTform format;
    private int bytesPerData = 0;
    private long noRows = 0L;
    private boolean binColumn = true;
    private String display;
    private String label;
    private String unit;
    private double zero;
    private double scale;
    private boolean scaling = false;
    private RandomAccessFile dataFile = null;
    private long dataOffset = 0L;
    private boolean isRAFile = true;
    private byte[] dataArray = null;

    public FitsColumn(int type, String tform, String label, int rows) throws FitsException {
        this.format = new FitsTform(tform);
        this.dataType = this.format.getDataType();
        this.repeat = this.format.getRepeat();
        this.bytesPerData = this.format.getWidth();
        this.label = label;
        this.noRows = rows;
        this.binColumn = type == 2;
    }

    public void setData(RandomAccessFile file, long dataOffset, int position, int recordSize) {
        this.dataFile = file;
        this.dataOffset = dataOffset;
        this.isRAFile = true;
        this.columnOffset = position;
        this.recordSize = recordSize;
    }

    public void setData(byte[] array, int position, int recordSize) {
        this.dataArray = array;
        this.isRAFile = false;
        this.columnOffset = position;
        this.recordSize = recordSize;
    }

    public int getInt(int row) {
        int value = Integer.MIN_VALUE;
        byte[] dbuf = this.getBytes(row);
        try {
            if (this.binColumn) {
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(dbuf));
                switch (this.dataType) {
                    case 'I': {
                        value = di.readShort();
                        break;
                    }
                    case 'J': {
                        value = di.readInt();
                    }
                }
                if (this.intNullDefined && (long)value == this.intNull) {
                    value = Integer.MIN_VALUE;
                } else if (this.scaling) {
                    value = (int)(this.zero + this.scale * (double)value);
                }
            } else {
                String str = new String(dbuf);
                if (this.stringNull == null || !str.startsWith(this.stringNull)) {
                    value = Integer.valueOf(str);
                    if (this.scaling) {
                        value = (int)(this.zero + this.scale * (double)value);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int[] getInts(int row) {
        int[] arr = new int[this.repeat];
        byte[] dbuf = this.getBytes(row);
        try {
            if (this.binColumn) {
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(dbuf));
                int n = 0;
                while (n < this.repeat) {
                    int value = Integer.MIN_VALUE;
                    switch (this.dataType) {
                        case 'I': {
                            value = di.readShort();
                            break;
                        }
                        case 'J': {
                            value = di.readInt();
                        }
                    }
                    if (this.intNullDefined && (long)value == this.intNull) {
                        value = Integer.MIN_VALUE;
                    } else if (this.scaling) {
                        value = (int)(this.zero + this.scale * (double)value);
                    }
                    arr[n] = value;
                    ++n;
                }
            } else {
                String str = new String(dbuf);
                arr[0] = Integer.MIN_VALUE;
                if (this.stringNull == null || !str.startsWith(this.stringNull)) {
                    arr[0] = Integer.valueOf(str);
                    if (this.scaling) {
                        arr[0] = (int)(this.zero + this.scale * (double)arr[0]);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arr;
    }

    public double getReal(int row) {
        double value = Double.NaN;
        byte[] dbuf = this.getBytes(row);
        try {
            if (this.binColumn) {
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(dbuf));
                switch (this.dataType) {
                    case 'I': {
                        value = di.readShort();
                        break;
                    }
                    case 'J': {
                        value = di.readInt();
                        break;
                    }
                    case 'E': {
                        value = di.readFloat();
                        break;
                    }
                    case 'D': {
                        value = di.readDouble();
                    }
                }
                if (this.scaling) {
                    value = this.zero + this.scale * value;
                }
            } else {
                String str = new String(dbuf);
                if (this.stringNull == null || !str.startsWith(this.stringNull)) {
                    value = Double.valueOf(str);
                    if (this.scaling) {
                        value = this.zero + this.scale * value;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public double[] getReals(int row) {
        double[] arr = new double[this.repeat];
        byte[] dbuf = this.getBytes(row);
        try {
            if (this.binColumn) {
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(dbuf));
                int n = 0;
                while (n < this.repeat) {
                    switch (this.dataType) {
                        case 'I': {
                            arr[n] = di.readShort();
                            break;
                        }
                        case 'J': {
                            arr[n] = di.readInt();
                            break;
                        }
                        case 'E': {
                            arr[n] = di.readFloat();
                            break;
                        }
                        case 'D': {
                            arr[n] = di.readDouble();
                        }
                    }
                    if (this.scaling) {
                        arr[n] = this.zero + this.scale * arr[n];
                    }
                    ++n;
                }
            } else {
                double value = Double.NaN;
                String str = new String(dbuf);
                if (this.stringNull == null || !str.startsWith(this.stringNull)) {
                    arr[0] = Double.valueOf(str);
                    if (this.scaling) {
                        arr[0] = this.zero + this.scale * arr[0];
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arr;
    }

    public String getString(int row) {
        byte[] dbuf;
        String str = null;
        if (!(this.dataType != 'A' && this.dataType != 'L' || (dbuf = this.getBytes(row)) == null || this.stringNull != null && str.startsWith(this.stringNull))) {
            str = new String(dbuf);
        }
        return str;
    }

    private byte[] getBytes(int row) {
        if (row < 0 || this.noRows <= (long)row) {
            return null;
        }
        byte[] dbuf = new byte[this.getWidth()];
        if (this.isRAFile) {
            try {
                if (this.dataFile == null) {
                    return null;
                }
                this.dataFile.seek(this.dataOffset + this.columnOffset + (long)(row * this.recordSize));
                this.dataFile.read(dbuf);
            }
            catch (IOException e) {
                return null;
            }
        } else {
            if (this.dataArray == null) {
                return null;
            }
            int k = 0;
            int n = (int)(this.columnOffset + (long)(row * this.recordSize));
            int nsize = this.getWidth();
            while (nsize-- > 0) {
                dbuf[k++] = this.dataArray[n++];
            }
        }
        return dbuf;
    }

    public void setNull(String nullValue) {
        this.stringNull = nullValue;
    }

    public void setNull(int nullValue) {
        this.intNull = nullValue;
        this.intNullDefined = true;
    }

    public void setDim(String dim) {
    }

    public int getRepeat() {
        return this.repeat;
    }

    public char getDataType() {
        return this.dataType;
    }

    protected int getWidth() {
        return this.repeat * this.bytesPerData;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public double getZero() {
        return this.zero;
    }

    public void setZero(double zero) {
        this.zero = zero;
        this.scaling = true;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.scaling = true;
    }
}

