/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsHeader;
import de.andreasroerig.fits.FitsKeyword;

public class FitsWCS {
    public static final int ARC = 2;
    public static final int LIN = 0;
    private static final int MPS = 20;
    public static final int TAN = 1;
    protected double[] amdx = new double[20];
    protected double[] amdy = new double[20];
    protected double[] cdelt;
    protected double[][] cdMatrix;
    protected int[] cproj;
    protected double[] crota;
    protected double[] crpix;
    protected double[] crval;
    protected String[] ctype;
    protected boolean hasCdMatrix = false;
    protected boolean hasPcMatrix = false;
    protected int nax = 0;
    protected double[][] pcMatrix;
    protected int type = 0;

    public FitsWCS() {
    }

    public FitsWCS(FitsHeader header) {
        this();
        this.setHeader(header, ' ');
    }

    public FitsWCS(FitsHeader header, char ver) {
        this();
        this.setHeader(header, ver);
    }

    public FitsWCS(int nax) {
        this();
        this.init(nax);
    }

    private void init(int nax) {
        this.cproj = new int[nax];
        this.crpix = new double[nax];
        this.crval = new double[nax];
        this.cdelt = new double[nax];
        this.ctype = new String[nax];
        this.cdMatrix = new double[nax][nax];
        this.pcMatrix = new double[nax][nax];
        this.ctype = new String[nax];
        int n = 0;
        while (n < nax) {
            this.cproj[n] = 0;
            this.crpix[n] = 0.0;
            this.crval[n] = 0.0;
            this.cdelt[n] = 1.0;
            this.ctype[n] = "        ";
            int i = 0;
            while (i < nax) {
                this.cdMatrix[n][i] = i == n ? 1.0 : 0.0;
                this.pcMatrix[n][i] = i == n ? 1.0 : 0.0;
                ++i;
            }
            ++n;
        }
    }

    private double[] matrixMult(double[][] mtx, double[] vec) {
        int nv = vec.length;
        double[] res = new double[nv];
        int j = 0;
        while (j < nv) {
            res[j] = 0.0;
            int i = 0;
            while (i < nv) {
                int n = j;
                res[n] = res[n] + mtx[j][i] * vec[i];
                ++i;
            }
            ++j;
        }
        return res;
    }

    public void setHeader(FitsHeader header, char ver) {
        this.type = header.getType();
        FitsKeyword kw = header.getKeyword("NAXIS");
        this.nax = kw == null ? 0 : kw.getInt();
        this.init(this.nax);
        String sver = String.valueOf(ver).toUpperCase().trim();
        int j = 1;
        while (j <= this.nax) {
            String wctype;
            kw = header.getKeyword("CRPIX" + j + sver);
            this.crpix[j - 1] = kw == null ? 0.0 : kw.getReal();
            kw = header.getKeyword("CRVAL" + j + sver);
            this.crval[j - 1] = kw == null ? 0.0 : kw.getReal();
            kw = header.getKeyword("CDELT" + j + sver);
            this.cdelt[j - 1] = kw == null ? 1.0 : kw.getReal();
            this.cdMatrix[j - 1][j - 1] = this.cdelt[j - 1];
            kw = header.getKeyword("CTYPE" + j + sver);
            String string = this.ctype[j - 1] = kw == null ? "        " : kw.getString();
            this.cproj[j - 1] = 7 < this.ctype[j - 1].length() ? ((wctype = this.ctype[j - 1].substring(5, 7)).equals("TAN") ? 1 : (wctype.equals("ARC") ? 2 : 0)) : 0;
            int i = 1;
            while (i <= this.nax) {
                kw = header.getKeyword("CD" + j + "_" + j + sver);
                if (kw != null) {
                    this.cdMatrix[j - 1][i - 1] = kw.getReal();
                    this.hasCdMatrix = true;
                }
                ++i;
            }
            i = 1;
            while (i <= this.nax) {
                kw = header.getKeyword("PC" + j + "_" + i + sver);
                if (kw != null) {
                    this.pcMatrix[j - 1][i - 1] = kw.getReal();
                    this.hasPcMatrix = true;
                }
                ++i;
            }
            ++j;
        }
        j = 1;
        while (j < 20) {
            kw = header.getKeyword("AMDX" + j);
            this.amdx[j - 1] = kw == null ? 0.0 : kw.getReal();
            kw = header.getKeyword("AMDY" + j);
            this.amdy[j - 1] = kw == null ? 0.0 : kw.getReal();
            ++j;
        }
    }

    public double[] toPixel(double[] wcs) {
        double[] pix = new double[this.nax];
        double[] wc = new double[this.nax];
        int n = 0;
        while (n < this.nax) {
            pix[n] = (wcs[n] - this.crval[n]) / this.cdelt[n] + this.crpix[n];
            ++n;
        }
        return pix;
    }

    public double[] toWCS(double[] p) {
        double[] q;
        int j = 0;
        while (j < this.nax) {
            int n = j;
            p[n] = p[n] - this.crpix[j];
            ++j;
        }
        if (this.hasPcMatrix) {
            q = this.matrixMult(this.pcMatrix, p);
            j = 0;
            while (j < this.nax) {
                int n = j;
                q[n] = q[n] * this.cdelt[j];
                ++j;
            }
        } else if (this.hasCdMatrix) {
            q = this.matrixMult(this.cdMatrix, p);
        } else {
            q = p;
            j = 0;
            while (j < this.nax) {
                int n = j;
                q[n] = q[n] * this.cdelt[j];
                ++j;
            }
        }
        switch (this.cproj[0]) {
            case 0: 
            case 1: {
                j = 0;
                while (j < this.nax) {
                    int n = j;
                    q[n] = q[n] + this.crval[j];
                    ++j;
                }
                break;
            }
        }
        return q;
    }
}

