/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.tiff;

import de.andreasroerig.tiff.ReaderUtil;
import de.andreasroerig.util.SLogger;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CrwDirEntry {
    private int tag;
    private long valueSize;
    private long valueOffset;

    public CrwDirEntry(RandomAccessFile ras, boolean bigEnd) throws IOException {
        int[] theBytes = new int[5];
        int i = 0;
        while (i < 2) {
            theBytes[i] = ras.read();
            ++i;
        }
        this.tag = ReaderUtil.calcInt16(theBytes, bigEnd);
        SLogger.debug("tag=" + this.tag);
        i = 0;
        while (i < 4) {
            theBytes[i] = ras.read();
            ++i;
        }
        this.valueSize = ReaderUtil.calcInt16(theBytes, bigEnd);
        SLogger.debug("valueSize=" + this.valueSize);
        i = 0;
        while (i < 4) {
            theBytes[i] = ras.read();
            ++i;
        }
        this.valueOffset = ReaderUtil.calcInt16(theBytes, bigEnd);
        SLogger.debug("valueOffset=" + this.valueOffset);
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public long getValueOffset() {
        return this.valueOffset;
    }

    public void setValueOffset(long valueOffset) {
        this.valueOffset = valueOffset;
    }

    public long getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(long valueSize) {
        this.valueSize = valueSize;
    }
}

