/*
 * Decompiled with CFR 0.152.
 */
package regim;

import de.andreasroerig.bild.BWBild;
import de.andreasroerig.bild.Bild;
import de.andreasroerig.bild.IllegalDimensionException;
import de.andreasroerig.bild.MatchFinder;
import de.andreasroerig.bild.RGBBild;
import de.andreasroerig.gui.AboutDialog;
import de.andreasroerig.gui.CombineColorDialog;
import de.andreasroerig.gui.ExtendedFileFilter;
import de.andreasroerig.gui.FileChooser;
import de.andreasroerig.gui.GuiHelper;
import de.andreasroerig.gui.ImageFrame;
import de.andreasroerig.gui.MsgBox;
import de.andreasroerig.gui.MultChannelsDialog;
import de.andreasroerig.gui.RMenuBar;
import de.andreasroerig.gui.RegisterDialog;
import de.andreasroerig.gui.ScreenStretchPanel;
import de.andreasroerig.gui.SelectionDialog;
import de.andreasroerig.gui.StatusFrame;
import de.andreasroerig.match.MatchFinderTS;
import de.andreasroerig.tiff.TiffReader;
import de.andreasroerig.util.RegParams;
import de.andreasroerig.util.SLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import regim.BildVector;
import regim.FrameVector;

public class Regim
extends JFrame
implements ActionListener,
ComponentListener,
WindowListener,
InternalFrameListener,
PropertyChangeListener,
Runnable {
    private static final String cln = "Regim";
    private FrameVector pageFrame;
    private BildVector bilder;
    private int imageCount = 0;
    private String mainFrameName;
    private String currentPath = RegParams.instance().getCurrentPath();
    private String activeImageFrameName = "";
    private int runtype;
    private static final int RUNTYPE_REGISTER = 0;
    private static final int RUNTYPE_REGISTER_FILES = 1;
    private static final int RUNTYPE_BLEND = 2;
    private static final int RUNTYPE_BLEND_FILES = 3;
    private static final int RUNTYPE_MEDIAN_COMBINE = 4;
    private static final int RUNTYPE_MEDIAN_COMBINE_FILES = 5;
    private static final int RUNTYPE_OPEN = 6;
    private static final int RUNTYPE_SETUP_DARKS = 7;
    private static final int RUNTYPE_SETUP_FLATS = 8;
    private static final int RUNTYPE_CALIBRATE_FILES = 9;
    private static final int RUNTYPE_SAVE_AS = 10;
    private static final int RUNTYPE_SIGMA_COMBINE = 11;
    private static final int RUNTYPE_SIGMA_COMBINE_FILES = 12;
    private static final int RUNTYPE_COMBINE_CHNL = 13;
    private static final int RUNTYPE_SPLIT_CHNL = 14;
    private static final int RUNTYPE_MULT_CHNL = 15;
    private static final int RUNTYPE_SUBTRACT_FILES = 16;
    private boolean threadRunning = false;
    private JSplitPane splitPane;
    private JDesktopPane desktop;
    private ScreenStretchPanel ssf;
    protected RMenuBar mainMenuBar;
    private StatusFrame theStatusFrame;

    public Regim() {
        super(cln);
        this.bilder = new BildVector();
        this.pageFrame = new FrameVector();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = RegParams.instance().getMainWinWidth();
        int h = RegParams.instance().getMainWinHeight();
        int x = RegParams.instance().getMainWinPosX();
        int y = RegParams.instance().getMainWinPosY();
        if (w == 0) {
            w = (int)((double)screenSize.width / 1.5);
        }
        if (h == 0) {
            h = (int)((double)screenSize.height / 1.5);
        }
        if (x > screenSize.width) {
            x = 0;
        }
        if (y > screenSize.height) {
            y = 0;
        }
        this.setBounds(x, y, w, h);
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.createMenuBar();
        this.ssf = new ScreenStretchPanel(this, this);
        super.getContentPane().add((Component)this.ssf, "East");
        this.desktop = new JDesktopPane();
        this.theStatusFrame = new StatusFrame(this, "Status");
        this.splitPane = new JSplitPane(0, this.desktop, this.theStatusFrame);
        this.splitPane.setResizeWeight(0.9);
        super.getContentPane().add((Component)this.splitPane, "Center");
        this.desktop.setDragMode(1);
        SLogger.setStatusFrame(this.theStatusFrame);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.mainFrameName = this.getName();
        this.checkMenus();
    }

    public Regim(String title) {
        this();
        this.setTitle(title);
    }

    public Container getContentPane() {
        return this.desktop;
    }

    private void about_Action() {
        AboutDialog about = new AboutDialog(this);
    }

    private void open_Action() {
        Bild myBild = null;
        SLogger.debug("Regim Open gewaehlt!");
        FileChooser fileChooser = new FileChooser(this.currentPath);
        fileChooser.setDialogTitle("Open files");
        fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
        int rc = fileChooser.showOpenDialog(this);
        RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
        if (rc == 0) {
            File[] theFiles = fileChooser.getSelectedFiles();
            if (theFiles != null && theFiles.length > 0) {
                int i = 0;
                while (i < theFiles.length) {
                    try {
                        if (fileChooser.isFilterTypeFits()) {
                            myBild = new BWBild();
                            myBild.readFromFits(theFiles[i].getAbsolutePath());
                        } else {
                            TiffReader tr = new TiffReader(theFiles[i].getAbsolutePath());
                            myBild = tr.readBildFromTiff();
                            tr = null;
                        }
                        myBild.setFname(theFiles[i].getName());
                        this.activeImageFrameName = theFiles[i].getName();
                        this.display(myBild);
                        ++this.imageCount;
                    }
                    catch (IOException e) {
                        new MsgBox((Frame)this, "I/O Error", e.getMessage(), true);
                    }
                    ++i;
                }
                this.currentPath = theFiles[0].getPath();
            }
        } else {
            SLogger.debug("Regim Open canceled!");
        }
    }

    private void save_as_Action() {
        File theFiles;
        String name = "";
        SLogger.log("Save as gewaehlt!");
        ImageFrame imgFrame = this.getPageFrameByName(this.activeImageFrameName);
        if (imgFrame != null) {
            name = imgFrame.getTheBild().getFname();
        }
        FileChooser fileChooser = new FileChooser(this.currentPath, name);
        fileChooser.setDialogTitle("Save as");
        ExtendedFileFilter filter = new ExtendedFileFilter();
        filter.addExtension("tif");
        filter.setDescription("TIF Images");
        fileChooser.addChoosableFileFilter(filter);
        int rc = fileChooser.showSaveDialog(this);
        if (rc == 0 && (theFiles = fileChooser.getSelectedFile()) != null) {
            try {
                if (imgFrame != null) {
                    imgFrame.getTheBild().writeAsTiff(theFiles.getAbsolutePath());
                }
            }
            catch (Exception e) {
                SLogger.error(1, "can't write " + theFiles.getAbsolutePath());
                e.printStackTrace();
                MsgBox msgBox = new MsgBox((Frame)this, "Error", "Could not save " + theFiles.getAbsolutePath() + "|" + e.getMessage(), true);
            }
            this.currentPath = theFiles.getPath();
        }
    }

    private void save_as_Fits_Action() {
        File theFiles;
        String name = "";
        SLogger.log("Save as FitsConst gewaehlt!");
        ImageFrame imgFrame = this.getPageFrameByName(this.activeImageFrameName);
        if (imgFrame != null) {
            name = imgFrame.getTheBild().getFname();
        }
        FileChooser fileChooser = new FileChooser(this.currentPath, name);
        fileChooser.setDialogTitle("Save as");
        int rc = fileChooser.showSaveDialog(this);
        if (rc == 0 && (theFiles = fileChooser.getSelectedFile()) != null) {
            try {
                if (imgFrame != null) {
                    imgFrame.getTheBild().writeAsFits(String.valueOf(fileChooser.getPath()) + fileChooser.getNameWithoutExtension());
                }
            }
            catch (Exception e) {
                SLogger.error(1, "can't write " + theFiles.getAbsolutePath());
                e.printStackTrace();
                MsgBox msgBox = new MsgBox((Frame)this, "Error", "Could not save " + theFiles.getAbsolutePath(), true);
            }
            this.currentPath = theFiles.getPath();
        }
    }

    private void save_as_splited_Fits_Action() {
        String name = "";
        SLogger.log("Save as splited Fits gewaehlt!");
        ImageFrame imgFrame = this.getPageFrameByName(this.activeImageFrameName);
        if (imgFrame != null) {
            name = imgFrame.getTheBild().getFname();
        }
        if (imgFrame.getTheBild().getType() != 2) {
            File theFiles;
            FileChooser fileChooser = new FileChooser(this.currentPath, name);
            fileChooser.setDialogTitle("Save as");
            ExtendedFileFilter filter = new ExtendedFileFilter();
            filter.addExtension("fit");
            filter.setDescription("FITS Images");
            fileChooser.addChoosableFileFilter(filter);
            int rc = fileChooser.showSaveDialog(this);
            if (rc == 0 && (theFiles = fileChooser.getSelectedFile()) != null) {
                try {
                    if (imgFrame != null) {
                        ((RGBBild)imgFrame.getTheBild()).writeAsSplitedFits(fileChooser.getPath(), fileChooser.getNameWithoutExtension());
                    }
                }
                catch (Exception e) {
                    SLogger.error(1, "can't write " + theFiles.getAbsolutePath());
                    e.printStackTrace();
                    MsgBox msgBox = new MsgBox((Frame)this, "Error", "Could not save " + theFiles.getAbsolutePath(), true);
                }
            }
        } else {
            MsgBox msgBox = new MsgBox((Frame)this, "Error", "Image is already FITS. Could not split", true);
        }
    }

    private void closeAll_Action() {
        int i = 0;
        while (i < this.pageFrame.size()) {
            this.pageFrame.getFrameAt(i).close();
            ++i;
        }
        this.pageFrame.removeAllElements();
        this.bilder.removeAllElements();
        this.imageCount = 0;
        this.pageFrame = null;
        this.bilder = null;
        this.pageFrame = new FrameVector();
        this.bilder = new BildVector();
        System.runFinalization();
        System.gc();
    }

    private void exit_Action() {
        SLogger.debug("exit_Action() called");
        RegParams.instance().setCurrentPath(this.currentPath);
        RegParams.instance().setMainWinHeight(this.getHeight());
        RegParams.instance().setMainWinWidth(this.getWidth());
        RegParams.instance().setMainWinPosX(this.getX());
        RegParams.instance().setMainWinPosY(this.getY());
        RegParams.instance().saveProperties();
        this.hide();
        this.dispose();
        System.exit(0);
    }

    private void combineChnlAction() {
        SLogger.log("Combine chanels  gewaehlt! imageCount=" + this.imageCount);
        CombineColorDialog selection = new CombineColorDialog((Frame)this, this.pageFrame);
        if (selection.getOkPressed()) {
            int idxRed = selection.getRedIndex();
            int idxGreen = selection.getGreenIndex();
            int idxBlue = selection.getBlueIndex();
            try {
                BWBild br = (BWBild)this.bilder.getBildAt(idxRed);
                BWBild bg = (BWBild)this.bilder.getBildAt(idxGreen);
                BWBild bb = (BWBild)this.bilder.getBildAt(idxBlue);
                int len = br.getLen();
                int width = br.getWidth();
                br.checkDimensions(br, bg);
                br.checkDimensions(br, bb);
                RGBBild combined = new RGBBild();
                combined.setLen(len);
                combined.setWidth(width);
                combined.setR(br.getData());
                combined.setG(bg.getData());
                combined.setB(bb.getData());
                combined.setType(0);
                combined.calcStats();
                combined.setFname("RGBCombined.tif");
                this.display(combined);
                ++this.imageCount;
            }
            catch (IllegalDimensionException e) {
                SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                new MsgBox((Frame)this, "Error", "Illegal image size |" + e.getMessage(), true);
            }
            catch (ClassCastException e) {
                SLogger.error(1, "ClassCastException: " + e.getMessage());
                new MsgBox((Frame)this, "Error", "Images must be greyscale images!", true);
            }
        }
    }

    private void multiplyChannels_Action() {
        SLogger.log("Multiply Channels gewaehlt!");
        ImageFrame fr = this.getPageFrameByName(this.activeImageFrameName);
        Bild original = fr.getTheBild();
        if (original.getType() == 0) {
            RGBBild tmpBild = new RGBBild((RGBBild)original);
            tmpBild.setFname("mc_" + tmpBild.getFname());
            this.display(tmpBild);
            ImageFrame newFrame = this.getPageFrameByName(this.activeImageFrameName);
            newFrame.setScreenStretch(fr.getBlackPt(), fr.getWhitePt());
            MultChannelsDialog multChannels = new MultChannelsDialog(this, (RGBBild)original, newFrame);
            if (!multChannels.getOkPressed()) {
                newFrame.doDefaultCloseAction();
            }
        } else {
            new MsgBox((Frame)this, "Attention", "This is only possible for RGB TIFF images.", true);
        }
    }

    private void register_Action() {
        try {
            SLogger.log("Register gewaehlt!");
            RegisterDialog register = new RegisterDialog((Frame)this, this.pageFrame);
            int[] regImg = register.getRegIdx();
            if (regImg != null) {
                int masterIdx = register.getMasterIdx();
                Bild master = this.bilder.getBildAt(masterIdx);
                master.findStars();
                int i = 0;
                while (i < regImg.length) {
                    master.clearMatches();
                    Bild slave = this.bilder.getBildAt(regImg[i]);
                    slave.findStars();
                    MatchFinderTS mf = new MatchFinderTS(master, slave);
                    Bild result = mf.do_register();
                    if (result != null) {
                        result.setFname("Reg_" + slave.getFname());
                        this.display(result);
                    } else {
                        new MsgBox((Frame)this, "Attention", "Image " + slave.getFname() + " can not be registered!", true);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            SLogger.error(1, "register_Action() Exception! " + e.getMessage() + " : " + e.getCause());
            e.printStackTrace();
        }
    }

    private void registerSunFiles_Action() {
        SLogger.log("Register Sun Files gewaehlt! imageCount=" + this.imageCount);
        FileChooser fileChooser = new FileChooser(".");
        ExtendedFileFilter filter = new ExtendedFileFilter();
        filter.addExtension("tif");
        filter.setDescription("TIF Images");
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.showOpenDialog(this);
        File[] files = fileChooser.getSelectedFiles();
        int numfiles = files.length;
        try {
            RGBBild result = new RGBBild();
            result.readFromTiff(files[0].getAbsolutePath());
            result.setFname(files[0].getName());
        }
        catch (IOException e) {
            new MsgBox((Frame)this, "I/O Error", e.getMessage(), true);
        }
        ++this.imageCount;
        this.activeImageFrameName = files[0].getName();
        this.currentPath = files[0].getPath();
        try {
            int i = 1;
            while (i < numfiles) {
                RGBBild tmpBild2 = new RGBBild();
                tmpBild2.readFromTiff(files[i].getAbsolutePath());
                tmpBild2.setFname(files[i].getName());
                this.activeImageFrameName = files[i].getName();
                this.currentPath = files[i].getPath();
                MatchFinder mf = new MatchFinder(this.bilder.getBildAt(this.bilder.size() - 1), (Bild)tmpBild2);
                RGBBild tmpBild = mf.registerSun();
                String fname = this.currentPath.substring(0, this.currentPath.length() - files[i].getName().length());
                tmpBild.writeAsTiff(String.valueOf(fname) + "Reg_" + files[i].getName());
                tmpBild = null;
                ++i;
            }
        }
        catch (IOException e) {
            SLogger.error(1, "can't write ");
            e.printStackTrace();
            MsgBox msgBox = new MsgBox((Frame)this, "Error", "Could not save " + e.getMessage(), true);
        }
    }

    private void registerSun_Action() {
        try {
            SLogger.log("Register Sun gewaehlt!");
            RegisterDialog register = new RegisterDialog((Frame)this, this.pageFrame);
            int[] regImg = register.getRegIdx();
            int masterIdx = register.getMasterIdx();
            Bild master = this.bilder.getBildAt(masterIdx);
            int i = 0;
            while (i < regImg.length) {
                Bild slave = this.bilder.getBildAt(regImg[i]);
                MatchFinder mf = new MatchFinder(master, slave);
                RGBBild result = mf.registerSun();
                if (result != null) {
                    result.setFname("Reg_" + slave.getFname());
                    this.display(result);
                }
                ++i;
            }
        }
        catch (Exception e) {
            SLogger.error(1, "register_Action() Exception!");
            e.printStackTrace();
        }
    }

    private void sigmaCombine_Action() {
        SLogger.log("Sigma Combine gewaehlt! imageCount=" + this.imageCount);
        SelectionDialog selection = new SelectionDialog((Frame)this, this.pageFrame, 2);
        if (selection.getOkPressed()) {
            try {
                int[] frameIndices = selection.getFrameIndices();
                Bild[] bildArray = this.bilder.getBildArray();
                Bild blended = this.bilder.getBildAt(frameIndices[0]).sigmaCombine(bildArray, frameIndices);
                if (blended.getType() == 2) {
                    blended.setFname("SigmaCombined.fit");
                } else {
                    blended.setFname("SigmaCombined.tif");
                }
                this.display(blended);
                ++this.imageCount;
            }
            catch (IllegalDimensionException e) {
                SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                new MsgBox((Frame)this, "Error", "Illegal image size |" + e.getMessage(), true);
            }
        }
    }

    private void blend_Action() {
        SLogger.log("Blend gewaehlt! imageCount=" + this.imageCount);
        SelectionDialog selection = new SelectionDialog((Frame)this, this.pageFrame, 0);
        if (selection.getOkPressed()) {
            try {
                int[] frameIndices = selection.getFrameIndices();
                double[] weights = selection.getWeights();
                Bild[] bildArray = this.bilder.getBildArray();
                Bild blended = this.bilder.getBildAt(frameIndices[0]).blend(bildArray, frameIndices, weights);
                if (blended.getType() == 2) {
                    blended.setFname("Blended.fit");
                } else {
                    blended.setFname("Blended.tif");
                }
                this.display(blended);
                ++this.imageCount;
            }
            catch (IllegalDimensionException e) {
                SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                new MsgBox((Frame)this, "Error", "Illegal image size |" + e.getMessage(), true);
            }
        }
    }

    private void blendFiles_Action() {
        SLogger.log("Blend Files gewaehlt! imageCount=" + this.imageCount);
        FileChooser fileChooser = new FileChooser(this.currentPath);
        fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
        int returnVal = fileChooser.showOpenDialog(this);
        RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
        if (returnVal == 0) {
            File[] theFiles = fileChooser.getSelectedFiles();
            try {
                Bild blended = GuiHelper.isFitsFileExtension(theFiles[0].getAbsolutePath()) ? new BWBild() : new RGBBild();
                try {
                    blended.blendFiles(theFiles);
                    this.display(blended);
                    ++this.imageCount;
                }
                catch (IOException e) {
                    new MsgBox((Frame)this, "I/O Error", e.getMessage(), true);
                }
                this.currentPath = theFiles[0].getPath();
            }
            catch (IllegalDimensionException e) {
                SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                new MsgBox((Frame)this, "Error", "Illegal image size |" + e.getMessage(), true);
            }
        }
    }

    private void sigmaCombineFiles_Action() {
        SLogger.log("Sigma Combine Files gewaehlt! imageCount=" + this.imageCount);
        FileChooser fileChooser = new FileChooser(this.currentPath);
        fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File[] theFiles = fileChooser.getSelectedFiles();
            RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
            SelectionDialog selection = new SelectionDialog((Frame)this, theFiles, 2);
            if (selection.getOkPressed()) {
                try {
                    Bild blended = GuiHelper.isFitsFileExtension(theFiles[0].getAbsolutePath()) ? new BWBild() : new RGBBild();
                    try {
                        blended.sigmaCombineFiles(theFiles);
                        this.display(blended);
                        ++this.imageCount;
                    }
                    catch (IOException e) {
                        new MsgBox((Frame)this, "I/O Error", e.getMessage(), true);
                    }
                    this.currentPath = theFiles[0].getPath();
                }
                catch (IllegalDimensionException e) {
                    SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                    new MsgBox((Frame)this, "Error", "Illegal image size |" + e.getMessage(), true);
                }
            }
        }
    }

    private void medianCombine_Action() {
        SLogger.log("Median Combine! imageCount=" + this.imageCount);
        SelectionDialog selection = new SelectionDialog((Frame)this, this.pageFrame, 1);
        if (selection.getOkPressed()) {
            try {
                int[] frameIndices = selection.getFrameIndices();
                Bild[] bildArray = this.bilder.getBildArray();
                Bild combined = this.bilder.getBildAt(frameIndices[0]).medianCombine(bildArray, frameIndices);
                if (combined.getType() == 2) {
                    combined.setFname("MedianCombined.fit");
                } else {
                    combined.setFname("MedianCombined.tif");
                }
                this.display(combined);
                ++this.imageCount;
            }
            catch (IllegalDimensionException e) {
                SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                new MsgBox((Frame)this, "Attention", "Image has illegal dimensions: |" + e.getMessage(), true);
            }
        }
    }

    private void medianCombineFiles_Action() {
        File[] theFiles;
        SLogger.log("Median Combine Files! imageCount=" + this.imageCount);
        FileChooser fileChooser = new FileChooser(this.currentPath);
        fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
        int returnVal = fileChooser.showOpenDialog(this);
        RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
        if (returnVal == 0 && (theFiles = fileChooser.getSelectedFiles()) != null && theFiles.length > 0) {
            Bild combined = GuiHelper.isFitsFileExtension(theFiles[0].getAbsolutePath()) ? new BWBild() : new RGBBild();
            try {
                combined.medianCombineFiles(theFiles);
                this.display(combined);
                ++this.imageCount;
            }
            catch (IOException e) {
                new MsgBox((Frame)this, "I/O Error", e.getMessage(), true);
            }
            catch (IllegalDimensionException e) {
                SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                new MsgBox((Frame)this, "Attention", "Image has illegal dimensions: |" + e.getMessage(), true);
            }
            this.currentPath = theFiles[0].getPath();
        }
    }

    private void registerFiles_Action() {
        block16: {
            SLogger.log("Register Files! imageCount=" + this.imageCount);
            FileChooser fileChooser = new FileChooser(this.currentPath);
            fileChooser.setDialogTitle("Select files for registration");
            fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
            int rc = fileChooser.showOpenDialog(this);
            RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
            try {
                TiffReader tr;
                RegisterDialog register;
                int[] regImg;
                File[] theFiles;
                if (rc != 0 || (theFiles = fileChooser.getSelectedFiles()) == null || theFiles.length <= 0 || (regImg = (register = new RegisterDialog((Frame)this, theFiles, theFiles.length)).getRegIdx()) == null) break block16;
                int masterIdx = register.getMasterIdx();
                Bild master = null;
                try {
                    if (GuiHelper.isFitsFileExtension(theFiles[masterIdx].getAbsolutePath())) {
                        master = new BWBild();
                        master.readFromFits(theFiles[masterIdx].getAbsolutePath());
                    } else {
                        tr = new TiffReader(theFiles[masterIdx].getAbsolutePath());
                        master = tr.readBildFromTiff();
                        tr = null;
                    }
                }
                catch (IOException e) {
                    new MsgBox((Frame)this, "I/O Error", e.getMessage(), true);
                }
                master.findStars();
                Bild slave = null;
                int i = 0;
                while (i < theFiles.length) {
                    Bild result;
                    if (i != masterIdx) {
                        try {
                            if (GuiHelper.isFitsFileExtension(theFiles[i].getAbsolutePath())) {
                                slave = new BWBild();
                                slave.readFromFits(theFiles[i].getAbsolutePath());
                            } else {
                                tr = new TiffReader(theFiles[i].getAbsolutePath());
                                slave = tr.readBildFromTiff();
                                tr = null;
                            }
                        }
                        catch (IOException e) {
                            new MsgBox((Frame)this, "I/O Error", e.getMessage(), true);
                        }
                        slave.findStars();
                        MatchFinderTS mf = new MatchFinderTS(master, slave);
                        result = mf.do_register();
                        if (result != null) {
                            result.setFname("Reg_" + theFiles[i].getName());
                            String fname = theFiles[i].getAbsolutePath().substring(0, theFiles[i].getAbsolutePath().indexOf(theFiles[i].getName()));
                            fname = String.valueOf(fname) + "Reg_" + theFiles[i].getName();
                            if (result.getType() == 2) {
                                result.writeAsFits(fname);
                            } else {
                                result.writeAsTiff(fname);
                            }
                        } else {
                            new MsgBox((Frame)this, "Attention", "Image " + slave.getFname() + " can not be registered!", true);
                        }
                    }
                    result = null;
                    master.clearMatches();
                    System.runFinalization();
                    System.gc();
                    ++i;
                }
                this.currentPath = theFiles[0].getPath();
            }
            catch (IOException e) {
                SLogger.error(1, "can't write ");
                e.printStackTrace();
                MsgBox msgBox = new MsgBox((Frame)this, "Error", "Could not save " + e.getMessage(), true);
            }
        }
    }

    private void setupDarks_Action() {
        File[] theFiles;
        SLogger.log("Setup Darks! imageCount=" + this.imageCount);
        FileChooser fileChooser = new FileChooser(this.currentPath);
        fileChooser.setDialogTitle("Select dark frames");
        fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
        int rc = fileChooser.showOpenDialog(this);
        RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
        if (rc == 0 && (theFiles = fileChooser.getSelectedFiles()) != null && theFiles.length > 0) {
            Bild dark = GuiHelper.isFitsFileExtension(theFiles[0].getAbsolutePath()) ? new BWBild() : new RGBBild();
            try {
                dark.medianCombineFiles(theFiles);
            }
            catch (IOException e) {
                new MsgBox((Frame)this, "I/O Error", e.getMessage(), true);
            }
            catch (IllegalDimensionException e) {
                SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                new MsgBox((Frame)this, "Attention", "Image has illegal dimensions: |" + e.getMessage(), true);
            }
            if (dark.getType() == 2) {
                dark.setFname("dark.fit");
            } else {
                dark.setFname("dark.tif");
            }
            this.display(dark);
            ++this.imageCount;
            this.currentPath = theFiles[0].getPath();
        }
    }

    private void calibrateFiles_Action() {
        boolean darkPresent = false;
        boolean flatPresent = false;
        Bild image = null;
        Bild flat = null;
        Bild dark = null;
        SLogger.log("Calibrate Files! imageCount=" + this.imageCount);
        FileChooser fileChooser = new FileChooser(this.currentPath);
        fileChooser.setDialogTitle("Select master dark frame");
        fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
        int rc = fileChooser.showOpenDialog(this);
        RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
        try {
            File[] theFlat;
            File[] theDark;
            if (rc == 0 && (theDark = fileChooser.getSelectedFiles()) != null && theDark.length > 0) {
                if (GuiHelper.isFitsFileExtension(theDark[0].getAbsolutePath())) {
                    dark = new BWBild();
                    dark.readFromFits(theDark[0].getAbsolutePath());
                } else {
                    dark = new RGBBild();
                    dark.readFromTiff(theDark[0].getAbsolutePath());
                }
                this.currentPath = theDark[0].getPath();
                darkPresent = true;
            }
            fileChooser = new FileChooser(this.currentPath);
            fileChooser.setDialogTitle("Select master flat frame");
            fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
            rc = fileChooser.showOpenDialog(this);
            RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
            if (rc == 0 && (theFlat = fileChooser.getSelectedFiles()) != null && theFlat.length > 0) {
                if (GuiHelper.isFitsFileExtension(theFlat[0].getAbsolutePath())) {
                    flat = new BWBild();
                    flat.readFromFits(theFlat[0].getAbsolutePath());
                } else {
                    flat = new RGBBild();
                    flat.readFromTiff(theFlat[0].getAbsolutePath());
                }
                this.currentPath = theFlat[0].getPath();
                flatPresent = true;
                flat.toBW();
            }
            fileChooser = new FileChooser(this.currentPath);
            fileChooser.setDialogTitle("Select all image frames to calibrate");
            fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
            rc = fileChooser.showOpenDialog(this);
            RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
            if (rc == 0) {
                File[] theFiles = fileChooser.getSelectedFiles();
                fileChooser = null;
                if (theFiles != null && theFiles.length > 0) {
                    int i = 0;
                    while (i < theFiles.length) {
                        if (GuiHelper.isFitsFileExtension(theFiles[0].getAbsolutePath())) {
                            image = new BWBild();
                            image.readFromFits(theFiles[i].getAbsolutePath());
                        } else {
                            image = new RGBBild();
                            image.readFromTiff(theFiles[i].getAbsolutePath());
                        }
                        if (darkPresent) {
                            image = image.subtract(dark);
                        }
                        if (flatPresent) {
                            image = image.doFlat(flat);
                        }
                        this.currentPath = theFiles[i].getPath();
                        String fname = this.currentPath.substring(0, this.currentPath.length() - theFiles[i].getName().length());
                        if (image.getType() == 2) {
                            image.writeAsFits(String.valueOf(fname) + "Cal_" + theFiles[i].getName());
                        } else {
                            image.writeAsTiff(String.valueOf(fname) + "Cal_" + theFiles[i].getName());
                        }
                        image = null;
                        System.gc();
                        ++i;
                    }
                }
            }
        }
        catch (IOException e) {
            SLogger.error(1, "can't write ");
            e.printStackTrace();
            MsgBox msgBox = new MsgBox((Frame)this, "Error", "Could not save " + e.getMessage(), true);
        }
        catch (IllegalDimensionException e) {
            SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
            new MsgBox((Frame)this, "Attention", "Image has illegal dimensions: |" + e.getMessage(), true);
        }
        fileChooser = null;
        image = null;
        dark = null;
        flat = null;
        System.gc();
    }

    private void setupFlats_Action() {
        boolean fdarkPresent = false;
        Bild flatdark = null;
        SLogger.log("Setup Flats! imageCount=" + this.imageCount);
        FileChooser fileChooser = new FileChooser(this.currentPath);
        fileChooser.setDialogTitle("Select flat frames");
        fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
        fileChooser.showOpenDialog(this);
        File[] theFiles = fileChooser.getSelectedFiles();
        RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
        if (theFiles != null && theFiles.length > 0) {
            this.currentPath = theFiles[0].getPath();
            fileChooser = new FileChooser(this.currentPath);
            fileChooser.setDialogTitle("Select dark frames for flats");
            fileChooser.setFilterFitsTiff(RegParams.instance().getLastFileFilterType());
            fileChooser.showOpenDialog(this);
            File[] theFDarks = fileChooser.getSelectedFiles();
            RegParams.instance().setLastFileFilterType(fileChooser.getExtendedFileFilterType());
            if (theFDarks != null && theFDarks.length > 0) {
                flatdark = GuiHelper.isFitsFileExtension(theFDarks[0].getAbsolutePath()) ? new BWBild() : new RGBBild();
                try {
                    flatdark.medianCombineFiles(theFDarks);
                }
                catch (IOException e) {
                    new MsgBox((Frame)this, "I/O Error", e.getMessage(), true);
                }
                catch (IllegalDimensionException e) {
                    SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                    new MsgBox((Frame)this, "Attention", "Image has illegal dimensions: |" + e.getMessage(), true);
                }
                if (flatdark.getType() == 2) {
                    flatdark.setFname("flatdark.fit");
                } else {
                    flatdark.setFname("flatdark.tif");
                }
                this.display(flatdark);
                ++this.imageCount;
                fdarkPresent = true;
            }
            Bild tmpflat = GuiHelper.isFitsFileExtension(theFiles[0].getAbsolutePath()) ? new BWBild() : new RGBBild();
            try {
                tmpflat.medianCombineFiles(theFiles);
            }
            catch (IOException e) {
                new MsgBox((Frame)this, "I/O Error", e.getMessage(), true);
            }
            catch (IllegalDimensionException e) {
                SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                new MsgBox((Frame)this, "Attention", "Image has illegal dimensions: |" + e.getMessage(), true);
            }
            if (tmpflat.getType() == 2) {
                tmpflat.setFname("tempflat.fit");
            } else {
                tmpflat.setFname("tempflat.tif");
            }
            tmpflat.toBW();
            this.display(tmpflat);
            ++this.imageCount;
            if (fdarkPresent) {
                try {
                    Bild flat = tmpflat.subtract(flatdark);
                    if (flat.getType() == 2) {
                        flat.setFname("flat.fit");
                    } else {
                        flat.setFname("flat.tif");
                    }
                    this.display(flat);
                    ++this.imageCount;
                }
                catch (IllegalDimensionException e) {
                    SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
                    new MsgBox((Frame)this, "Attention", "Image has illegal dimensions: |" + e.getMessage(), true);
                }
            }
            this.currentPath = theFiles[0].getPath();
        }
    }

    private void subtractFiles_Action() {
        SLogger.log("Subtract Files! imageCount=" + this.imageCount);
        FileChooser fileChooser = new FileChooser(".");
        ExtendedFileFilter fitsFilter = new ExtendedFileFilter();
        fitsFilter.addExtension("fit");
        fitsFilter.addExtension("fts");
        fitsFilter.addExtension("fits");
        fitsFilter.setDescription("FITS Images");
        fileChooser.addChoosableFileFilter(fitsFilter);
        ExtendedFileFilter filter = new ExtendedFileFilter();
        filter.addExtension("tif");
        filter.setDescription("TIF Images");
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.showOpenDialog(this);
        File[] theFiles = fileChooser.getSelectedFiles();
        ImageFrame imgFrame = this.getPageFrameByName(this.activeImageFrameName);
        try {
            if (imgFrame != null) {
                Bild subBild = imgFrame.getTheBild();
                int i = 0;
                while (i < theFiles.length) {
                    Bild aBild;
                    if (GuiHelper.isFitsFileExtension(theFiles[i].getAbsolutePath())) {
                        aBild = new BWBild();
                        aBild.readFromFits(theFiles[i].getAbsolutePath());
                    } else {
                        aBild = new RGBBild();
                        aBild.readFromTiff(theFiles[i].getAbsolutePath());
                    }
                    SLogger.debug("subtracting " + subBild.getFname() + " from " + aBild.getFname());
                    aBild = aBild.subtract(subBild);
                    String fname = String.valueOf(theFiles[i].getParent()) + File.separator + "Sub_" + theFiles[i].getName();
                    if (aBild.getType() == 2) {
                        aBild.writeAsFits(fname);
                    } else {
                        aBild.writeAsTiff(fname);
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            SLogger.error(1, "can't write ");
            e.printStackTrace();
            MsgBox msgBox = new MsgBox((Frame)this, "Error", "Could not save " + e.getMessage(), true);
        }
        catch (IllegalDimensionException e) {
            SLogger.error(1, "IllegalDimensionException: " + e.getMessage());
            new MsgBox((Frame)this, "Attention", "Image has illegal dimensions: |" + e.getMessage(), true);
        }
    }

    private void splitChnlAction() {
        SLogger.log("Split Channels gewaehlt!");
        ImageFrame imgFrame = this.getPageFrameByName(this.activeImageFrameName);
        if (imgFrame != null) {
            if (imgFrame.getTheBild() instanceof RGBBild) {
                RGBBild theBild = (RGBBild)imgFrame.getTheBild();
                int l = theBild.getLen();
                int w = theBild.getWidth();
                int bps = theBild.getBitsPerSamp();
                BWBild br = new BWBild(l, w);
                br.setBitsPerSamp(bps);
                br.setData(theBild.getR());
                br.setFname("R_" + theBild.getFname());
                br.setType(1);
                br.calcStats();
                this.display(br);
                BWBild bg = new BWBild(l, w);
                bg.setBitsPerSamp(bps);
                bg.setData(theBild.getG());
                bg.setFname("G_" + theBild.getFname());
                bg.setType(1);
                bg.calcStats();
                this.display(bg);
                BWBild bb = new BWBild(l, w);
                bb.setBitsPerSamp(bps);
                bb.setData(theBild.getB());
                bb.setFname("B_" + theBild.getFname());
                bb.setType(1);
                bb.calcStats();
                this.display(bb);
            } else {
                MsgBox msgBox = new MsgBox((Frame)this, "Error", "Image must be RGB image!", true);
            }
        }
    }

    private void rot_left_90_Action() {
        Bild theBild;
        Bild rotated;
        SLogger.log("Rot Left 90 gewaehlt!");
        ImageFrame imgFrame = this.getPageFrameByName(this.activeImageFrameName);
        if (imgFrame != null && (rotated = (theBild = imgFrame.getTheBild()).rotate(theBild.getLen(), theBild.getWidth(), true)) != null) {
            rotated.setFname("RotL90_" + theBild.getFname());
            this.display(rotated);
            ++this.imageCount;
        }
    }

    private void rot_right_90_Action() {
        Bild theBild;
        Bild rotated;
        SLogger.log("Rot Right 90 gewaehlt!");
        ImageFrame imgFrame = this.getPageFrameByName(this.activeImageFrameName);
        if (imgFrame != null && (rotated = (theBild = imgFrame.getTheBild()).rotate(theBild.getLen(), theBild.getWidth(), false)) != null) {
            rotated.setFname("RotR90_" + theBild.getFname());
            this.display(rotated);
            ++this.imageCount;
        }
    }

    private void checkOpenImages() {
        if (this.imageCount <= 0) {
            SLogger.debug("checkOpenImages()");
            this.pageFrame.removeAllElements();
            this.bilder.removeAllElements();
            this.imageCount = 0;
            this.pageFrame = null;
            this.bilder = null;
            this.pageFrame = new FrameVector();
            this.bilder = new BildVector();
            System.runFinalization();
            System.gc();
        }
    }

    private void checkMenus() {
        if (this.threadRunning) {
            this.mainMenuBar.setAllMenusEnable(false);
        } else {
            this.mainMenuBar.setAllMenusEnable(true);
            this.imageCount = this.pageFrame.size();
            this.mainMenuBar.checkMenuItems(this.imageCount);
        }
    }

    protected void display(Bild aBild) {
        String frameName = "[" + this.imageCount + "]" + aBild.getFname();
        ImageFrame fr = new ImageFrame(frameName, aBild.getBufferedImage());
        fr.move(5 + this.imageCount * 5, 5 + this.imageCount * 5);
        fr.setTheBild(aBild);
        fr.addInternalFrameListener(this);
        fr.setVisible(true);
        this.desktop.add(fr);
        this.pageFrame.addFrame(fr);
        this.bilder.addBild(aBild);
        this.imageCount = this.bilder.size();
        try {
            fr.setSelected(true);
        }
        catch (PropertyVetoException e) {
            SLogger.debug("Exception: " + e.getMessage());
        }
    }

    public void run() {
        this.theStatusFrame.clear();
        this.threadRunning = true;
        Thread t = Thread.currentThread();
        t.setPriority(1);
        this.checkMenus();
        SLogger.debug("Thread running, runtype=" + this.runtype);
        try {
            switch (this.runtype) {
                case 0: {
                    this.register_Action();
                    break;
                }
                case 1: {
                    this.registerFiles_Action();
                    break;
                }
                case 2: {
                    this.blend_Action();
                    break;
                }
                case 3: {
                    this.blendFiles_Action();
                    break;
                }
                case 4: {
                    this.medianCombine_Action();
                    break;
                }
                case 5: {
                    this.medianCombineFiles_Action();
                    break;
                }
                case 11: {
                    this.sigmaCombine_Action();
                    break;
                }
                case 12: {
                    this.sigmaCombineFiles_Action();
                    break;
                }
                case 6: {
                    this.open_Action();
                    break;
                }
                case 7: {
                    this.setupDarks_Action();
                    break;
                }
                case 8: {
                    this.setupFlats_Action();
                    break;
                }
                case 9: {
                    this.calibrateFiles_Action();
                    break;
                }
                case 10: {
                    this.save_as_Action();
                    break;
                }
                case 13: {
                    this.combineChnlAction();
                    break;
                }
                case 14: {
                    this.splitChnlAction();
                    break;
                }
                case 15: {
                    this.multiplyChannels_Action();
                    break;
                }
                case 16: {
                    this.subtractFiles_Action();
                }
            }
        }
        catch (Throwable e) {
            SLogger.debug("Error: " + e.getMessage());
        }
        this.threadRunning = false;
        SLogger.log("=====================");
        SLogger.log("===== FINISHED! =====");
        SLogger.log("=====================");
        this.checkMenus();
        this.checkOpenImages();
        System.runFinalization();
        System.gc();
    }

    public void actionPerformed(ActionEvent event) {
        Thread t;
        this.theStatusFrame.clear();
        if (event.getActionCommand().equalsIgnoreCase("Open..")) {
            this.runtype = 6;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Save As..")) {
            this.runtype = 10;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Save As FITS..")) {
            this.save_as_Fits_Action();
        }
        if (event.getActionCommand().equalsIgnoreCase("Save As Splited FITS..")) {
            this.save_as_splited_Fits_Action();
        }
        if (event.getActionCommand().equalsIgnoreCase("Close all")) {
            this.closeAll_Action();
        }
        if (event.getActionCommand().equalsIgnoreCase("Exit")) {
            this.exit_Action();
        }
        if (event.getActionCommand().equalsIgnoreCase("Register")) {
            this.runtype = 0;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Register Files..")) {
            this.runtype = 1;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Register Sun")) {
            this.registerSun_Action();
        }
        if (event.getActionCommand().equalsIgnoreCase("Register Sun Files")) {
            this.registerSunFiles_Action();
        }
        if (event.getActionCommand().equalsIgnoreCase("Blend..")) {
            this.runtype = 2;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Blend Files..")) {
            this.runtype = 3;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Median combine..")) {
            this.runtype = 4;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Median combine Files..")) {
            this.runtype = 5;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Sigma combine..")) {
            this.runtype = 11;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Sigma combine Files..")) {
            this.runtype = 12;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Subtract Files..")) {
            this.runtype = 16;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Rotate Left 90\u00b0")) {
            this.rot_left_90_Action();
        }
        if (event.getActionCommand().equalsIgnoreCase("Rotate Right 90\u00b0")) {
            this.rot_right_90_Action();
        }
        if (event.getActionCommand().equalsIgnoreCase("Multiply Channels..")) {
            this.runtype = 15;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Combine Channels..")) {
            this.runtype = 13;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Split Channels")) {
            this.runtype = 14;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Setup darks..")) {
            this.runtype = 7;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Setup flats..")) {
            this.runtype = 8;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("Calibrate files..")) {
            this.runtype = 9;
            t = new Thread(this);
            t.start();
        }
        if (event.getActionCommand().equalsIgnoreCase("About")) {
            this.about_Action();
        }
        this.checkMenus();
    }

    public void internalFrameClosed(InternalFrameEvent event) {
        String winName = event.getInternalFrame().getName();
        if (winName.equals(this.mainFrameName)) {
            this.exit_Action();
        } else {
            this.checkMenus();
        }
    }

    public void internalFrameClosing(InternalFrameEvent event) {
        String winName = event.getInternalFrame().getName();
        if (winName.equals(this.mainFrameName)) {
            this.exit_Action();
        } else {
            int i = 0;
            while (i < this.pageFrame.size()) {
                if (winName.equals(this.pageFrame.getFrameAt(i).getName())) {
                    this.pageFrame.getFrameAt(i).close();
                    this.pageFrame.removeElementAt(i);
                    this.bilder.removeElementAt(i);
                    this.imageCount = this.pageFrame.size();
                    this.activeImageFrameName = this.imageCount > 0 ? this.pageFrame.getFrameAt(this.imageCount - 1).getName() : "";
                    this.checkMenus();
                    break;
                }
                ++i;
            }
            System.runFinalization();
            System.gc();
        }
    }

    public void internalFrameOpened(InternalFrameEvent event) {
        String winName = event.getInternalFrame().getName();
        if (!winName.equals(this.mainFrameName)) {
            this.activeImageFrameName = winName;
        }
    }

    public void internalFrameDeactivated(InternalFrameEvent event) {
    }

    public void internalFrameDeiconified(InternalFrameEvent event) {
        String winName = event.getInternalFrame().getName();
    }

    public void internalFrameIconified(InternalFrameEvent event) {
    }

    public void internalFrameActivated(InternalFrameEvent event) {
        String winName = event.getInternalFrame().getName();
        if (!winName.equals(this.mainFrameName)) {
            this.activeImageFrameName = winName;
            ImageFrame fr = this.getPageFrameByName(this.activeImageFrameName);
            if (fr != null) {
                this.ssf.setValues(fr.getBlackPt(), fr.getWhitePt());
            }
        }
    }

    public void windowClosed(WindowEvent event) {
        String winName = event.getWindow().getName();
        if (winName.equals(this.mainFrameName)) {
            this.exit_Action();
        }
    }

    public void windowClosing(WindowEvent event) {
        String winName = event.getWindow().getName();
        if (winName.equals(this.mainFrameName)) {
            this.exit_Action();
        }
    }

    public void windowOpened(WindowEvent event) {
        String winName = event.getWindow().getName();
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
        String winName = event.getWindow().getName();
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
        String winName = event.getWindow().getName();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.ssf.resize(this);
    }

    public void componentShown(ComponentEvent e) {
    }

    public ImageFrame getPageFrameByName(String name) {
        int i = 0;
        while (i < this.pageFrame.size()) {
            if (name.equals(this.pageFrame.getFrameAt(i).getName())) {
                return this.pageFrame.getFrameAt(i);
            }
            ++i;
        }
        return null;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Regim.createAndShowGUI();
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!this.ssf.getJslBlackPt().getValueIsAdjusting() && !this.ssf.getJslWhitePt().getValueIsAdjusting()) {
            int blackVal = this.ssf.getBlack();
            int whiteVal = this.ssf.getWhite();
            ImageFrame imgFrame = this.getPageFrameByName(this.activeImageFrameName);
            if (imgFrame != null) {
                imgFrame.setScreenStretch(blackVal, whiteVal);
            }
        }
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        Regim frame = new Regim();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    protected void createMenuBar() {
        this.mainMenuBar = new RMenuBar(this);
        this.checkMenus();
        this.setJMenuBar(this.mainMenuBar);
    }

    private void createTestImage() {
        RGBBild b = new RGBBild();
        b.createTestImage();
        this.display(b);
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public void setImageCount(int i) {
        this.imageCount = i;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public void setDesktop(JDesktopPane desktop) {
        this.desktop = desktop;
    }
}

