/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedInputStream;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Rdr;
import javajs.util.SB;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jmol.adapter.readers.xml.XmlHandler;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.api.Interface;
import org.jmol.api.js.JSmolAppletObject;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.xml.sax.XMLReader;

public class XmlReader
extends AtomSetCollectionReader {
    protected Atom atom;
    protected Bond bond;
    protected XmlReader parent;
    public Map<String, String> atts;
    protected boolean keepChars;
    protected SB chars = SB.newN((int)2000);
    private Object[] domObj = new Object[1];
    private Object[] attribs;
    private Object[] attArgs;
    private Object[] nullObj = new Object[0];

    public void initializeReader() throws Exception {
        this.initCML();
    }

    protected void initCML() {
        this.atts = new Hashtable<String, String>();
        this.setMyError(this.parseXML());
        this.continuing = false;
    }

    private void setMyError(String err) {
        if (err != null && (this.asc == null || this.asc.errorMessage == null)) {
            this.asc = new AtomSetCollection("xml", (AtomSetCollectionReader)this, null, null);
            this.asc.errorMessage = err;
        }
    }

    private String parseXML() {
        XMLReader saxReader;
        block4: {
            saxReader = null;
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                saxReader = saxParser.getXMLReader();
                if (this.debugging) {
                    Logger.debug((String)"Using JAXP/SAX XML parser.");
                }
            }
            catch (Exception e) {
                if (!this.debugging) break block4;
                Viewer cfr_ignored_0 = (this.parent == null ? this : this.parent).vwr;
                Logger.debug((String)("Could not instantiate JAXP/SAX XML reader: " + (Viewer.isJS ? e : e.getMessage())));
            }
        }
        if (saxReader == null) {
            return "No XML reader found";
        }
        return this.selectReaderAndGo(saxReader);
    }

    private String selectReaderAndGo(Object saxReader) {
        this.asc = new AtomSetCollection(this.readerName, (AtomSetCollectionReader)this, null, null);
        String className = null;
        XmlReader thisReader = null;
        int pt = this.readerName.indexOf("(");
        String name = pt < 0 ? this.readerName : this.readerName.substring(0, pt);
        className = Resolver.getReaderClassBase((String)name);
        thisReader = (XmlReader)((Object)this.getInterface(className));
        if (thisReader == null) {
            return "File reader was not found: " + className;
        }
        try {
            thisReader.processXml(this, saxReader);
        }
        catch (Exception e) {
            Viewer viewer = this.parent == null ? this.vwr : this.parent.vwr;
            return "Error reading XML: " + (Viewer.isJS ? e : e.getMessage());
        }
        return null;
    }

    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        this.processXml2(parent, saxReader);
    }

    protected void processXml2(XmlReader parent, Object saxReader) throws Exception {
        this.parent = parent;
        this.asc = parent.asc;
        this.reader = parent.reader;
        this.atts = parent.atts;
        if (saxReader == null) {
            this.attribs = new Object[1];
            this.attArgs = new Object[1];
            this.domObj = new Object[1];
            String o = "";
            byte[] data = null;
            if (o instanceof BufferedInputStream) {
                o = Rdr.streamToUTF8String((BufferedInputStream)Rdr.getBIS(data));
            }
            boolean isjs = false;
            this.walkDOMTree();
            if (isjs) {
                this.domObj[0] = this.createDomNodeJS("xmlReader", o);
                this.walkDOMTree();
                this.createDomNodeJS("xmlReader", null);
            }
        } else {
            ((XmlHandler)Interface.getOption((String)"adapter.readers.xml.XmlHandler", (Viewer)this.vwr, (String)"file")).parseXML(this, saxReader, this.reader);
        }
    }

    Object createDomNodeJS(String id, Object data) {
        JSmolAppletObject applet = this.parent.vwr.html5Applet;
        Object d = null;
        return d;
    }

    public void applySymmetryAndSetTrajectory() {
        try {
            if (this.parent == null) {
                this.applySymTrajASCR();
            } else {
                this.parent.applySymmetryAndSetTrajectory();
            }
        }
        catch (Exception e) {
            Viewer cfr_ignored_0 = (this.parent == null ? this : this.parent).vwr;
            System.out.println(Viewer.isJS ? e : e.getMessage());
            Logger.error((String)("applySymmetry failed: " + e));
        }
    }

    protected void processDOM(Object DOMNode) {
        this.domObj = new Object[]{DOMNode};
        this.setMyError(this.selectReaderAndGo(null));
    }

    protected void processStartElement(String localName, String nodeName) {
    }

    protected void setKeepChars(boolean TF) {
        this.keepChars = TF;
        this.chars.setLength(0);
    }

    void processEndElement(String localName) {
    }

    private void walkDOMTree() {
        String localName = "localName";
        String nodeName = (String)this.jsObjectGetMember(this.domObj, localName);
        if ((localName = this.fixLocal(nodeName)) == null) {
            return;
        }
        if (localName.equals("#text")) {
            if (this.keepChars) {
                this.chars.append((String)this.jsObjectGetMember(this.domObj, "data"));
            }
            return;
        }
        localName = localName.toLowerCase();
        nodeName = nodeName.toLowerCase();
        this.attribs[0] = this.jsObjectGetMember(this.domObj, "attributes");
        this.getDOMAttributesA(this.attribs);
        this.processStartElement(localName, nodeName);
        boolean haveChildren = (Boolean)this.jsObjectCall(this.domObj, "hasChildNodes", null);
        if (haveChildren) {
            Object nextNode = this.jsObjectGetMember(this.domObj, "firstChild");
            while (nextNode != null) {
                this.domObj[0] = nextNode;
                this.walkDOMTree();
                this.domObj[0] = nextNode;
                nextNode = this.jsObjectGetMember(this.domObj, "nextSibling");
            }
        }
        this.processEndElement(localName);
    }

    private String fixLocal(String name) {
        return name;
    }

    private void getDOMAttributesA(Object[] attributes) {
        int n;
        this.atts.clear();
        if (attributes == null) {
            return;
        }
        Object nodes = null;
        Number N = (Number)this.jsObjectGetMember(attributes, "length");
        int i = n = N == null ? 0 : N.intValue();
        while (--i >= 0) {
            String attValue;
            this.attArgs[0] = i;
            this.attArgs[0] = this.jsObjectCall(attributes, "item", this.attArgs);
            if (this.attArgs[0] == null || (attValue = (String)this.jsObjectGetMember(this.attArgs, "value")) == null) continue;
            this.atts.put(((String)this.jsObjectGetMember(this.attArgs, "name")).toLowerCase(), attValue);
        }
    }

    private Object jsObjectCall(Object[] jsObject, String method, Object[] args) {
        return this.parent.vwr.apiPlatform.getJsObjectInfo(jsObject, method, args == null ? this.nullObj : args);
    }

    private Object jsObjectGetMember(Object[] jsObject, String name) {
        return this.parent.vwr.apiPlatform.getJsObjectInfo(jsObject, name, null);
    }

    public void endDocument() {
    }

    private class NVPair {
        String name;
        String value;

        private NVPair() {
        }
    }
}

