/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.geocentral.geometria.action.GAction;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GAnswerAction;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.action.GNavigationAction;
import net.geocentral.geometria.action.GUndoable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GLog;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GIconManager;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GActionLoader {
    public static final String FILE = "/conf/actions.xml";
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public Map<String, AbstractAction> loadActions() throws Exception {
        logger.info((Object)"");
        LinkedHashMap<String, AbstractAction> actionHandlers = new LinkedHashMap<String, AbstractAction>();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        InputStream in = this.getClass().getResourceAsStream(FILE);
        Element element = builder.parse(in).getDocumentElement();
        in.close();
        NodeList nodes = element.getElementsByTagName("action");
        String packageName = GActionLoader.class.getPackage().getName();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            String name = node.getElementsByTagName("name").item(0).getTextContent();
            String cName = node.getElementsByTagName("className").item(0).getTextContent();
            final String className = packageName + "." + cName;
            final ArrayList<String> parameters = new ArrayList<String>();
            NodeList ns = node.getElementsByTagName("parameter");
            if (ns.getLength() > 0) {
                for (int j = 0; j < ns.getLength(); ++j) {
                    String parameter = ns.item(j).getTextContent();
                    parameters.add(parameter);
                }
            }
            ns = node.getElementsByTagName("helpId");
            String hId = null;
            if (ns.getLength() > 0) {
                hId = ns.item(0).getTextContent();
            }
            final String helpId = hId;
            AbstractAction actionHandler = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    GDocumentHandler documentHandler = GDocumentHandler.getInstance();
                    GDocument document = documentHandler.getActiveDocument();
                    GAction action = null;
                    try {
                        Constructor<?>[] constructors;
                        for (Constructor<?> constructor : constructors = Class.forName(className).getConstructors()) {
                            if (constructor.getParameterTypes().length != parameters.size()) continue;
                            switch (parameters.size()) {
                                case 1: {
                                    action = (GAction)constructor.newInstance(parameters.get(0));
                                    break;
                                }
                                default: {
                                    action = (GAction)constructor.newInstance(new Object[0]);
                                    break;
                                }
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)GStringUtils.stackTraceToString(exception));
                        return;
                    }
                    if (action instanceof GActionWithHelp) {
                        ((GActionWithHelp)action).setHelpId(helpId);
                    }
                    if (action instanceof GLoggable && GActionLoader.this.solutionConcluded(documentHandler, document)) {
                        return;
                    }
                    Frame ownerFrame = documentHandler.getOwnerFrame();
                    ownerFrame.setCursor(Cursor.getPredefinedCursor(3));
                    boolean result = action.execute();
                    ownerFrame.setCursor(Cursor.getPredefinedCursor(0));
                    if (!result) {
                        return;
                    }
                    if (!(action instanceof GNavigationAction)) {
                        if (action instanceof GUndoable) {
                            documentHandler.addAction((GUndoable)action);
                        }
                        if (document instanceof GSolution && action instanceof GLoggable) {
                            ((GSolution)document).getLog().add((GLoggable)action);
                        }
                    }
                    documentHandler.updateActionHandlerStates();
                }
            };
            if (node.getElementsByTagName("icon").getLength() == 0) {
                actionHandler.putValue("SmallIcon", GIconManager.getInstance().getEmptyIcon());
            } else {
                String iconFile = node.getElementsByTagName("icon").item(0).getTextContent();
                ImageIcon icon = GIconManager.getInstance().get24x24Icon(iconFile);
                actionHandler.putValue("SmallIcon", icon);
            }
            String shortDesc = node.getElementsByTagName("shortDesc").item(0).getTextContent();
            actionHandler.putValue("ShortDescription", GDictionary.get(shortDesc, new String[0]));
            actionHandlers.put(name, actionHandler);
        }
        return actionHandlers;
    }

    private boolean solutionConcluded(GDocumentHandler documentHandler, GDocument document) {
        GLog log;
        int logSize;
        logger.info((Object)"");
        if (document instanceof GSolution && (logSize = (log = ((GSolution)document).getLog()).size()) > 0 && log.actionAt(logSize - 1) instanceof GAnswerAction) {
            GGraphicsFactory.getInstance().showErrorDialog(GDictionary.get("SolutionConcluded", new String[0]));
            return true;
        }
        return false;
    }
}

