/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.evaluator.token.GVariable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GMeasurement;
import net.geocentral.geometria.model.GNotepad;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GAreaDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GAreaAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String[] fLabels;
    private String variableName;
    private GSolid solid;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            GFigure figure = document.getSelectedFigure();
            this.figureName = figure.getName();
            this.solid = figure.getSolid();
            Set<GSelectable> selection = this.solid.getSelection();
            this.prefill(selection);
            String[] fLabelStrings = new String[this.solid.faceCount()];
            for (int i = 0; i < this.solid.faceCount(); ++i) {
                GFace face = this.solid.faceAt(i);
                StringBuffer buf = new StringBuffer();
                buf.append(face.labelAt(0)).append(face.labelAt(1)).append(face.labelAt(2));
                fLabelStrings[i] = String.valueOf(buf);
            }
            GAreaDialog dialog = new GAreaDialog(documentHandler.getOwnerFrame(), this, fLabelStrings);
            if (this.fLabels != null) {
                dialog.prefill(this.fLabels[0] + this.fLabels[1] + this.fLabels[2]);
            }
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
            this.solid.clearSelection();
        }
        document.setSelectedFigure(this.figureName);
        document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + Arrays.asList(this.fLabels)));
        return true;
    }

    private void prefill(Set<GSelectable> selection) {
        logger.info(selection);
        if (selection.isEmpty()) {
            return;
        }
        GDocument document = GDocumentHandler.getInstance().getActiveDocument();
        GFigure figure = document.getSelectedFigure();
        this.figureName = figure.getName();
        GSolid solid = figure.getSolid();
        Iterator<GSelectable> it = selection.iterator();
        LinkedHashSet<String> labelSet = new LinkedHashSet<String>();
        LinkedHashSet<GFace> faces = new LinkedHashSet<GFace>();
        while (it.hasNext()) {
            GSelectable element = it.next();
            if (element instanceof GPoint3d) {
                labelSet.add(((GPoint3d)element).getLabel());
                continue;
            }
            if (element instanceof GStick) {
                labelSet.add(((GStick)element).label1);
                labelSet.add(((GStick)element).label2);
                continue;
            }
            if (!(element instanceof GFace)) continue;
            faces.add((GFace)element);
        }
        String[] pLabels = new String[labelSet.size()];
        labelSet.toArray(pLabels);
        Collection<GFace> fs = solid.facesThroughPoints(pLabels);
        faces.addAll(fs);
        if (faces.size() != 1) {
            return;
        }
        GFace face = (GFace)faces.iterator().next();
        this.fLabels = new String[3];
        this.fLabels[0] = face.labelAt(0);
        this.fLabels[1] = face.labelAt(1);
        this.fLabels[2] = face.labelAt(2);
    }

    public void validateApply() throws Exception {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        if (this.variableName.length() == 0) {
            logger.info((Object)"No variable");
            throw new Exception(GDictionary.get("EnterVariable", new String[0]));
        }
        if (Arrays.asList(GVariable.RESERVED).contains(this.variableName.toLowerCase())) {
            logger.info((Object)("Reserved variable: " + this.variableName));
            throw new Exception(GDictionary.get("ReservedVariable", this.variableName));
        }
        if (!this.variableName.matches("[a-zA-Z\\p{InCyrillic}_][0-9a-zA-Z\\p{InCyrillic}_]*")) {
            logger.info((Object)("Bad variable: " + this.variableName));
            throw new Exception(GDictionary.get("InvalidVariable", this.variableName));
        }
        if (document.getVariable(this.variableName) != null) {
            logger.info((Object)("Duplicate variable: " + this.variableName));
            throw new Exception(GDictionary.get("DuplicateVariable", this.variableName));
        }
        GFigure figure = document.getFigure(this.figureName);
        this.solid = figure.getSolid();
        GFace face = this.solid.facesThroughPoints(this.fLabels).iterator().next();
        double area = face.computeArea(this.solid);
        GMeasurement expression = GMeasurement.newArea(this.fLabels, this.figureName);
        GNotepadVariable variable = new GNotepadVariable(this.variableName, area);
        GNotepadRecord record = new GNotepadRecord(variable, expression);
        GNotepad notepad = document.getNotepad();
        notepad.add(record);
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.clearSelection();
        GDocument document = documentHandler.getActiveDocument();
        GNotepad notepad = document.getNotepad();
        notepad.removeLastRecord();
        logger.info((Object)this.figureName);
    }

    @Override
    public GLoggable clone() {
        GAreaAction action = new GAreaAction();
        action.figureName = this.figureName;
        action.fLabels = this.fLabels;
        for (int i = 0; i < 3; ++i) {
            action.fLabels[i] = this.fLabels[i];
        }
        action.variableName = this.variableName;
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("MeasureAreaOfFaceInFigure", this.variableName, this.fLabels[0] + this.fLabels[1] + this.fLabels[2], this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        this.fLabels = new String[3];
        ns = node.getElementsByTagName("fLabel1");
        if (ns.getLength() == 0) {
            logger.error((Object)"No fLabel1");
            throw new Exception();
        }
        this.fLabels[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("fLabel2");
        if (ns.getLength() == 0) {
            logger.error((Object)"No fLabel2");
            throw new Exception();
        }
        this.fLabels[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("fLabel3");
        if (ns.getLength() == 0) {
            logger.error((Object)"No fLabel3");
            throw new Exception();
        }
        this.fLabels[2] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("variableName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No variable name");
            throw new Exception();
        }
        this.variableName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<fLabel1>").append(this.fLabels[0]).append("</fLabel1>").append("\n<fLabel2>").append(this.fLabels[1]).append("</fLabel2>").append("\n<fLabel3>").append(this.fLabels[2]).append("</fLabel3>").append("\n<variableName>").append(this.variableName).append("</variableName>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String fLabelsString, String recordName) {
        logger.info((Object)(fLabelsString + ", " + recordName));
        this.variableName = recordName;
        this.fLabels = new String[3];
        StringBuffer buf = new StringBuffer();
        buf.append("(").append("[A-Z][0-9]*").append(")").append("(").append("[A-Z][0-9]*").append(")").append("(").append("[A-Z][0-9]*").append(")");
        Pattern pattern = Pattern.compile(String.valueOf(buf));
        Matcher matcher = pattern.matcher(fLabelsString);
        matcher.matches();
        for (int i = 0; i < 3; ++i) {
            this.fLabels[i] = matcher.group(i + 1);
        }
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("measureAreaOfFace", this.fLabels[0] + this.fLabels[1] + this.fLabels[2]);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

