/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GLayDistanceDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GLayDistanceAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String distanceString;
    private String[] pLabels;
    private GDocument document;
    private List<String> addedPointLabels;
    private GFigure figure;
    private GSolid solid;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        GSolid solid;
        GDocumentHandler documentHandler;
        block7: {
            logger.info((Object)silent);
            documentHandler = GDocumentHandler.getInstance();
            this.document = documentHandler.getActiveDocument();
            if (silent) {
                try {
                    this.validateApply();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            GNotepadRecord record = this.document.getNotepad().getSelectedRecord();
            if (record != null) {
                this.distanceString = record.getVariable().getName();
            }
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                GLayDistanceDialog dialog = new GLayDistanceDialog(documentHandler.getOwnerFrame(), this);
                dialog.prefill(this.pLabels, this.distanceString);
                dialog.setVisible(true);
                if (dialog.getResult()) break block7;
                return false;
            }
        }
        solid.clearSelection();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + this.distanceString + ", " + Arrays.asList(this.pLabels)));
        return true;
    }

    private void prefill(Set<GSelectable> selection) {
        logger.info(selection);
        this.pLabels = new String[3];
        if (selection.isEmpty()) {
            return;
        }
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 2) {
            GStick s;
            GPoint3d p;
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GPoint3d && element2 instanceof GStick) {
                p = (GPoint3d)element1;
                s = (GStick)element2;
            } else if (element1 instanceof GStick && element2 instanceof GPoint3d) {
                p = (GPoint3d)element2;
                s = (GStick)element1;
            } else {
                return;
            }
            this.pLabels[0] = p.getLabel();
            this.pLabels[1] = s.label1;
            this.pLabels[2] = s.label2;
        }
    }

    public void validateApply() throws Exception {
        Double distance;
        logger.info((Object)"");
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        if (this.distanceString.length() == 0) {
            logger.info((Object)"No distance");
            throw new Exception(GDictionary.get("EnterValidExpressionForDistance", new String[0]));
        }
        GNotepadVariable variable = this.document.getVariable(this.distanceString);
        if (variable != null) {
            distance = variable.getValue();
        } else {
            List<GNotepadVariable> variables = this.document.getNotepad().getVariables();
            distance = GMath.evaluate(this.distanceString, variables);
            if (distance == null) {
                logger.info((Object)("Bad expression: " + this.distanceString));
                throw new Exception(GDictionary.get("EnterValidExpressionForDistance", new String[0]));
            }
        }
        if (distance <= 0.0) {
            logger.info((Object)("Distance must be positive: " + distance));
            throw new Exception(GDictionary.get("DistanceMustBePositive", new String[0]));
        }
        GPoint3d[] ps = new GPoint3d[3];
        for (int i = 0; i < 3; ++i) {
            if (this.pLabels[i].length() == 0) {
                logger.info((Object)("No end points: " + Arrays.asList(this.pLabels)));
                throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
            }
            ps[i] = this.solid.getPoint(this.pLabels[i]);
            if (ps[i] != null) continue;
            logger.info((Object)("No point: " + this.pLabels[i]));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.pLabels[i]));
        }
        if (ps[1] == ps[2]) {
            logger.info((Object)("Equal points: " + Arrays.asList(ps)));
            throw new Exception(GDictionary.get("PointsRefNoLine", this.pLabels[1], this.pLabels[2]));
        }
        if (this.solid.linesThroughPoints(this.pLabels[1], this.pLabels[2]).isEmpty()) {
            logger.info((Object)("No line: " + this.pLabels[1] + ", " + this.pLabels[2]));
            throw new Exception(GDictionary.get("NoLinePassesThroughPoints", this.pLabels[1], this.pLabels[2], this.figureName));
        }
        List<Point3d> pCoords = GMath.intersectSphere(ps[1].coords, ps[2].coords, ps[0].coords, distance);
        if (pCoords.isEmpty()) {
            logger.info((Object)("No point at distance: " + this.pLabels[1] + ", " + this.pLabels[2] + ", " + this.distanceString + ", " + this.pLabels[0]));
            throw new Exception(GDictionary.get("LineContainsNoPointAtDistance", this.pLabels[1] + this.pLabels[2], this.distanceString, this.pLabels[0]));
        }
        boolean alreadyLaid = true;
        for (Point3d pCs : pCoords) {
            alreadyLaid &= this.solid.getPoint(pCs) != null;
        }
        if (alreadyLaid) {
            logger.info((Object)("Already laid: " + this.pLabels[1] + ", " + this.pLabels[2] + ", " + this.distanceString + ", " + this.pLabels[0]));
            throw new Exception(GDictionary.get("DistanceAlreadyLaidOff", this.distanceString, this.pLabels[0], this.pLabels[1] + this.pLabels[2], this.figureName));
        }
        Collection<GFace> faces = this.solid.facesThroughPoints(new String[]{this.pLabels[1], this.pLabels[2]});
        this.addedPointLabels = new ArrayList<String>();
        for (Point3d pCs : pCoords) {
            if (this.solid.getPoint(pCs) != null) continue;
            GPoint3d p = this.solid.addPoint(pCs);
            this.addedPointLabels.add(p.getLabel());
            for (GFace face : faces) {
                face.addPoint(p, this.solid);
            }
        }
        this.solid.makeConfig();
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.clearSelection();
        for (String pLabel : this.addedPointLabels) {
            GPoint3d p = this.solid.getPoint(pLabel);
            Collection<GFace> faces = this.solid.facesThroughPoints(new String[]{this.pLabels[1], this.pLabels[2]});
            for (GFace face : faces) {
                face.removePoint(p);
            }
            this.solid.removePoint(pLabel);
        }
        this.solid.makeConfig();
        this.figure.repaint();
        this.document.setSelectedFigure(this.figureName);
        logger.info((Object)(this.figureName + ", " + this.distanceString + ", " + Arrays.asList(this.pLabels)));
    }

    @Override
    public GLoggable clone() {
        GLayDistanceAction action = new GLayDistanceAction();
        action.figureName = this.figureName;
        action.distanceString = this.distanceString;
        action.pLabels = new String[3];
        for (int i = 0; i < 3; ++i) {
            action.pLabels[i] = this.pLabels[i];
        }
        action.addedPointLabels = new ArrayList<String>();
        for (String label : this.addedPointLabels) {
            action.addedPointLabels.add(label);
        }
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("LayDistanceOffPointToLine", this.distanceString, this.pLabels[0], this.pLabels[1] + this.pLabels[2], this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("distance");
        if (ns.getLength() == 0) {
            logger.error((Object)"No distance");
            throw new Exception();
        }
        this.distanceString = ns.item(0).getTextContent();
        this.pLabels = new String[3];
        ns = node.getElementsByTagName("p0Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p0Label");
            throw new Exception();
        }
        this.pLabels[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.pLabels[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.pLabels[2] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<distance>").append(this.distanceString).append("</distance>").append("\n<p0Label>").append(this.pLabels[0]).append("</p0Label>").append("\n<p1Label>").append(this.pLabels[1]).append("</p1Label>").append("\n<p2Label>").append(this.pLabels[2]).append("</p2Label>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p0String, String p1String, String p2String, String distanceString) {
        logger.info((Object)(p0String + ", " + p1String + ", " + p2String + ", " + distanceString));
        this.pLabels[0] = p0String.toUpperCase();
        this.pLabels[1] = p1String.toUpperCase();
        this.pLabels[2] = p2String.toUpperCase();
        this.distanceString = distanceString;
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("layDistanceOffPointToLine", this.distanceString, this.pLabels[0], this.pLabels[1] + this.pLabels[2]);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

