/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.evaluator.token.GVariable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GMeasurement;
import net.geocentral.geometria.model.GNotepad;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GMeasureAngleDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GMeasureAngleAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String variableName;
    private String[] pLabels;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            GFigure figure = document.getSelectedFigure();
            this.figureName = figure.getName();
            GSolid solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            GMeasureAngleDialog dialog = new GMeasureAngleDialog(documentHandler.getOwnerFrame(), this);
            dialog.prefill(this.pLabels);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
            solid.clearSelection();
        }
        document.setSelectedFigure(this.figureName);
        document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + this.variableName + ", " + Arrays.asList(this.pLabels)));
        return true;
    }

    protected void prefill(Set<GSelectable> selection) {
        logger.info(selection);
        this.pLabels = new String[3];
        if (selection.isEmpty()) {
            return;
        }
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 2) {
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GStick && element2 instanceof GStick) {
                if (((GStick)element1).label1.equals(((GStick)element2).label1)) {
                    this.pLabels[0] = ((GStick)element1).label1;
                    this.pLabels[1] = ((GStick)element1).label2;
                    this.pLabels[2] = ((GStick)element2).label2;
                } else if (((GStick)element1).label1.equals(((GStick)element2).label2)) {
                    this.pLabels[0] = ((GStick)element1).label1;
                    this.pLabels[1] = ((GStick)element1).label2;
                    this.pLabels[2] = ((GStick)element2).label1;
                } else if (((GStick)element1).label2.equals(((GStick)element2).label1)) {
                    this.pLabels[0] = ((GStick)element1).label2;
                    this.pLabels[1] = ((GStick)element1).label1;
                    this.pLabels[2] = ((GStick)element2).label2;
                } else if (((GStick)element1).label2.equals(((GStick)element2).label2)) {
                    this.pLabels[0] = ((GStick)element1).label2;
                    this.pLabels[1] = ((GStick)element1).label1;
                    this.pLabels[2] = ((GStick)element2).label1;
                }
            }
        }
    }

    public void validateApply() throws Exception {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getFigure(this.figureName);
        GSolid solid = figure.getSolid();
        GPoint3d[] ps = new GPoint3d[3];
        for (int i = 0; i < 3; ++i) {
            if (this.pLabels[i].length() == 0) {
                logger.info((Object)("No end points: " + Arrays.asList(this.pLabels)));
                throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
            }
            ps[i] = solid.getPoint(this.pLabels[i]);
            if (ps[i] != null) continue;
            logger.info((Object)("No point: " + this.pLabels[i]));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.pLabels[i]));
        }
        if (ps[0] == ps[1] || ps[0] == ps[2]) {
            logger.info((Object)("End points equal: " + Arrays.asList(ps)));
            throw new Exception(GDictionary.get("EndPointsCannotBeEqual", new String[0]));
        }
        Collection<GFace> faces = solid.facesThroughPoints(this.pLabels);
        if (faces.isEmpty()) {
            logger.info((Object)("Not in the same face: " + Arrays.asList(this.pLabels)));
            throw new Exception(GDictionary.get("LinesDoNotBelongToSameFace", this.pLabels[0] + this.pLabels[1], this.pLabels[0] + this.pLabels[2], this.figureName));
        }
        if (this.variableName.length() == 0) {
            logger.info((Object)"No variable");
            throw new Exception(GDictionary.get("EnterVariable", new String[0]));
        }
        if (Arrays.asList(GVariable.RESERVED).contains(this.variableName.toLowerCase())) {
            logger.info((Object)("Reserved variable: " + this.variableName));
            throw new Exception(GDictionary.get("ReservedVariable", this.variableName));
        }
        if (!this.variableName.matches("[a-zA-Z\\p{InCyrillic}_][0-9a-zA-Z\\p{InCyrillic}_]*")) {
            logger.info((Object)("Bad variable: " + this.variableName));
            throw new Exception(GDictionary.get("InvalidVariable", this.variableName));
        }
        if (document.getVariable(this.variableName) != null) {
            logger.info((Object)("Duplicate variable: " + this.variableName));
            throw new Exception(GDictionary.get("DuplicateVariable", this.variableName));
        }
        Vector3d v1 = new Vector3d((Tuple3d)ps[1].coords);
        v1.sub((Tuple3d)ps[0].coords);
        Vector3d v2 = new Vector3d((Tuple3d)ps[2].coords);
        v2.sub((Tuple3d)ps[0].coords);
        double angle = v1.angle(v2);
        if (angle < 1.0E-7) {
            logger.info((Object)("Null angle: " + angle));
            throw new Exception(GDictionary.get("AngleIsNull", new String[0]));
        }
        GNotepadVariable variable = new GNotepadVariable(this.variableName, angle);
        GMeasurement measurement = GMeasurement.newAngle(this.pLabels, this.figureName);
        GNotepadRecord record = new GNotepadRecord(variable, measurement);
        GNotepad notepad = document.getNotepad();
        notepad.add(record);
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        GNotepad notepad = document.getNotepad();
        notepad.removeLastRecord();
        logger.info((Object)(this.figureName + ", " + this.variableName + ", " + Arrays.asList(this.pLabels)));
    }

    @Override
    public GLoggable clone() {
        GMeasureAngleAction action = new GMeasureAngleAction();
        action.figureName = this.figureName;
        action.pLabels = new String[3];
        for (int i = 0; i < 3; ++i) {
            action.pLabels[i] = this.pLabels[i];
        }
        action.variableName = this.variableName;
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("MeasureAngleInFigure", this.variableName, this.pLabels[1] + this.pLabels[0] + this.pLabels[2], this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figureName");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        this.pLabels = new String[3];
        ns = node.getElementsByTagName("p0Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p0Label");
            throw new Exception();
        }
        this.pLabels[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.pLabels[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.pLabels[2] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("variableName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No variable name");
            throw new Exception();
        }
        this.variableName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<p0Label>").append(this.pLabels[0]).append("</p0Label>").append("\n<p1Label>").append(this.pLabels[1]).append("</p1Label>").append("\n<p2Label>").append(this.pLabels[2]).append("</p2Label>").append("\n<variableName>").append(this.variableName).append("</variableName>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p0String, String p1String, String p2String, String variableName) {
        logger.info((Object)(p0String + ", " + p1String + ", " + p2String + ", " + variableName));
        this.pLabels[0] = p0String.toUpperCase();
        this.pLabels[1] = p1String.toUpperCase();
        this.pLabels[2] = p2String.toUpperCase();
        this.variableName = variableName;
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("measureAngle", this.pLabels[1] + this.pLabels[0] + this.pLabels[2]);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

