/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GUndoable;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.view.GProblemAnswerDialog;
import org.apache.log4j.Logger;

public class GProblemAnswerAction
implements GUndoable,
GActionWithHelp {
    private GAnswer oldAnswer;
    private GAnswer newAnswer;
    private String helpId;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GProblem document = (GProblem)documentHandler.getActiveDocument();
        if (silent) {
            document.setAnswer(this.newAnswer);
        } else {
            this.oldAnswer = document.getAnswer();
            GProblemAnswerDialog dialog = new GProblemAnswerDialog(documentHandler.getOwnerFrame(), this, document);
            dialog.setVisible(true);
            GAnswer answer = dialog.getAnswer();
            if (answer == null) {
                return false;
            }
            document.setAnswer(answer);
            this.newAnswer = answer;
        }
        documentHandler.setDocumentModified(true);
        logger.info((Object)(this.oldAnswer + ", " + this.newAnswer));
        return true;
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GProblem document = (GProblem)documentHandler.getActiveDocument();
        document.setAnswer(this.oldAnswer);
        logger.info((Object)(this.oldAnswer + ", " + this.newAnswer));
    }

    @Override
    public String getShortDescription() {
        return "answer";
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

