/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GSolidFactory;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GPyramidAction
implements GLoggable,
GFigureAction {
    private String figureName;
    private Integer sideCount;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GPyramidAction() {
    }

    public GPyramidAction(String parameter) {
        this.sideCount = Integer.valueOf(parameter);
    }

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)(silent + ", " + this.sideCount));
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        if (!silent && this.sideCount == null) {
            String input = GGraphicsFactory.getInstance().showInputDialog(GDictionary.get("EnterNumberOfSides", new String[0]));
            if (input == null) {
                return false;
            }
            try {
                this.sideCount = Integer.parseInt(input);
            }
            catch (Exception exception) {
                documentHandler.error(GDictionary.get("BadSideCount", input));
                return false;
            }
            if (this.sideCount < 3) {
                documentHandler.error(GDictionary.get("BadSideCount", input));
                return false;
            }
        }
        GSolid solid = GSolidFactory.getInstance().newPyramid(this.sideCount);
        GFigure figure = documentHandler.newFigure(solid);
        this.figureName = figure.getName();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        documentHandler.notepadChanged();
        logger.info((Object)this.figureName);
        return true;
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        document.removeFigure(this.figureName);
        documentHandler.removeFigure(this.figureName);
        documentHandler.notepadChanged();
        logger.info((Object)this.figureName);
    }

    @Override
    public GLoggable clone() {
        GPyramidAction action = new GPyramidAction();
        action.figureName = this.figureName;
        action.sideCount = this.sideCount;
        return action;
    }

    @Override
    public String toLogString() {
        String figureType = GDictionary.get("pyramid", new String[0]);
        return GDictionary.get("Create", figureType, this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("sideCount");
        if (ns.getLength() < 1) {
            logger.error((Object)"No side count");
            throw new Exception();
        }
        this.sideCount = Integer.valueOf(ns.item(0).getTextContent());
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<sideCount>").append(String.valueOf(this.sideCount)).append("</sideCount>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    @Override
    public String getShortDescription() {
        String figureType = GDictionary.get("pyramid", new String[0]);
        return GDictionary.get("Create", figureType, this.figureName);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }
}

