/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.awt.Color;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GUndoable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import org.apache.log4j.Logger;

public class GSetColorAction
implements GUndoable {
    private String figureName;
    private Color wasBaseColor;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getSelectedFigure();
        this.wasBaseColor = figure.getBaseColor();
        Color baseColor = GGraphicsFactory.getInstance().showColorChooser(figure.getBaseColor());
        if (baseColor != null) {
            figure.setBaseColor(baseColor);
            this.figureName = figure.getName();
            documentHandler.setDocumentModified(true);
            return true;
        }
        logger.info((Object)(this.figureName + ", " + this.wasBaseColor + ", " + baseColor));
        return false;
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GFigure figure = documentHandler.getActiveDocument().getFigure(this.figureName);
        figure.setBaseColor(this.wasBaseColor);
        logger.info((Object)(this.figureName + ", " + this.wasBaseColor + ", " + figure.getBaseColor()));
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("setColor", new String[0]);
    }
}

