/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GShearDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GShearAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String[] pLabels;
    private GDocument document;
    private GFigure figure;
    private GSolid solid;
    private Vector3d v1;
    private Vector3d v2;
    private Point3d p0;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        this.document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            GSolid solid = figure.getSolid();
            GShearDialog dialog = new GShearDialog(documentHandler.getOwnerFrame(), this);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
            solid.clearSelection();
        }
        this.document.getNotepad().update();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + Arrays.asList(this.pLabels)));
        return true;
    }

    public void validateApply() throws Exception {
        logger.info((Object)"");
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        GPoint3d[] ps = new GPoint3d[3];
        for (int i = 0; i < 3; ++i) {
            if (this.pLabels[i].length() == 0) {
                logger.info((Object)"No reference points");
                throw new Exception(GDictionary.get("EnterRefPoints", new String[0]));
            }
            ps[i] = this.solid.getPoint(this.pLabels[i]);
            if (ps[i] != null) continue;
            logger.info((Object)("No point: " + this.pLabels[i]));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.pLabels[i]));
        }
        if (GMath.areCollinear(new Point3d[]{ps[0].coords, ps[1].coords, ps[2].coords}, this.solid.getEpsilon())) {
            logger.info((Object)("Collinear points: " + Arrays.asList(this.pLabels)));
            throw new Exception(GDictionary.get("PointsAreCollinear", this.pLabels[0], this.pLabels[1], this.pLabels[2]));
        }
        this.v1 = new Vector3d((Tuple3d)ps[1].coords);
        this.v1.sub((Tuple3d)ps[0].coords);
        this.v2 = new Vector3d((Tuple3d)ps[2].coords);
        this.v2.sub((Tuple3d)ps[0].coords);
        this.p0 = new Point3d(ps[0].coords);
        this.solid.shear(this.p0, this.v1, this.v2);
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.undoShear(this.p0, this.v1, this.v2);
        this.document.getNotepad().update();
        this.document.setSelectedFigure(this.figureName);
        this.figure.repaint();
        logger.info((Object)(this.figureName + Arrays.asList(this.pLabels)));
    }

    @Override
    public GLoggable clone() {
        GShearAction action = new GShearAction();
        action.figureName = this.figureName;
        action.pLabels = new String[3];
        for (int i = 0; i < 3; ++i) {
            action.pLabels[i] = this.pLabels[i];
        }
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("ShearFigureAlong", this.figureName, this.pLabels[0] + this.pLabels[1], this.pLabels[2]);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        this.pLabels = new String[3];
        ns = node.getElementsByTagName("p0Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p0Label");
            throw new Exception();
        }
        this.pLabels[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.pLabels[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.pLabels[2] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<p0Label>").append(this.pLabels[0]).append("</p0Label>").append("\n<p1Label>").append(this.pLabels[1]).append("</p1Label>").append("\n<p2Label>").append(this.pLabels[2]).append("</p2Label>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p0String, String p1String, String p2String) {
        logger.info((Object)(p0String + ", " + p1String + ", " + p2String));
        this.pLabels = new String[3];
        this.pLabels[0] = p0String.toUpperCase();
        this.pLabels[1] = p1String.toUpperCase();
        this.pLabels[2] = p2String.toUpperCase();
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("shearFigure", this.figureName);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

