/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.io;

import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.geocentral.geometria.io.GFileTreeCellRenderer;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class GFileTree
extends JTree {
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GFileTree(DefaultTreeModel model) {
        super(model);
        GFileTreeCellRenderer renderer = new GFileTreeCellRenderer();
        this.setCellRenderer(renderer);
        this.setExpandsSelectedPaths(true);
    }

    public void setSelectionPath(String path) {
        logger.info((Object)path);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        TreePath treePath = new TreePath(treeNode);
        String[] tokens = path.split("/");
        int index = 1;
        this.makeTreePath(treePath, tokens, index);
        this.setSelectionPath(treePath);
    }

    private void makeTreePath(TreePath treePath, String[] pathTokens, int index) {
        logger.info(Arrays.asList(pathTokens + ", " + index));
        if (index > pathTokens.length - 1) {
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        String name = pathTokens[index];
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            Element n = (Element)tNode.getUserObject();
            if (!n.getAttribute("name").equals(name)) continue;
            treePath.pathByAddingChild(tNode);
            ++index;
            return;
        }
    }
}

