/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.io;

import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.geocentral.geometria.io.GExtensionFileFilter;
import net.geocentral.geometria.io.GFileWriter;
import org.apache.log4j.Logger;

public class GLocalFileWriter
implements GFileWriter {
    private boolean approved;
    private String filePath;
    private JFileChooser fc;
    private Frame ownerFrame;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GLocalFileWriter(Frame ownerFrame, String filePath, FileFilter[] filters, boolean acceptAllFileFilter) {
        logger.info((Object)filePath);
        this.ownerFrame = ownerFrame;
        this.filePath = filePath;
        this.fc = new JFileChooser(filePath);
        for (FileFilter filter : filters) {
            this.fc.addChoosableFileFilter(filter);
        }
        this.fc.setAcceptAllFileFilterUsed(acceptAllFileFilter);
    }

    @Override
    public void selectFile() throws Exception {
        logger.info((Object)this.filePath);
        int option = this.fc.showSaveDialog(this.ownerFrame);
        boolean bl = this.approved = option == 0;
        if (!this.approved) {
            this.filePath = null;
        } else {
            File file = this.fc.getSelectedFile();
            if (file != null) {
                this.filePath = file.getPath();
                FileFilter filter = this.fc.getFileFilter();
                if (filter instanceof GExtensionFileFilter) {
                    String extension = ((GExtensionFileFilter)filter).getExtension();
                    if (!this.filePath.endsWith("." + extension)) {
                        this.filePath = this.filePath + "." + extension;
                    }
                }
            } else {
                this.filePath = null;
            }
        }
        logger.info((Object)this.filePath);
    }

    @Override
    public void write(String str) throws Exception {
        logger.info((Object)(str.length() + ", " + this.filePath));
        OutputStreamWriter writer = new OutputStreamWriter(new ByteArrayOutputStream());
        String encoding = writer.getEncoding();
        writer.close();
        logger.info((Object)("Encoding: " + encoding));
        str = new String(str.getBytes("UTF-8"), encoding);
        FileWriter out = new FileWriter(this.filePath);
        out.write(str);
        ((Writer)out).close();
    }

    @Override
    public String getSelectedFilePath() {
        return this.filePath;
    }

    @Override
    public boolean fileExists() {
        File file = new File(this.filePath);
        return file.exists();
    }

    @Override
    public boolean approved() {
        return this.approved;
    }

    @Override
    public FileFilter getFileFilter() {
        return this.fc.getFileFilter();
    }
}

